/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class RGBImageRenderer
extends Renderer {
    BufferedImage image = null;
    Rectangle rect = null;
    private boolean nearestNeighborInterpolation = false;
    public static final String PROP_NEARESTNEIGHBORINTERPOLATION = "nearestNeighborInterpolation";

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.nearestNeighborInterpolation = this.getBooleanControl(PROP_NEARESTNEIGHBORINTERPOLATION, this.nearestNeighborInterpolation);
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_NEARESTNEIGHBORINTERPOLATION, RGBImageRenderer.encodeBooleanControl(this.nearestNeighborInterpolation));
        return Renderer.formatControl(controls);
    }

    @Override
    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        boolean ylog;
        boolean xlog;
        BufferedImage im;
        QDataSet lds = this.getDataSet();
        if (lds == null || lds.length() == 0) {
            this.getParent().postMessage((Renderer)this, "null data set", Level.INFO, null, null);
            return;
        }
        if (this.image == null) {
            this.getParent().postException(this, this.lastException);
        }
        if ((im = this.image) == null) {
            return;
        }
        QDataSet dep0 = (QDataSet)lds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)lds.property("DEPEND_1");
        if (dep0 == null) {
            dep0 = Ops.dindgen(im.getWidth());
        }
        if (dep1 == null) {
            dep1 = Ops.dindgen(im.getHeight());
        }
        int n = dep0.length();
        double dx1 = dep0.value(1) - dep0.value(0);
        double dx2 = dep0.value(n - 1) - dep0.value(n - 2);
        boolean bl = xlog = dx2 / dx1 > 10.0;
        if (xAxis.isLog() != xlog) {
            this.getParent().postMessage((Renderer)this, "xaxis must be " + (xlog ? "log" : "linear") + ", for this image", Level.INFO, null, null);
            return;
        }
        n = dep1.length();
        double dy1 = dep1.value(1) - dep1.value(0);
        double dy2 = dep1.value(n - 1) - dep1.value(n - 2);
        boolean bl2 = ylog = dy2 / dy1 > 10.0;
        if (yAxis.isLog() != ylog) {
            this.getParent().postMessage((Renderer)this, "yaxis must be " + (ylog ? "log" : "linear") + ", for this image", Level.INFO, null, null);
            return;
        }
        Units xunits = SemanticOps.getUnits(dep0);
        Units yunits = SemanticOps.getUnits(dep1);
        int h = im.getHeight();
        int w = im.getWidth();
        double dx0 = dep0.value(1) - dep0.value(0);
        double dy0 = dep1.value(1) - dep1.value(0);
        double dx = dep0.value(1) - dep0.value(0);
        Datum d = xAxis.invTransform(0.0);
        if (!d.getUnits().isConvertibleTo(xunits)) {
            d = xunits.createDatum(d.value());
        }
        int ix0 = dx > 0.0 ? (int)Math.floor(Ops.findex((Object)dep0, xAxis.invTransform(0.0)).value()) : (int)Math.floor(Ops.findex((Object)Ops.multiply(-1, (Object)dep0), d.multiply(-1.0)).value());
        ix0 = Math.max(0, ix0);
        ix0 = Math.min(w - 1, ix0);
        int x0 = (int)xAxis.transform(dep0.value(ix0) - dx0 / 2.0, xAxis.getUnits());
        double dy = dep1.value(1) - dep1.value(0);
        int iy0 = dy > 0.0 ? (int)Math.floor(Ops.findex((Object)dep1, yAxis.invTransform(yAxis.getHeight() + yAxis.getY())).value()) : (int)Math.floor(Ops.findex((Object)Ops.multiply(-1, (Object)dep1), yAxis.invTransform(yAxis.getHeight() + yAxis.getY()).multiply(-1.0)).value());
        iy0 = Math.max(0, iy0);
        iy0 = Math.min(h - 1, iy0);
        int y0 = (int)yAxis.transform(dep1.value(iy0) - dy0 / 2.0, yAxis.getUnits());
        Datum d2 = xAxis.invTransform(xAxis.getWidth() + xAxis.getX());
        if (!d2.getUnits().isConvertibleTo(xunits)) {
            d2 = xunits.createDatum(d2.value());
        }
        int ix1 = dx > 0.0 ? (int)Math.ceil(Ops.findex((Object)dep0, d2).value()) : (int)Math.ceil(Ops.findex((Object)Ops.multiply(-1, (Object)dep0), d2.multiply(-1.0)).value());
        ix1 = Math.max(0, ix1);
        ix1 = Math.min(w - 1, ix1);
        int x1 = (int)xAxis.transform(dep0.value(ix1) + dx0 / 2.0, xAxis.getUnits());
        int iy1 = dy > 0.0 ? (int)Math.ceil(Ops.findex((Object)dep1, yAxis.invTransform(0.0)).value()) : (int)Math.floor(Ops.findex((Object)Ops.multiply(-1, (Object)dep1), yAxis.invTransform(0.0).multiply(-1.0)).value());
        iy1 = Math.max(0, iy1);
        iy1 = Math.min(h - 1, iy1);
        int y1 = (int)yAxis.transform(dep1.value(iy1) + dy0 / 2.0, yunits);
        if (this.nearestNeighborInterpolation) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        ++iy1;
        if (ix0 == ++ix1) {
            this.getParent().postMessage((Renderer)this, "image is off screen", Level.INFO, null, null);
        }
        if (iy0 == iy1) {
            this.getParent().postMessage((Renderer)this, "image is off screen", Level.INFO, null, null);
        }
        if (ix0 > 0 || ix1 < w || iy0 > 0 || iy1 < h) {
            if (ix0 < ix1) {
                if (iy0 < iy1) {
                    im = im.getSubimage(ix0, iy0, ix1 - ix0, iy1 - iy0);
                } else {
                    im = im.getSubimage(ix0, iy1, ix1 - ix0, iy0 - iy1);
                    AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
                    tx.translate(0.0, -im.getHeight(null));
                    AffineTransformOp op = new AffineTransformOp(tx, 1);
                    im = op.filter(im, null);
                }
            } else if (iy0 < iy1) {
                im = im.getSubimage(ix1, iy0, ix0 - ix1, iy1 - iy0);
                AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                tx.translate(-im.getWidth(null), 0.0);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                im = op.filter(im, null);
            } else {
                im = im.getSubimage(ix1, iy1, ix0 - ix1, iy0 - iy1);
                AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
                tx.translate(-im.getWidth(null), -im.getHeight(null));
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                im = op.filter(im, null);
            }
        }
        g.drawImage(im, x0, y0, x1 - x0, y1 - y0, null);
        this.rect = new Rectangle(x0, y1, x1 - x0, y0 - y1);
    }

    public boolean isNearestNeighborInterpolation() {
        return this.nearestNeighborInterpolation;
    }

    public void setNearestNeighborInterpolation(boolean nearestNeighborInterpolation) {
        boolean oldNearestNeighborInterpolation = this.nearestNeighborInterpolation;
        this.nearestNeighborInterpolation = nearestNeighborInterpolation;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_NEARESTNEIGHBORINTERPOLATION, oldNearestNeighborInterpolation, nearestNeighborInterpolation);
    }

    @Override
    public void setDataSet(QDataSet ds) {
        super.setDataSet(ds);
        this.image = null;
    }

    @Override
    protected void installRenderer() {
        super.installRenderer();
        DasPlot parent = this.getParent();
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            DasMouseInputAdapter mouseAdapter = parent.mouseAdapter;
            CrossHairMouseModule ch = new CrossHairMouseModule(parent, this, parent.getXAxis(), parent.getYAxis());
            mouseAdapter.addMouseModule(ch);
        }
    }

    @Override
    protected void uninstallRenderer() {
        super.uninstallRenderer();
    }

    @Override
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        monitor.started();
        monitor.setProgressMessage("creating image from RGB data");
        if (this.ds == null) {
            this.image = null;
        } else if (this.image == null) {
            try {
                this.image = this.getImage(this.ds, xAxis, yAxis);
                this.setLastException(null);
            }
            catch (IllegalArgumentException ex) {
                this.setLastException(ex);
                return;
            }
        }
        monitor.finished();
    }

    private BufferedImage getImage(QDataSet ds, DasAxis xAxis, DasAxis yAxis) throws IllegalArgumentException {
        BufferedImage im;
        block17: {
            int h;
            int w;
            block16: {
                int imageType = -19999;
                w = ds.length();
                h = ds.length(0);
                switch (ds.rank()) {
                    case 2: {
                        imageType = 10;
                        break;
                    }
                    case 3: {
                        String s2;
                        String s1;
                        String s0;
                        QDataSet dep2;
                        if (ds.length(0, 0) == 3) {
                            dep2 = (QDataSet)ds.property("DEPEND_2");
                            imageType = 1;
                            if (dep2 == null) break;
                            s0 = DataSetUtil.asDatum(dep2.slice(0)).toString().toLowerCase();
                            s1 = DataSetUtil.asDatum(dep2.slice(1)).toString().toLowerCase();
                            s2 = DataSetUtil.asDatum(dep2.slice(2)).toString().toLowerCase();
                            if (s0.startsWith("r") && s1.startsWith("g") && s2.startsWith("b")) {
                                imageType = 1;
                                break;
                            }
                            if (!s0.startsWith("b") || !s1.startsWith("g") || !s2.startsWith("r")) break;
                            imageType = 4;
                            break;
                        }
                        if (ds.length(0, 0) != 4) break;
                        dep2 = (QDataSet)ds.property("DEPEND_2");
                        imageType = 2;
                        if (dep2 == null) break;
                        s0 = DataSetUtil.asDatum(dep2.slice(0)).toString().toLowerCase();
                        s1 = DataSetUtil.asDatum(dep2.slice(1)).toString().toLowerCase();
                        s2 = DataSetUtil.asDatum(dep2.slice(2)).toString().toLowerCase();
                        String s3 = DataSetUtil.asDatum(dep2.slice(3)).toString().toLowerCase();
                        if (s0.startsWith("a") && s1.startsWith("r") && s2.startsWith("g") && s3.startsWith("b")) {
                            imageType = 2;
                            break;
                        }
                        if (!s0.startsWith("a") || !s1.startsWith("b") || !s2.startsWith("g") || !s3.startsWith("r")) break;
                        imageType = 6;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("DataSet must be rank 2 or rank 3: " + ds);
                    }
                }
                if (imageType == -19999) {
                    throw new IllegalArgumentException("DataSet must be ds[w,h] ds[w,h,3] or ds[w,h,4] and be RGB, BGR, or ARGB.  Default is RBG");
                }
                im = new BufferedImage(w, h, imageType);
                if (ds.rank() != 2) break block16;
                for (int i = 0; i < w; ++i) {
                    for (int j = 0; j < h; ++j) {
                        im.setRGB(i, j, 65536 * (int)ds.value(i, j) + 256 * (int)ds.value(i, j) + (int)ds.value(i, j));
                    }
                }
                break block17;
            }
            if (ds.rank() != 3) break block17;
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int v;
                    switch (ds.length(0, 0)) {
                        case 4: {
                            v = 0x1000000 * (int)ds.value(i, j, 0) + 65536 * (int)ds.value(i, j, 1) + 256 * (int)ds.value(i, j, 2) + (int)ds.value(i, j, 3);
                            break;
                        }
                        case 3: {
                            v = 65536 * (int)ds.value(i, j, 0) + 256 * (int)ds.value(i, j, 1) + (int)ds.value(i, j, 2);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("ds.length=" + ds.length());
                        }
                    }
                    im.setRGB(i, j, v);
                }
            }
        }
        return im;
    }

    public static boolean acceptsData(QDataSet ds) {
        switch (ds.rank()) {
            case 2: {
                return !SemanticOps.isBundle(ds);
            }
            case 3: {
                return ds.length(0, 0) > 2 && ds.length(0, 0) < 5;
            }
        }
        return false;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        return this.rect != null && this.rect.contains(x, y);
    }

    public Shape selectionArea() {
        if (this.rect == null) {
            return SelectionUtil.NULL;
        }
        return this.rect;
    }

    @Override
    public Icon getListIcon() {
        BufferedImage result = new BufferedImage(16, 16, 1);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.drawImage(this.image, 0, 0, 16, 16, null);
        return new ImageIcon(result);
    }

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet yrange;
        QDataSet xrange;
        if (ds.rank() == 2 || ds.rank() == 3) {
            QDataSet xx = (QDataSet)ds.property("DEPEND_0");
            QDataSet yy = (QDataSet)ds.property("DEPEND_1");
            xrange = xx != null ? Ops.extent(xx) : DDataSet.wrap(new double[]{0.0, ds.length()});
            yrange = yy != null ? Ops.extent(yy) : DDataSet.wrap(new double[]{0.0, ds.length(0)});
        } else {
            throw new IllegalArgumentException("dataset should be rank 2 or rank 3: " + ds);
        }
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }
}

