/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.ObjectLocator;

public class Legend
extends DasCanvasComponent {
    static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    ArrayList elements = new ArrayList();
    ObjectLocator locator;

    public Legend() {
        this.getDasMouseInputAdapter().addMenuItem(new JMenuItem(this.getEditAction()));
    }

    private Action getEditAction() {
        return new AbstractAction("Renderer Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p = Legend.this.getDasMouseInputAdapter().getMousePressPosition();
                LegendElement item = (LegendElement)Legend.this.locator.closestObject(p);
                if (item == null) {
                    return;
                }
                Displayable rend = item.getDisplayable();
                PropertyEditor editor = new PropertyEditor(rend);
                editor.showDialog(Legend.this);
            }
        };
    }

    public static Icon getIcon(Color color) {
        BufferedImage image = new BufferedImage(6, 10, 1);
        Graphics g2 = ((Image)image).getGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, 6, 10);
        return new ImageIcon(image);
    }

    public void add(Displayable rend, String label) {
        LegendElement e = new LegendElement(rend, label);
        this.elements.add(e);
    }

    public void remove(Displayable rend) {
        for (int i = 0; i < this.elements.size(); ++i) {
            LegendElement ele = (LegendElement)this.elements.get(i);
            if (ele.rend == null || rend != ele.rend) continue;
            this.elements.remove(i);
            this.repaint();
            break;
        }
    }

    public void add(Icon icon, String label) {
        this.elements.add(new LegendElement(icon, label));
    }

    @Override
    public void resize() {
        int xmin = this.getColumn().getDMinimum();
        int ymin = this.getRow().getDMinimum();
        Rectangle r = new Rectangle(xmin, ymin, this.getColumn().getDMaximum() - xmin + 1, this.getRow().getDMaximum() - ymin + 1);
        this.setBounds(r);
    }

    @Override
    public void paintComponent(Graphics g1) {
        Object font0;
        String invisibleString;
        Icon icon;
        LegendElement e;
        if (this.elements.isEmpty()) {
            logger.fine("no elements in legend, returning.");
            this.getDasMouseInputAdapter().paint(g1);
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int border = 5;
        int x = 5;
        int y = 5;
        FontMetrics fm = g.getFontMetrics();
        Color color0 = g.getColor();
        this.locator = new ObjectLocator();
        boolean allVisible = true;
        int maxWidth = 0;
        for (Object element : this.elements) {
            e = (LegendElement)element;
            icon = e.getIcon();
            invisibleString = "";
            if (!e.isVisible()) {
                invisibleString = "\u00b9";
                allVisible = false;
            }
            int itemWidth = fm.stringWidth(e.getLabel() + invisibleString);
            int itemHeight = fm.getHeight() > icon.getIconHeight() ? fm.getHeight() : icon.getIconHeight() + border;
            int w1 = itemWidth + x + 20;
            if (w1 > maxWidth) {
                maxWidth = w1;
            }
            y += itemHeight;
        }
        if (!allVisible) {
            font0 = g.getFont();
            g.setFont(((Font)font0).deriveFont((float)((Font)font0).getSize() * 0.66f));
            y += g.getFontMetrics().getHeight() / 2;
            g.setFont((Font)font0);
            y += g.getFontMetrics().getHeight() / 2;
        }
        g.setColor(new Color(255, 255, 255, 240));
        g.fill(new Rectangle(0, 0, maxWidth + 10, y - 1));
        g.setColor(Color.DARK_GRAY);
        g.draw(new Rectangle(0, 0, maxWidth + 10, y - 1));
        x = 5;
        y = 5;
        for (Object element : this.elements) {
            e = (LegendElement)element;
            icon = e.getIcon();
            icon.paintIcon(this, g, x, y);
            invisibleString = "";
            if (!e.isVisible()) {
                invisibleString = "\u00b9";
                allVisible = false;
            }
            g.drawString(e.getLabel() + invisibleString, x + 20, y + icon.getIconHeight());
            int itemHeight = fm.getHeight() > icon.getIconHeight() ? fm.getHeight() : icon.getIconHeight() + border;
            this.locator.addObject(new Rectangle(x, y - border / 2, maxWidth, itemHeight), e);
            y += fm.getHeight() > icon.getIconHeight() ? fm.getHeight() : icon.getIconHeight() + border;
        }
        if (!allVisible) {
            font0 = g.getFont();
            g.setFont(((Font)font0).deriveFont((float)((Font)font0).getSize() * 0.66f));
            g.setColor(Color.DARK_GRAY);
            g.drawString("\u00b9 not drawn", x + 10, y += g.getFontMetrics().getHeight() / 2);
            g.setFont((Font)font0);
            y += g.getFontMetrics().getHeight() / 2;
        }
        g.setColor(color0);
        this.getDasMouseInputAdapter().paint(g1);
    }

    private static class LegendElement {
        Icon icon;
        Displayable rend;
        String label;

        Icon getIcon() {
            if (this.rend != null) {
                return this.rend.getListIcon();
            }
            return this.icon;
        }

        void update() {
            if (this.rend != null) {
                this.icon = this.rend.getListIcon();
            }
        }

        Displayable getDisplayable() {
            return this.rend;
        }

        private String getLabel() {
            return this.label;
        }

        private boolean isVisible() {
            return this.rend == null || !(this.rend instanceof Renderer) || ((Renderer)this.rend).isActive();
        }

        LegendElement(Displayable rend, String label) {
            this.icon = rend.getListIcon();
            this.label = label;
            this.rend = rend;
        }

        LegendElement(Icon icon, String label) {
            this.icon = icon;
            this.label = label;
        }
    }
}

