/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.ColorUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.ImageVectorDataSetRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.jdesktop.beansbinding.Converter;

public class GraphUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.graphics.util");
    public static final String CONNECT_MODE_HISTOGRAM = "histogram";
    public static final String CONNECT_MODE_SCATTER = "scatter";
    public static final String CONNECT_MODE_SERIES = "series";

    public static DasPlot newDasPlot(DasCanvas canvas, DatumRange x, DatumRange y) {
        DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 2.0, -3.0, 0, 0);
        DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 5.0, -3.0, 0, 0);
        DasPlot result = new DasPlot(xaxis, yaxis);
        canvas.add(result, row, col);
        return result;
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet ds, boolean histogram, boolean clip) {
        return GraphUtil.getPath(xAxis, yAxis, SemanticOps.xtagsDataSet(ds), ds, histogram, clip);
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet yds, boolean histogram, boolean clip) {
        return GraphUtil.getPath(xAxis, yAxis, xds, yds, histogram ? CONNECT_MODE_HISTOGRAM : CONNECT_MODE_SERIES, clip);
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet yds, String mode, boolean clip) {
        GeneralPath newPath = new GeneralPath();
        Units xUnits = SemanticOps.getUnits(xds);
        Units yUnits = SemanticOps.getUnits(yds);
        double i0 = -1.7976931348623157E308;
        double j0 = -1.7976931348623157E308;
        boolean v0 = false;
        boolean skippedLast = true;
        int n = xds.length();
        QDataSet wds = SemanticOps.weightsDataSet(yds);
        Rectangle rclip = clip ? DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn()) : null;
        boolean histogram = mode.equals(CONNECT_MODE_HISTOGRAM);
        boolean scatter = mode.equals(CONNECT_MODE_SCATTER);
        for (int index = 0; index < n; ++index) {
            boolean v;
            double x = xds.value(index);
            double y = yds.value(index);
            double i = xAxis.transform(x, xUnits);
            double j = yAxis.transform(y, yUnits);
            boolean bl = v = rclip == null || rclip.contains(i, j);
            if (wds.value(index) == 0.0 || Double.isNaN(y)) {
                skippedLast = true;
            } else if (skippedLast) {
                newPath.moveTo((float)i, (float)j);
                if (scatter) {
                    newPath.lineTo((float)i, (float)j);
                }
                skippedLast = !v;
            } else {
                if (v || v0) {
                    if (histogram) {
                        double i1 = (i0 + i) / 2.0;
                        newPath.lineTo((float)i1, (float)j0);
                        newPath.lineTo((float)i1, (float)j);
                        newPath.lineTo((float)i, (float)j);
                    } else if (scatter) {
                        newPath.moveTo((float)i, (float)j);
                        newPath.lineTo((float)i, (float)j);
                    } else {
                        newPath.lineTo((float)i, (float)j);
                    }
                }
                skippedLast = false;
            }
            i0 = i;
            j0 = j;
            v0 = v;
        }
        return newPath;
    }

    public static AffineTransform calculateAT(DasAxis xaxis0, DasAxis yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        return GraphUtil.calculateAT(xaxis0.getDatumRange(), yaxis0.getDatumRange(), xaxis1, yaxis1);
    }

    public static AffineTransform calculateAT(DatumRange xaxis0, DatumRange yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        AffineTransform at = new AffineTransform();
        double dmin0 = xaxis1.transform(xaxis0.min());
        double dmax0 = xaxis1.transform(xaxis0.max());
        double dmin1 = xaxis1.transform(xaxis1.getDataMinimum());
        double dmax1 = xaxis1.transform(xaxis1.getDataMaximum());
        double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transx = -1.0 * dmin1 * scalex + dmin0;
        at.translate(transx, 0.0);
        at.scale(scalex, 1.0);
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        dmin0 = yaxis1.transform(yaxis0.min());
        dmax0 = yaxis1.transform(yaxis0.max());
        dmin1 = yaxis1.transform(yaxis1.getDataMinimum());
        dmax1 = yaxis1.transform(yaxis1.getDataMaximum());
        double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transy = -1.0 * dmin1 * scaley + dmin0;
        at.translate(0.0, transy);
        at.scale(1.0, scaley);
        return at;
    }

    public static DasAxis guessYAxis(QDataSet dsz) {
        DasAxis result;
        boolean log = false;
        if (dsz.property("SCALE_TYPE") != null && dsz.property("SCALE_TYPE").equals("log")) {
            log = true;
        }
        if (SemanticOps.isSimpleTableDataSet(dsz)) {
            QDataSet ds = dsz;
            QDataSet yds = SemanticOps.ytagsDataSet(ds);
            DatumRange yrange = DataSetUtil.asDatumRange(Ops.extent(yds), true);
            yrange = DatumRangeUtil.rescale(yrange, -0.1, 1.1);
            Datum dy = DataSetUtil.asDatum(DataSetUtil.guessCadenceNew(yds, null));
            if (UnitsUtil.isRatiometric(dy.getUnits())) {
                log = true;
            }
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else if (!SemanticOps.isTableDataSet(dsz)) {
            QDataSet yds = dsz;
            if (SemanticOps.isBundle(dsz)) {
                dsz = yds = DataSetOps.unbundleDefaultDataSet(dsz);
            }
            DatumRange yrange = DataSetUtil.asDatumRange(Ops.extent(yds), true);
            yrange = DatumRangeUtil.rescale(yrange, -0.1, 1.1);
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else {
            throw new IllegalArgumentException("not supported: " + dsz);
        }
        if (dsz.property("LABEL") != null) {
            result.setLabel((String)dsz.property("LABEL"));
        }
        return result;
    }

    public static DasAxis guessXAxis(QDataSet ds) {
        QDataSet xds = SemanticOps.xtagsDataSet(ds);
        DatumRange range = DataSetUtil.asDatumRange(Ops.extent(xds), true);
        range = DatumRangeUtil.rescale(range, -0.1, 1.1);
        return new DasAxis(range.min(), range.max(), 2);
    }

    public static DasAxis guessZAxis(QDataSet dsz) {
        if (!SemanticOps.isTableDataSet(dsz)) {
            throw new IllegalArgumentException("only TableDataSet supported");
        }
        QDataSet ds = dsz;
        DatumRange range = DataSetUtil.asDatumRange(Ops.extent(ds), true);
        boolean log = false;
        if ("log".equals(dsz.property("SCALE_TYPE"))) {
            log = true;
            if (range.min().doubleValue(range.getUnits()) <= 0.0) {
                double max = range.max().doubleValue(range.getUnits());
                range = new DatumRange(max / 1000.0, max, range.getUnits());
            }
        }
        DasAxis result = new DasAxis(range.min(), range.max(), 3, log);
        if (dsz.property("LABEL") != null) {
            result.setLabel((String)dsz.property("LABEL"));
        }
        return result;
    }

    public static Renderer guessRenderer(QDataSet ds) {
        Renderer rend = null;
        if (!SemanticOps.isTableDataSet(ds)) {
            if (ds.length() > 10000) {
                rend = new ImageVectorDataSetRenderer(null);
                rend.setDataSet(ds);
            } else {
                rend = new SeriesRenderer();
                rend.setDataSet(ds);
                ((SeriesRenderer)rend).setPsym(DefaultPlotSymbol.CIRCLES);
                ((SeriesRenderer)rend).setSymSize(2.0);
            }
        } else if (SemanticOps.isTableDataSet(ds)) {
            DasAxis zaxis = GraphUtil.guessZAxis(ds);
            DasColorBar colorbar = new DasColorBar(zaxis.getDataMinimum(), zaxis.getDataMaximum(), zaxis.isLog());
            colorbar.setLabel(zaxis.getLabel());
            rend = new SpectrogramRenderer(null, colorbar);
            rend.setDataSet(ds);
        }
        return rend;
    }

    public static DasPlot guessPlot(QDataSet ds) {
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        plot.addRenderer(GraphUtil.guessRenderer(ds));
        return plot;
    }

    public static DasAxis copyAxis(DasAxis a) {
        DasAxis c = new DasAxis(a.getDatumRange(), a.getOrientation());
        c.setDataMinimum(a.getDataMinimum());
        c.setDataMaximum(a.getDataMaximum());
        c.setLog(a.isLog());
        c.setLabel(a.getLabel());
        c.setFlipLabel(a.isFlipLabel());
        c.setFlipped(a.isFlipped());
        c.setEnabled(a.isEnabled());
        c.setEnableHistory(a.isEnableHistory());
        c.setLog(a.isLog());
        c.setOpaque(a.isOpaque());
        c.setOppositeAxisVisible(a.isOppositeAxisVisible());
        c.setTickLabelsVisible(a.isTickLabelsVisible());
        c.setUseDomainDivider(a.isUseDomainDivider());
        c.setUserDatumFormatter(a.getUserDatumFormatter());
        return c;
    }

    public static DasColorBar copyColorBar(DasColorBar a) {
        DasColorBar c = new DasColorBar(a.getDataMinimum(), a.getDataMaximum(), a.getOrientation(), a.isLog());
        c.setLabel(a.getLabel());
        c.setFlipLabel(a.isFlipLabel());
        c.setType(a.getType());
        return c;
    }

    public static DasPlot copyPlot(DasPlot p) {
        DasAxis xaxis = GraphUtil.copyAxis(p.getXAxis());
        DasAxis yaxis = GraphUtil.copyAxis(p.getYAxis());
        DasPlot c = new DasPlot(xaxis, yaxis);
        c.setTitle(p.getTitle());
        c.setDisplayTitle(p.isDisplayTitle());
        c.setDrawGrid(p.isDrawGrid());
        c.setPreviewEnabled(p.isPreviewEnabled());
        c.setLegendPosition(p.getLegendPosition());
        c.setDisplayLegend(p.isDisplayLegend());
        for (Renderer r : p.getRenderers()) {
            Renderer sr;
            Renderer cr;
            if (r instanceof Copyable) {
                Copyable copyable = (Copyable)((Object)r);
                cr = (Renderer)copyable.copy();
            } else if (r instanceof SpectrogramRenderer) {
                DasColorBar cb = GraphUtil.copyColorBar(((SpectrogramRenderer)r).getColorBar());
                cr = new SpectrogramRenderer(null, cb);
                SpectrogramRenderer sr2 = (SpectrogramRenderer)cr;
                sr2.setRebinner(((SpectrogramRenderer)r).getRebinner());
            } else if (r instanceof SeriesRenderer) {
                cr = new SeriesRenderer();
                sr = (SeriesRenderer)cr;
                ((SeriesRenderer)cr).setAntiAliased(((SeriesRenderer)r).isAntiAliased());
                ((SeriesRenderer)sr).setColor(((SeriesRenderer)r).getColor());
                ((SeriesRenderer)sr).setFillColor(((SeriesRenderer)r).getFillColor());
                ((SeriesRenderer)sr).setFillStyle(((SeriesRenderer)r).getFillStyle());
                ((SeriesRenderer)sr).setLineWidth(((SeriesRenderer)r).getLineWidth());
                ((SeriesRenderer)sr).setFillToReference(((SeriesRenderer)r).isFillToReference());
                ((SeriesRenderer)sr).setReference(((SeriesRenderer)r).getReference());
                ((SeriesRenderer)sr).setSymSize(((SeriesRenderer)r).getSymSize());
                ((SeriesRenderer)sr).setPsym(((SeriesRenderer)r).getPsym());
                ((SeriesRenderer)sr).setPsymConnector(((SeriesRenderer)r).getPsymConnector());
                sr.setLegendLabel(((SeriesRenderer)r).getLegendLabel());
                sr.setDrawLegendLabel(((SeriesRenderer)r).isDrawLegendLabel());
            } else if (r instanceof ImageVectorDataSetRenderer) {
                cr = new ImageVectorDataSetRenderer(null);
                sr = (ImageVectorDataSetRenderer)cr;
                ((ImageVectorDataSetRenderer)sr).setColor(((ImageVectorDataSetRenderer)r).getColor());
            } else {
                throw new UnsupportedOperationException("source renderer cannot be copied");
            }
            cr.setControl(r.getControl());
            cr.setDataSet(r.getDataSet());
            c.addRenderer(cr);
        }
        return c;
    }

    public static DasPlot visualize(QDataSet ds) {
        JFrame jframe = new JFrame("DataSetUtil.visualize");
        DasCanvas canvas = new DasCanvas(400, 400);
        jframe.getContentPane().add(canvas);
        DasPlot result = GraphUtil.guessPlot(ds);
        canvas.add(result, new DasRow(canvas, 0.1, 0.9), DasColumn.create(canvas, null, "5em", "100%-10em"));
        jframe.pack();
        jframe.setVisible(true);
        jframe.setDefaultCloseOperation(3);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int reducePath20140622(PathIterator it, GeneralPath result, int resn, int resd) {
        logger.fine("enter reducePath20140622");
        long t0 = System.currentTimeMillis();
        float[] p = new float[6];
        int x0 = -99999;
        int y0 = -99999;
        int entryy = -99999;
        int miny = 99999;
        int maxy = -99999;
        int type0 = -999;
        int points = 0;
        int inCount = 0;
        boolean atMiny = false;
        boolean atMaxy = false;
        while (!it.isDone()) {
            ++inCount;
            int type = it.currentSegment(p);
            it.next();
            int xx = (int)(p[0] * (float)resd) / resn;
            int yy = (int)(p[1] * (float)resd) / resn;
            if (type0 == -999) {
                result.moveTo((float)xx / (float)resd, (float)yy / (float)resd);
                x0 = xx;
                entryy = yy;
                miny = yy;
                maxy = yy;
            }
            if (!(type == 0 && xx == x0 || type != 1 && type != type0 || xx != x0)) {
                miny = Math.min(miny, yy);
                maxy = Math.max(maxy, yy);
            }
            if (xx != x0) {
                atMiny = false;
                atMaxy = false;
                int exity = y0;
                if (miny == maxy) {
                    atMaxy = true;
                    atMiny = true;
                } else if (entryy == miny) {
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                    ++points;
                    atMiny = true;
                } else if (entryy == maxy) {
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                    ++points;
                    atMaxy = true;
                } else {
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)entryy * (float)resn / (float)resd);
                    ++points;
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                    ++points;
                    atMiny = true;
                }
                if (miny < maxy) {
                    if (atMiny) {
                        result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                        ++points;
                        atMaxy = true;
                    } else if (!atMiny) {
                        result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                        ++points;
                        atMiny = true;
                    }
                }
                if (miny != maxy) {
                    if (exity == miny) {
                        if (atMiny) {
                            result.lineTo((float)x0 * (float)resn / (float)resd, (float)exity * (float)resn / (float)resd);
                            ++points;
                        } else {
                            if (!atMaxy) throw new RuntimeException("shouldn't get here 1");
                            result.lineTo((float)x0 * (float)resn / (float)resd, (float)exity * (float)resn / (float)resd);
                            ++points;
                        }
                    } else if (exity == maxy) {
                        if (!atMaxy) {
                            if (!atMiny) throw new RuntimeException("shouldn't get here");
                            throw new RuntimeException("shouldn't get here 2");
                        }
                    } else {
                        result.lineTo((float)x0 * (float)resn / (float)resd, (float)exity * (float)resn / (float)resd);
                        ++points;
                    }
                }
                if (type == 1) {
                    result.lineTo((float)xx * (float)resn / (float)resd, (float)yy * (float)resn / (float)resd);
                    ++points;
                } else if (type == 0) {
                    result.moveTo((float)xx * (float)resn / (float)resd, (float)yy * (float)resn / (float)resd);
                    ++points;
                }
                entryy = yy;
                miny = yy;
                maxy = yy;
            }
            if (type == 0) {
                result.moveTo((float)xx * (float)resn / (float)resd, (float)yy * (float)resn / (float)resd);
                ++points;
            }
            x0 = xx;
            y0 = yy;
            type0 = type;
        }
        if (miny != maxy) {
            if (entryy == miny) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                ++points;
                atMiny = true;
            } else if (entryy == maxy) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                ++points;
                atMiny = false;
            } else {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)entryy * (float)resn / (float)resd);
                ++points;
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                ++points;
                atMiny = true;
            }
        }
        if (miny < maxy) {
            if (atMiny) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                ++points;
            } else if (!atMiny) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                ++points;
            }
        }
        logger.log(Level.FINE, "reduce {0} to {1} in {2}ms", new Object[]{inCount, points, System.currentTimeMillis() - t0});
        return points;
    }

    public static int reducePath(PathIterator it, GeneralPath result) {
        return GraphUtil.reducePath(it, result, 1);
    }

    public static int reducePath(PathIterator it, GeneralPath result, int res) {
        float ay0;
        float ax0;
        logger.fine("enter reducePath");
        long t0 = System.currentTimeMillis();
        float[] p = new float[6];
        float x0 = Float.MAX_VALUE;
        float y0 = Float.MAX_VALUE;
        float sx0 = 0.0f;
        float sy0 = 0.0f;
        int nx0 = 0;
        int ny0 = 0;
        int type0 = -999;
        float xres = res;
        float yres = res;
        int points = 0;
        int inCount = 0;
        while (!it.isDone()) {
            ++inCount;
            int type = it.currentSegment(p);
            it.next();
            float dx = p[0] - x0;
            float dy = p[1] - y0;
            if ((type == 0 || type == type0) && Math.abs(dx) < xres && Math.abs(dy) < yres) {
                sx0 += p[0];
                sy0 += p[1];
                ++nx0;
                ++ny0;
                continue;
            }
            x0 = 0.5f + (float)((int)Math.floor(p[0]));
            y0 = 0.5f + (float)((int)Math.floor(p[1]));
            ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
            ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
            sx0 = p[0];
            sy0 = p[1];
            nx0 = 1;
            ny0 = 1;
            switch (type0) {
                case 1: {
                    result.lineTo(ax0, ay0);
                    ++points;
                    break;
                }
                case 0: {
                    result.moveTo(ax0, ay0);
                    break;
                }
                case 3: {
                    result.lineTo(ax0, ay0);
                    break;
                }
                case 4: {
                    break;
                }
                case -999: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            type0 = type;
        }
        ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
        ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
        switch (type0) {
            case 1: {
                result.lineTo(ax0, ay0);
                ++points;
                break;
            }
            case 0: {
                result.moveTo(ax0, ay0);
                break;
            }
            case 3: {
                result.lineTo(ax0, ay0);
                break;
            }
            case 4: {
                break;
            }
            case -999: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported");
            }
        }
        logger.log(Level.FINE, "reduce {0} to {1} in {2}ms", new Object[]{inCount, points, System.currentTimeMillis() - t0});
        return points;
    }

    public static double pointsAlongCurve(PathIterator it, double[] pathlen, Point2D.Double[] result, double[] orientation, boolean stopAtMoveTo) {
        float[] point = new float[6];
        float fx0 = Float.NaN;
        float fy0 = Float.NaN;
        double slen = 0.0;
        int pathlenIndex = 0;
        if (pathlen == null) {
            pathlen = new double[]{};
        }
        while (!it.isDone()) {
            int type = it.currentSegment(point);
            it.next();
            if (!Float.isNaN(fx0) && type == 0 && stopAtMoveTo) break;
            if (3 == type) {
                throw new IllegalArgumentException("cubicto not supported");
            }
            if (2 == type) {
                throw new IllegalArgumentException("quadto not supported");
            }
            if (1 == type) {
                // empty if block
            }
            if (Float.isNaN(fx0)) {
                fx0 = point[0];
                fy0 = point[1];
                continue;
            }
            double thislen = (float)Point.distance(fx0, fy0, point[0], point[1]);
            if (thislen == 0.0) continue;
            slen += thislen;
            while (pathlenIndex < pathlen.length && slen >= pathlen[pathlenIndex]) {
                double alpha = 1.0 - (slen - pathlen[pathlenIndex]) / thislen;
                double dx = point[0] - fx0;
                double dy = point[1] - fy0;
                if (result != null) {
                    result[pathlenIndex] = new Point2D.Double((double)fx0 + dx * alpha, (double)fy0 + dy * alpha);
                }
                if (orientation != null) {
                    orientation[pathlenIndex] = Math.atan2(dy, dx);
                }
                ++pathlenIndex;
            }
            fx0 = point[0];
            fy0 = point[1];
        }
        double remaining = pathlenIndex > 0 ? slen - pathlen[pathlenIndex - 1] : slen;
        if (result != null) {
            while (pathlenIndex < result.length) {
                result[pathlenIndex] = null;
                ++pathlenIndex;
            }
        }
        return remaining;
    }

    public static String getATScaleTranslateString(AffineTransform at) {
        DecimalFormat nf = new DecimalFormat("0.00");
        if (at == null) {
            return "null";
        }
        if (!at.isIdentity()) {
            String atDesc = "scaleX:" + nf.format(at.getScaleX()) + " translateX:" + nf.format(at.getTranslateX());
            atDesc = atDesc + "!cscaleY:" + nf.format(at.getScaleY()) + " translateY:" + nf.format(at.getTranslateY());
            return atDesc;
        }
        return "identity";
    }

    public static double[] getSlopeIntercept(double x0, double y0, double x1, double y1) {
        double slope = (y1 - y0) / (x1 - x0);
        double intercept = y0 - slope * x0;
        return new double[]{slope, intercept};
    }

    public static Color getRicePaperColor() {
        return ColorUtil.getRicePaperColor();
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public static BufferedImage blurImage(BufferedImage im, int size) {
        ConvolveOp op = GraphUtil.getGaussianBlurFilter(size, true);
        BufferedImage out = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        op.filter(im, out);
        op = GraphUtil.getGaussianBlurFilter(size, false);
        im = out;
        out = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        return op.filter(im, out);
    }

    public static String describe(GeneralPath path, boolean enumeratePoints) {
        PathIterator it = path.getPathIterator(null);
        int count = 0;
        int lineToCount = 0;
        double[] seg = new double[6];
        while (!it.isDone()) {
            int type = it.currentSegment(seg);
            if (type == 1) {
                ++lineToCount;
            }
            if (enumeratePoints) {
                if (type == 0) {
                    System.err.println(String.format(Locale.US, "moveTo( %9.2f, %9.2f )\n", seg[0], seg[1]));
                } else if (type == 1) {
                    System.err.println(String.format(Locale.US, "lineTo( %9.2f, %9.2f )\n", seg[0], seg[1]));
                } else {
                    System.err.println(String.format(Locale.US, "%4d( %9.2f, %9.2f )\n", type, seg[0], seg[1]));
                }
            }
            ++count;
            it.next();
        }
        System.err.println("count: " + count + "  lineToCount: " + lineToCount);
        return "count: " + count + "  lineToCount: " + lineToCount;
    }

    static String toString(Line2D line) {
        return "" + line.getX1() + "," + line.getY1() + " " + line.getX2() + "," + line.getY2();
    }

    public static Point2D lineIntersection(Line2D line1, Line2D line2, boolean noBoundsCheck) {
        double a1 = line1.getY2() - line1.getY1();
        double b1 = line1.getX1() - line1.getX2();
        double c1 = line1.getX2() * line1.getY1() - line1.getX1() * line1.getY2();
        double a2 = line2.getY2() - line2.getY1();
        double b2 = line2.getX1() - line2.getX2();
        double c2 = line2.getX2() * line2.getY1() - line2.getX1() * line2.getY2();
        double denom = a1 * b2 - a2 * b1;
        if (denom != 0.0) {
            Point2D.Double result = new Point2D.Double((b1 * c2 - b2 * c1) / denom, (a2 * c1 - a1 * c2) / denom);
            if (noBoundsCheck || (((Point2D)result).getX() - line1.getX1()) * (line1.getX2() - ((Point2D)result).getX()) >= 0.0 && (((Point2D)result).getY() - line1.getY1()) * (line1.getY2() - ((Point2D)result).getY()) >= 0.0 && (((Point2D)result).getX() - line2.getX1()) * (line2.getX2() - ((Point2D)result).getX()) >= 0.0 && (((Point2D)result).getY() - line2.getY1()) * (line2.getY2() - ((Point2D)result).getY()) >= 0.0) {
                return result;
            }
            return null;
        }
        return null;
    }

    public static Point2D lineRectangleIntersection(Point2D p0, Point2D p1, Rectangle2D r0) {
        PathIterator it = r0.getPathIterator(null);
        Line2D.Double line = new Line2D.Double(p0, p1);
        float[] c0 = new float[6];
        float[] c1 = new float[6];
        it.currentSegment(c0);
        it.next();
        while (!it.isDone()) {
            Line2D.Double seg;
            Point2D result;
            int type = it.currentSegment(c1);
            if (type == 1 && (result = GraphUtil.lineIntersection(line, seg = new Line2D.Double(c0[0], c0[1], c1[0], c1[1]), false)) != null) {
                return result;
            }
            it.next();
            c0[0] = c1[0];
            c0[1] = c1[1];
        }
        return null;
    }

    public static double[] transformRange(DasAxis axis, DatumRange range) {
        double x2;
        double x1 = axis.transform(range.min());
        if (x1 > (x2 = axis.transform(range.max()))) {
            double t = x2;
            x2 = x1;
            x1 = t;
        }
        return new double[]{x1, x2};
    }

    public static DatumRange invTransformRange(DasAxis axis, double x1, double x2) {
        Datum d2;
        Datum d1 = axis.invTransform(x1);
        if (d1.gt(d2 = axis.invTransform(x2))) {
            Datum t = d2;
            d2 = d1;
            d1 = t;
        }
        return new DatumRange(d1, d2);
    }

    public static Icon colorIcon(Color iconColor, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        if (iconColor.getAlpha() != 255) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    g.setColor((i - j) % 2 == 0 ? Color.GRAY : Color.WHITE);
                    g.fillRect(0 + i * 4, 0 + j * 4, 4, 4);
                }
            }
        }
        g.setColor(iconColor);
        g.fillRect(0, 0, w, h);
        return new ImageIcon(image);
    }

    public static Rectangle shrinkRectangle(Rectangle bounds, int percent) {
        Rectangle result = new Rectangle(bounds.x + bounds.width * (100 - percent) / 2 / 100, bounds.y + bounds.height * (100 - percent) / 2 / 100, bounds.width * percent / 100, bounds.height * percent / 100);
        return result;
    }

    public static Converter getFontConverter(final DasCanvasComponent dcc, final String fallbackFont) {
        return new Converter(){

            public Object convertForward(Object s) {
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)s);
                    Font f = dcc.getFont();
                    if (f == null) {
                        f = Font.decode(fallbackFont);
                    }
                    if (dd[1] == 1.0 && dd[2] == 0.0) {
                        return Float.valueOf(f.getSize2D());
                    }
                    double parentSize = f.getSize2D();
                    double newSize = dd[1] * parentSize + dd[2];
                    return Float.valueOf((float)newSize);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    return Float.valueOf(0.0f);
                }
            }

            public Object convertReverse(Object t) {
                float size = ((Float)t).floatValue();
                Font f = dcc.getFont();
                if (f == null) {
                    f = Font.decode(fallbackFont);
                }
                if (size == 0.0f) {
                    return "1em";
                }
                double parentSize = f.getSize2D();
                double relativeSize = (double)size / parentSize;
                return String.format(Locale.US, "%.2fem", relativeSize);
            }
        };
    }

    public static interface Copyable<T> {
        public T copy();
    }

    public static class DebuggingGeneralPath {
        GeneralPath delegate;
        int count = 0;
        double lastfx0 = 0.0;
        double lastfy0 = 0.0;
        double initx = 0.0;
        double inity = 0.0;
        boolean arrows = false;
        boolean printRoute = true;

        DebuggingGeneralPath(int rule, int capacity) {
            this.delegate = new GeneralPath(rule, capacity);
            System.err.println(String.format("==newPath==", new Object[0]));
            this.count = 0;
        }

        DebuggingGeneralPath() {
            this.delegate = new GeneralPath(1, 20);
            System.err.println(String.format("==newPath==", new Object[0]));
            this.count = 0;
        }

        public void setArrows(boolean drawArrows) {
            this.arrows = drawArrows;
        }

        public void lineTo(double fx, double fy) {
            int len;
            double n;
            double perpx;
            double perpy;
            if (this.printRoute) {
                System.err.println(String.format("lineTo(%5.1f,%5.1f) %d", fx, fy, this.count));
            }
            if (this.arrows && this.inity == this.lastfy0 && this.initx == this.lastfx0) {
                perpy = fx - this.lastfx0;
                perpx = -1.0 * (fy - this.lastfy0);
                n = Math.sqrt(perpx * perpx + perpy * perpy);
                len = 4;
                this.delegate.lineTo(this.lastfx0 - (perpx /= n) * (double)len, this.lastfy0 - (perpy /= n) * (double)len);
                this.delegate.lineTo(this.lastfx0 + perpx * (double)len, this.lastfy0 + perpy * (double)len);
                this.delegate.moveTo(this.lastfx0, this.lastfy0);
            }
            this.delegate.lineTo(fx, fy);
            if (this.arrows) {
                perpy = fx - this.lastfx0;
                perpx = -1.0 * (fy - this.lastfy0);
                n = Math.sqrt(perpx * perpx + perpy * perpy);
                len = 4;
                this.delegate.lineTo(fx + (perpx /= n) * (double)len - (perpy /= n) * (double)len, fy + perpy * (double)len + perpx * (double)len);
                this.delegate.lineTo(fx, fy);
            }
            this.lastfx0 = fx;
            this.lastfy0 = fy;
            ++this.count;
        }

        public void moveTo(double fx, double fy) {
            if (this.printRoute) {
                System.err.println(String.format("moveTo(%5.1f,%5.1f) %d", fx, fy, this.count));
            }
            this.delegate.moveTo(fx, fy);
            this.lastfx0 = fx;
            this.lastfy0 = fy;
            if (this.count == 0) {
                this.initx = fx;
                this.inity = fy;
            }
            ++this.count;
        }

        PathIterator getPathIterator(AffineTransform at) {
            return this.delegate.getPathIterator(at);
        }

        GeneralPath getGeneralPath() {
            return this.delegate;
        }
    }
}

