/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.LabelDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.system.DasLogger;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.ProgressMonitor;

public class EventsRenderer
extends Renderer {
    public static final String PROP_COLOR = "color";
    private boolean useOnlyEventsMap = false;
    int[] eventMap;
    private Shape selectionArea;
    public static final TextSpecifier DEFAULT_TEXT_SPECIFIER = new TextSpecifier(){

        @Override
        public String getText(DatumRange dr, Datum d) {
            Datum sy = DatumUtil.asOrderOneUnits(dr.width());
            if (dr.width().value() == 0.0) {
                if (d.toString().equals(dr.min().toString())) {
                    return d.toString();
                }
                return String.format("%s", d);
            }
            String ssy = sy.toString().trim();
            return String.format("%s (%s)!c%s", dr, ssy, d);
        }
    };
    private MouseModule mouseModule = null;
    private QDataSet cds = null;
    private int renderTimeLimitMs = 3000;
    private boolean useColor = false;
    private Color color = new Color(100, 100, 100);
    protected boolean showLabels = false;
    public static final String PROP_SHOWLABELS = "showLabels";
    protected boolean orbitMode = false;
    public static final String PROP_ORBITMODE = "orbitMode";
    private boolean ganttMode = false;
    public static final String PROP_GANTTMODE = "ganttMode";
    protected String fontSize = "1em";
    public static final String PROP_FONTSIZE = "fontSize";
    public static final String PROP_COLOR_SPECIFIER = "colorSpecifier";
    private ColorSpecifier colorSpecifier = null;
    private TextSpecifier textSpecifier = DEFAULT_TEXT_SPECIFIER;

    public static QDataSet doAutorange(QDataSet ds) {
        QDataSet xrange;
        QDataSet xmaxs;
        QDataSet xmins;
        DDataSet yrange = DDataSet.createRank1(2);
        yrange.putValue(0, 0.0);
        yrange.putValue(1, 10.0);
        if (ds.rank() == 1 && ds.property("DEPEND_0") == null) {
            xmins = ds;
            xmaxs = ds;
        } else if (ds.rank() == 1 && ds.property("DEPEND_0") != null) {
            xmaxs = xmins = (QDataSet)ds.property("DEPEND_0");
        } else if (ds.rank() == 0) {
            xmaxs = xmins = Ops.join(null, ds);
        } else {
            xmins = SemanticOps.xtagsDataSet(ds);
            xmaxs = ds.length(0) > 1 ? DataSetOps.unbundle(ds, 1) : xmins;
        }
        Units u0 = SemanticOps.getUnits(xmins);
        Units u1 = SemanticOps.getUnits(xmaxs);
        if (xmins.length() == 0) {
            xrange = DDataSet.wrap(new double[]{0.0, 1.0}, u0);
        } else {
            DDataSet dx;
            if (UnitsUtil.isIntervalOrRatioMeasurement(u1)) {
                xrange = Ops.extent(xmins);
                if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                    xmaxs = Ops.add(xmins, xmaxs);
                    xrange = Ops.extent(xmaxs, xrange);
                } else {
                    xrange = Ops.extent(xmaxs, xrange);
                }
            } else {
                xrange = DDataSet.createRank1(2);
                ((DDataSet)xrange).putValue(0, 0.0);
                ((DDataSet)xrange).putValue(1, 10.0);
            }
            if (xrange.value(0) < xrange.value(1)) {
                xrange = Ops.rescaleRangeLogLin(xrange, -0.1, 1.1);
            } else if (UnitsUtil.isTimeLocation(u0)) {
                dx = DDataSet.wrap(new double[]{-0.5, 0.5}, Units.hours);
                xrange = Ops.add(xrange, dx);
            } else {
                dx = DDataSet.wrap(new double[]{-1.0, 1.0}, u0.getOffsetUnits());
                xrange = Ops.add(xrange, dx);
            }
        }
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    Shape selectionArea() {
        return this.selectionArea == null ? SelectionUtil.NULL : this.selectionArea;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        if (this.selectionArea != null) {
            return this.selectionArea.contains(x, y);
        }
        return false;
    }

    @Override
    protected void installRenderer() {
        MouseModule mm = this.getMouseModule();
        DasPlot parent = this.getParent();
        parent.getDasMouseInputAdapter().addMouseModule(mm);
        parent.getDasMouseInputAdapter().setPrimaryModule(mm);
        super.installRenderer();
    }

    @Override
    protected void uninstallRenderer() {
        MouseModule mm = this.getMouseModule();
        DasPlot parent = this.getParent();
        parent.getDasMouseInputAdapter().removeMouseModule(mm);
        super.uninstallRenderer();
    }

    private MouseModule getMouseModule() {
        if (this.mouseModule == null) {
            DasPlot parent = this.getParent();
            this.mouseModule = new MouseModule(parent, new DragRenderer(parent), "Event Lookup");
        }
        return this.mouseModule;
    }

    private QDataSet coalesce(QDataSet vds) {
        QDataSet bds = (QDataSet)vds.property("BUNDLE_1");
        DataSetBuilder build = new DataSetBuilder(2, 100, 4);
        DDataSet v = DDataSet.createRank1(4);
        QDataSet dep0 = DataSetOps.unbundle(vds, 0);
        double tlim = 1.0E-31;
        RankZeroDataSet cad = DataSetUtil.guessCadenceNew(dep0, null);
        if (cad != null) {
            tlim = cad.value() / 100.0;
        }
        int count = 0;
        if (vds.length() == 0) {
            return vds;
        }
        v.putValue(0, vds.value(0, 0));
        v.putValue(1, vds.value(0, 1));
        v.putValue(2, vds.value(0, 2));
        v.putValue(3, vds.value(0, 3));
        for (int i = 1; i < vds.length(); ++i) {
            if (Math.abs(vds.value(i, 0) - vds.value(i - 1, 1)) > tlim || vds.value(i, 3) != vds.value(i - 1, 3) || Math.abs(vds.value(i, 2) - vds.value(i - 1, 2)) > 1.0E-31) {
                build.putValues(-1, v, 4);
                build.nextRecord();
                v.putValue(0, vds.value(i, 0));
                v.putValue(1, vds.value(i, 1));
                v.putValue(2, vds.value(i, 2));
                v.putValue(3, vds.value(i, 3));
                count = 1;
                continue;
            }
            v.putValue(1, vds.value(i, 1));
            ++count;
        }
        build.putValues(-1, v, 4);
        build.putProperty("BUNDLE_1", bds);
        return build.getDataSet();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private QDataSet makeCanonical(QDataSet vds) {
        void var4_16;
        QDataSet msgs;
        QDataSet xmaxs;
        QDataSet xmins;
        block32: {
            QDataSet w;
            Datum width;
            Units u0;
            QDataSet dep0;
            DasPlot parent;
            block30: {
                block28: {
                    block31: {
                        if (vds == null) {
                            return null;
                        }
                        parent = this.getParent();
                        if (vds.rank() != 2) break block30;
                        dep0 = (QDataSet)vds.property("DEPEND_0");
                        if (dep0 != null) break block31;
                        xmins = DataSetOps.unbundle(vds, 0);
                        xmaxs = DataSetOps.unbundle(vds, 1);
                        if (this.useColor) {
                            WritableDataSet writableDataSet = Ops.replicate(this.getColor().getRGB(), xmins.length());
                            break block28;
                        } else if (vds.length(0) > 3) {
                            QDataSet qDataSet = DataSetOps.unbundle(vds, 2);
                            break block28;
                        } else {
                            WritableDataSet writableDataSet = Ops.replicate(this.getColor().getRGB(), xmins.length());
                        }
                        break block28;
                    }
                    if (dep0.rank() == 2) {
                        if (!SemanticOps.isBins(dep0)) {
                            parent.postMessage((Renderer)this, "DEPEND_0 is rank 2 but not bins", DasPlot.WARNING, null, null);
                            return null;
                        }
                        xmins = DataSetOps.slice1(dep0, 0);
                        xmaxs = DataSetOps.slice1(dep0, 1);
                        WritableDataSet writableDataSet = Ops.replicate(this.getColor().getRGB(), xmins.length());
                        u0 = SemanticOps.getUnits(xmins);
                        Units u1 = SemanticOps.getUnits(xmaxs);
                        if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                            xmaxs = Ops.add(xmins, xmaxs);
                        }
                    } else {
                        if (dep0.rank() != 1) {
                            parent.postMessage((Renderer)this, "rank 2 dataset must have dep0 of rank 1 or rank 2 bins", DasPlot.WARNING, null, null);
                            return null;
                        }
                        width = SemanticOps.guessXTagWidth(dep0, null);
                        if (width != null) {
                            width = width.divide(2.0);
                        } else {
                            QDataSet sort = Ops.sort(dep0);
                            QDataSet diffs = Ops.diff(DataSetOps.applyIndex(dep0, 0, sort, false));
                            w = Ops.reduceMin(diffs, 0);
                            width = DataSetUtil.asDatum(w);
                        }
                        xmins = Ops.subtract(dep0, DataSetUtil.asDataSet(width));
                        xmaxs = Ops.add(dep0, DataSetUtil.asDataSet(width));
                        WritableDataSet writableDataSet = Ops.replicate(this.getColor().getRGB(), xmins.length());
                    }
                }
                msgs = DataSetOps.unbundle(vds, vds.length(0) - 1);
                break block32;
            }
            if (vds.rank() == 1) {
                dep0 = (QDataSet)vds.property("DEPEND_0");
                if (dep0 == null) {
                    if (UnitsUtil.isNominalMeasurement(SemanticOps.getUnits(vds))) {
                        xmins = new TagGenDataSet(vds.length(), 1.0, 0.0);
                        xmaxs = new TagGenDataSet(vds.length(), 1.0, 1.0);
                        msgs = vds;
                    } else {
                        xmins = vds;
                        xmaxs = vds;
                        msgs = vds;
                    }
                } else if (dep0.rank() == 2) {
                    if (!SemanticOps.isBins(dep0)) {
                        parent.postMessage((Renderer)this, "DEPEND_0 is rank 2 but not bins", DasPlot.WARNING, null, null);
                        return null;
                    }
                    xmins = DataSetOps.slice1(dep0, 0);
                    xmaxs = DataSetOps.slice1(dep0, 1);
                    u0 = SemanticOps.getUnits(xmins);
                    Units u1 = SemanticOps.getUnits(xmaxs);
                    if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                        xmaxs = Ops.add(xmins, xmaxs);
                    }
                    msgs = vds;
                } else {
                    if (dep0.rank() != 1) {
                        parent.postMessage((Renderer)this, "dataset is not correct form", DasPlot.WARNING, null, null);
                        return null;
                    }
                    width = SemanticOps.guessXTagWidth(dep0, null);
                    if (width != null) {
                        width = width.divide(2.0);
                    } else {
                        QDataSet sort = Ops.sort(dep0);
                        QDataSet diffs = Ops.diff(DataSetOps.applyIndex(dep0, 0, sort, false));
                        w = Ops.reduceMin(diffs, 0);
                        width = DataSetUtil.asDatum(w);
                    }
                    xmins = Ops.subtract(dep0, DataSetUtil.asDataSet(width));
                    xmaxs = Ops.add(dep0, DataSetUtil.asDataSet(width));
                    msgs = vds;
                }
                Color c0 = this.getColor();
                Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), c0.getAlpha() == 255 ? 128 : c0.getAlpha());
                int irgb = c1.getRGB();
                WritableDataSet writableDataSet = Ops.replicate(irgb, xmins.length());
            } else {
                if (vds.rank() != 0) {
                    parent.postMessage((Renderer)this, "dataset must be rank 0, 1 or 2", DasPlot.WARNING, null, null);
                    return null;
                }
                xmaxs = xmins = Ops.replicate(vds, 1);
                Color c0 = this.getColor();
                Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), c0.getAlpha() == 255 ? 128 : c0.getAlpha());
                int irgb = c1.getRGB();
                WritableDataSet writableDataSet = Ops.replicate(irgb, xmins.length());
                msgs = Ops.replicate(vds, 1);
            }
        }
        if (this.colorSpecifier != null) {
            void var4_14;
            Units u = SemanticOps.getUnits(msgs);
            ArrayDataSet wds = IDataSet.copy((QDataSet)var4_14);
            for (int i = 0; i < msgs.length(); ++i) {
                wds.putValue(i, this.colorSpecifier.getColor(Datum.create(msgs.value(i), u)).getRGB());
            }
            ArrayDataSet arrayDataSet = wds;
        }
        Units u0 = SemanticOps.getUnits(xmins);
        Units u1 = SemanticOps.getUnits(xmaxs);
        if (!u1.isConvertibleTo(u0.getOffsetUnits())) return Ops.bundle(xmins, xmaxs, (QDataSet)var4_16, msgs);
        if (u1.isConvertibleTo(u0)) return Ops.bundle(xmins, xmaxs, (QDataSet)var4_16, msgs);
        xmaxs = Ops.add(xmins, xmaxs);
        return Ops.bundle(xmins, xmaxs, (QDataSet)var4_16, msgs);
    }

    @Override
    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        GeneralPath sa = new GeneralPath();
        QDataSet vds = this.getDataSet();
        if (vds == null) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            return;
        }
        if (vds.rank() > 0 && vds.length() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("empty data set");
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setColor(this.color);
        if (this.cds == null) {
            return;
        }
        QDataSet xmins = DataSetOps.unbundle(this.cds, 0);
        QDataSet xmaxs = DataSetOps.unbundle(this.cds, 1);
        QDataSet msgs = DataSetOps.unbundle(this.cds, 3);
        Units eu = SemanticOps.getUnits(msgs);
        QDataSet lcolor = DataSetOps.unbundle(this.cds, 2);
        long t0 = System.currentTimeMillis();
        DasPlot parent = this.getParent();
        Rectangle current = null;
        if (this.lastException != null) {
            this.renderException(g, xAxis, yAxis, this.lastException);
        } else {
            DasColumn column = xAxis.getColumn();
            DasRow row = parent.getRow();
            this.eventMap = new int[column.getWidth()];
            for (int k = 0; k < this.eventMap.length; ++k) {
                this.eventMap[k] = -1;
            }
            QDataSet wxmins = SemanticOps.weightsDataSet(xmins);
            QDataSet xds = xmins;
            Units xunits = SemanticOps.getUnits(xds);
            if (!xunits.isConvertibleTo(xAxis.getUnits()) && UnitsUtil.isRatioMeasurement(xunits)) {
                parent.postMessage((Renderer)this, "x axis units changed from \"" + xunits + "\" to \"" + xAxis.getUnits() + "\"", DasPlot.INFO, null, null);
                xunits = xAxis.getUnits();
            }
            if (this.cds.length() > 0) {
                int gymin;
                int gymax;
                int ivds0 = 0;
                int ivds1 = xmins.length();
                Font f = this.getParent().getFont();
                if (this.getFontSize() != null && this.getFontSize().length() > 0 && !this.getFontSize().equals("1em")) {
                    try {
                        double[] size = DasDevicePosition.parseLayoutStr(this.getFontSize());
                        double s = (double)f.getSize2D() * size[0] / 100.0 + (double)f.getSize2D() * size[1] + size[2];
                        f = f.deriveFont((float)s);
                    }
                    catch (ParseException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                g1.setFont(f);
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> pam = new HashMap<Integer, Integer>();
                try {
                    QDataSet s = Ops.sort(msgs);
                    QDataSet u = Ops.uniq(msgs, s);
                    gymax = u.length();
                    gymin = 0;
                    for (int i = 0; i < u.length(); ++i) {
                        map.put((int)msgs.value((int)u.value(i)), i);
                        pam.put(i, (int)msgs.value((int)u.value(i)));
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                    return;
                }
                int lastMessageTailX = -10000;
                gtr.setString(g1, "xxx");
                int textHeight = (int)gtr.getHeight();
                int imin = xAxis.getColumn().getDMinimum();
                int imax = xAxis.getColumn().getDMaximum();
                for (int i = ivds0; i < ivds1; ++i) {
                    Rectangle r1;
                    long dt = System.currentTimeMillis() - t0;
                    if (i % 10 == 0 && dt > (long)this.renderTimeLimitMs) {
                        parent.postMessage((Renderer)this, "renderer ran out of time, dataset truncated", DasPlot.WARNING, null, null);
                        break;
                    }
                    if (wxmins.value(i) == 0.0) continue;
                    int ixmin = (int)xAxis.transform(xmins.value(i), xunits);
                    int ixmax = (int)xAxis.transform(xmaxs.value(i), xunits);
                    if (ixmax <= -10000 || ixmin >= 10000) continue;
                    ixmin = Math.max(ixmin, imin);
                    ixmax = Math.min(ixmax, imax);
                    int iwidth = Math.max(ixmax - ixmin, 1);
                    if (lcolor != null) {
                        int irgb = (int)lcolor.value(i);
                        int rr = (irgb & 0xFF0000) >> 16;
                        int gg = (irgb & 0xFF00) >> 8;
                        int bb = irgb & 0xFF;
                        int aa = irgb >> 24 & 0xFF;
                        if (aa > 0) {
                            g.setColor(new Color(rr, gg, bb, aa));
                        } else {
                            g.setColor(new Color(rr, gg, bb, 128));
                        }
                    }
                    if (column.getDMinimum() >= ixmax && column.getDMaximum() <= ixmin) continue;
                    if (iwidth == 0) {
                        iwidth = 1;
                    }
                    if (this.orbitMode) {
                        r1 = new Rectangle(ixmin, row.getDMaximum() - textHeight, iwidth - 1, textHeight);
                        g.fill(r1);
                    } else if (this.ganttMode) {
                        int ord = (int)msgs.value(i);
                        int iy = (Integer)map.get(ord);
                        int iymin = row.getDMinimum() + row.getHeight() * iy / (gymax - gymin) + 1;
                        int iymax = row.getDMinimum() + row.getHeight() * (1 + iy) / (gymax - gymin) - 1;
                        r1 = new Rectangle(ixmin, iymin, iwidth, Math.max(iymax - iymin, 2));
                        g.fill(r1);
                    } else {
                        r1 = new Rectangle(ixmin, row.getDMinimum(), iwidth, row.getHeight());
                        g.fill(r1);
                    }
                    r1.x -= 2;
                    r1.y -= 2;
                    r1.width += 4;
                    r1.height += 4;
                    if (current == null) {
                        current = r1;
                    } else if (current.intersects(r1)) {
                        current = current.union(r1);
                    } else {
                        sa.append(current, false);
                        current = r1;
                    }
                    int im = ixmin - column.getDMinimum();
                    int em0 = im - 1;
                    int em1 = im + iwidth + 1;
                    for (int k = em0; k < em1; ++k) {
                        if (k < 0 || k >= this.eventMap.length) continue;
                        this.eventMap[k] = i;
                    }
                    if (this.showLabels) {
                        DatumRange dr = new DatumRange(xmins.value(i), xmaxs.value(i), xunits);
                        Datum d = eu.createDatum(msgs.value(i));
                        String text = this.textSpecifier.getText(dr, d);
                        gtr.setString(g1, text);
                        gtr.draw(g1, ixmin + 2, row.getDMinimum() + (int)gtr.getAscent());
                    }
                    if (!this.orbitMode) continue;
                    String text = eu.createDatum(msgs.value(i)).toString();
                    gtr.setString(g1, text);
                    Color c0 = g1.getColor();
                    g1.setColor(this.getParent().getBackground());
                    gtr.draw(g1, ixmin + 2 - 1, row.getDMaximum() - textHeight + (int)gtr.getAscent());
                    gtr.draw(g1, ixmin + 2, row.getDMaximum() - textHeight + (int)gtr.getAscent() + 1);
                    gtr.draw(g1, ixmin + 2 + 1, row.getDMaximum() - textHeight + (int)gtr.getAscent());
                    gtr.draw(g1, ixmin + 2, row.getDMaximum() - textHeight + (int)gtr.getAscent() - 1);
                    g1.setColor(c0);
                    gtr.draw(g1, ixmin + 2, row.getDMaximum() - textHeight + (int)gtr.getAscent());
                    lastMessageTailX = ixmin + 2 + (int)gtr.getWidth();
                }
                if (current != null) {
                    sa.append(current, false);
                }
                if (this.ganttMode) {
                    g1.setColor(this.color);
                    int di = Math.max(1, (gymax - gymin - 1) / (row.getHeight() / textHeight));
                    for (int i = gymin; i < gymax; i += di) {
                        gtr.setString(g1, eu.createDatum((Number)pam.get(i)).toString());
                        int iymin = row.getDMinimum() + row.getHeight() * (i - gymin) / (gymax - gymin);
                        Color c0 = g1.getColor();
                        g1.setColor(Color.white);
                        gtr.draw(g1, column.getDMinimum() + textHeight / 3 - 1, iymin + textHeight);
                        gtr.draw(g1, column.getDMinimum() + textHeight / 3, iymin + textHeight + 1);
                        gtr.draw(g1, column.getDMinimum() + textHeight / 3 + 1, iymin + textHeight);
                        gtr.draw(g1, column.getDMinimum() + textHeight / 3, iymin + textHeight - 1);
                        g1.setColor(c0);
                        gtr.draw(g1, column.getDMinimum() + textHeight / 3, iymin + textHeight);
                    }
                }
                for (int k1 = 1; k1 <= 2; ++k1) {
                    for (int k2 = -1; k2 <= 1; k2 += 2) {
                        int em0 = k2 == 1 ? 0 : this.eventMap.length - 1;
                        int em1 = k2 == 1 ? this.eventMap.length - k1 : k1;
                        for (int k = em0; k != em1; k += k2) {
                            if (this.eventMap[k] != -1) continue;
                            this.eventMap[k] = this.eventMap[k + k2];
                        }
                    }
                }
            }
        }
        g.dispose();
        this.selectionArea = sa;
    }

    @Override
    public void setDataSet(QDataSet ds) {
        this.cds = this.makeCanonical(ds);
        super.setDataSet(ds);
    }

    @Override
    public Icon getListIcon() {
        return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/eventsBar.png"));
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.setShowLabels(this.getBooleanControl(PROP_SHOWLABELS, false));
        this.setOrbitMode(this.getBooleanControl(PROP_ORBITMODE, false));
        this.setFontSize(this.getControl(PROP_FONTSIZE, "1em"));
        this.setGanttMode(this.getBooleanControl(PROP_GANTTMODE, false));
        if (this.hasControl(PROP_COLOR)) {
            this.setColor(this.getColorControl(PROP_COLOR, this.color));
            this.useColor = true;
        } else {
            this.setColor(new Color(100, 100, 100));
        }
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_SHOWLABELS, EventsRenderer.encodeBooleanControl(this.isShowLabels()));
        controls.put(PROP_ORBITMODE, EventsRenderer.encodeBooleanControl(this.isOrbitMode()));
        controls.put(PROP_FONTSIZE, this.getFontSize());
        controls.put(PROP_GANTTMODE, EventsRenderer.encodeBooleanControl(this.isGanttMode()));
        if (this.useColor) {
            controls.put(PROP_COLOR, EventsRenderer.encodeColorControl(this.color));
        }
        return Renderer.formatControl(controls);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color old = this.color;
        this.color = color;
        this.cds = this.makeCanonical(this.getDataSet());
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, old, color);
        super.invalidateParentCacheImage();
    }

    public int getRenderTimeLimitMs() {
        return this.renderTimeLimitMs;
    }

    public void setRenderTimeLimitMs(int renderTimeLimitMs) {
        this.renderTimeLimitMs = renderTimeLimitMs;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        boolean oldShowLabels = this.showLabels;
        this.showLabels = showLabels;
        DasPlot parent = this.getParent();
        if (parent != null) {
            parent.invalidateCacheImage();
            parent.repaint();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_SHOWLABELS, oldShowLabels, showLabels);
    }

    public boolean isOrbitMode() {
        return this.orbitMode;
    }

    public void setOrbitMode(boolean orbitMode) {
        boolean oldOrbitMode = this.orbitMode;
        this.orbitMode = orbitMode;
        this.propertyChangeSupport.firePropertyChange(PROP_ORBITMODE, oldOrbitMode, orbitMode);
    }

    public boolean isGanttMode() {
        return this.ganttMode;
    }

    public void setGanttMode(boolean ganttMode) {
        boolean oldGanttMode = this.ganttMode;
        this.ganttMode = ganttMode;
        this.propertyChangeSupport.firePropertyChange(PROP_GANTTMODE, oldGanttMode, ganttMode);
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.propertyChangeSupport.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public void setColorSpecifier(ColorSpecifier spec) {
        ColorSpecifier old = this.colorSpecifier;
        this.colorSpecifier = spec;
        this.cds = this.makeCanonical(this.ds);
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR_SPECIFIER, old, spec);
        super.invalidateParentCacheImage();
    }

    public ColorSpecifier getColorSpecifier() {
        return this.colorSpecifier;
    }

    public TextSpecifier getTextSpecifier() {
        return this.textSpecifier;
    }

    public void setTextSpecifier(TextSpecifier textSpecifier) {
        TextSpecifier oldTextSpecifier = this.textSpecifier;
        this.textSpecifier = textSpecifier;
        this.propertyChangeSupport.firePropertyChange("textSpecifier", oldTextSpecifier, textSpecifier);
    }

    public static interface ColorSpecifier {
        public Color getColor(Datum var1);
    }

    private class DragRenderer
    extends LabelDragRenderer {
        DasPlot parent;

        DragRenderer(DasPlot parent) {
            super(parent);
            this.parent = parent;
            this.setTooltip(true);
        }

        @Override
        public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
            QDataSet vds = EventsRenderer.this.getDataSet();
            if (vds == null) {
                return new Rectangle[0];
            }
            if (vds.rank() == 0) {
                return new Rectangle[0];
            }
            if (vds.length() == 0) {
                return new Rectangle[0];
            }
            QDataSet ds = EventsRenderer.this.cds;
            if (ds == null) {
                return new Rectangle[0];
            }
            QDataSet xmins = DataSetOps.unbundle(ds, 0);
            QDataSet xmaxs = DataSetOps.unbundle(ds, 1);
            QDataSet msgs = DataSetOps.unbundle(ds, ds.length(0) - 1);
            int ix = (int)p2.getX() - this.parent.getColumn().getDMinimum();
            Datum px = this.parent.getXAxis().invTransform(p2.getX());
            if (ix < 0 || EventsRenderer.this.eventMap == null || ix >= EventsRenderer.this.eventMap.length) {
                this.setLabel(null);
            } else {
                Units sxunits = SemanticOps.getUnits(xmins);
                Units zunits = SemanticOps.getUnits(msgs);
                Units sxmaxunits = SemanticOps.getUnits(xmaxs);
                ArrayList<Integer> ii = new ArrayList<Integer>();
                if (EventsRenderer.this.useOnlyEventsMap && EventsRenderer.this.eventMap[ix] > -1) {
                    ii.add(EventsRenderer.this.eventMap[ix]);
                } else {
                    if (EventsRenderer.this.eventMap[ix] > -1) {
                        ii.add(EventsRenderer.this.eventMap[ix]);
                    }
                    for (int i = 0; i < xmaxs.length(); ++i) {
                        double sxmin = xmins.value(i);
                        double sxmax = xmaxs.value(i);
                        sxmax = !sxmaxunits.isConvertibleTo(sxunits) ? (sxmaxunits.isConvertibleTo(sxunits.getOffsetUnits()) ? sxmin + sxmaxunits.convertDoubleTo(sxunits.getOffsetUnits(), sxmax) : sxmin) : sxmaxunits.convertDoubleTo(sxunits, sxmax);
                        if (sxmax < sxmin) {
                            this.setLabel("Error, sxmax<sxmin: " + Datum.create(sxmax, sxunits) + " < " + Datum.create(sxmin, sxmaxunits));
                            continue;
                        }
                        DatumRange dr = new DatumRange(sxmin, sxmax, sxunits);
                        if (!dr.getUnits().isConvertibleTo(px.getUnits())) {
                            Renderer.logger.fine("inconvertible units");
                            return new Rectangle[0];
                        }
                        if (!dr.contains(px) || ii.contains(i)) continue;
                        ii.add(i);
                    }
                }
                if (ii.size() >= 0) {
                    StringBuilder sb = new StringBuilder();
                    int count = 0;
                    for (Integer ii1 : ii) {
                        int i = ii1;
                        double sxmin = xmins.value(i);
                        double sxmax = xmaxs.value(i);
                        sxmax = !sxmaxunits.isConvertibleTo(sxunits) ? (sxmaxunits.isConvertibleTo(sxunits.getOffsetUnits()) ? sxmin + sxmaxunits.convertDoubleTo(sxunits.getOffsetUnits(), sxmax) : sxmin) : sxmaxunits.convertDoubleTo(sxunits, sxmax);
                        if (sxmax < sxmin) {
                            sb.append("Error, sxmax<sxmin!c");
                        } else {
                            String ss;
                            DatumRange dr = new DatumRange(sxmin, sxmax, sxunits);
                            try {
                                Datum sz = zunits.createDatum(msgs.value(i));
                                ss = EventsRenderer.this.textSpecifier.getText(dr, sz);
                            }
                            catch (RuntimeException ex) {
                                ss = "" + dr + " fill";
                            }
                            sb.append(ss).append("!c");
                        }
                        if (++count <= 10) continue;
                        break;
                    }
                    if (ii.size() > count) {
                        sb.append("(").append(ii.size() - count).append(" more items not shown)");
                    }
                    this.setLabel(sb.toString());
                } else {
                    this.setLabel(null);
                }
            }
            return super.renderDrag(g, p1, p2);
        }
    }

    public static interface TextSpecifier {
        public String getText(DatumRange var1, Datum var2);
    }
}

