/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import org.das2.DasApplication;
import org.das2.dataset.RebinDescriptor;
import org.das2.graph.DasAxis;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;

public abstract class DataLoader {
    Renderer renderer;
    private boolean fullResolution = false;
    private boolean reloadDataSet;
    private boolean active = true;

    protected ProgressMonitor getMonitor(String description) {
        return DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(this.renderer.getParent(), "Loading data set", description);
    }

    protected DataLoader(Renderer renderer) {
        this.renderer = renderer;
    }

    public abstract void update();

    public boolean isFullResolution() {
        return this.fullResolution;
    }

    public void setFullResolution(boolean b) {
        if (this.fullResolution == b) {
            return;
        }
        this.fullResolution = b;
        this.update();
    }

    public void setReloadDataSet(boolean reloadDataSet) {
        if (reloadDataSet) {
            this.renderer.setDataSet(null);
            this.renderer.getParent().markDirty();
            this.renderer.getParent().update();
        }
        reloadDataSet = false;
    }

    public boolean isReloadDataSet() {
        return this.reloadDataSet;
    }

    protected Renderer getRenderer() {
        return this.renderer;
    }

    protected RebinDescriptor getRebinDescriptor(DasAxis axis) {
        int npix = axis.getOrientation() == 3 ? axis.getRow().getHeight() : axis.getColumn().getWidth();
        RebinDescriptor rebinDescriptor = new RebinDescriptor(axis.getDataMinimum(), axis.getDataMaximum(), npix, axis.isLog());
        rebinDescriptor.setOutOfBoundsAction(-3);
        return rebinDescriptor;
    }

    public boolean isActive() {
        return this.active && this.renderer.isActive();
    }

    public void setActive(boolean active) {
        this.active = active;
        this.update();
    }

    public static class Request {
        public ProgressMonitor monitor;
        public DasAxis.Memento xmem;
        public DasAxis.Memento ymem;

        public Request(ProgressMonitor mon, DasAxis.Memento xmem, DasAxis.Memento ymem) {
            this.monitor = mon;
            this.xmem = xmem;
            this.ymem = ymem;
        }

        public String toString() {
            return this.xmem.toString();
        }
    }
}

