/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasAxis;

public class DataGeneralPathBuilder {
    private static final Logger logger = LoggerManager.getLogger("das2.graph.renderer.path");
    private final GeneralPath gp;
    private int pointCount = 0;
    private final DasAxis xaxis;
    private final DasAxis yaxis;
    private final Units xunits;
    private final Units yunits;
    private static final Object PEN_UP = "penup";
    private static final Object PEN_DOWN = "pendown";
    private Object pen = PEN_UP;
    private Datum pendingx = null;
    private Datum pendingy = null;
    private double lastx = -1.7976931348623157E308;
    private double cadence = 0.0;
    private boolean logStep = false;

    public DataGeneralPathBuilder(DasAxis xaxis, DasAxis yaxis) {
        this.gp = new GeneralPath();
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.xunits = xaxis.getUnits();
        this.yunits = yaxis.getUnits();
        logger.fine("-----");
    }

    public void setCadence(Datum sw) {
        if (sw == null) {
            this.cadence = 0.0;
            this.logStep = false;
        } else if (UnitsUtil.isRatiometric(sw.getUnits())) {
            this.cadence = sw.multiply(1.2).doubleValue(Units.logERatio);
            this.logStep = true;
        } else {
            try {
                this.cadence = sw.multiply(1.2).doubleValue(this.xunits.getOffsetUnits());
            }
            catch (InconvertibleUnitsException ex) {
                this.cadence = sw.multiply(1.2).doubleValue(sw.getUnits());
            }
        }
    }

    public void addDataPoint(boolean valid, Datum x, Datum y) {
        double xx = x.doubleValue(this.xunits);
        double yy = y.doubleValue(this.yunits);
        this.addDataPoint(valid, xx, yy);
    }

    public void addDataPoint(boolean valid, double x, double y) {
        ++this.pointCount;
        if (this.pointCount == 1) {
            logger.fine("here 1");
        }
        if (this.lastx > x) {
            logger.log(Level.FINE, "data step back: {0} -> {1}", new Object[]{this.xunits.createDatum(this.lastx), this.xunits.createDatum(x)});
        }
        if (this.cadence > 0.0 && this.pen == PEN_DOWN) {
            double step;
            double d = step = this.logStep ? Math.log(x / this.lastx) : x - this.lastx;
            if (step > this.cadence) {
                this.pen = PEN_UP;
            }
        }
        if (this.pen == PEN_UP) {
            if (valid) {
                this.gp.moveTo(this.xaxis.transform(x, this.xunits), this.yaxis.transform(y, this.yunits));
                this.pen = PEN_DOWN;
                this.pendingx = this.xunits.createDatum(x);
                this.pendingy = this.yunits.createDatum(y);
            } else {
                this.pen = PEN_UP;
            }
        } else {
            if (valid) {
                this.gp.lineTo(this.xaxis.transform(x, this.xunits), this.yaxis.transform(y, this.yunits));
            } else {
                if (this.pendingx != null) {
                    this.gp.lineTo(this.xaxis.transform(this.pendingx), this.yaxis.transform(this.pendingy));
                }
                this.pen = PEN_UP;
            }
            this.pendingx = null;
            this.pendingy = null;
        }
        this.lastx = x;
    }

    public GeneralPath getGeneralPath() {
        return this.gp;
    }

    public PathIterator getPathIterator() {
        return this.gp.getPathIterator(null);
    }
}

