/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.ColorWedgeColorSource;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;

public class DasColorBar
extends DasAxis {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    private BufferedImage image;
    private transient Type type;
    private static int fillColor = Color.LIGHT_GRAY.getRGB();
    private int fillColorIndex;
    private int ncolor;
    private static final int COLORTABLE_SIZE = 240;
    private boolean showColorBar = true;
    public static final String PROP_SHOWCOLORBAR = "showColorBar";

    public DasColorBar(Datum min, Datum max, boolean log) {
        this(min, max, 4, log);
    }

    public DasColorBar(Datum min, Datum max, int orientation, boolean log) {
        super(min, max, orientation, log);
        this.setLayout(new ColorBarLayoutManager());
        this.setType(Type.COLOR_WEDGE);
    }

    public int rgbTransform(double data, Units units) {
        int icolor = (int)this.transform(data, units, 0, this.ncolor);
        if (units.isFill(data)) {
            return fillColor;
        }
        icolor = icolor < 0 ? 0 : icolor;
        icolor = icolor >= this.ncolor ? this.ncolor - 1 : icolor;
        return this.type.getRGB(icolor);
    }

    public int indexColorTransform(double data, Units units) {
        if (units.isFill(data)) {
            return this.fillColorIndex;
        }
        int icolor = (int)this.transform(data, units, 0, this.ncolor);
        icolor = icolor < 0 ? 0 : icolor;
        icolor = icolor >= this.ncolor ? this.ncolor - 1 : icolor;
        return icolor;
    }

    public IndexColorModel getIndexColorModel() {
        return new IndexColorModel(8, this.type.getColorCount() + 1, this.type.colorTable, 0, true, -1, 0);
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        if (this.type == type) {
            return;
        }
        Type oldValue = this.type;
        this.type = type;
        this.ncolor = type.getColorCount();
        this.image = null;
        this.fillColorIndex = this.getType().getColorCount();
        fillColor = this.getType().getRGB(this.fillColorIndex);
        this.markDirty(PROPERTY_TYPE);
        this.update();
        this.firePropertyChange(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getCanvas().isValueAdjusting()) {
            return;
        }
        if (this.showColorBar) {
            int x = this.getColumn().getDMinimum();
            int y = this.getRow().getDMinimum();
            int width = this.getColumn().getDMaximum() - x;
            int height = this.getRow().getDMaximum() - y;
            this.image = this.isHorizontal() ? this.type.getHorizontalScaledImage(width, height) : this.type.getVerticalScaledImage(width, height + 1);
            g.translate(-this.getX(), -this.getY());
            try {
                g.drawImage(this.image, x, y, this);
            }
            catch (ClassCastException ex) {
                System.err.println("rte_1917581137: " + ex.getMessage());
            }
            g.translate(this.getX(), this.getY());
        }
        super.paintComponent(g);
    }

    @Override
    protected Rectangle getAxisBounds() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int width = this.getColumn().getDMaximum() - x;
        int height = this.getRow().getDMaximum() - y;
        Rectangle rc = new Rectangle(x, y, width, height);
        Rectangle bounds = super.getAxisBounds();
        bounds.add(rc);
        return bounds;
    }

    public static DasColumn getColorBarColumn(DasColumn column) {
        return new DasColumn(null, column, 1.0, 1.0, 1.0, 2.0, 0, 0);
    }

    @Override
    public Shape getActiveRegion() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int width = this.getColumn().getWidth();
        int height = this.getRow().getHeight();
        Rectangle bounds = this.primaryInputPanel.getBounds();
        bounds.translate(this.getX(), this.getY());
        Rectangle middleBounds = new Rectangle(x, y, width, height);
        bounds.add(middleBounds);
        if (this.isOppositeAxisVisible()) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            bounds.add(secondaryBounds);
        }
        return bounds;
    }

    public boolean isShowColorBar() {
        return this.showColorBar;
    }

    public void setShowColorBar(boolean showColorBar) {
        boolean oldShowColorBar = this.showColorBar;
        this.showColorBar = showColorBar;
        this.firePropertyChange(PROP_SHOWCOLORBAR, oldShowColorBar, showColorBar);
    }

    public Color getFillColor() {
        return new Color(fillColor, true);
    }

    public void setFillColor(Color fillColor) {
        Color oldColor = new Color(DasColorBar.fillColor);
        DasColorBar.fillColor = fillColor.getRGB();
        this.type.initializeColorTable(240, 0, this.type.getColorCount());
        this.markDirty(PROPERTY_FILL_COLOR);
        this.update();
        this.firePropertyChange(PROPERTY_FILL_COLOR, oldColor, fillColor);
    }

    protected class ColorBarLayoutManager
    extends DasAxis.AxisLayoutManager {
        protected ColorBarLayoutManager() {
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            int x = DasColorBar.this.getColumn().getDMinimum();
            int y = DasColorBar.this.getRow().getDMinimum();
            int width = DasColorBar.this.getColumn().getWidth();
            int height = DasColorBar.this.getRow().getHeight();
            Rectangle rc = new Rectangle(x - DasColorBar.this.getX(), y - DasColorBar.this.getY(), width, height);
            Rectangle bounds = DasColorBar.this.primaryInputPanel.getBounds();
            bounds.add(rc);
            DasColorBar.this.primaryInputPanel.setBounds(bounds);
        }
    }

    public static final class Type
    implements Enumeration,
    Displayable {
        public static final Type COLOR_WEDGE = new Type("color_wedge");
        public static final Type APL_RAINBOW_BLACK0 = new Type("apl_rainbow_black0");
        public static final Type APL_RAINBOW_WHITE0 = new Type("apl_rainbow_white0");
        public static final Type GSFC_RP_SPECIAL = new Type("gsfc_rp_special");
        public static final Type MATLAB_JET = new Type("matlab_jet");
        public static final Type MATLAB_JET_BLACK0 = new Type("matlab_jet_black0");
        public static final Type BLUE_TO_ORANGE = new Type("blue_to_orange");
        public static final Type GRAYSCALE = new Type("grayscale");
        public static final Type INVERSE_GRAYSCALE = new Type("inverse_grayscale");
        public static final Type WRAPPED_COLOR_WEDGE = new Type("wrapped_color_wedge");
        public static final Type BLUE_BLACK_RED_WEDGE = new Type("blue_black_red");
        public static final Type BLUE_WHITE_RED_WEDGE = new Type("blue_white_red");
        public static final Type BLACK_RED = new Type("black_red");
        public static final Type BLACK_GREEN = new Type("black_green");
        public static final Type BLACK_BLUE = new Type("black_blue");
        public static final Type WHITE_BLUE_BLACK = new Type("white_blue_black");
        public static final Type INVERSE_WHITE_BLUE_BLACK = new Type("inverse_white_blue_black");
        public static final Type VIOLET_YELLOW = new Type("violet_yellow");
        public static final Type SCIPY_PLASMA = new Type("scipy_plasma");
        private BufferedImage image;
        private int[] colorTable;
        private final String desc;
        private Icon icon;
        private static Map<String, Type> extraTypes = new HashMap<String, Type>();

        private Type(String desc) {
            this.desc = desc;
        }

        public Type(String desc, int[] colorTable) {
            this.desc = desc;
            this.colorTable = colorTable;
            extraTypes.put(desc, this);
        }

        @Override
        public void drawListIcon(Graphics2D g, int x, int y) {
            ImageIcon licon = (ImageIcon)this.getListIcon();
            g.drawImage(licon.getImage(), x, y, null);
        }

        @Override
        public Icon getListIcon() {
            this.maybeInitializeIcon();
            return this.icon;
        }

        public void maybeInitializeIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(this.getVerticalScaledImage(16, 16));
            }
        }

        @Override
        public String toString() {
            return this.desc;
        }

        @Override
        public String getListLabel() {
            return this.desc;
        }

        public int getColorCount() {
            this.maybeInitializeColorTable();
            return this.colorTable.length - 1;
        }

        public int getRGB(int index) {
            this.maybeInitializeColorTable();
            return this.colorTable[index];
        }

        public BufferedImage getHorizontalScaledImage(int width, int height) {
            this.maybeInitializeImage();
            BufferedImage scaled = new BufferedImage(width, height, 1);
            AffineTransform at = new AffineTransform();
            at.scale((double)width / (double)this.getColorCount(), height);
            at.rotate(-1.5707963267948966);
            at.translate(-1.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, 1);
            op.filter(this.image, scaled);
            return scaled;
        }

        public BufferedImage getVerticalScaledImage(int width, int height) {
            this.maybeInitializeImage();
            BufferedImage scaled = new BufferedImage(width, height, 1);
            AffineTransform at = new AffineTransform();
            at.scale(width, -((double)height) / (double)this.getColorCount());
            at.translate(0.0, -((double)this.getColorCount()));
            AffineTransformOp op = new AffineTransformOp(at, 1);
            op.filter(this.image, scaled);
            return scaled;
        }

        private void maybeInitializeImage() {
            if (this.image == null) {
                this.maybeInitializeColorTable();
                this.image = new BufferedImage(1, this.getColorCount(), 1);
                this.image.setRGB(0, 0, 1, this.getColorCount(), this.colorTable, 0, 1);
            }
        }

        public static int[] makeColorTable(int[] index, int[] red, int[] green, int[] blue, int ncolor, int bottom, int top) {
            int[] colorTable = new int[ncolor];
            int ii = 0;
            for (int i = 0; i < ncolor - 1; ++i) {
                double a;
                int comp = (i - bottom) * 255 / (top - bottom);
                if (comp > index[ii + 1]) {
                    ++ii;
                }
                if (ii >= index.length - 1) {
                    a = 1.0;
                    ii = index.length - 2;
                } else {
                    a = (double)(comp - index[ii]) / (double)(index[ii + 1] - index[ii]);
                }
                if (a > 1.0) {
                    a = 1.0;
                }
                if (a < 0.0) {
                    a = 0.0;
                }
                double rr = ((double)red[ii] * (1.0 - a) + (double)red[ii + 1] * a) / 255.0;
                double gg = ((double)green[ii] * (1.0 - a) + (double)green[ii + 1] * a) / 255.0;
                double bb = ((double)blue[ii] * (1.0 - a) + (double)blue[ii + 1] * a) / 255.0;
                colorTable[i] = new Color((float)rr, (float)gg, (float)bb).getRGB();
            }
            colorTable[ncolor - 1] = fillColor;
            return colorTable;
        }

        private void maybeInitializeColorTable() {
            if (this.colorTable == null) {
                this.initializeColorTable(240, 0, 240);
            }
        }

        private void initializeColorTable(int size, int bottom, int top) {
            if (this == COLOR_WEDGE) {
                this.initializeColorWedge(size, bottom, top);
            } else if (this == APL_RAINBOW_WHITE0) {
                this.initializeColorWedgeWhite(size, bottom, top);
            } else if (this == APL_RAINBOW_BLACK0) {
                this.initializeColorWedgeBlack(size, bottom, top);
            } else if (this == GSFC_RP_SPECIAL) {
                this.initializeRPSpecial(size, bottom, top);
            } else if (this == MATLAB_JET) {
                this.initializeMatlabJet(size, bottom, top, false);
            } else if (this == MATLAB_JET_BLACK0) {
                this.initializeMatlabJet(size, bottom, top, true);
            } else if (this == GRAYSCALE) {
                this.initializeGrayScale(size, bottom, top);
            } else if (this == INVERSE_GRAYSCALE) {
                this.initializeInverseGrayScale(size, bottom, top);
            } else if (this == WRAPPED_COLOR_WEDGE) {
                this.initializeWrappedColorWedge(size, bottom, top);
            } else if (this == BLUE_BLACK_RED_WEDGE) {
                this.initializeBlueBlackRedWedge(size, bottom, top);
            } else if (this == BLUE_WHITE_RED_WEDGE) {
                this.initializeBlueWhiteRedWedge(size, bottom, top);
            } else if (this == BLACK_RED) {
                this.initializeWhiteRed(size, bottom, top);
            } else if (this == BLACK_GREEN) {
                this.initializeWhiteGreen(size, bottom, top);
            } else if (this == BLACK_BLUE) {
                this.initializeWhiteBlue(size, bottom, top);
            } else if (this == WHITE_BLUE_BLACK) {
                this.initializeWhiteBlueBlack(size, bottom, top);
            } else if (this == INVERSE_WHITE_BLUE_BLACK) {
                this.initializeRevWhiteBlueBlack(size, bottom, top);
            } else if (this == VIOLET_YELLOW) {
                this.initializeVioletYellow(size, bottom, top);
            } else if (this == BLUE_TO_ORANGE) {
                this.initializeBlueToOrange(size, bottom, top);
            } else if (this == SCIPY_PLASMA) {
                this.initializeSciPyPlasma(size, bottom, top);
            }
        }

        private void initializeColorWedge(int size, int bottom, int top) {
            int[] index = new int[]{0, 30, 63, 126, 162, 192, 221, 255};
            int[] red = new int[]{0, 0, 0, 0, 255, 255, 255, 255};
            int[] green = new int[]{0, 0, 255, 255, 255, 185, 84, 0};
            int[] blue = new int[]{137, 255, 255, 0, 0, 0, 0, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeColorWedgeWhite(int size, int bottom, int top) {
            ColorWedgeColorSource ct = new ColorWedgeColorSource(true);
            int[] index = ct.getIndex();
            int[] red = ct.getRed();
            int[] green = ct.getGreen();
            int[] blue = ct.getBlue();
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeColorWedgeBlack(int size, int bottom, int top) {
            ColorWedgeColorSource ct = new ColorWedgeColorSource(false);
            int[] index = ct.getIndex();
            int[] red = ct.getRed();
            int[] green = ct.getGreen();
            int[] blue = ct.getBlue();
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeBlueBlackRedWedge(int size, int bottom, int top) {
            int[] index = new int[]{0, 64, 128, 192, 255};
            int[] red = new int[]{0, 0, 0, 128, 255};
            int[] green = new int[]{0, 0, 0, 0, 0};
            int[] blue = new int[]{255, 128, 0, 0, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeBlueWhiteRedWedge(int size, int bottom, int top) {
            int[] index = new int[]{0, 64, 128, 192, 255};
            int[] red = new int[]{0, 128, 255, 255, 255};
            int[] green = new int[]{0, 128, 255, 128, 0};
            int[] blue = new int[]{255, 255, 255, 128, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeBlueToOrange(int size, int bottom, int top) {
            int[] index = new int[]{0, 23, 46, 69, 92, 115, 139, 162, 185, 208, 231, 255};
            int[] red = new int[]{0, 25, 50, 101, 153, 204, 255, 255, 255, 255, 255, 255};
            int[] green = new int[]{42, 101, 153, 204, 237, 255, 255, 238, 204, 153, 102, 42};
            int[] blue = new int[]{255, 255, 255, 255, 255, 255, 204, 153, 101, 50, 25, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeSciPyPlasma(int size, int bottom, int top) {
            int[] index = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
            int[] red = new int[]{12, 16, 19, 22, 24, 27, 29, 31, 33, 35, 38, 40, 42, 43, 45, 47, 49, 51, 53, 54, 56, 58, 60, 61, 63, 65, 66, 68, 70, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 88, 89, 91, 92, 94, 95, 97, 99, 100, 102, 103, 105, 106, 108, 110, 111, 113, 114, 116, 117, 119, 120, 122, 123, 125, 126, 128, 129, 131, 132, 134, 135, 136, 138, 139, 141, 142, 144, 145, 146, 148, 149, 150, 152, 153, 155, 156, 157, 158, 160, 161, 162, 164, 165, 166, 167, 169, 170, 171, 172, 173, 175, 176, 177, 178, 179, 180, 181, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 208, 209, 210, 211, 212, 213, 214, 215, 215, 216, 217, 218, 219, 220, 220, 221, 222, 223, 224, 224, 225, 226, 227, 227, 228, 229, 230, 230, 231, 232, 232, 233, 234, 235, 235, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 244, 244, 245, 245, 246, 246, 247, 247, 247, 248, 248, 249, 249, 249, 250, 250, 251, 251, 251, 251, 252, 252, 252, 252, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 253, 253, 253, 253, 253, 252, 252, 252, 251, 251, 251, 250, 250, 249, 249, 248, 248, 247, 247, 246, 246, 245, 244, 244, 243, 242, 242, 241, 241, 240};
            int[] green = new int[]{7, 7, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 36, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64, 66, 67, 68, 69, 70, 71, 72, 73, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 95, 96, 98, 99, 100, 101, 102, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 116, 117, 118, 119, 121, 122, 123, 124, 126, 127, 128, 129, 131, 132, 133, 135, 136, 137, 139, 140, 141, 143, 144, 145, 147, 148, 149, 151, 152, 154, 155, 156, 158, 159, 161, 162, 164, 165, 166, 168, 169, 171, 172, 174, 175, 177, 178, 180, 181, 183, 185, 186, 188, 189, 191, 192, 194, 195, 197, 199, 200, 202, 203, 205, 207, 208, 210, 212, 213, 215, 217, 218, 220, 222, 223, 225, 227, 229, 230, 232, 234, 235, 237, 239, 241, 242, 244, 246, 247, 249};
            int[] blue = new int[]{135, 136, 137, 138, 140, 141, 142, 143, 144, 145, 146, 146, 147, 148, 149, 150, 151, 151, 152, 153, 154, 154, 155, 156, 156, 157, 158, 158, 159, 160, 160, 161, 161, 162, 162, 163, 163, 164, 164, 165, 165, 165, 166, 166, 166, 167, 167, 167, 167, 168, 168, 168, 168, 168, 168, 168, 169, 169, 169, 168, 168, 168, 168, 168, 168, 168, 167, 167, 167, 167, 166, 166, 166, 165, 165, 164, 164, 163, 163, 162, 161, 161, 160, 160, 159, 158, 157, 157, 156, 155, 154, 154, 153, 152, 151, 150, 149, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 112, 111, 110, 109, 108, 107, 106, 105, 105, 104, 103, 102, 101, 100, 99, 98, 98, 97, 96, 95, 94, 93, 92, 92, 91, 90, 89, 88, 87, 86, 86, 85, 84, 83, 82, 81, 80, 80, 79, 78, 77, 76, 75, 74, 73, 73, 72, 71, 70, 69, 68, 67, 67, 66, 65, 64, 63, 62, 61, 60, 60, 59, 58, 57, 56, 55, 54, 54, 53, 52, 51, 50, 49, 49, 48, 47, 46, 46, 45, 44, 43, 43, 42, 41, 41, 40, 40, 39, 39, 38, 38, 37, 37, 37, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 39, 39, 39, 38, 38, 37, 36, 33};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeWrappedColorWedge(int size, int bottom, int top) {
            int[] index = new int[]{0, 32, 64, 96, 128, 160, 192, 224, 255};
            int[] red = new int[]{225, 0, 0, 0, 255, 255, 255, 255, 255};
            int[] green = new int[]{0, 0, 255, 255, 255, 185, 84, 0, 0};
            int[] blue = new int[]{225, 255, 255, 0, 0, 0, 0, 0, 255};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeInverseGrayScale(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{0, 255};
            int[] green = new int[]{0, 255};
            int[] blue = new int[]{0, 255};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeGrayScale(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{255, 0};
            int[] green = new int[]{255, 0};
            int[] blue = new int[]{255, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeRPSpecial(int size, int bottom, int top) {
            int[] index = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
            int[] red = new int[]{64, 64, 64, 63, 62, 62, 62, 62, 62, 62, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 64, 64, 64, 64, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 67, 67, 67, 67, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 71, 71, 71, 71, 72, 72, 73, 73, 74, 74, 75, 76, 76, 77, 78, 78, 79, 79, 80, 80, 81, 81, 82, 82, 83, 83, 84, 84, 85, 85, 86, 86, 88, 89, 91, 93, 95, 96, 98, 99, 100, 101, 103, 104, 106, 107, 109, 110, 111, 113, 114, 114, 114, 114, 114, 115, 115, 115, 115, 116, 116, 116, 116, 116, 116, 116, 116, 117, 118, 120, 121, 122, 124, 125, 127, 128, 129, 131, 133, 137, 141, 145, 149, 153, 156, 159, 161, 164, 166, 171, 177, 183, 189, 195, 201, 207, 211, 215, 218, 222, 225, 229, 233, 237, 241, 245, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 254, 255, 255, 255, 255, 255, 254, 254, 254, 253, 253, 253, 253, 252, 252, 252, 251, 250, 249, 249, 248, 247, 246, 245, 245, 244, 243, 242, 242, 241, 240, 239, 238, 238, 237, 236, 235, 235, 234, 233, 232, 232, 231, 230, 229, 228, 227, 226, 225, 224, 223, 222, 221, 219, 218, 217, 215, 214, 212, 210, 208, 206, 204, 202, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200};
            int[] green = new int[]{85, 85, 85, 83, 82, 82, 82, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 82, 83, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 120, 120, 121, 121, 122, 122, 123, 124, 124, 125, 126, 127, 128, 130, 131, 133, 134, 136, 137, 139, 140, 142, 143, 145, 146, 147, 149, 151, 153, 155, 158, 160, 162, 164, 166, 169, 171, 173, 177, 180, 183, 187, 190, 194, 195, 196, 197, 198, 199, 201, 203, 205, 207, 210, 212, 213, 214, 215, 216, 217, 218, 220, 221, 223, 225, 227, 229, 229, 230, 231, 232, 233, 234, 235, 236, 238, 239, 241, 242, 243, 243, 244, 244, 245, 246, 247, 248, 249, 250, 250, 251, 251, 252, 252, 252, 253, 253, 253, 254, 254, 254, 255, 255, 255, 255, 255, 255, 253, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 236, 234, 231, 229, 227, 226, 225, 224, 223, 221, 218, 215, 212, 209, 206, 203, 200, 198, 196, 192, 189, 185, 182, 178, 175, 171, 168, 164, 159, 156, 152, 149, 145, 141, 138, 134, 130, 126, 122, 118, 114, 110, 107, 103, 99, 95, 92, 89, 85, 82, 79, 76, 72, 69, 66, 63, 59, 55, 51, 47, 42, 40, 38, 36, 35, 33, 31, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30};
            int[] blue = new int[]{141, 141, 141, 138, 136, 136, 136, 135, 135, 135, 135, 135, 135, 135, 135, 135, 134, 134, 134, 135, 135, 136, 137, 138, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 169, 170, 170, 171, 171, 171, 171, 172, 172, 173, 173, 173, 174, 174, 175, 176, 177, 178, 178, 179, 180, 181, 182, 182, 183, 184, 184, 185, 185, 186, 187, 187, 188, 188, 189, 189, 190, 190, 191, 191, 192, 192, 192, 193, 194, 193, 193, 193, 192, 192, 192, 192, 191, 189, 188, 187, 186, 185, 184, 183, 182, 182, 180, 177, 174, 171, 168, 165, 161, 159, 157, 155, 153, 151, 147, 143, 139, 135, 131, 127, 124, 123, 121, 119, 117, 115, 112, 110, 107, 104, 101, 99, 98, 97, 96, 95, 94, 92, 90, 89, 87, 85, 83, 82, 81, 81, 80, 79, 78, 76, 75, 73, 72, 71, 70, 69, 68, 68, 67, 67, 66, 64, 63, 62, 61, 60, 59, 58, 58, 57, 56, 55, 53, 52, 50, 49, 47, 46, 45, 44, 43, 42, 40, 39, 38, 37, 36, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 25, 24, 23, 22, 21, 20, 20, 19, 18, 17, 16, 16, 15, 15, 15, 14, 14, 13, 13, 12, 12, 11, 10, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeMatlabJet(int size, int bottom, int top, boolean black0) {
            int[] index = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 81, 85, 89, 93, 97, 101, 105, 109, 113, 117, 121, 125, 129, 133, 137, 141, 145, 149, 153, 157, 162, 166, 170, 174, 178, 182, 186, 190, 194, 198, 202, 206, 210, 214, 218, 222, 226, 230, 234, 238, 243, 247, 251, 255};
            int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 223, 207, 191, 175, 159, 143, 127};
            int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 223, 207, 191, 175, 159, 143, 127, 111, 95, 79, 63, 47, 31, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int[] blue = new int[]{143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 239, 223, 207, 191, 175, 159, 143, 127, 111, 95, 79, 63, 47, 31, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            if (black0) {
                blue[0] = 0;
            }
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeWhiteRed(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{0, 255};
            int[] green = new int[]{0, 0};
            int[] blue = new int[]{0, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeWhiteGreen(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{0, 0};
            int[] green = new int[]{0, 255};
            int[] blue = new int[]{0, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeWhiteBlue(int size, int bottom, int top) {
            int[] index = new int[]{0, 255};
            int[] red = new int[]{0, 0};
            int[] green = new int[]{0, 0};
            int[] blue = new int[]{0, 255};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeWhiteBlueBlack(int size, int bottom, int top) {
            int[] index = new int[]{0, 67, 161, 255};
            int[] red = new int[]{255, 0, 0, 0};
            int[] green = new int[]{255, 150, 0, 0};
            int[] blue = new int[]{255, 255, 133, 0};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeRevWhiteBlueBlack(int size, int bottom, int top) {
            int[] index = new int[]{0, 94, 188, 255};
            int[] red = new int[]{0, 0, 0, 255};
            int[] green = new int[]{0, 0, 150, 255};
            int[] blue = new int[]{0, 133, 255, 255};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        private void initializeVioletYellow(int size, int bottom, int top) {
            int[] index = new int[]{0, 27, 64, 95, 127, 159, 183, 202, 225, 246, 255};
            int[] red = new int[]{68, 71, 59, 45, 34, 36, 71, 110, 174, 233, 253};
            int[] green = new int[]{2, 36, 83, 111, 139, 171, 192, 206, 221, 229, 231};
            int[] blue = new int[]{86, 114, 139, 142, 141, 129, 110, 87, 46, 23, 37};
            this.colorTable = Type.makeColorTable(index, red, green, blue, size, bottom, top);
        }

        public static Type parse(String s) {
            switch (s) {
                case "color_wedge": {
                    return COLOR_WEDGE;
                }
                case "grayscale": {
                    return GRAYSCALE;
                }
                case "inverse_grayscale": {
                    return INVERSE_GRAYSCALE;
                }
                case "blue_black_red": {
                    return BLUE_BLACK_RED_WEDGE;
                }
                case "blue_white_red": {
                    return BLUE_WHITE_RED_WEDGE;
                }
                case "apl_rainbow_black0": {
                    return APL_RAINBOW_BLACK0;
                }
                case "apl_rainbow_white0": {
                    return APL_RAINBOW_WHITE0;
                }
                case "gsfc_rp_special": {
                    return GSFC_RP_SPECIAL;
                }
                case "matlab_jet": {
                    return MATLAB_JET;
                }
                case "matlab_jet_black0": {
                    return MATLAB_JET_BLACK0;
                }
                case "black_white": {
                    return INVERSE_GRAYSCALE;
                }
                case "black_red": {
                    return BLACK_RED;
                }
                case "black_green": {
                    return BLACK_GREEN;
                }
                case "black_blue": {
                    return BLACK_BLUE;
                }
                case "white_blue_black": {
                    return WHITE_BLUE_BLACK;
                }
                case "violet_yellow": {
                    return VIOLET_YELLOW;
                }
                case "blue_to_orange": {
                    return BLUE_TO_ORANGE;
                }
                case "scipy_plasma": {
                    return SCIPY_PLASMA;
                }
            }
            Type r = extraTypes.get(s);
            if (r == null) {
                throw new IllegalArgumentException("undefined DasColorBar.Type identifier: " + s);
            }
            return r;
        }
    }
}

