/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.ArrowDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MoveComponentMouseModule;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.Arrow;
import org.das2.graph.BorderType;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.util.GrannyTextRenderer;

public class DasAnnotation
extends DasCanvasComponent {
    private static final Logger logger = LoggerManager.getLogger("das.graph.annotation");
    String templateString;
    GrannyTextRenderer gtr;
    BufferedImage img;
    private PointDescriptor pointAt;
    public static final String PROP_TEXT = "text";
    private String url = "";
    public static final String PROP_URL = "url";
    float fontSize = 0.0f;
    public static final String PROP_FONT_SIZE = "fontSize";
    private BorderType borderType = BorderType.NONE;
    public static final String PROP_BORDERTYPE = "borderType";
    private AnchorPosition anchorPosition = AnchorPosition.NW;
    public static final String PROP_ANCHORPOSITION = "anchorPosition";
    private DasPlot plot;
    PropertyChangeListener plotListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.finer("plot change, resizing");
            if (evt.getPropertyName().equals("paintingForPrint")) {
                logger.finer("plot change is trivial, ignoring");
            } else {
                DasAnnotation.this.resize();
            }
        }
    };
    private DatumRange xrange = DatumRange.newDatumRange(0.0, 10.0, Units.dimensionless);
    public static final String PROP_XRANGE = "xrange";
    private DatumRange yrange = DatumRange.newDatumRange(0.0, 10.0, Units.dimensionless);
    public static final String PROP_YRANGE = "yrange";
    private Datum pointAtX = Datum.create(0);
    public static final String PROP_POINTATX = "pointAtX";
    private Datum pointAtY = Datum.create(0);
    public static final String PROP_POINTATY = "pointAtY";
    private boolean showArrow = false;
    public static final String PROP_SHOWARROW = "showArrow";
    private BorderType anchorBorderType = BorderType.NONE;
    public static final String PROP_ANCHORBORDERTYPE = "anchorBorderType";
    private AnchorType anchorType = AnchorType.CANVAS;
    public static final String PROP_ANCHORTYPE = "anchorType";
    private Arrow.HeadStyle arrowStyle = Arrow.HeadStyle.DRAFTING;
    public static final String PROP_ARROWSTYLE = "arrowStyle";
    private boolean overrideColors = false;
    public static final String PROP_OVERRIDECOLORS = "overrideColors";
    private Color textColor = new Color(0, 0, 0, 0);
    public static final String PROP_TEXTCOLOR = "textColor";
    private String anchorOffset = "";
    public static final String PROP_ANCHOROFFSET = "anchorOffset";

    public DasAnnotation(String string) {
        if (string.startsWith("http:")) {
            this.gtr = null;
            try {
                this.img = ImageIO.read(new URL(string));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                this.gtr = new GrannyTextRenderer();
            }
        } else {
            this.gtr = new GrannyTextRenderer();
            this.gtr.setString(this.getFont(), "");
        }
        this.templateString = string;
        AbstractAction removeMeAction = new AbstractAction("remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DasCanvas canvas = DasAnnotation.this.getCanvas();
                canvas.remove(DasAnnotation.this);
                canvas.revalidate();
            }
        };
        this.getDasMouseInputAdapter().addMenuItem(new JMenuItem(removeMeAction));
        MoveComponentMouseModule mm = new MoveComponentMouseModule(this){
            Point p0;

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.p0 = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DasAnnotation.this.getAnchorType() == AnchorType.CANVAS) {
                    Point p = e.getPoint();
                    int dx = p.x - this.p0.x;
                    int dy = p.y - this.p0.y;
                    DasAnnotation.this.adjustAnchorOffset(dx, dy);
                    DasAnnotation.this.resize();
                    DasAnnotation.this.repaint();
                } else if (DasAnnotation.this.getAnchorType() == AnchorType.PLOT) {
                    Point p = e.getPoint();
                    int dx = p.x - this.p0.x;
                    int dy = p.y - this.p0.y;
                    DasAnnotation.this.adjustAnchorOffset(dx, dy);
                    DasAnnotation.this.resize();
                    DasAnnotation.this.repaint();
                } else if (DasAnnotation.this.getAnchorType() == AnchorType.DATA) {
                    Datum d;
                    Point p = e.getPoint();
                    DasAxis axis = DasAnnotation.this.plot.getXAxis();
                    DatumRange xrange = DasAnnotation.this.getXrange();
                    if (axis.isLog()) {
                        d = axis.invTransform(p.x).divide(axis.invTransform(this.p0.x));
                        xrange = new DatumRange(xrange.min().multiply(d), xrange.max().multiply(d));
                    } else {
                        d = axis.invTransform(p.x).subtract(axis.invTransform(this.p0.x));
                        xrange = new DatumRange(xrange.min().add(d), xrange.max().add(d));
                    }
                    DasAnnotation.this.setXrange(xrange);
                    axis = DasAnnotation.this.plot.getYAxis();
                    DatumRange range = DasAnnotation.this.getYrange();
                    if (axis.isLog()) {
                        Datum d2 = axis.invTransform(p.y).divide(axis.invTransform(this.p0.y));
                        range = new DatumRange(range.min().multiply(d2), range.max().multiply(d2));
                    } else {
                        Datum d3 = axis.invTransform(p.y).subtract(axis.invTransform(this.p0.y));
                        range = new DatumRange(range.min().add(d3), range.max().add(d3));
                    }
                    DasAnnotation.this.setYrange(range);
                    DasAnnotation.this.resize();
                    DasAnnotation.this.repaint();
                } else {
                    throw new IllegalArgumentException("not implemented");
                }
            }
        };
        mm.setLabel("Move Annotation");
        this.getDasMouseInputAdapter().setPrimaryModule(mm);
        MouseModule pointAtMouseModule = new MouseModule(this, new ArrowDragRenderer(), "Point At"){
            Point p0;

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (DasAnnotation.this.plot != null) {
                    this.p0 = e.getPoint();
                    this.p0 = SwingUtilities.convertPoint(DasAnnotation.this, this.p0, DasAnnotation.this.plot.getCanvas());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DasAnnotation.this.plot != null) {
                    Datum oldx = DasAnnotation.this.getPointAtX();
                    Datum oldy = DasAnnotation.this.getPointAtY();
                    Datum x = DasAnnotation.this.plot.getXAxis().invTransform(e.getX() + DasAnnotation.this.getX());
                    Datum y = DasAnnotation.this.plot.getYAxis().invTransform(e.getY() + DasAnnotation.this.getY());
                    DasAnnotation.this.setPointAtX(x);
                    DasAnnotation.this.setPointAtY(y);
                    if (DasAnnotation.this.getAnchorType() == AnchorType.CANVAS) {
                        DasAnnotation.this.setXrange(new DatumRange(x, x));
                        DasAnnotation.this.setYrange(new DatumRange(y, y));
                    } else if (DasAnnotation.this.getAnchorType() == AnchorType.DATA) {
                        int dx = (int)(DasAnnotation.this.plot.getXAxis().transform(x) - DasAnnotation.this.plot.getXAxis().transform(oldx));
                        int dy = (int)(DasAnnotation.this.plot.getYAxis().transform(y) - DasAnnotation.this.plot.getYAxis().transform(oldy));
                        DasAnnotation.this.adjustAnchorOffset(-dx, -dy);
                        DasAnnotation.this.resize();
                    } else if (DasAnnotation.this.getAnchorType() == AnchorType.PLOT) {
                        int dx = (int)(DasAnnotation.this.plot.getXAxis().transform(x) - DasAnnotation.this.plot.getXAxis().transform(oldx));
                        int dy = (int)(DasAnnotation.this.plot.getYAxis().transform(y) - DasAnnotation.this.plot.getYAxis().transform(oldy));
                        DasAnnotation.this.adjustAnchorOffset(-dx, -dy);
                        DasAnnotation.this.resize();
                    }
                    DasAnnotation.this.setShowArrow(true);
                }
            }
        };
        this.getDasMouseInputAdapter().addMouseModule(pointAtMouseModule);
    }

    private void adjustDataRanges(int dx, int dy) {
    }

    private void adjustAnchorOffset(int dx, int dy) {
        if (this.anchorPosition != AnchorPosition.NW && this.anchorPosition != AnchorPosition.N) {
            if (this.anchorPosition == AnchorPosition.OutsideN) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.NE) {
                dx = -dx;
            } else if (this.anchorPosition == AnchorPosition.OutsideNE) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.OutsideSE) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.SW) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.SE) {
                dx = -dx;
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.OutsideNNW) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.OutsideNNE) {
                dx = -dx;
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.Center) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.W) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.E) {
                dx = -dx;
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.OutsideE) {
                dy = -dy;
            } else if (this.anchorPosition == AnchorPosition.S) {
                dy = -dy;
            }
        }
        String offset = this.getAnchorOffset();
        double em = this.getEmSize();
        if (offset.trim().length() == 0) {
            offset = String.format(Locale.US, "%.2fem,%.2fem", (double)dx / em, (double)dy / em);
            this.setAnchorOffset(offset);
        } else {
            try {
                String[] ss = offset.split(",", -2);
                double[] dd = DasDevicePosition.parseLayoutStr(ss[0]);
                dd[1] = dd[1] + (double)dx / em;
                ss[0] = DasDevicePosition.formatFormatStr(dd);
                dd = DasDevicePosition.parseLayoutStr(ss[1]);
                dd[1] = dd[1] + (double)dy / em;
                ss[1] = DasDevicePosition.formatFormatStr(dd);
                offset = ss[0] + "," + ss[1];
                this.setAnchorOffset(offset);
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setText(String string) {
        String oldValue = this.templateString;
        this.templateString = string;
        if (this.getGraphics() != null) {
            if (this.url.length() == 0) {
                if (string.startsWith("http:") || string.startsWith("https:") || string.startsWith("file:")) {
                    try {
                        this.img = ImageIO.read(new URL(string));
                        this.gtr = null;
                    }
                    catch (IOException ex) {
                        this.gtr = new GrannyTextRenderer();
                        this.gtr.setString(this.getGraphics(), this.getString());
                    }
                } else {
                    this.gtr = new GrannyTextRenderer();
                    this.gtr.setString(this.getGraphics(), this.getString());
                }
            }
            this.resize();
        }
        this.firePropertyChange(PROP_TEXT, oldValue, string);
        this.repaint();
    }

    public String getText() {
        return this.templateString;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        String oldUrl = this.url;
        if (url.length() == 0) {
            this.url = url;
            this.setText(this.getText());
        } else {
            try {
                this.img = ImageIO.read(new URL(url));
                this.gtr = null;
            }
            catch (IOException ex) {
                this.gtr = new GrannyTextRenderer();
                this.gtr.setString(this.getGraphics(), url);
            }
        }
        this.url = url;
        this.firePropertyChange(PROP_URL, oldUrl, url);
    }

    @Override
    public void resize() {
        Font f = this.getFont();
        if (f != null) {
            super.resize();
            Font thefont = f;
            if (this.fontSize > 0.0f) {
                thefont = f.deriveFont(this.fontSize);
            }
            if (this.gtr != null) {
                this.gtr.setString(thefont, this.getString());
            }
            Rectangle r = this.calcBounds();
            r.add(r.x + r.width + 1, r.y + r.height + 1);
            r = this.anchorType == AnchorType.CANVAS || this.plot == null ? r.intersection(new Rectangle(0, 0, this.getCanvas().getWidth(), this.getCanvas().getHeight())) : r.intersection(DasDevicePosition.toRectangle(this.plot.getRow(), this.plot.getColumn()));
            this.setBounds(r);
        }
    }

    @Override
    public Shape getActiveRegion() {
        Rectangle r = this.getAnnotationBubbleBounds();
        return r;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        if (this.getActiveRegion().contains(x, y)) {
            return true;
        }
        return this.pointAt != null && this.pointAt.getPoint().distance(x, y) < 5.0;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.acceptContext(x + this.getX(), y + this.getY());
    }

    private Rectangle calcBounds() {
        Rectangle r = (Rectangle)this.getActiveRegion();
        if (this.pointAt != null) {
            Point head = this.pointAt.getPoint();
            r.add(head);
        }
        if (this.anchorBorderType != BorderType.NONE) {
            Rectangle anchorRect = this.getAnchorBounds();
            r.add(anchorRect);
        }
        if (this.showArrow && this.plot != null) {
            int heady;
            int headx;
            try {
                headx = (int)this.plot.getXAxis().transform(this.pointAtX);
            }
            catch (InconvertibleUnitsException ex) {
                headx = (int)this.plot.getXAxis().transform(this.pointAtX.value(), this.plot.getXAxis().getUnits());
            }
            try {
                heady = (int)this.plot.getYAxis().transform(this.pointAtY);
            }
            catch (InconvertibleUnitsException ex) {
                heady = (int)this.plot.getYAxis().transform(this.pointAtY.value(), this.plot.getYAxis().getUnits());
            }
            r.add(headx, heady);
        }
        int s = Math.max(this.getFont().getSize() / 5, 3);
        return new Rectangle(r.x - s, r.y - s, r.width + s * 2 + 1, r.height + s * 2 + 1);
    }

    @Override
    public void paintComponent(Graphics g1) {
        Color fore;
        Graphics2D g = (Graphics2D)g1.create();
        double em2 = g.getFont().getSize();
        Stroke stroke0 = g.getStroke();
        g.setStroke(new BasicStroke((float)(em2 / 8.0), 1, 1));
        g.translate(-this.getX(), -this.getY());
        if (this.anchorType != AnchorType.CANVAS && this.plot != null) {
            Rectangle r = DasDevicePosition.toRectangle(this.plot.getRow(), this.plot.getColumn());
            g.setClip(r);
        }
        Color ltextColor = fore = this.getCanvas().getForeground();
        Color back = this.getCanvas().getBackground();
        if (this.isOverrideColors()) {
            fore = this.getForeground();
            ltextColor = this.textColor;
            back = this.getBackground();
        }
        if (this.fontSize > 0.0f) {
            g.setFont(this.getFont().deriveFont(this.fontSize));
        }
        int em = (int)this.getEmSize() / 2;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.gtr != null) {
            this.gtr.setString(g, this.getString());
        }
        Rectangle r = this.getAnnotationBubbleBounds();
        if ((this.anchorPosition == AnchorPosition.N || this.anchorPosition == AnchorPosition.OutsideN || this.anchorPosition == AnchorPosition.Center || this.anchorPosition == AnchorPosition.S) && this.gtr != null) {
            this.gtr.setAlignment(0.5f);
        }
        if (this.showArrow) {
            int headx = 0;
            int heady = 0;
            if (this.plot != null) {
                try {
                    headx = (int)this.plot.getXAxis().transform(this.pointAtX);
                }
                catch (InconvertibleUnitsException ex) {
                    headx = (int)this.plot.getXAxis().transform(this.pointAtX.value(), this.plot.getXAxis().getUnits());
                }
                try {
                    heady = (int)this.plot.getYAxis().transform(this.pointAtY);
                }
                catch (InconvertibleUnitsException ex) {
                    heady = (int)this.plot.getYAxis().transform(this.pointAtY.value(), this.plot.getYAxis().getUnits());
                }
            }
            Point head = new Point(headx, heady);
            Graphics2D g2 = (Graphics2D)g.create();
            Point2D.Double tail2d = new Point2D.Double(r.x + r.width / 2, r.y + r.height / 2);
            Point2D.Double head2d = new Point2D.Double(head.x, head.y);
            Rectangle2D.Double rect2d = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
            Point2D p2d = GraphUtil.lineRectangleIntersection(tail2d, head2d, rect2d);
            Point p = p2d == null ? head : new Point((int)p2d.getX(), (int)p2d.getY());
            g2.setStroke(new BasicStroke((float)(em2 / 4.0), 1, 1));
            Color glowColor = this.getCanvas().getBackground();
            g2.setColor(new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), 128));
            Arrow.paintArrow(g2, head, p, em2, this.arrowStyle);
            g2.setStroke(stroke0);
            g2.setColor(fore);
            Arrow.paintArrow(g2, head, p, em2, this.arrowStyle);
            g2.dispose();
        }
        g.setColor(back);
        if (this.gtr == null || !this.getString().equals("")) {
            if (this.borderType == BorderType.RECTANGLE || this.borderType == BorderType.NONE) {
                g.fill(r);
            } else if (this.borderType == BorderType.ROUNDED_RECTANGLE) {
                g.fillRoundRect(r.x, r.y, r.width, r.height, em * 2, em * 2);
            }
            g.setColor(ltextColor);
            if (this.gtr != null) {
                this.gtr.draw(g, r.x + em, (float)(r.y + em) + (float)this.gtr.getAscent());
            } else {
                g.drawImage((Image)this.img, r.x + em, r.y + em, this);
            }
            g.setColor(fore);
            if (this.borderType != BorderType.NONE) {
                if (this.borderType == BorderType.RECTANGLE) {
                    g.draw(r);
                } else if (this.borderType == BorderType.ROUNDED_RECTANGLE) {
                    g.drawRoundRect(r.x, r.y, r.width, r.height, em * 2, em * 2);
                }
            }
            if (this.anchorBorderType != BorderType.NONE) {
                Rectangle anchorRect = this.getAnchorBounds();
                if (this.anchorBorderType == BorderType.RECTANGLE) {
                    g.draw(anchorRect);
                } else if (this.anchorBorderType == BorderType.ROUNDED_RECTANGLE) {
                    g.drawRoundRect(anchorRect.x, anchorRect.y, anchorRect.width, anchorRect.height, em * 2, em * 2);
                }
            }
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(g1);
    }

    private Rectangle getAnchorBounds() {
        Rectangle anchorRect;
        block24: {
            anchorRect = new Rectangle();
            if ((this.anchorType == AnchorType.PLOT || this.anchorType == AnchorType.DATA) && this.plot != null && this.xrange != null && this.yrange != null) {
                if (this.anchorBorderType == BorderType.NONE && this.showArrow) {
                    try {
                        anchorRect.x = (int)this.plot.getXAxis().transform(this.pointAtX);
                    }
                    catch (InconvertibleUnitsException ex) {
                        if (this.pointAtX.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(this.plot.getXAxis().getUnits())) {
                            anchorRect.x = (int)this.plot.getXAxis().transform(this.pointAtX.value(), this.plot.getXAxis().getUnits());
                        }
                        logger.info("unable to convert x units for annotation");
                        anchorRect.x = this.getColumn().getDMiddle();
                    }
                    try {
                        anchorRect.y = (int)this.plot.getYAxis().transform(this.pointAtY);
                    }
                    catch (InconvertibleUnitsException ex) {
                        if (this.pointAtY.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(this.plot.getYAxis().getUnits())) {
                            anchorRect.y = (int)this.plot.getYAxis().transform(this.pointAtY.value(), this.plot.getYAxis().getUnits());
                        }
                        logger.info("unable to convert y units for annotation");
                        anchorRect.y = this.getRow().getDMiddle();
                    }
                    anchorRect.width = 1;
                    anchorRect.height = 1;
                } else {
                    int t;
                    int t2;
                    try {
                        anchorRect.x = (int)this.plot.getXAxis().transform(this.xrange.min());
                        int x1 = (int)this.plot.getXAxis().transform(this.xrange.max());
                        if (x1 < anchorRect.x) {
                            t2 = anchorRect.x;
                            anchorRect.x = x1;
                            x1 = t2;
                        }
                        anchorRect.width = x1 - anchorRect.x;
                    }
                    catch (InconvertibleUnitsException ex) {
                        if (this.xrange.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(this.plot.getXAxis().getUnits())) {
                            anchorRect.x = (int)this.plot.getXAxis().transform(this.xrange.min().value(), this.plot.getXAxis().getUnits());
                            int x1 = (int)this.plot.getXAxis().transform(this.xrange.max().value(), this.plot.getXAxis().getUnits());
                            if (x1 < anchorRect.x) {
                                t = anchorRect.x;
                                anchorRect.x = x1;
                                x1 = t;
                            }
                            anchorRect.width = x1 - anchorRect.x;
                        }
                        if (this.xrange.min().getUnits() == Units.dimensionless && this.xrange.min().value() == 0.0) {
                            logger.fine("unable to convert x units for annotation, transitional state");
                        } else {
                            logger.info("unable to convert x units for annotation");
                        }
                        anchorRect.x = this.getColumn().getDMinimum();
                        anchorRect.width = this.getColumn().getWidth();
                    }
                    try {
                        anchorRect.y = (int)this.plot.getYAxis().transform(this.yrange.min());
                        int y1 = (int)this.plot.getYAxis().transform(this.yrange.max());
                        if (y1 < anchorRect.y) {
                            t2 = anchorRect.y;
                            anchorRect.y = y1;
                            y1 = t2;
                        }
                        anchorRect.height = y1 - anchorRect.y;
                    }
                    catch (InconvertibleUnitsException ex) {
                        if (this.yrange.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(this.plot.getYAxis().getUnits())) {
                            anchorRect.y = (int)this.plot.getYAxis().transform(this.yrange.min().value(), this.plot.getYAxis().getUnits());
                            int y1 = (int)this.plot.getYAxis().transform(this.yrange.max().value(), this.plot.getYAxis().getUnits());
                            if (y1 < anchorRect.y) {
                                t = anchorRect.y;
                                anchorRect.y = y1;
                                y1 = t;
                            }
                            anchorRect.height = y1 - anchorRect.y;
                            break block24;
                        }
                        if (this.xrange.min().getUnits() == Units.dimensionless && this.xrange.min().value() == 0.0) {
                            logger.fine("unable to convert y units for annotation, transitional state");
                        } else {
                            logger.info("unable to convert y units for annotation");
                        }
                        anchorRect.y = this.getRow().getDMinimum();
                        anchorRect.height = this.getRow().getHeight();
                    }
                }
            } else {
                anchorRect = DasDevicePosition.toRectangle(this.getRow(), this.getColumn());
            }
        }
        return anchorRect;
    }

    private Rectangle getAnnotationBubbleBounds() {
        int em = (int)this.getEmSize();
        Rectangle anchor = this.getAnchorBounds();
        Rectangle r = this.gtr == null ? (this.img == null ? new Rectangle(0, 0, 64, 64) : new Rectangle(0, 0, this.img.getWidth(), this.img.getHeight())) : this.gtr.getBounds();
        int xoffset = 0;
        int yoffset = 0;
        if (this.anchorOffset.length() > 0) {
            String[] ss = this.anchorOffset.split(",");
            if (ss.length == 2) {
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr(ss[0]);
                    xoffset = (int)((double)this.getCanvas().getWidth() * dd[0] + (double)em * dd[1] + dd[2]);
                    dd = DasDevicePosition.parseLayoutStr(ss[1]);
                    yoffset = (int)((double)this.getCanvas().getHeight() * dd[0] + (double)em * dd[1] + dd[2]);
                }
                catch (NumberFormatException | ParseException ex) {
                    logger.log(Level.WARNING, null, ex);
                    xoffset = 0;
                    yoffset = 0;
                }
            } else {
                logger.warning(PROP_ANCHOROFFSET);
            }
        }
        if (this.anchorPosition == AnchorPosition.NW) {
            r.x = anchor.x + em + xoffset;
            r.y = anchor.y + em + yoffset;
        } else if (this.anchorPosition == AnchorPosition.N) {
            r.x = anchor.x + anchor.width / 2 - (int)(r.getWidth() / 2.0) + xoffset;
            r.y = anchor.y + em + yoffset;
        } else if (this.anchorPosition == AnchorPosition.OutsideN) {
            r.x = anchor.x + anchor.width / 2 - (int)(r.getWidth() / 2.0) + xoffset;
            r.y = anchor.y - (int)r.getHeight() - yoffset;
        } else if (this.anchorPosition == AnchorPosition.NE) {
            r.x = anchor.x + anchor.width - r.width - xoffset;
            r.y = anchor.y + em + yoffset;
        } else if (this.anchorPosition == AnchorPosition.OutsideNE) {
            r.x = anchor.x + anchor.width + em + xoffset;
            r.y = anchor.y + em + yoffset;
        } else if (this.anchorPosition == AnchorPosition.OutsideSE) {
            r.x = anchor.x + anchor.width + em + xoffset;
            r.y = anchor.y + anchor.height - r.height - yoffset;
        } else if (this.anchorPosition == AnchorPosition.SW) {
            r.x = anchor.x + em + xoffset;
            r.y = anchor.y + anchor.height - r.height - yoffset;
        } else if (this.anchorPosition == AnchorPosition.SE) {
            r.x = anchor.x + anchor.width - r.width - xoffset;
            r.y = anchor.y + anchor.height - r.height - yoffset;
        } else if (this.anchorPosition == AnchorPosition.OutsideNNW) {
            r.x = anchor.x + em + xoffset;
            r.y = anchor.y - (int)r.getHeight() - yoffset;
        } else if (this.anchorPosition == AnchorPosition.OutsideNNE) {
            r.x = anchor.x + anchor.width - r.width - xoffset;
            r.y = anchor.y - (int)r.getHeight() - yoffset;
        } else if (this.anchorPosition == AnchorPosition.Center) {
            r.x = anchor.x + anchor.width / 2 - (int)(r.getWidth() / 2.0) + xoffset;
            r.y = anchor.y + anchor.height / 2 - (int)(r.getHeight() / 2.0) - yoffset;
        } else if (this.anchorPosition == AnchorPosition.W) {
            r.x = anchor.x + em + xoffset;
            r.y = anchor.y + anchor.height / 2 - (int)(r.getHeight() / 2.0) - yoffset;
        } else if (this.anchorPosition == AnchorPosition.E) {
            r.x = anchor.x + anchor.width - r.width - xoffset;
            r.y = anchor.y + anchor.height / 2 - (int)(r.getHeight() / 2.0) - yoffset;
        } else if (this.anchorPosition == AnchorPosition.OutsideE) {
            r.x = anchor.x + anchor.width + em + xoffset;
            r.y = anchor.y + anchor.height / 2 - (int)(r.getHeight() / 2.0) - yoffset;
        } else if (this.anchorPosition == AnchorPosition.S) {
            r.x = anchor.x + anchor.width / 2 - (int)(r.getWidth() / 2.0) + xoffset;
            r.y = anchor.y + anchor.height - r.height - yoffset;
        }
        if (this.gtr == null) {
            r.x -= em / 2;
            r.y -= em / 2;
            r.width += em;
            r.height += em;
        } else {
            r.x -= em;
            r.y -= em;
            r.width += em;
            r.height += em;
        }
        return r;
    }

    public void setPointAt(PointDescriptor p) {
        this.pointAt = p;
        this.repaint();
    }

    public PointDescriptor getPointAt() {
        return this.pointAt;
    }

    private String getString() {
        String s = this.templateString;
        if (this.templateString != null && this.templateString.contains("%") && this.pointAt != null) {
            s = this.templateString.replace("%p", this.pointAt.getLabel());
        }
        return s;
    }

    @Override
    protected void installComponent() {
        super.installComponent();
        if (this.gtr != null) {
            this.gtr.setString(this.getFont(), this.getString());
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        float oldsize = this.fontSize;
        this.fontSize = fontSize;
        Font f = this.getFont();
        if (f == null) {
            if (this.getCanvas() == null) {
                return;
            }
            f = this.getCanvas().getBaseFont();
        }
        if (fontSize > 0.0f) {
            f = f.deriveFont(fontSize);
        }
        Font newFont = f;
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setFont(newFont);
        if (this.gtr != null) {
            this.gtr.setString(g, this.getString());
        }
        this.resize();
        this.repaint();
        this.firePropertyChange(PROP_FONT_SIZE, oldsize, fontSize);
    }

    public BorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(BorderType newborderType) {
        BorderType oldborderType = this.borderType;
        this.borderType = newborderType;
        this.repaint();
        this.firePropertyChange(PROP_BORDERTYPE, (Object)oldborderType, (Object)newborderType);
    }

    public AnchorPosition getAnchorPosition() {
        return this.anchorPosition;
    }

    public void setAnchorPosition(AnchorPosition anchorPosition) {
        AnchorPosition oldAnchorPosition = this.anchorPosition;
        this.anchorPosition = anchorPosition;
        this.firePropertyChange(PROP_ANCHORPOSITION, oldAnchorPosition, anchorPosition);
    }

    public void setPlot(DasPlot p) {
        if (this.plot != null) {
            this.plot.getXAxis().removePropertyChangeListener(this.plotListener);
            this.plot.getYAxis().removePropertyChangeListener(this.plotListener);
        }
        p.getXAxis().addPropertyChangeListener(this.plotListener);
        p.getYAxis().addPropertyChangeListener(this.plotListener);
        this.plot = p;
    }

    public DatumRange getXrange() {
        return this.xrange;
    }

    public void setXrange(DatumRange xrange) {
        DatumRange oldXrange = this.xrange;
        this.xrange = xrange;
        this.resize();
        this.repaint();
        this.firePropertyChange(PROP_XRANGE, oldXrange, xrange);
    }

    public DatumRange getYrange() {
        return this.yrange;
    }

    public void setYrange(DatumRange yrange) {
        DatumRange oldYrange = this.yrange;
        this.yrange = yrange;
        this.resize();
        this.repaint();
        this.firePropertyChange(PROP_YRANGE, oldYrange, yrange);
    }

    public Datum getPointAtX() {
        return this.pointAtX;
    }

    public void setPointAtX(Datum pointAtX) {
        Datum oldPointAtX = this.pointAtX;
        this.pointAtX = pointAtX;
        this.firePropertyChange(PROP_POINTATX, oldPointAtX, pointAtX);
    }

    public Datum getPointAtY() {
        return this.pointAtY;
    }

    public void setPointAtY(Datum pointAtY) {
        Datum oldPointAtY = this.pointAtY;
        this.pointAtY = pointAtY;
        this.firePropertyChange(PROP_POINTATY, oldPointAtY, pointAtY);
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowArrow(boolean showArrow) {
        boolean oldShowArrow = this.showArrow;
        this.showArrow = showArrow;
        this.firePropertyChange(PROP_SHOWARROW, oldShowArrow, showArrow);
    }

    public BorderType getAnchorBorderType() {
        return this.anchorBorderType;
    }

    public void setAnchorBorderType(BorderType anchorBorderType) {
        BorderType oldAnchorBorderType = this.anchorBorderType;
        this.anchorBorderType = anchorBorderType;
        this.firePropertyChange(PROP_ANCHORBORDERTYPE, (Object)oldAnchorBorderType, (Object)anchorBorderType);
    }

    public AnchorType getAnchorType() {
        return this.anchorType;
    }

    public void setAnchorType(AnchorType anchorType) {
        AnchorType oldAnchorType = this.anchorType;
        this.anchorType = anchorType;
        this.firePropertyChange(PROP_ANCHORTYPE, (Object)oldAnchorType, (Object)anchorType);
    }

    public Arrow.HeadStyle getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(Arrow.HeadStyle newarrowStyle) {
        Arrow.HeadStyle oldarrowStyle = this.arrowStyle;
        this.arrowStyle = newarrowStyle;
        this.repaint();
        this.firePropertyChange(PROP_ARROWSTYLE, (Object)oldarrowStyle, (Object)newarrowStyle);
    }

    public boolean isOverrideColors() {
        return this.overrideColors;
    }

    public void setOverrideColors(boolean overrideColors) {
        boolean oldOverrideColors = this.overrideColors;
        this.overrideColors = overrideColors;
        this.firePropertyChange(PROP_OVERRIDECOLORS, oldOverrideColors, overrideColors);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        Color oldTextColor = this.textColor;
        this.textColor = textColor;
        this.repaint();
        this.firePropertyChange(PROP_TEXTCOLOR, oldTextColor, textColor);
    }

    public String getAnchorOffset() {
        return this.anchorOffset;
    }

    public void setAnchorOffset(String anchorOffset) {
        String oldAnchorOffset = this.anchorOffset;
        this.anchorOffset = anchorOffset;
        this.firePropertyChange(PROP_ANCHOROFFSET, oldAnchorOffset, anchorOffset);
    }

    public static class DatumPairPointDescriptor
    implements PointDescriptor {
        DasPlot p;
        Datum x;
        Datum y;

        public DatumPairPointDescriptor(DasPlot p, Datum x, Datum y) {
            this.x = x;
            this.y = y;
            this.p = p;
        }

        @Override
        public Point getPoint() {
            int ix = (int)this.p.getXAxis().transform(this.x);
            int iy = (int)this.p.getYAxis().transform(this.y);
            return new Point(ix, iy);
        }

        @Override
        public String getLabel() {
            return "" + this.x + "," + this.y;
        }
    }

    public static interface PointDescriptor {
        public Point getPoint();

        public String getLabel();
    }
}

