/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.das2.DasException;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.monitor.ProgressMonitor;

public class CurveRenderer
extends Renderer {
    private final String xplane;
    private final String yplane;
    private Color color = Color.black;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private Psym psym = Psym.NONE;
    private double symSize = 1.0;
    private float lineWidth = 1.5f;
    private GeneralPath path;
    public static final String PROP_LINE_WIDTH = "lineWidth";
    public static final String PROP_COLOR = "color";
    public static final String PROP_SYM_SIZE = "symSize";
    public static final String PROP_SYM_CONNECTOR = "symConnector";
    public static final String PROP_PSYM = "psym";

    public CurveRenderer(DataSetDescriptor dsd, String xplane, String yplane) {
        super(dsd);
        this.setLineWidth(1.0);
        this.xplane = xplane;
        this.yplane = yplane;
    }

    public CurveRenderer() {
        this(null, "", "");
    }

    @Override
    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        QDataSet yds;
        QDataSet xds;
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null || dataSet.length() == 0) {
            return;
        }
        if (this.xplane != null && this.xplane.length() > 1) {
            xds = DataSetOps.unbundle(dataSet, this.xplane);
        } else if (dataSet.rank() == 1) {
            xds = SemanticOps.xtagsDataSet(dataSet);
        } else {
            throw new IllegalArgumentException("rank must be 1 or xplane identified");
        }
        if (this.yplane != null && this.yplane.length() > 1) {
            yds = DataSetOps.unbundle(dataSet, this.yplane);
        } else if (dataSet.rank() == 1) {
            yds = dataSet;
        } else {
            throw new IllegalArgumentException("rank must be 1 or xplane identified");
        }
        QDataSet wds = SemanticOps.weightsDataSet(xds);
        Graphics2D graphics = (Graphics2D)g1.create();
        RenderingHints hints0 = graphics.getRenderingHints();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.color);
        if (this.path != null) {
            this.psymConnector.draw(graphics, this.path, this.lineWidth);
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        for (int index = 0; index < xds.length(); ++index) {
            if (!(wds.value(index) > 0.0)) continue;
            double i = xAxis.transform(xds.value(index), xUnits);
            double j = yAxis.transform(yds.value(index), yUnits);
            this.psym.draw(g1, i, j, (float)this.symSize);
        }
        graphics.setRenderingHints(hints0);
    }

    @Override
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        QDataSet yds;
        QDataSet xds;
        super.updatePlotImage(xAxis, yAxis, monitor);
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null || dataSet.length() == 0) {
            return;
        }
        if (this.xplane != null && this.xplane.length() > 1) {
            xds = DataSetOps.unbundle(dataSet, this.xplane);
        } else if (dataSet.rank() == 1) {
            xds = SemanticOps.xtagsDataSet(dataSet);
        } else {
            throw new IllegalArgumentException("rank must be 1 or xplane identified");
        }
        if (this.yplane != null && this.yplane.length() > 1) {
            yds = DataSetOps.unbundle(dataSet, this.yplane);
        } else if (dataSet.rank() == 1) {
            yds = dataSet;
        } else {
            throw new IllegalArgumentException("rank must be 1 or xplane identified");
        }
        this.path = GraphUtil.getPath(xAxis, yAxis, xds, yds, false, false);
    }

    public final double getLineWidth() {
        return this.lineWidth;
    }

    public final void setLineWidth(double lineWidth) {
        double oldValue = this.lineWidth;
        this.lineWidth = (float)lineWidth;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_LINE_WIDTH, oldValue, lineWidth);
    }

    public final double getSymSize() {
        return this.symSize;
    }

    public final void setSymSize(double symSize) {
        double old = this.symSize;
        this.symSize = symSize;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_SYM_SIZE, old, symSize);
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        PsymConnector old = this.psymConnector;
        if (p == null) {
            throw new NullPointerException("psymConnector cannot be null");
        }
        this.psymConnector = p;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_SYM_CONNECTOR, old, p);
    }

    public final Psym getPsym() {
        return this.psym;
    }

    public final void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym old = this.psym;
        this.psym = psym;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_PSYM, old, psym);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

