/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasException;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.math.Contour;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.Converter;

public class ContoursRenderer
extends Renderer {
    GeneralPath[] paths;
    String[] pathLabels;
    Converter fontConverter = null;
    public static final String CONTROL_KEY_LEVELS = "levels";
    public static final String CONTROL_KEY_LABELS = "labels";
    public static final String CONTROL_KEY_LABEL_CADENCE = "labelCadence";
    public static final String CONTROL_KEY_FORMAT = "format";
    public static final String CONTROL_KEY_LABEL_ORIENT = "labelOrient";
    QDataSet vds;
    private String fontSize = "8pt";
    public static final String PROP_FONTSIZE = "fontSize";
    public static final String PROP_FORMAT = "format";
    private String format = "";
    private String labelOrient = "";
    public static final String PROP_LABELORIENT = "labelOrient";
    private String contours = "-.7,-.6,-.5,-.4,-.3,-.2,-.1,0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9";
    private String labelCadence = "100px";
    private boolean drawLabels;
    private Color color = Color.BLACK;
    private boolean simplifyPaths = true;
    public static final String PROP_SIMPLIFYPATHS = "simplifyPaths";
    private double lineThick = 1.0;
    public static final String PROP_LINETHICK = "lineThick";

    public static QDataSet doAutorange(QDataSet ds) {
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("ds rank must be 2");
        }
        QDataSet xds = SemanticOps.xtagsDataSet(ds);
        QDataSet yds = SemanticOps.ytagsDataSet(ds);
        QDataSet xrange = ContoursRenderer.doRange(xds);
        QDataSet yrange = ContoursRenderer.doRange(yds);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join(xrange);
        bds.join(yrange);
        return bds;
    }

    private static QDataSet doRange(QDataSet xds) {
        QDataSet xrange = Ops.extent(xds);
        if (xrange.value(1) == xrange.value(0)) {
            xrange = !"log".equals(xrange.property("SCALE_TYPE")) ? DDataSet.wrap(new double[]{xrange.value(0) - 1.0, xrange.value(1) + 1.0}).setUnits(SemanticOps.getUnits(xrange)) : DDataSet.wrap(new double[]{xrange.value(0) / 10.0, xrange.value(1) * 10.0}).setUnits(SemanticOps.getUnits(xrange));
        }
        xrange = Ops.rescaleRangeLogLin(xrange, -0.1, 1.1);
        return xrange;
    }

    @Override
    public void setParent(DasPlot parent) {
        this.fontConverter = GraphUtil.getFontConverter(parent, "sans-9");
        super.setParent(parent);
    }

    private boolean checkInputs(DasPlot lparent) {
        QDataSet tds = this.getDataSet();
        if (tds == null) {
            lparent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            return true;
        }
        if (tds.rank() != 2) {
            lparent.postMessage((Renderer)this, "dataset must be rank 2", DasPlot.INFO, null, null);
            return true;
        }
        if (this.vds == null) {
            return true;
        }
        return this.paths == null;
    }

    @Override
    public synchronized void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        DasPlot lparent = this.getParent();
        if (lparent == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        if (this.ds == null) {
            lparent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            return;
        }
        if (this.ds.rank() != 2) {
            lparent.postMessage((Renderer)this, "dataset rank must be 2", DasPlot.INFO, null, null);
            return;
        }
        QDataSet _xds = SemanticOps.xtagsDataSet(this.ds);
        if (_xds.rank() != 1) {
            lparent.postMessage((Renderer)this, "xtags must be rank 1", DasPlot.INFO, null, null);
            return;
        }
        QDataSet _yds = SemanticOps.ytagsDataSet(this.ds);
        if (_yds.rank() != 1) {
            lparent.postMessage((Renderer)this, "ytags must be rank 1", DasPlot.INFO, null, null);
            return;
        }
        if (this.paths == null) {
            return;
        }
        if (lparent.getCanvas().isAntiAlias()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.checkInputs(lparent)) {
            return;
        }
        g.setColor(this.color);
        g.setStroke(new BasicStroke((float)this.lineThick));
        if (this.drawLabels) {
            Area labelClip = this.paintLabels(g);
            Shape rclip = g.getClip() == null ? new Rectangle(lparent.getX(), lparent.getY(), lparent.getWidth(), lparent.getHeight()) : g.getClip();
            Area clip = new Area(rclip);
            clip.subtract(labelClip);
            g.setClip(clip);
        }
        for (GeneralPath path : this.paths) {
            if (path == null) continue;
            g.draw(path);
        }
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.contours = this.getControl(CONTROL_KEY_LEVELS, this.contours);
        this.drawLabels = this.getBooleanControl(CONTROL_KEY_LABELS, this.drawLabels);
        this.lineThick = this.getDoubleControl(PROP_LINETHICK, this.lineThick);
        this.labelCadence = this.getControl(CONTROL_KEY_LABEL_CADENCE, this.labelCadence);
        this.color = this.getColorControl("color", this.color);
        this.format = this.getControl("format", this.format);
        this.setFontSize(this.getControl(PROP_FONTSIZE, this.fontSize));
        this.setLabelOrient(this.getControl("labelOrient", this.labelOrient));
        this.updateContours();
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(CONTROL_KEY_LEVELS, this.contours);
        controls.put(CONTROL_KEY_LABELS, ContoursRenderer.encodeBooleanControl(this.drawLabels));
        controls.put(PROP_LINETHICK, String.valueOf(this.lineThick));
        controls.put(CONTROL_KEY_LABEL_CADENCE, String.valueOf(this.labelCadence));
        controls.put("color", ContoursRenderer.encodeColorControl(this.color));
        controls.put("format", this.format);
        controls.put(PROP_FONTSIZE, this.fontSize);
        controls.put("labelOrient", this.labelOrient);
        return Renderer.formatControl(controls);
    }

    @Override
    public boolean acceptsDataSet(QDataSet ds) {
        if (ds == null) {
            return true;
        }
        if (ds.rank() != 2) {
            return false;
        }
        QDataSet xds = SemanticOps.xtagsDataSet(ds);
        if (xds.rank() != 1) {
            return false;
        }
        QDataSet yds = SemanticOps.ytagsDataSet(ds);
        return yds.rank() == 1;
    }

    @Override
    public void setDataSet(QDataSet ds) {
        super.setDataSet(ds);
        if (this.acceptsDataSet(ds)) {
            this.updateContours();
        }
    }

    private synchronized void updateContours() {
        QDataSet tds = this.getDataSet();
        if (tds == null) {
            this.vds = null;
            return;
        }
        if (tds.rank() == 2 && tds.length(0) == 3 && tds.property("DEPEND_0") != null) {
            logger.fine("contour was already performed");
            this.vds = tds;
            return;
        }
        Units units = SemanticOps.getUnits(tds);
        String[] cons = this.contours.trim().split(",");
        double[] dcons = new double[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            double c;
            if (cons[i].trim().equals("")) continue;
            dcons[i] = c = Double.parseDouble(cons[i]);
        }
        DatumVector dv = DatumVector.newDatumVector(dcons, units);
        this.vds = Contour.contour(tds, DDataSet.wrap(dv.toDoubleArray(units)));
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        String oldValue = this.format;
        this.format = value;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange("format", oldValue, value);
        this.propertyChangeSupport.firePropertyChange("control", null, this.getControl());
    }

    public String getLabelOrient() {
        return this.labelOrient;
    }

    public void setLabelOrient(String labelOrient) {
        String oldLabelOrient = this.labelOrient;
        this.labelOrient = labelOrient;
        this.updateCacheImage();
        this.propertyChangeSupport.firePropertyChange("labelOrient", oldLabelOrient, labelOrient);
    }

    private double getPixelLength(String s, double em) {
        try {
            double[] dd = DasDevicePosition.parseLayoutStr(s);
            if (dd[1] == 1.0 && dd[2] == 0.0) {
                return em;
            }
            double parentSize = em;
            double newSize = dd[1] * parentSize + dd[2];
            return (float)newSize;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    private Area paintLabels(Graphics2D g) {
        Font font;
        Area clip = new Area();
        AffineTransform at0 = g.getTransform();
        String lfontSize = this.fontSize;
        if (lfontSize.length() == 0) {
            lfontSize = "8pt";
        }
        if ((double)(font = this.getParent().getFont().deriveFont(((Number)this.fontConverter.convertForward((Object)lfontSize)).floatValue())).getSize2D() == 0.0) {
            logger.info("parsed font size is 0.0, using 8pt");
            font = font.deriveFont(8.0f);
        }
        g.setFont(font);
        GeneralPath[] lpaths = this.getPaths();
        double labelCadencePixels = this.getPixelLength(this.labelCadence, font.getSize2D());
        double minLength = 20.0;
        for (int i = 0; i < lpaths.length; ++i) {
            if (lpaths[i] == null) continue;
            String label = this.pathLabels[i];
            GeneralPath p = lpaths[i];
            if (p == null) continue;
            PathIterator it1 = p.getPathIterator(null);
            PathIterator it2 = p.getPathIterator(null);
            while (!it1.isDone()) {
                double len = GraphUtil.pointsAlongCurve(it1, null, null, null, true);
                int nlabel = 1 + (int)Math.floor(len / labelCadencePixels);
                double phase = (len - (double)(nlabel - 1) * labelCadencePixels) / 2.0;
                if (len < minLength) {
                    GraphUtil.pointsAlongCurve(it2, null, null, null, true);
                    continue;
                }
                double[] lens = new double[nlabel * 2];
                double labelWidth = 10.0;
                if (labelWidth > labelCadencePixels) {
                    labelWidth = labelCadencePixels * 0.99;
                }
                for (int ilabel = 0; ilabel < nlabel; ++ilabel) {
                    lens[ilabel * 2] = phase + labelCadencePixels * (double)ilabel;
                    lens[ilabel * 2 + 1] = phase + labelCadencePixels * (double)ilabel + labelWidth;
                }
                Point2D.Double[] points = new Point2D.Double[nlabel * 2];
                double[] orient = new double[nlabel * 2];
                GraphUtil.pointsAlongCurve(it2, lens, points, orient, true);
                if (this.labelOrient.equals("N")) {
                    for (int ilabel = 0; ilabel < nlabel * 2; ++ilabel) {
                        if (!(Math.abs(orient[ilabel]) > 1.5707963267948966)) continue;
                        int n = ilabel;
                        orient[n] = orient[n] + Math.PI;
                    }
                }
                FontMetrics fm = g.getFontMetrics(font);
                for (int ilabel = 0; ilabel < nlabel; ++ilabel) {
                    AffineTransform at = new AffineTransform();
                    at.translate(points[ilabel * 2].x, points[ilabel * 2].y);
                    at.rotate(orient[ilabel * 2]);
                    at.translate(0.0, fm.getAscent() / 2 - 1);
                    Rectangle2D sbounds = g.getFontMetrics().getStringBounds(label, g);
                    double w = sbounds.getWidth();
                    double emw = (double)fm.getAscent() / 3.0;
                    sbounds = new Rectangle2D.Double(sbounds.getX(), sbounds.getY(), w + emw, sbounds.getHeight());
                    GeneralPath rect = new GeneralPath(sbounds);
                    rect.transform(AffineTransform.getTranslateInstance(-w / 2.0, 0.0));
                    rect.transform(at);
                    clip.add(new Area(rect));
                    AffineTransform gat = new AffineTransform(at0);
                    gat.concatenate(at);
                    g.setTransform(gat);
                    g.setColor(this.color);
                    g.drawString(label, (int)(-w / 2.0 + emw / 2.0), 0);
                }
            }
        }
        g.setTransform(at0);
        return clip;
    }

    @Override
    public Icon getListIcon() {
        return new ImageIcon(ContoursRenderer.class.getResource("/images/icons/contoursRenderer.png"));
    }

    @Override
    public String getListLabel() {
        return "" + (this.getLegendLabel().length() > 0 ? this.getLegendLabel() + " " : "contours");
    }

    private String getFormat(QDataSet zds) {
        String form = this.format;
        if (form.length() == 0) {
            form = "%.2f";
        }
        return form;
    }

    @Override
    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        char c;
        super.incrementUpdateCount();
        QDataSet tds = this.getDataSet();
        if (tds == null) {
            return;
        }
        Units units = SemanticOps.getUnits(tds);
        double d0 = units.getFillDouble();
        if (this.vds == null) {
            return;
        }
        QDataSet xds = DataSetOps.unbundle(this.vds, 0);
        QDataSet yds = DataSetOps.unbundle(this.vds, 1);
        QDataSet zds = DataSetOps.unbundle(this.vds, 2);
        QDataSet ids = SemanticOps.xtagsDataSet(zds);
        Units xunits = xAxis.getUnits();
        Units yunits = yAxis.getUnits();
        ArrayList<GeneralPath> list = new ArrayList<GeneralPath>();
        ArrayList<String> labels = new ArrayList<String>();
        GeneralPath currentPath = null;
        int n0 = 0;
        String form = this.getFormat();
        if (form.length() == 0) {
            form = "%.2f";
        }
        Units zunits = SemanticOps.getUnits(zds);
        try {
            c = DigitalRenderer.typeForFormat(form);
        }
        catch (IllegalArgumentException ex) {
            c = 'f';
        }
        for (int i = 0; i < zds.length(); ++i) {
            double d = zds.value(i);
            int n = (int)ids.value(i);
            float fx = (float)xAxis.transform(xds.value(i), xunits);
            float fy = (float)yAxis.transform(yds.value(i), yunits);
            if (d != d0) {
                if (currentPath != null && this.simplifyPaths) {
                    GeneralPath newPath = new GeneralPath();
                    GraphUtil.reducePath(currentPath.getPathIterator(null), newPath);
                    list.set(list.indexOf(currentPath), newPath);
                }
                currentPath = new GeneralPath();
                list.add(currentPath);
                labels.add(DigitalRenderer.formatDatum(form, zunits.createDatum(d), c));
                d0 = d;
                currentPath.moveTo(fx, fy);
            } else if (n != n0 + 1) {
                if (currentPath != null) {
                    currentPath.moveTo(fx, fy);
                }
            } else if (currentPath != null) {
                currentPath.lineTo(fx, fy);
            }
            n0 = n;
        }
        this.paths = list.toArray(new GeneralPath[list.size()]);
        this.pathLabels = labels.toArray(new String[labels.size()]);
    }

    public String getContours() {
        return this.contours;
    }

    public void setContours(String contours) {
        String oldContours = this.contours;
        this.contours = contours;
        this.updateContours();
        this.update();
        this.propertyChangeSupport.firePropertyChange("contours", oldContours, contours);
    }

    public String getLabelCadence() {
        return this.labelCadence;
    }

    public void setLabelCadence(String labelCadence) {
        String oldLabelCadence = this.labelCadence;
        this.labelCadence = labelCadence;
        this.update();
        this.propertyChangeSupport.firePropertyChange(CONTROL_KEY_LABEL_CADENCE, oldLabelCadence, labelCadence);
    }

    private synchronized GeneralPath[] getPaths() {
        return this.paths;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        GeneralPath[] lpaths = this.getPaths();
        if (lpaths == null) {
            return false;
        }
        for (GeneralPath lpath : lpaths) {
            if (lpath == null || !lpath.intersects(x - 2, y - 2, 5.0, 5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    public void setDrawLabels(boolean drawLabels) {
        boolean oldDrawLabels = this.drawLabels;
        this.drawLabels = drawLabels;
        this.update();
        this.propertyChangeSupport.firePropertyChange("drawLabels", oldDrawLabels, drawLabels);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.update();
        this.propertyChangeSupport.firePropertyChange("color", oldColor, color);
    }

    public boolean isSimplifyPaths() {
        return this.simplifyPaths;
    }

    public void setSimplifyPaths(boolean newsimplifyPaths) {
        boolean oldsimplifyPaths = this.simplifyPaths;
        this.simplifyPaths = newsimplifyPaths;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_SIMPLIFYPATHS, oldsimplifyPaths, newsimplifyPaths);
    }

    public double getLineThick() {
        return this.lineThick;
    }

    public void setLineThick(double newlineThick) {
        double oldlineThick = this.lineThick;
        this.lineThick = newlineThick;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_LINETHICK, oldlineThick, newlineThick);
    }
}

