/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.LinkedHashMap;
import org.das2.graph.DasAxis;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class BoundsRenderer
extends Renderer {
    private Color color = Color.BLACK;
    public static final String PROP_COLOR = "color";

    private void expectDs() {
        throw new IllegalArgumentException("Expect rank 2 bins dataset");
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_COLOR, BoundsRenderer.encodeColorControl(this.color));
        return Renderer.formatControl(controls);
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.color = this.getColorControl(PROP_COLOR, this.color);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color string) {
        Color oldColor = this.color;
        this.color = string;
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldColor, string);
    }

    @Override
    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g = (Graphics2D)g1;
        QDataSet d = this.getDataSet();
        if (d.rank() != 2) {
            this.expectDs();
        }
        QDataSet mins = Ops.slice1(d, 0);
        QDataSet maxs = Ops.slice1(d, 1);
        GeneralPath pmin = GraphUtil.getPath(xAxis, yAxis, Ops.append(mins, Ops.reverse(maxs)), false, false);
        g.setColor(this.getColor());
        g.fill(pmin);
    }
}

