/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.das2.datum.Datum;
import org.das2.graph.Auralizor;

public class AuralizorControlPanel
extends JPanel {
    Auralizor auralizor;
    private JButton playButton;
    private JLabel positionLabel;
    private JButton resetButton;

    public AuralizorControlPanel() {
        this.initComponents();
    }

    public void setAuralizor(Auralizor a) {
        this.auralizor = a;
        this.auralizor.addPropertyChangeListener("position", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Datum newPosition = (Datum)evt.getNewValue();
                AuralizorControlPanel.this.positionLabel.setText(newPosition.toString());
            }
        });
    }

    private void initComponents() {
        this.playButton = new JButton();
        this.resetButton = new JButton();
        this.positionLabel = new JLabel();
        this.playButton.setText("Play Sound");
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuralizorControlPanel.this.playButtonActionPerformed(evt);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.setEnabled(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuralizorControlPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.positionLabel.setText("(position)");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.playButton, -1, -1, Short.MAX_VALUE).addComponent(this.resetButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.positionLabel, -1, 283, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playButton).addComponent(this.positionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton).addContainerGap(228, Short.MAX_VALUE)));
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AuralizorControlPanel.this.auralizor.playSound();
                AuralizorControlPanel.this.playButton.setEnabled(true);
            }
        };
        new Thread(run, "auralizeData").start();
        this.playButton.setEnabled(false);
        this.resetButton.setEnabled(true);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.auralizor.reset();
        this.resetButton.setEnabled(false);
    }
}

