/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JPanel;
import org.das2.datum.Datum;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.graph.AuralizorControlPanel;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FlattenWaveformDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.DebugPropertyChangeSupport;

public class Auralizor {
    private static final Logger logger = LoggerManager.getLogger("das2.graph");
    private static final int EXTERNAL_BUFFER_SIZE = 100000;
    ByteBuffer buffer;
    byte[] buf;
    SourceDataLine line = null;
    double min;
    double max;
    QDataSet ds;
    QDataSet dep0;
    int currentRecord = 0;
    boolean playing = false;
    PropertyChangeSupport pcs = new DebugPropertyChangeSupport(this);
    private Datum position = Units.seconds.createDatum(0);
    private Datum lastAnnouncedPosition = null;
    private Datum limit = Units.milliseconds.createDatum(100);
    public static final String PROP_POSITION = "position";

    public final void setDataSet(QDataSet ds) {
        switch (ds.rank()) {
            case 2: {
                this.ds = new FlattenWaveformDataSet(ds);
                break;
            }
            case 1: {
                this.ds = ds;
                break;
            }
            default: {
                throw new IllegalArgumentException("dataset must be rank 1 or rank 2 waveform");
            }
        }
        this.dep0 = (QDataSet)ds.property("DEPEND_0");
        this.min = -1.0;
        this.max = 1.0;
        QDataSet yrange = Ops.extent(this.ds);
        this.min = yrange.value(0);
        this.max = yrange.value(1);
    }

    public JPanel getControlPanel() {
        AuralizorControlPanel acp = new AuralizorControlPanel();
        acp.setAuralizor(this);
        return acp;
    }

    public void reset() {
        this.currentRecord = 0;
        this.playing = false;
        this.setPosition(Units.seconds.createDatum(0));
    }

    public Datum getPosition() {
        return DataSetUtil.asDatum(this.dep0.slice(this.currentRecord));
    }

    public void setPosition(Datum position) {
        if (position != this.position) {
            this.currentRecord = DataSetUtil.closestIndex(this.dep0, position);
            if (this.lastAnnouncedPosition == null || this.lastAnnouncedPosition.subtract(position).abs().gt(this.limit)) {
                Datum newPosition = this.getPosition();
                this.pcs.firePropertyChange(PROP_POSITION, this.lastAnnouncedPosition, newPosition);
                this.lastAnnouncedPosition = newPosition;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propname, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propname, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propname, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propname, listener);
    }

    public void playSound() {
        this.playing = true;
        QDataSet dep0 = (QDataSet)this.ds.property("DEPEND_0");
        UnitsConverter uc = UnitsConverter.getConverter(SemanticOps.getUnits(dep0).getOffsetUnits(), Units.seconds);
        float sampleRate = (float)(1.0 / uc.convert(dep0.value(1) - dep0.value(0)));
        logger.log(Level.FINE, "sampleRate= {0}", Float.valueOf(sampleRate));
        AudioFormat audioFormat = new AudioFormat(sampleRate, 16, 1, true, true);
        this.buf = new byte[100000];
        this.buffer = ByteBuffer.wrap(this.buf);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            this.line.addLineListener(this.getLineListener());
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException(e);
        }
        this.line.start();
        int i = this.currentRecord;
        int ibuf = 0;
        while (this.currentRecord < dep0.length() && this.playing) {
            i = this.currentRecord;
            double d = this.ds.value(i++);
            int b = (int)(65536.0 * (d - this.min) / (this.max - this.min)) - 32768;
            try {
                this.buffer.putShort(ibuf, (short)b);
            }
            catch (IndexOutOfBoundsException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            if ((ibuf += 2) == 100000) {
                this.line.write(this.buf, 0, ibuf);
                ibuf = 0;
            }
            this.currentRecord = i;
            this.setPosition(this.getPosition());
        }
        this.line.write(this.buf, 0, ibuf);
        this.line.drain();
        this.line.close();
    }

    LineListener getLineListener() {
        return new LineListener(){

            @Override
            public void update(LineEvent e) {
                if (e.getType().equals(LineEvent.Type.CLOSE)) {
                    // empty if block
                }
            }
        };
    }

    public Auralizor(QDataSet ds) {
        this.setDataSet(ds);
    }
}

