/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;

public class Arrow
extends DasCanvasComponent {
    Point head;
    Point tail;
    Stroke stroke;
    double em = 24.0;

    public Arrow(DasCanvas c, Point head, Point tail) {
        this.head = head;
        this.tail = tail;
        this.setRow(new DasRow(c, head.getX(), tail.getX()));
        this.setColumn(new DasColumn(c, head.getY(), tail.getY()));
    }

    @Override
    public void resize() {
        Rectangle bounds = new Rectangle((int)((double)this.head.x - this.em), (int)((double)this.head.y - this.em), 0, 0);
        bounds.add((double)this.head.x - this.em, (double)this.head.y - this.em);
        bounds.add((double)this.tail.x + this.em, (double)this.tail.y + this.em);
        this.setBounds(bounds);
    }

    public static void paintArrow(Graphics2D g, Point head, Point tail, double headSize, HeadStyle style) {
        Arrow.paintArrow(g, new Point2D.Double(head.getX(), head.getY()), new Point2D.Double(tail.getX(), tail.getY()), headSize, style);
    }

    public static void paintArrow(Graphics2D g, Point2D head, Point2D tail, double headSize, HeadStyle style) {
        double dy;
        double pt = headSize;
        g = (Graphics2D)g.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float s0 = 1.0f;
        Stroke s = g.getStroke();
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            s0 = bs.getLineWidth();
        }
        Line2D.Double line = new Line2D.Double(head, tail);
        double dx = -(head.getX() - tail.getX());
        double dd = Math.sqrt(dx * dx + (dy = -(head.getY() - tail.getY())) * dy);
        if (dd == 0.0) {
            return;
        }
        dx = dx * pt / 4.0 / dd;
        dy = dy * pt / 4.0 / dd;
        double hx = head.getX();
        double hy = head.getY();
        g.setStroke(new BasicStroke((float)(pt / 8.0) * s0, 1, 1));
        g.draw(line);
        GeneralPath p = new GeneralPath();
        p.moveTo((float)hx, (float)hy);
        if (style == HeadStyle.DRAFTING) {
            p.lineTo((float)(hx + 2.0 * dx + 0.5 * dy), (float)(hy + 2.0 * dy - 0.5 * dx));
            p.lineTo((float)(hx + 3.0 * dx + dy), (float)(hy + 3.0 * dy - dx));
            p.lineTo((float)(hx + 3.0 * dx - dy), (float)(hy + 3.0 * dy + dx));
            p.lineTo((float)(hx + 2.0 * dx - 0.5 * dy), (float)(hy + 2.0 * dy + 0.5 * dx));
            p.lineTo((float)hx, (float)hy);
        } else if (style == HeadStyle.FAT_TRIANGLE) {
            p.lineTo((float)(hx + 3.0 * dx + 1.5 * dy), (float)(hy + 3.0 * dy - 1.5 * dx));
            p.lineTo((float)(hx + 3.0 * dx - 1.5 * dy), (float)(hy + 3.0 * dy + 1.5 * dx));
            p.lineTo((float)hx, (float)hy);
        } else if (style == HeadStyle.THIN_TRIANGLE) {
            p.lineTo((float)(hx + 3.0 * dx + dy), (float)(hy + 3.0 * dy - dx));
            p.lineTo((float)(hx + 3.0 * dx - dy), (float)(hy + 3.0 * dy + dx));
            p.lineTo((float)hx, (float)hy);
        }
        g.fill(p);
        g.draw(p);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        g.translate(-this.getX(), -this.getY());
        Arrow.paintArrow(g, this.head, this.tail, this.em, HeadStyle.DRAFTING);
        this.getDasMouseInputAdapter().paint(g1);
        g.dispose();
    }

    public static enum HeadStyle {
        DRAFTING,
        FAT_TRIANGLE,
        THIN_TRIANGLE;

    }
}

