/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.DragRenderer;
import org.das2.event.GesturesRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.graph.DasCanvasComponent;

public class VerticalRangeGesturesRenderer
implements DragRenderer {
    protected int xInitial;
    protected int yInitial;
    private GesturesRenderer gr;
    private Rectangle dirtyBounds;
    private DasCanvasComponent parent;

    public VerticalRangeGesturesRenderer(DasCanvasComponent parent) {
        this.gr = new GesturesRenderer(parent);
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        if (this.gr.isGesture(p1, p2)) {
            this.gr.renderDrag(g, p1, p2);
            this.dirtyBounds.setBounds(this.gr.getDirtyBounds());
        } else {
            int y2 = p2.y;
            int y1 = p1.y;
            if (y2 < y1) {
                int t = y2;
                y2 = y1;
                y1 = t;
            }
            int height = y2 - y1;
            int x = p2.x;
            Color color0 = g.getColor();
            g.setColor(new Color(255, 255, 255, 100));
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            if (height > 6) {
                g.drawLine(x, y1 + 3, x, y2 - 3);
            }
            g.drawLine(x + 2, y1, x - 2, y1);
            g.drawLine(x + 2, y2, x - 2, y2);
            g.setStroke(new BasicStroke());
            g.setColor(color0);
            if (height > 6) {
                g.drawLine(x, y1 + 3, x, y2 - 3);
            }
            g.drawLine(x + 2, y1, x - 2, y1);
            g.drawLine(x + 2, y2, x - 2, y2);
            this.dirtyBounds.setLocation(x - 4, y1 - 2);
            this.dirtyBounds.add(x + 4, y2 + 2);
        }
        return new Rectangle[]{this.dirtyBounds};
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        if (this.gr.isGesture(p1, p2)) {
            return this.gr.getMouseDragEvent(source, p1, p2, isModified);
        }
        return new MouseRangeSelectionEvent(source, p1.y, p2.y, isModified);
    }

    @Override
    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    @Override
    public boolean isPointSelection() {
        return false;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }
}

