/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.GrannyTextRenderer;

public class PointSlopeDragRenderer
extends LabelDragRenderer {
    DasAxis xaxis;
    DasAxis yaxis;
    NumberFormat nf;

    public PointSlopeDragRenderer(DasCanvasComponent parent, DasAxis xaxis, DasAxis yaxis) {
        super(parent);
        this.parent = parent;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.gtr = new GrannyTextRenderer();
        this.nf = new DecimalFormat("0.00E0");
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double atan = Math.atan2(p2.y - p1.y, p2.x - p1.x);
        Line2D.Double line2 = new Line2D.Double(p1.x + (int)(6.0 * Math.cos(atan)), (int)((double)p1.y + 6.0 * Math.sin(atan)), p2.x, p2.y);
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.draw(line2);
        g.draw(new Ellipse2D.Double(p1.x - 4, p1.y - 4, 8.0, 8.0));
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        g1.drawLine(p1.x, p1.y, p2.x, p2.y);
        g1.drawOval(p1.x - 1, p1.y - 1, 3, 3);
        Rectangle myDirtyBounds = new Rectangle(p1.x - 2, p1.y - 2, 5, 5);
        myDirtyBounds.add(p2.x - 2, p2.y - 2);
        myDirtyBounds.add(p2.x + 2, p2.y + 2);
        Datum run = this.xaxis.invTransform(p2.x).subtract(this.xaxis.invTransform(p1.x));
        Datum rise = this.yaxis.invTransform(p2.y).subtract(this.yaxis.invTransform(p1.y));
        Datum xdr = this.xaxis.getDatumRange().width();
        Datum ydr = this.yaxis.getDatumRange().width();
        Units xunits = DatumUtil.asOrderOneUnits(xdr).getUnits();
        Units yunits = DatumUtil.asOrderOneUnits(ydr).getUnits();
        run = run.convertTo(xunits);
        rise = rise.convertTo(yunits);
        if (!p1.equals(p2)) {
            try {
                Datum slope = rise.divide(run);
                this.setLabel("m=" + slope);
            }
            catch (InconvertibleUnitsException ex) {
                double drise = rise.doubleValue(rise.getUnits());
                double drun = run.doubleValue(run.getUnits());
                double mag = drise / drun;
                String units = "" + rise.getUnits() + " / " + run.getUnits();
                this.setLabel("m=" + this.nf.format(mag) + " " + units);
            }
            catch (IllegalArgumentException ex) {
                double drise = rise.doubleValue(rise.getUnits());
                double drun = run.doubleValue(run.getUnits());
                double mag = drise / drun;
                String units = "" + rise.getUnits() + " / " + run.getUnits();
                this.setLabel("m=" + this.nf.format(mag) + " " + units);
            }
        } else {
            this.setLabel("");
        }
        super.renderDrag(g, p1, p2);
        return new Rectangle[]{this.dirtyBounds, myDirtyBounds};
    }
}

