/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Editable;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.UnitsUtil;
import org.das2.event.DragRenderer;
import org.das2.event.EmptyDragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;
import org.das2.system.DasLogger;

public class MouseModule
implements Editable,
Displayable,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected static final Logger logger = LoggerManager.getLogger(DasLogger.GUI_LOG.toString());
    protected DragRenderer dragRenderer;
    private String label;
    private String directions;
    protected DasCanvasComponent parent;

    protected MouseModule() {
        this.label = "unlabelled MM";
        this.dragRenderer = EmptyDragRenderer.renderer;
    }

    public MouseModule(DasCanvasComponent parent) {
        this(parent, EmptyDragRenderer.renderer, "unlabelled MM");
        this.setLabel(this.getClass().getName());
    }

    public MouseModule(DasCanvasComponent parent, DragRenderer dragRenderer, String label) {
        this.parent = parent;
        this.dragRenderer = dragRenderer;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public Cursor getCursor() {
        return new Cursor(0);
    }

    public DragRenderer getDragRenderer() {
        return this.dragRenderer;
    }

    public void setDragRenderer(DragRenderer d) {
        this.dragRenderer = d;
        this.parent.repaint();
    }

    public void mouseRangeSelected(MouseDragEvent e) {
    }

    public void mousePointSelected(MousePointSelectionEvent e) {
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    protected static DatumRange maybeRound(DasAxis xAxis, DatumRange dr) {
        DomainDivider div = xAxis.getMinorTicksDomainDivider();
        if (div != null) {
            try {
                DatumRange drRound;
                DatumRange minDr;
                int px = 999;
                while (px > 1) {
                    div = div.finerDivider(false);
                    minDr = div.rangeContaining(dr.min());
                    px = (int)Math.ceil(Math.abs(xAxis.transform(minDr.max()) - xAxis.transform(minDr.min())));
                }
                minDr = div.rangeContaining(dr.min());
                DatumRange maxDr = div.rangeContaining(dr.max());
                Datum min = DatumRangeUtil.normalize(minDr, dr.min()) < 0.5 ? minDr.min() : minDr.max();
                Datum max = DatumRangeUtil.normalize(maxDr, dr.max()) < 0.5 ? maxDr.min() : maxDr.max();
                dr = drRound = new DatumRange(min, max);
            }
            catch (InconvertibleUnitsException inconvertibleUnitsException) {
                // empty catch block
            }
        }
        return dr;
    }

    protected static boolean axisIsAdjustable(DasAxis axis) {
        return axis != null && (UnitsUtil.isIntervalMeasurement(axis.getUnits()) || UnitsUtil.isRatioMeasurement(axis.getUnits()));
    }

    public String getDirections() {
        return this.directions;
    }

    public void setDirections(String directions) {
        this.directions = directions;
    }

    @Override
    public Icon getListIcon() {
        return null;
    }

    @Override
    public void drawListIcon(Graphics2D g, int x, int y) {
    }

    @Override
    public String getListLabel() {
        return this.getLabel();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public Pos position(DasDevicePosition ddp, int pos, int threshold) {
        int min;
        int max = ddp.getDMaximum();
        if ((max - (min = ddp.getDMinimum())) / threshold < 3) {
            threshold = (max - min) / 3;
        }
        if (pos < min) {
            return Pos.beyondMin;
        }
        if (pos < min + threshold) {
            return Pos.min;
        }
        if (pos <= max - threshold) {
            return Pos.middle;
        }
        if (pos <= max) {
            return Pos.max;
        }
        return Pos.beyondMax;
    }

    protected static enum Pos {
        _null,
        beyondMin,
        min,
        middle,
        max,
        beyondMax;

    }
}

