/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;

public class LengthDragRenderer
extends LabelDragRenderer {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DasPlot plot;
    private boolean showSlope = false;
    protected boolean showFit = true;

    public LengthDragRenderer(DasCanvasComponent parent, DasAxis xaxis, DasAxis yaxis) {
        super(parent);
        this.plot = (DasPlot)parent;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        DasAxis ya;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double atan = Math.atan2(p2.y - p1.y, p2.x - p1.x);
        Line2D.Double line = new Line2D.Double(p1.x + (int)(4.0 * Math.cos(atan)), (int)((double)p1.y + 4.0 * Math.sin(atan)), p2.x, p2.y);
        Line2D.Double line2 = new Line2D.Double(p1.x + (int)(6.0 * Math.cos(atan)), (int)((double)p1.y + 6.0 * Math.sin(atan)), p2.x, p2.y);
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.draw(line2);
        g.draw(new Ellipse2D.Double(p1.x - 4, p1.y - 4, 8.0, 8.0));
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        g.draw(line);
        g.draw(new Ellipse2D.Double(p1.x - 4, p1.y - 4, 8.0, 8.0));
        Rectangle myDirtyBounds = new Rectangle();
        myDirtyBounds.setRect(p1.x - 3, p1.y - 3, 7.0, 7.0);
        myDirtyBounds.add(p2.x - 2, p2.y - 2);
        myDirtyBounds.add(p2.x + 2, p2.y + 2);
        DasAxis xa = this.xaxis == null ? this.plot.getXAxis() : this.xaxis;
        DasAxis dasAxis = ya = this.yaxis == null ? this.plot.getYAxis() : this.yaxis;
        if (!p1.equals(p2)) {
            String radString;
            Datum x1 = xa.invTransform(p2.x);
            Datum x0 = xa.invTransform(p1.x);
            Datum run = x1.subtract(x0);
            run = DatumUtil.asOrderOneUnits(run);
            String runString = x1.getUnits() == run.getUnits() ? x1.getFormatter().format(run) : run.toString();
            Datum y1 = ya.invTransform(p2.y);
            Datum y0 = ya.invTransform(p1.y);
            Datum rise = y1.subtract(y0);
            String riseString = rise.toString();
            if (rise.getUnits().isConvertibleTo(run.getUnits())) {
                Units u = run.getUnits();
                double rised = rise.doubleValue(u);
                double rund = run.doubleValue(u);
                double rad = Math.sqrt(rised * rised + rund * rund);
                double srised = rise.getResolution(u);
                double srund = run.getResolution(u);
                double res = rad * Math.sqrt(Math.pow(srised / Math.max(Math.abs(rised), srised), 2.0) + Math.pow(srund / Math.max(Math.abs(rund), srund), 2.0));
                Datum radDatum = Datum.create(rad, u, res / 100.0);
                radString = "!cR:" + radDatum;
            } else {
                radString = "";
            }
            String label1 = "\u0394x: " + runString + " \u0394y: " + riseString + radString;
            if (this.showSlope) {
                label1 = label1 + "!cm: " + UnitsUtil.divideToString(rise, run);
            }
            if (this.showFit) {
                String fit;
                Units runUnits = run.getUnits();
                Datum slope = rise.getUnits().isConvertibleTo(runUnits) ? rise.divide(run) : rise.divide(run.doubleValue(runUnits));
                if (this.yaxis.isLog() && this.xaxis.isLog()) {
                    double ycycles = Math.log10(y1.divide(y0).doubleValue(Units.dimensionless));
                    double xcycles = Math.log10(x1.divide(x0).doubleValue(Units.dimensionless));
                    DecimalFormat nf = new DecimalFormat("0.00");
                    String sslope = nf.format(ycycles / xcycles);
                    fit = "y= ( x/" + x1 + " )!A" + sslope + "!n * " + y1;
                } else if (this.yaxis.isLog() && !this.xaxis.isLog()) {
                    DecimalFormat nf = new DecimalFormat("0.00");
                    Units u = run.getUnits();
                    double drise = Math.log10(y1.divide(y0).doubleValue(Units.dimensionless));
                    double drun = x1.subtract(x0).doubleValue(u);
                    String sslope = nf.format(drise / drun);
                    String su = u.isConvertibleTo(Units.seconds) ? UnitsUtil.divideToString(Units.dimensionless.createDatum(drise), run) : (u == Units.dimensionless ? sslope : sslope + "/(" + u + ")");
                    String sx0 = x1.toString();
                    if (UnitsUtil.isTimeLocation(x1.getUnits())) {
                        fit = "!Cx0=" + sx0 + "!C";
                        fit = fit + "!Cy=10!A( x-x0 )*" + su + "!n * " + y1;
                    } else {
                        fit = "!Cy=10!A( x-(" + x1 + ") )*" + su + "!n * " + y1;
                    }
                } else if (!this.yaxis.isLog() && this.xaxis.isLog()) {
                    DecimalFormat nf = new DecimalFormat("0.00");
                    Units u = rise.getUnits();
                    double drise = y1.subtract(y0).doubleValue(u);
                    double drun = Math.log10(x1.divide(x0).doubleValue(Units.dimensionless));
                    String sslope = nf.format(drise / drun);
                    String su = u.isConvertibleTo(Units.seconds) ? UnitsUtil.divideToString(rise, Units.dimensionless.createDatum(drun)) : (u == Units.dimensionless ? sslope : sslope + "(" + u + ")");
                    fit = "y=Log( x / " + x1 + " )*" + su + " + " + y1;
                } else {
                    DecimalFormat nf = new DecimalFormat("0.00");
                    String dx = "( x - (" + x1 + ") )";
                    if (runUnits != Units.dimensionless) {
                        if (UnitsUtil.isTimeLocation(x1.getUnits())) {
                            fit = "!Cx0=" + x1 + "!C";
                            dx = "( x-x0 )";
                            fit = fit + "!Cy=" + nf.format(slope.value()) + "/" + runUnits + " * " + dx + " + " + y1;
                        } else {
                            fit = "y=" + nf.format(slope.value()) + "/" + runUnits + " * " + dx + " + " + y1;
                        }
                    } else {
                        fit = "y=" + slope + " * ( x - (" + x1 + ") ) + " + y1;
                    }
                }
                label1 = label1 + "!c" + fit;
            }
            this.setLabel(label1);
        } else {
            this.setLabel("");
        }
        super.renderDrag(g, p1, p2);
        return new Rectangle[]{this.dirtyBounds, myDirtyBounds};
    }

    public boolean isShowSlope() {
        return this.showSlope;
    }

    public void setShowSlope(boolean showSlope) {
        this.showSlope = showSlope;
    }

    public boolean isShowFit() {
        return this.showFit;
    }

    public void setShowFit(boolean showFit) {
        this.showFit = showFit;
    }
}

