/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.das2.event.DragRenderer;
import org.das2.event.InfoLabel;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.GrannyTextRenderer;

public class LabelDragRenderer
implements DragRenderer {
    String label = "Label not set";
    GrannyTextRenderer gtr;
    DasCanvasComponent parent;
    InfoLabel infoLabel;
    int labelPositionX = 1;
    int labelPositionY = -1;
    Rectangle dirtyBounds;
    static final Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    int maxLabelWidth;
    ArrayList newDirtyBounds;
    boolean tooltip = false;

    @Override
    public void clear(Graphics g) {
        if (this.dirtyBounds != null) {
            this.parent.paintImmediately(this.dirtyBounds);
        }
        this.dirtyBounds = null;
    }

    public LabelDragRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
        this.gtr = new GrannyTextRenderer();
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        this.maxLabelWidth = 0;
        if (this.tooltip && this.infoLabel != null) {
            this.infoLabel.hide(this.parent);
        }
        return null;
    }

    @Override
    public boolean isPointSelection() {
        return true;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    private Rectangle paintLabel(Graphics g1, Point p2) {
        if (this.label == null) {
            return null;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setClip(null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getCanvas() == null) {
            return null;
        }
        Dimension d = this.parent.getCanvas().getSize();
        this.gtr.setString(g1, this.label);
        int dx = (int)this.gtr.getWidth() + 6;
        int dy = (int)this.gtr.getHeight();
        if (this.maxLabelWidth < dx) {
            this.maxLabelWidth = dx;
        }
        this.labelPositionX = p2.x + this.maxLabelWidth > d.width && p2.x - 3 - dx > 0 ? -1 : 1;
        int xp = this.labelPositionX == 1 ? p2.x + 3 : p2.x - 3 - dx;
        this.labelPositionY = p2.y - 3 - dy < 13 ? -1 : 1;
        int yp = this.labelPositionY == 1 ? p2.y - 3 - dy : p2.y + 3;
        this.dirtyBounds = new Rectangle();
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 200));
        this.dirtyBounds.setRect(xp, yp, dx, dy);
        g.fill(this.dirtyBounds);
        g.setColor(new Color(20, 20, 20));
        this.gtr.draw(g, xp + 3, (float)((double)yp + this.gtr.getAscent()));
        g.setColor(color0);
        return this.dirtyBounds;
    }

    @Override
    public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
        Rectangle[] result;
        logger.log(Level.FINEST, "renderDrag {0}", p2);
        if (this.tooltip) {
            if (this.infoLabel == null) {
                this.infoLabel = new InfoLabel();
            }
            Point p = (Point)p2.clone();
            DasCanvas c = this.parent.getCanvas();
            if (c != null) {
                SwingUtilities.convertPointToScreen(p, this.parent.getCanvas());
                this.infoLabel.setText(this.label, p, this.parent, this.labelPositionX, this.labelPositionY);
                result = new Rectangle[]{};
            } else {
                this.infoLabel.setText(this.label, p, this.parent, this.labelPositionX, this.labelPositionY);
                result = new Rectangle[]{};
            }
        } else if (this.label == null) {
            result = new Rectangle[]{};
        } else {
            Rectangle r = this.paintLabel(g, p2);
            result = new Rectangle[]{r};
        }
        return result;
    }

    protected void resetDirtyBounds() {
        this.newDirtyBounds = new ArrayList();
    }

    protected void addDirtyBounds(Rectangle[] dirty) {
        if (dirty != null && dirty.length > 0) {
            this.newDirtyBounds.addAll(Arrays.asList(dirty));
        }
    }

    protected void addDirtyBounds(Rectangle dirty) {
        if (dirty != null) {
            this.newDirtyBounds.add(dirty);
        }
    }

    protected Rectangle[] getDirtyBounds() {
        return this.newDirtyBounds.toArray(new Rectangle[this.newDirtyBounds.size()]);
    }

    public boolean isTooltip() {
        return this.tooltip;
    }

    public void setTooltip(boolean tooltip) {
        this.tooltip = tooltip;
        if (tooltip) {
            this.labelPositionX = 1;
            this.labelPositionY = -1;
        }
    }
}

