/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.HorizontalSliceSelectionRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;

public class HorizontalSlicerMouseModule
extends MouseModule {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private TableDataSetConsumer dataSetConsumer;
    private DataPointSelectionEvent de;
    private EventListenerList listenerList = new EventListenerList();

    public HorizontalSlicerMouseModule(DasPlot parent, TableDataSetConsumer dataSetConsumer, DasAxis xaxis, DasAxis yaxis) {
        this(parent, (DataSetConsumer)dataSetConsumer, xaxis, yaxis);
    }

    protected HorizontalSlicerMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xaxis, DasAxis yaxis) {
        super(parent, new HorizontalSliceSelectionRenderer(parent), "Horizontal Slice");
        if (!(dataSetConsumer instanceof TableDataSetConsumer)) {
            throw new IllegalArgumentException("dataSetConsumer must be an XTaggedYScanDataSetConsumer");
        }
        this.dataSetConsumer = (TableDataSetConsumer)dataSetConsumer;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static HorizontalSlicerMouseModule create(DasPlot parent) {
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new HorizontalSlicerMouseModule(parent, null, xaxis, yaxis);
    }

    public static HorizontalSlicerMouseModule create(Renderer renderer) {
        DasPlot parent = renderer.getParent();
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new HorizontalSlicerMouseModule(parent, renderer, xaxis, yaxis);
    }

    @Override
    public void mousePointSelected(MousePointSelectionEvent e) {
        QDataSet ds = this.dataSetConsumer.getConsumedDataSet();
        this.de.setDataSet(ds);
        this.de.set(this.xaxis.invTransform(e.getX()), this.yaxis.invTransform(e.getY()));
        this.fireDataPointSelectionListenerDataPointSelected(this.de);
    }

    public void addDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.add(DataPointSelectionListener.class, listener);
    }

    public void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(DataPointSelectionListener.class, listener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HorizontalSpectrogramSlicer getSlicer() {
        Object[] listeners;
        HorizontalSlicerMouseModule horizontalSlicerMouseModule = this;
        synchronized (horizontalSlicerMouseModule) {
            listeners = this.listenerList.getListenerList();
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HorizontalSpectrogramSlicer)) continue;
            return (HorizontalSpectrogramSlicer)listeners[i];
        }
        throw new IllegalArgumentException("slicer not found.");
    }
}

