/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.util.QDataSetTableModel;

public class DisplayDataMouseModule
extends MouseModule {
    private static final String LABEL = "Display Data";
    private final DasPlot plot;
    private JFrame myFrame;
    private JPanel myPanel;
    private JTable myEdit;
    private JComboBox comboBox;
    private JLabel messageLabel;
    private Renderer[] rends;
    private Renderer currentRenderer;
    private DatumRange xrange;
    private DatumRange yrange;
    private final ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DisplayDataMouseModule.this.rends == null) {
                return;
            }
            int i = DisplayDataMouseModule.this.comboBox.getSelectedIndex();
            if (i < DisplayDataMouseModule.this.rends.length) {
                DisplayDataMouseModule.this.setDataSet(DisplayDataMouseModule.this.rends[i].getDataSet(), DisplayDataMouseModule.this.xrange, DisplayDataMouseModule.this.yrange);
            }
            DisplayDataMouseModule.this.currentRenderer = DisplayDataMouseModule.this.rends[i];
        }
    };
    private boolean yclip = true;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DisplayDataMouseModule(DasPlot parent) {
        super(parent, new BoxRenderer(parent), LABEL);
        this.plot = parent;
    }

    private void maybeCreateFrame(Object source) {
        if (this.myFrame == null) {
            Window w;
            this.myFrame = new JFrame(LABEL);
            if (source != null && source instanceof JComponent && (w = SwingUtilities.getWindowAncestor((JComponent)source)) instanceof JFrame) {
                this.myFrame.setIconImage(((JFrame)w).getIconImage());
            }
            this.myPanel = new JPanel();
            this.myPanel.setPreferredSize(new Dimension(300, 300));
            this.myPanel.setLayout(new BorderLayout());
            this.myEdit = new JTable();
            this.myEdit.setFont(Font.decode("fixed-10"));
            this.myEdit.setAutoResizeMode(0);
            this.myEdit.getTableHeader().setReorderingAllowed(false);
            this.myEdit.setCellSelectionEnabled(true);
            final JPopupMenu pm = new JPopupMenu();
            pm.add(new CopyAction(this.myEdit));
            this.myEdit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.doPopup(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.doPopup(e);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.doPopup(e);
                    }
                }

                protected void doPopup(MouseEvent e) {
                    pm.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            JScrollPane scrollPane = new JScrollPane(this.myEdit, 20, 30);
            this.myPanel.add((Component)scrollPane, "Center");
            this.messageLabel = new JLabel("");
            this.myPanel.add((Component)this.messageLabel, "South");
            JPanel comboBoxArea = new JPanel();
            comboBoxArea.setLayout(new BoxLayout(comboBoxArea, 0));
            this.comboBox = new JComboBox();
            this.comboBox.addItemListener(this.itemListener);
            comboBoxArea.add(new JLabel("Plotted Data:"));
            comboBoxArea.add(this.comboBox);
            this.myPanel.add((Component)comboBoxArea, "North");
            this.myFrame.getContentPane().add(this.myPanel);
            this.myFrame.pack();
            this.myFrame.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this.plot));
        }
    }

    private String unitsStr(Units u) {
        return u == Units.dimensionless ? "" : "(" + u.toString() + ")";
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e0) {
        if (!(e0 instanceof MouseBoxEvent)) {
            throw new IllegalArgumentException("Event should be MouseBoxEvent");
        }
        MouseBoxEvent e = (MouseBoxEvent)e0;
        if (Point.distance(e.getXMaximum(), e.getYMinimum(), e.getXMaximum(), e.getYMaximum()) < 5.0) {
            return;
        }
        this.maybeCreateFrame(e0.getSource());
        DatumRange xrng = this.plot.getXAxis().isFlipped() ? new DatumRange(this.plot.getXAxis().invTransform(e.getXMaximum()), this.plot.getXAxis().invTransform(e.getXMinimum())) : new DatumRange(this.plot.getXAxis().invTransform(e.getXMinimum()), this.plot.getXAxis().invTransform(e.getXMaximum()));
        DatumRange yrng = this.yclip ? (this.plot.getYAxis().isFlipped() ? new DatumRange(this.plot.getYAxis().invTransform(e.getYMinimum()), this.plot.getYAxis().invTransform(e.getYMaximum())) : new DatumRange(this.plot.getYAxis().invTransform(e.getYMaximum()), this.plot.getYAxis().invTransform(e.getYMinimum()))) : null;
        final Renderer[] rends1 = this.plot.getRenderers();
        if (rends1.length == 0) {
            return;
        }
        this.myFrame.setVisible(true);
        String[] rlabels = new String[rends1.length];
        int firstActive = -1;
        for (int i = 0; i < rends1.length; ++i) {
            String label = rends1[i].getLegendLabel();
            if (label == null || label.equals("")) {
                label = "Renderer " + i;
            }
            if (!rends1[i].isActive()) {
                label = label + " (not visible)";
            } else if (firstActive == -1) {
                firstActive = i;
            }
            QDataSet ds = rends1[i].getDataSet();
            if (ds != null) {
                label = label + ": " + ds.toString();
            }
            rlabels[i] = label;
        }
        if (firstActive == -1) {
            firstActive = 0;
        }
        if (this.currentRenderer == null) {
            this.currentRenderer = rends1[firstActive];
        }
        int icurrent = -1;
        for (int i = 0; i < rends1.length; ++i) {
            Renderer r = rends1[i];
            if (this.currentRenderer != r) continue;
            icurrent = i;
        }
        if (icurrent == -1) {
            this.currentRenderer = rends1[firstActive];
            icurrent = firstActive;
        }
        this.rends = rends1;
        this.xrange = xrng;
        this.yrange = yrng;
        this.comboBox.setModel(new DefaultComboBoxModel<String>(rlabels));
        this.comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index > -1 && index < rends1.length) {
                    label.setIcon(rends1[index].getListIcon());
                } else {
                    label.setIcon(null);
                }
                return label;
            }
        });
        this.comboBox.setSelectedIndex(icurrent);
        this.setDataSet(this.currentRenderer.getDataSet(), this.xrange, this.yrange);
    }

    private void showMessageInTable(JTable t, final String message) {
        DefaultTableModel result = new DefaultTableModel(1, 1){

            @Override
            public Object getValueAt(int row, int col) {
                return message;
            }
        };
        t.setModel(result);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn c = new TableColumn(0);
        c.setHeaderValue("");
        c.setPreferredWidth(250);
        tcm.addColumn(c);
        t.setColumnModel(tcm);
    }

    private void setDataSet(QDataSet ds, DatumRange xrange, DatumRange yrange) {
        TableColumnModel tcm;
        QDataSetTableModel tm;
        if (ds == null) {
            this.showMessageInTable(this.myEdit, "no dataset");
            return;
        }
        if (ds.rank() > 2) {
            QDataSet ds2 = SemanticOps.getSimpleTableContaining(ds, xrange.min(), yrange.min());
            if (ds2 == null) {
                this.showMessageInTable(this.myEdit, "data cannot be displayed");
                return;
            }
            ds = ds2;
        }
        try {
            boolean isQube = DataSetUtil.isQube(ds);
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 != null && dep1.rank() == 2) {
                isQube = false;
            }
            QDataSet tds = isQube ? SemanticOps.trim(ds, xrange, yrange) : SemanticOps.trim(ds, xrange, null);
            tm = new QDataSetTableModel(tds);
            tcm = tm.getTableColumnModel();
            if (dep1 != null && dep1.rank() == 2) {
                this.myEdit.getTableHeader().setToolTipText("Column labels reported are from the first record");
            }
            if (tds.rank() == 1) {
                this.messageLabel.setText(tds.length() + " records");
            } else if (tds.length() > 0) {
                int[] qube = DataSetUtil.qubeDims(tds);
                int[] qube1 = DataSetUtil.qubeDims(tds.slice(0));
                if (qube != null) {
                    this.messageLabel.setText(tds.length() + " records, each is " + DataSetUtil.toString(qube1));
                } else {
                    this.messageLabel.setText(tds.length() + " records, first is " + DataSetUtil.toString(qube1));
                }
            } else {
                this.messageLabel.setText("no records");
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            tm = new QDataSetTableModel(ds);
            tcm = tm.getTableColumnModel();
            this.messageLabel.setText(ex.getMessage());
        }
        this.myEdit.setModel(tm);
        this.myEdit.setColumnModel(tcm);
        this.myEdit.setRowSorter(new TableRowSorter<QDataSetTableModel>(tm));
    }

    @Override
    public String getListLabel() {
        return this.getLabel();
    }

    @Override
    public Icon getListIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/icons/showDataMouseModule.png"));
        return icon;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isYclip() {
        return this.yclip;
    }

    public void setYclip(boolean yclip) {
        boolean oldYclip = this.yclip;
        this.yclip = yclip;
        this.propertyChangeSupport.firePropertyChange("yclip", oldYclip, yclip);
    }

    public static class CellTransferable
    implements Transferable {
        public static final DataFlavor CELL_DATA_FLAVOR = DataFlavor.stringFlavor;
        private final Object cellValue;

        public CellTransferable(Object cellValue) {
            this.cellValue = cellValue;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CELL_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return CELL_DATA_FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.cellValue;
        }
    }

    private static final class CopyAction
    extends AbstractAction {
        private final JTable table;

        public CopyAction(JTable table) {
            this.table = table;
            this.putValue("Name", "Copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder build = new StringBuilder();
            int[] rows = this.table.getSelectedRows();
            int[] cols = this.table.getSelectedColumns();
            for (int j = 0; j < rows.length; ++j) {
                if (j > 0) {
                    build.append("\n");
                }
                for (int i = 0; i < cols.length; ++i) {
                    if (i > 0) {
                        build.append(",");
                    }
                    build.append(this.table.getValueAt(rows[j], cols[i]));
                }
            }
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(new CellTransferable(build.toString()), null);
        }
    }
}

