/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.ClippedTableDataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.DataPointSelectorMouseModule;
import org.das2.event.HorizontalSliceSelectionRenderer;
import org.das2.event.VerticalSliceSelectionRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.SymbolLineRenderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.ProgressMonitor;

public class CutoffMouseModule
extends BoxSelectorMouseModule {
    DatumRange xrange;
    DatumRange yrange;
    String lastComment;
    CutoffSlicer cutoffSlicer;
    DasApplication application;
    private transient ArrayList dataSetUpdateListenerList;
    private Datum slopeMin = Units.dimensionless.createDatum(0.26);
    private Datum levelMin = Units.dimensionless.createDatum(-4.0);
    private int nave = 3;
    private Datum xResolution = Units.milliseconds.createDatum(1000);
    private boolean lowCutoff;
    private EventListenerList listenerList = new EventListenerList();

    public CutoffMouseModule(DasPlot parent, DataSetConsumer consumer) {
        super(parent, parent.getXAxis(), parent.getYAxis(), consumer, new BoxRenderer(parent, true), "Cutoff");
        this.application = parent.getCanvas().getApplication();
        this.dataSetConsumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBoxSelectionListenerBoxSelected(BoxSelectionEvent event) {
        DatumRange xrange0 = this.xrange;
        DatumRange yrange0 = this.yrange;
        this.xrange = event.getXRange();
        this.yrange = event.getYRange();
        CutoffMouseModule cutoffMouseModule = this;
        synchronized (cutoffMouseModule) {
            this.lastComment = event.getPlane("keyChar") != null ? (String)event.getPlane("keyChar") : null;
        }
        try {
            this.recalculateSoon();
        }
        catch (RuntimeException ex) {
            this.xrange = xrange0;
            this.yrange = yrange0;
            throw ex;
        }
    }

    private RebinDescriptor getRebinDescriptor(DatumRange range) {
        double res = this.xResolution.doubleValue(Units.microseconds);
        double min = range.min().doubleValue(Units.us2000);
        min = Math.floor(min / res);
        double max = range.max().doubleValue(Units.us2000);
        max = Math.ceil(max / res);
        int nbin = (int)(max - min);
        RebinDescriptor ddx = new RebinDescriptor(min * res, max * res, Units.us2000, nbin, false);
        return ddx;
    }

    private void recalculateSoon() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ProgressMonitor mon = CutoffMouseModule.this.application.getMonitorFactory().getMonitor(CutoffMouseModule.this.parent, "calculating cutoffs", "calculating cutoffs");
                CutoffMouseModule.this.recalculate(mon);
            }
        };
        new Thread(run, "digitizer recalculate").start();
    }

    private synchronized void recalculate(ProgressMonitor mon) {
        QDataSet tds = this.dataSetConsumer.getConsumedDataSet();
        if (tds == null) {
            return;
        }
        if (this.xrange == null) {
            return;
        }
        tds = new ClippedTableDataSet(tds, this.xrange, this.yrange);
        QDataSet yds = SemanticOps.ytagsDataSet(tds);
        QDataSet xds = SemanticOps.xtagsDataSet(tds);
        AverageTableRebinner rebinner = new AverageTableRebinner();
        DatumRange range = DataSetUtil.asDatumRange(SemanticOps.bounds(tds).slice(0), true);
        RebinDescriptor ddx = this.getRebinDescriptor(range);
        try {
            tds = rebinner.rebin(tds, ddx, null);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
        double fill = SemanticOps.getUnits(yds).getFillDouble();
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        builder.putProperty("UNITS", SemanticOps.getUnits(yds));
        builder.putProperty("FILL_VALUE", fill);
        DataSetBuilder xbuilder = new DataSetBuilder(1, 100);
        xbuilder.putProperty("UNITS", SemanticOps.getUnits(xds));
        mon.setTaskSize(tds.length());
        mon.started();
        for (int i = 0; i < tds.length(); ++i) {
            mon.setTaskProgress(i);
            if (mon.isCancelled()) break;
            QDataSet spec = Ops.log10(tds.slice(i));
            int icutoff = this.cutoff(spec, this.slopeMin, this.nave, this.isLowCutoff() ? 1 : -1, this.levelMin);
            if (icutoff > -1) {
                xbuilder.putValue(-1, xds.value(i));
                builder.putValue(-1, yds.value(icutoff));
            } else {
                xbuilder.putValue(-1, xds.value(i));
                builder.putValue(-1, fill);
            }
            builder.nextRecord();
            xbuilder.nextRecord();
        }
        mon.finished();
        if (mon.isCancelled()) {
            return;
        }
        String comment = "Ondrej:" + this.levelMin + ":" + this.slopeMin + ":" + this.nave;
        if (this.lastComment != null) {
            comment = this.lastComment + " " + comment;
        }
        builder.putProperty("USER_PROPERTIES", Collections.singletonMap("comment", comment));
        xbuilder.putProperty("CADENCE", DataSetUtil.asDataSet(this.xResolution));
        builder.putProperty("DEPEND_0", xbuilder.getDataSet());
        DDataSet vds = builder.getDataSet();
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(vds));
    }

    public int cutoff(QDataSet ds, Datum slopeMin, int nave, int mult, Datum levelMin) {
        int j;
        int nfr = ds.length();
        if (nfr < nave + 1) {
            throw new IllegalArgumentException("DataSet doesn't contain enough elements");
        }
        double[] cumul = new double[nfr];
        Units units = SemanticOps.getUnits(ds);
        double level = levelMin.doubleValue(units);
        double slope = slopeMin.doubleValue(units);
        cumul[0] = ds.value(0);
        for (int i = 1; i < nfr; ++i) {
            cumul[i] = cumul[i - 1] + ds.value(i);
        }
        boolean[] icof = new boolean[nfr];
        QDataSet xds = SemanticOps.xtagsDataSet(ds);
        Units xunits = SemanticOps.getUnits(xds);
        DataSetBuilder levelBuilder = new DataSetBuilder(1, 100);
        DataSetBuilder xlevelBuilder = new DataSetBuilder(1, 100);
        xlevelBuilder.putProperty("UNITS", xunits);
        DataSetBuilder slopeBuilder = new DataSetBuilder(1, 100);
        DataSetBuilder xslopeBuilder = new DataSetBuilder(1, 100);
        xslopeBuilder.putProperty("UNITS", xunits);
        DataSetBuilder icofBuilder = new DataSetBuilder(1, 100);
        DataSetBuilder xicofBuilder = new DataSetBuilder(1, 100);
        xicofBuilder.putProperty("UNITS", xunits);
        for (int i = 1; i < nfr; ++i) {
            icof[i] = true;
        }
        icof[0] = false;
        icof[nfr - 1] = false;
        for (int k = 1; k <= nave; ++k) {
            int j2;
            double[] ave = new double[nfr];
            ave[0] = cumul[k - 1] / (double)k;
            for (j2 = 0; j2 < nfr - k; ++j2) {
                ave[j2 + 1] = (cumul[j2 + k] - cumul[j2]) / (double)k;
                levelBuilder.putValue(-1, ave[j2 + 1]);
                levelBuilder.nextRecord();
                xlevelBuilder.putValue(-1, xds.value(j2 + 1));
                xlevelBuilder.nextRecord();
            }
            for (j2 = k; j2 < nfr - k; ++j2) {
                double uave;
                double slopeTest = (ave[j2 + 1] - ave[j2 - k]) / (double)k;
                slopeBuilder.putValue(-1, slopeTest);
                slopeBuilder.nextRecord();
                xslopeBuilder.putValue(-1, xds.value(j2 + 1));
                xslopeBuilder.nextRecord();
                if (slopeTest * (double)mult <= slope * (double)mult) {
                    icof[j2] = false;
                }
                double d = uave = mult > 0 ? ave[j2 + k] : ave[j2];
                if (uave <= level) {
                    icof[j2] = false;
                }
                icofBuilder.putValue(-1, icof[j2] ? 1.0 : 0.0);
                icofBuilder.nextRecord();
                xicofBuilder.putValue(-1, xds.value(j2));
                xicofBuilder.nextRecord();
            }
        }
        if (this.cutoffSlicer != null) {
            slopeBuilder.putProperty("DEPEND_0", xslopeBuilder.getDataSet());
            this.cutoffSlicer.slopeRenderer.setDataSet(slopeBuilder.getDataSet());
            levelBuilder.putProperty("DEPEND_0", xlevelBuilder.getDataSet());
            this.cutoffSlicer.levelRenderer.setDataSet(levelBuilder.getDataSet());
            icofBuilder.putProperty("DEPEND_0", xicofBuilder.getDataSet());
            this.cutoffSlicer.icofRenderer.setDataSet(icofBuilder.getDataSet());
        }
        int icutOff = -1;
        int n = j = mult < 0 ? nfr - 1 : 0;
        while (j >= 0 && j < nfr) {
            if (icof[j]) {
                icutOff = j;
                break;
            }
            j += mult;
        }
        return icutOff;
    }

    public DataPointSelectionListener getSlicer(DasPlot plot, TableDataSetConsumer consumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(2);
        this.cutoffSlicer = new CutoffSlicer(plot, xAxis);
        return this.cutoffSlicer;
    }

    public synchronized void addDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.dataSetUpdateListenerList == null) {
            this.dataSetUpdateListenerList = new ArrayList();
        }
        this.dataSetUpdateListenerList.add(listener);
    }

    public synchronized void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.dataSetUpdateListenerList != null) {
            this.dataSetUpdateListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        ArrayList list;
        CutoffMouseModule cutoffMouseModule = this;
        synchronized (cutoffMouseModule) {
            if (this.dataSetUpdateListenerList == null) {
                return;
            }
            list = (ArrayList)this.dataSetUpdateListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((DataSetUpdateListener)list.get(i)).dataSetUpdated(event);
        }
    }

    public Datum getSlopeMin() {
        return this.slopeMin;
    }

    public void setSlopeMin(Datum slopeMin) {
        Datum oldVal = this.slopeMin;
        if (!this.slopeMin.equals(slopeMin)) {
            this.slopeMin = slopeMin;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "slope", oldVal, slopeMin);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
        }
    }

    public Datum getLevelMin() {
        return this.levelMin;
    }

    public void setLevelMin(Datum levelMin) {
        Datum oldVal = this.levelMin;
        if (!this.levelMin.equals(levelMin)) {
            this.levelMin = levelMin;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "level", oldVal, levelMin);
            this.firePropertyChangeListenerPropertyChange(e);
            levelMin.getFormatter().format(levelMin);
            this.recalculateSoon();
        }
    }

    public int getNave() {
        return this.nave;
    }

    public void setNave(int nave) {
        int oldVal = this.nave;
        if (this.nave != nave) {
            this.nave = nave;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "nave", oldVal, nave);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
        }
    }

    public Datum getXResolution() {
        return this.xResolution;
    }

    public void setXResolution(Datum xResolution) {
        Datum oldVal = this.xResolution;
        if (!this.xResolution.equals(xResolution)) {
            this.xResolution = xResolution;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "timeResolution", oldVal, this.xResolution);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
        }
    }

    public boolean isLowCutoff() {
        return this.lowCutoff;
    }

    public void setLowCutoff(boolean lowCutoff) {
        Boolean oldVal = this.lowCutoff;
        if (this.lowCutoff != lowCutoff) {
            this.lowCutoff = lowCutoff;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "lowCutoff", oldVal, lowCutoff);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
            if (this.cutoffSlicer != null) {
                this.cutoffSlicer.slopePlot.repaint();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(PropertyChangeListener.class, listener);
    }

    private void firePropertyChangeListenerPropertyChange(PropertyChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    private class CutoffSlicer
    implements DataPointSelectionListener {
        DataPointSelectionEvent lastSelectedPoint;
        Datum cutoff;
        Datum yValue;
        Datum xValue;
        SymbolLineRenderer levelRenderer;
        SymbolLineRenderer contextLevelRenderer;
        SymbolLineRenderer slopeRenderer;
        SymbolLineRenderer contextSlopeRenderer;
        SymbolLineRenderer icofRenderer;
        DasPlot topPlot;
        DasPlot slopePlot;
        JFrame frame = new JFrame("Cutoff Slice");

        CutoffSlicer(DasPlot parent, DasAxis xaxis) {
            DasCanvas canvas = new DasCanvas(300, 600);
            this.frame.getContentPane().add(canvas);
            this.frame.pack();
            this.frame.setVisible(false);
            this.frame.setDefaultCloseOperation(1);
            DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 5.0, -1.5, 0, 0);
            DasRow row1 = new DasRow(canvas, null, 0.0, 0.3333333333333333, 2.0, -1.0, 0, 0);
            DasRow row2 = new DasRow(canvas, null, 0.3333333333333333, 0.6666666666666666, 1.5, -1.5, 0, 0);
            DasRow row3 = new DasRow(canvas, null, 0.6666666666666666, 1.0, 1.0, -2.0, 0, 0);
            DasPlot plot = new DasPlot(xaxis, new DasAxis(new DatumRange(-18.0, -10.0, Units.dimensionless), 3)){

                @Override
                protected void drawContent(Graphics2D g) {
                    super.drawContent(g);
                    int ix = this.getColumn().getDMinimum();
                    g.setColor(Color.GRAY);
                    int iy = (int)this.getYAxis().transform(CutoffMouseModule.this.levelMin);
                    g.drawLine(ix, iy, ix + this.getWidth(), iy);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.cutoff);
                    g.drawLine(ix, 0, ix, this.getHeight());
                    g.setColor(Color.pink);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.yValue);
                    g.drawLine(ix, 0, ix, this.getHeight());
                }
            };
            plot.getYAxis().setLabel("level");
            plot.getXAxis().setTickLabelsVisible(false);
            this.levelRenderer = new SymbolLineRenderer();
            this.contextLevelRenderer = new SymbolLineRenderer();
            this.contextLevelRenderer.setColor(Color.GRAY);
            plot.addRenderer(this.contextLevelRenderer);
            plot.addRenderer(this.levelRenderer);
            this.topPlot = plot;
            DataPointSelectorMouseModule tweakSlicer = new DataPointSelectorMouseModule(this.topPlot, this.levelRenderer, new VerticalSliceSelectionRenderer(this.topPlot), "tweak cutoff");
            tweakSlicer.setDragEvents(true);
            tweakSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                @Override
                public void dataPointSelected(DataPointSelectionEvent e) {
                    throw new IllegalArgumentException("Not implemented, since DataSetUpdateEvents take QDataSets.");
                }
            });
            this.topPlot.addMouseModule(tweakSlicer);
            this.topPlot.getDasMouseInputAdapter().setPrimaryModule(tweakSlicer);
            DataPointSelectorMouseModule levelSlicer = new DataPointSelectorMouseModule(this.topPlot, this.levelRenderer, new HorizontalSliceSelectionRenderer(this.topPlot), "cutoff level");
            levelSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                @Override
                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum y = e.getY();
                    CutoffMouseModule.this.setLevelMin(y);
                }
            });
            levelSlicer.setDragEvents(false);
            levelSlicer.setKeyEvents(false);
            levelSlicer.setReleaseEvents(true);
            this.topPlot.addMouseModule(levelSlicer);
            canvas.add(plot, row1, col);
            this.slopePlot = plot = new DasPlot(xaxis.createAttachedAxis(), new DasAxis(new DatumRange(-0.3, 0.3, Units.dimensionless), 3)){

                @Override
                protected void drawContent(Graphics2D g) {
                    super.drawContent(g);
                    int iy = (int)this.getYAxis().transform(CutoffMouseModule.this.slopeMin);
                    int ix = this.getColumn().getDMinimum();
                    g.setColor(Color.lightGray);
                    if (CutoffMouseModule.this.lowCutoff) {
                        g.drawString("slope greater than", ix + 3, iy);
                    } else {
                        g.drawString("slope less than", ix + 3, iy);
                    }
                    g.setColor(Color.GRAY);
                    g.drawLine(ix, iy, ix + this.getWidth(), iy);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.cutoff);
                    g.drawLine(ix, 0, ix, this.getHeight());
                    g.setColor(Color.pink);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.yValue);
                    g.drawLine(ix, 0, ix, this.getHeight());
                }
            };
            plot.getYAxis().setLabel("slope");
            this.slopeRenderer = new SymbolLineRenderer();
            this.contextSlopeRenderer = new SymbolLineRenderer();
            this.contextSlopeRenderer.setColor(Color.GRAY);
            plot.addRenderer(this.slopeRenderer);
            DataPointSelectorMouseModule slopeSlicer = new DataPointSelectorMouseModule(plot, this.levelRenderer, new HorizontalSliceSelectionRenderer(plot), "slope level");
            slopeSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                @Override
                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum y = e.getY();
                    CutoffMouseModule.this.setSlopeMin(y);
                }
            });
            slopeSlicer.setDragEvents(false);
            slopeSlicer.setKeyEvents(false);
            slopeSlicer.setReleaseEvents(true);
            plot.addMouseModule(slopeSlicer);
            canvas.add(plot, row2, col);
            plot = new DasPlot(xaxis.createAttachedAxis(), new DasAxis(new DatumRange(-0.3, 1.3, Units.dimensionless), 3));
            plot.getYAxis().setLabel("icof");
            this.icofRenderer = new SymbolLineRenderer();
            plot.addRenderer(this.icofRenderer);
            canvas.add(plot, row3, col);
        }

        private void recalculate() {
            this.dataPointSelected(this.lastSelectedPoint);
        }

        @Override
        public void dataPointSelected(DataPointSelectionEvent event) {
            this.lastSelectedPoint = event;
            QDataSet tds = CutoffMouseModule.this.dataSetConsumer.getConsumedDataSet();
            this.xValue = event.getX();
            this.yValue = event.getY();
            if (CutoffMouseModule.this.xrange == null) {
                return;
            }
            AverageTableRebinner rebinner = new AverageTableRebinner();
            DatumRange range = DataSetUtil.asDatumRange(DataSetOps.dependBounds(tds).slice(0), true);
            RebinDescriptor ddx = CutoffMouseModule.this.getRebinDescriptor(range);
            try {
                tds = rebinner.rebin(tds, ddx, null);
            }
            catch (DasException e) {
                throw new RuntimeException(e);
            }
            QDataSet xds = SemanticOps.xtagsDataSet(tds);
            int i = DataSetUtil.closestIndex(xds, event.getX());
            QDataSet contextDs = tds.slice(i);
            this.contextLevelRenderer.setDataSet(Ops.log10(contextDs));
            DatumRange xrange = DataSetUtil.asDatumRange(DataSetOps.dependBounds(tds).slice(0), true);
            tds = new ClippedTableDataSet(tds, xrange, CutoffMouseModule.this.yrange);
            this.xValue = SemanticOps.getDatum(xds, xds.value(i));
            this.topPlot.setTitle("" + this.xValue + " " + this.yValue);
            QDataSet spec = Ops.log10(tds.slice(i));
            QDataSet xspec = SemanticOps.xtagsDataSet(spec);
            int icutoff = CutoffMouseModule.this.cutoff(spec, CutoffMouseModule.this.slopeMin, CutoffMouseModule.this.nave, CutoffMouseModule.this.isLowCutoff() ? 1 : -1, CutoffMouseModule.this.levelMin);
            this.cutoff = icutoff == -1 ? SemanticOps.getUnits(xspec).getFillDatum() : SemanticOps.getDatum(xspec, xspec.value(icutoff));
            this.showPopup();
        }

        private void showPopup() {
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
        }
    }
}

