/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.ParseException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Editable;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.datum.format.EnumerationDatumFormatter;
import org.das2.event.DragRenderer;
import org.das2.event.LabelDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;

public class CrossHairRenderer
extends LabelDragRenderer
implements DragRenderer,
Editable {
    protected int xInitial;
    protected int yInitial;
    protected DasAxis XAxis;
    protected DasAxis YAxis;
    protected DasPlot parent;
    private DatumFormatter nfx;
    private DatumFormatter nfy;
    private DatumFormatter nfz;
    private FontMetrics fm;
    private Rectangle hDirtyBounds;
    private Rectangle vDirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;
    private boolean allPlanesReport;
    private boolean debugging;
    private boolean snapping;
    private boolean multiLine = false;

    public CrossHairRenderer(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent);
        this.XAxis = xAxis;
        this.YAxis = yAxis;
        this.parent = parent;
        this.dataSetConsumer = dataSetConsumer;
        this.hDirtyBounds = new Rectangle();
        this.vDirtyBounds = new Rectangle();
    }

    private DatumFormatter addResolutionToFormat(DatumFormatter nfz) throws ParseException {
        String[] ss;
        String formatString = nfz.toString();
        String result = formatString.indexOf(69) == -1 ? formatString + "00" : ((ss = formatString.split("E"))[0].indexOf(46) == -1 ? ss[0] + ".00E0" : ss[0] + "00E0");
        try {
            return DefaultDatumFormatterFactory.getInstance().newFormatter(result);
        }
        catch (IllegalArgumentException ex) {
            return nfz;
        }
    }

    private String getZComponentsString(QDataSet tds, Datum x, Datum y) {
        assert (tds.rank() == 3);
        try {
            int j;
            QDataSet xds = SemanticOps.xtagsDataSet(tds);
            int i = DataSetUtil.closestIndex(xds, x);
            WritableDataSet tds1 = Ops.copy(tds.slice(i));
            QDataSet yds = (QDataSet)tds1.property("DEPEND_0");
            if (yds == null) {
                yds = Ops.indgen(tds1.length());
            }
            try {
                yds = Ops.copy(yds);
                j = DataSetUtil.closestIndex(yds, y);
            }
            catch (IllegalArgumentException ex) {
                return ex.getMessage();
            }
            QDataSet rgb = tds1.slice(j);
            return DataSetUtil.toString(rgb);
        }
        catch (InconvertibleUnitsException ex) {
            return "N/A";
        }
    }

    private String getZString(QDataSet tds, Datum x, Datum y, int[] ij) {
        int j;
        int i;
        QDataSet xds = SemanticOps.xtagsDataSet(tds);
        try {
            i = DataSetUtil.closestIndex(xds, x);
        }
        catch (InconvertibleUnitsException ex) {
            Units u = SemanticOps.getUnits(xds);
            i = DataSetUtil.closestIndex(xds, x.value(), u);
        }
        QDataSet tds1 = tds.slice(i);
        QDataSet yds = SemanticOps.xtagsDataSet(tds1);
        try {
            j = DataSetUtil.closestIndex(yds, y);
        }
        catch (InconvertibleUnitsException ex) {
            Units u = SemanticOps.getUnits(yds);
            if (UnitsUtil.isIntervalOrRatioMeasurement(u)) {
                j = DataSetUtil.closestIndex(yds, y.value(), u);
            }
            return "";
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        double d = tds1.value(j);
        Datum zValue = SemanticOps.getDatum(tds1, d);
        if (ij != null) {
            ij[0] = i;
            ij[1] = j;
        }
        try {
            if (this.dataSetConsumer instanceof TableDataSetConsumer) {
                if (!UnitsUtil.isIntervalOrRatioMeasurement(zValue.getUnits())) {
                    this.nfz = new EnumerationDatumFormatter();
                } else {
                    this.nfz = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis().getDatumFormatter();
                    this.nfz = this.addResolutionToFormat(this.nfz);
                }
            } else {
                this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter("0.000");
            }
        }
        catch (ParseException pe) {
            DasProperties.getLogger().severe("failure to create formatter");
            DasAxis axis = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis();
            axis.getUnits().getDatumFormatterFactory().defaultFormatter();
        }
        StringBuilder result = zValue.isFill() ? new StringBuilder("fill") : new StringBuilder(this.nfz.grannyFormat(zValue));
        if (this.allPlanesReport) {
            QDataSet plane;
            if (this.debugging) {
                result.append("!c").append(tds.toString());
            }
            for (int iplane = 0; iplane < 50 && (plane = (QDataSet)tds.property("PLANE_" + iplane)) != null; ++iplane) {
                result.append("!c");
                result.append(plane.property("NAME")).append(":").append(this.nfz.grannyFormat(SemanticOps.getDatum(plane, plane.value(i, j))));
                if (!this.debugging) continue;
                result.append(" ").append(plane.toString());
            }
            if (this.debugging) {
                result.append("!ci:").append(i).append(" j:").append(j);
            }
        }
        return result.toString();
    }

    private int closestPointVector(QDataSet ds, Datum x, Datum y) {
        int end;
        int start;
        QDataSet xds = SemanticOps.xtagsDataSet(ds);
        Units xunits = SemanticOps.getUnits(xds);
        boolean xmono = SemanticOps.isMonotonic(xds);
        DasAxis xa = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
        DasAxis ya = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
        Point2D.Double me = new Point2D.Double(xa.transform(x), ya.transform(y));
        if (xmono) {
            start = DataSetUtil.getPreviousIndex(xds, xa.getDataMinimum());
            end = DataSetUtil.getNextIndex(xds, xa.getDataMaximum());
        } else {
            start = 0;
            end = xds.length();
        }
        int bestIndex = -1;
        double bestXDist = Double.POSITIVE_INFINITY;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int i = start; i < end; i += 100) {
            double x1 = xa.transform(xds.value(i), xunits);
            double dist = Math.abs(x1 - me.getX());
            if (!(dist < bestXDist)) continue;
            bestXDist = dist;
        }
        Units units = SemanticOps.getUnits(ds);
        for (int i = start; i < end; ++i) {
            Point2D.Double them;
            double dist;
            double x1 = xa.transform(xds.value(i), xunits);
            if (!(Math.abs(x1 - me.getX()) <= bestXDist) || !((dist = me.distance(them = new Point2D.Double(x1, ya.transform(ds.value(i), units)))) < bestDist)) continue;
            bestIndex = i;
            bestDist = dist;
            bestXDist = Math.abs(x1 - me.getX());
        }
        return bestIndex;
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        DasAxis ya;
        Renderer r;
        Renderer[] rends;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHints(DasProperties.getRenderingHints());
        QDataSet ds = this.dataSetConsumer != null ? this.dataSetConsumer.getConsumedDataSet() : ((rends = this.parent.getRenderers()).length > 0 ? rends[0].getConsumedDataSet() : null);
        if (this.dataSetConsumer instanceof Renderer && (!(r = (Renderer)this.dataSetConsumer).isActive() || r.getParent() == null)) {
            ds = null;
        }
        Datum x = null;
        Datum y = null;
        DasAxis xa = this.XAxis == null ? this.parent.getXAxis() : this.XAxis;
        DasAxis dasAxis = ya = this.YAxis == null ? this.parent.getYAxis() : this.YAxis;
        if (this.crossHairLocation == null) {
            x = xa.invTransform(p2.x);
            y = ya.invTransform(p2.y);
            this.nfy = y.getFormatter();
            this.nfx = x.getFormatter();
            String xAsString = this.nfx.format(x);
            String yAsString = this.nfy.format(y);
            String nl = this.multiLine ? "!c" : " ";
            String report = "x:" + xAsString + nl + "y:" + yAsString;
            if (ds != null) {
                QDataSet xds = SemanticOps.xtagsDataSet(ds);
                if (SemanticOps.isTableDataSet(ds)) {
                    String zAsString;
                    QDataSet tds;
                    if (SemanticOps.isSimpleTableDataSet(ds)) {
                        tds = ds;
                    } else if (Schemes.isCompositeImage(ds)) {
                        tds = ds;
                    } else {
                        tds = SemanticOps.getSimpleTableContaining(ds, x, y);
                        if (tds == null) {
                            tds = ds.slice(0);
                        }
                    }
                    QDataSet yds = SemanticOps.ytagsDataSet(tds);
                    if (this.snapping) {
                        int[] ij = new int[2];
                        zAsString = this.getZString(tds, x, y, ij);
                        x = SemanticOps.getDatum(xds, xds.value(ij[0]));
                        xAsString = this.nfx.format(x);
                        y = SemanticOps.getDatum(yds, yds.value(ij[1]));
                        yAsString = this.nfy.format(y);
                    } else {
                        zAsString = Schemes.isCompositeImage(ds) ? "!c" + this.getZComponentsString(tds, x, y) : this.getZString(tds, x, y, null);
                    }
                    report = "x:" + xAsString + nl + "y:" + yAsString + nl + "z:" + zAsString;
                } else {
                    if (this.snapping) {
                        QDataSet vds = ds;
                        if (vds.length() == 0) {
                            yAsString = "(empty dataset)";
                        } else {
                            int i = this.closestPointVector(vds, x, y);
                            x = SemanticOps.getDatum(xds, xds.value(i));
                            y = SemanticOps.getDatum(vds, vds.value(i));
                            xAsString = this.nfx.format(x);
                            yAsString = this.nfy.format(y);
                            if (this.allPlanesReport) {
                                QDataSet plane;
                                StringBuilder result = new StringBuilder(yAsString);
                                for (int iplane = 0; iplane < 50 && (plane = (QDataSet)vds.property("PLANE_" + iplane)) != null; ++iplane) {
                                    result.append("!c");
                                    result.append(plane.property("NAME")).append(":").append(this.nfz.grannyFormat(SemanticOps.getDatum(plane, plane.value(i))));
                                    if (!this.debugging) continue;
                                    result.append(" ").append(plane.toString());
                                }
                                yAsString = result.toString();
                            }
                        }
                    }
                    report = "x:" + xAsString + nl + "y:" + yAsString;
                }
            }
            this.setLabel(report);
            super.renderDrag(g, p1, p2);
        }
        if (this.snapping && x != null && y != null) {
            Point p3 = new Point((int)xa.transform(x), (int)ya.transform(y));
            this.drawCrossHair(g, p3);
        } else {
            this.drawCrossHair(g, p2);
        }
        return new Rectangle[]{this.hDirtyBounds, this.vDirtyBounds, this.dirtyBounds};
    }

    private void drawCrossHair(Graphics g0, Point p) {
        Graphics2D g = (Graphics2D)g0.create();
        g.setClip(null);
        Color color0 = Color.black;
        g.setColor(color0);
        Dimension d = this.parent.getCanvas().getSize();
        this.hDirtyBounds.setBounds(0, p.y - 1, d.width, 3);
        Stroke stroke0 = g.getStroke();
        g.setColor(ghostColor);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine(0, p.y, d.width, p.y);
        g.drawLine(p.x, 0, p.x, d.height);
        g.setColor(color0);
        g.setStroke(stroke0);
        g.drawLine(0, p.y, d.width, p.y);
        this.vDirtyBounds.setBounds(p.x - 1, 0, 3, d.height);
        g.drawLine(p.x, 0, p.x, d.height);
        g.dispose();
    }

    @Override
    public void clear(Graphics g) {
        super.clear(g);
        this.parent.paintImmediately(this.hDirtyBounds);
        this.parent.paintImmediately(this.vDirtyBounds);
    }

    @Override
    public boolean isPointSelection() {
        return true;
    }

    @Override
    public boolean isUpdatingDragSelection() {
        return false;
    }

    public boolean isAllPlanesReport() {
        return this.allPlanesReport;
    }

    public void setAllPlanesReport(boolean allPlanesReport) {
        this.allPlanesReport = allPlanesReport;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Override
    public Rectangle[] getDirtyBounds() {
        return new Rectangle[]{this.dirtyBounds, this.hDirtyBounds, this.vDirtyBounds};
    }

    public boolean isSnapping() {
        return this.snapping;
    }

    public void setSnapping(boolean b) {
        this.snapping = b;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }
}

