/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.BoxRenderer;
import org.das2.event.GesturesRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvasComponent;

public class BoxGesturesRenderer
extends BoxRenderer {
    GesturesRenderer gr;

    public BoxGesturesRenderer(DasCanvasComponent parent) {
        super(parent);
        this.gr = new GesturesRenderer(parent);
    }

    @Override
    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    @Override
    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        if (this.gr.isGesture(p1, p2)) {
            Rectangle[] rr = this.gr.renderDrag(g, p1, p2);
            this.dirtyBounds = rr[0];
        } else {
            Rectangle r = new Rectangle(p1);
            r.add(p2);
            Color color0 = g.getColor();
            g.setColor(new Color(255, 255, 255, 100));
            g.setStroke(new BasicStroke(3.0f, 1, 1));
            g.drawRect(r.x, r.y, r.width, r.height);
            g.setStroke(new BasicStroke());
            g.setColor(color0);
            g.drawRect(r.x, r.y, r.width, r.height);
            this.dirtyBounds.setLocation(r.x - 2, r.y - 3);
            this.dirtyBounds.add(r.x + r.width + 2, r.y + r.height + 3);
        }
        return new Rectangle[]{this.dirtyBounds};
    }

    @Override
    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        if (this.gr.isGesture(p1, p2)) {
            return this.gr.getMouseDragEvent(source, p1, p2, isModified);
        }
        return super.getMouseDragEvent(source, p1, p2, isModified);
    }
}

