/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import org.das2.event.BoxRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;

public class AnnotatorMouseModule
extends MouseModule {
    DasCanvas canvas;

    public AnnotatorMouseModule(DasCanvasComponent parent) {
        super(parent, new BoxRenderer(parent), "Annotate");
        this.canvas = (DasCanvas)parent.getParent();
    }

    public DasCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e) {
        super.mouseRangeSelected(e);
        System.out.println(e);
        if (!(e instanceof MouseBoxEvent)) {
            logger.warning("Expected MouseBoxEvent");
            return;
        }
        MouseBoxEvent me = (MouseBoxEvent)e;
        double n = this.canvas.getHeight();
        DasRow row = new DasRow(this.canvas, (double)me.getYMinimum() / n, (double)me.getYMaximum() / n);
        n = this.canvas.getWidth();
        DasColumn col = new DasColumn(this.canvas, (double)me.getXMinimum() / n, (double)me.getXMaximum() / n);
        DasAnnotation anno = new DasAnnotation("right click");
        this.canvas.add(anno, row, col);
        this.canvas.revalidate();
    }
}

