/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Units;

public abstract class UnitsConverter {
    public static final UnitsConverter IDENTITY = new UnitsConverter(){

        @Override
        public UnitsConverter getInverse() {
            return this;
        }

        @Override
        public double convert(double value) {
            return value;
        }

        @Override
        public UnitsConverter append(UnitsConverter that) {
            return that;
        }

        public String toString() {
            return "IDENTITY UnitsConverter";
        }
    };
    public static final UnitsConverter LOOSE_IDENTITY = new UnitsConverter(){

        @Override
        public UnitsConverter getInverse() {
            return this;
        }

        @Override
        public double convert(double value) {
            return value;
        }

        @Override
        public UnitsConverter append(UnitsConverter that) {
            return that;
        }

        public String toString() {
            return "LOOSE_IDENTITY UnitsConverter";
        }
    };
    public static final UnitsConverter TERA = new ScaleOffset(1.0E-12, 0.0);
    public static final UnitsConverter GIGA = new ScaleOffset(1.0E-9, 0.0);
    public static final UnitsConverter MEGA = new ScaleOffset(1.0E-6, 0.0);
    public static final UnitsConverter KILO = new ScaleOffset(0.001, 0.0);
    public static final UnitsConverter MILLI = new ScaleOffset(1000.0, 0.0);
    public static final UnitsConverter CENTI = new ScaleOffset(100.0, 0.0);
    public static final UnitsConverter MICRO = new ScaleOffset(1000000.0, 0.0);
    public static final UnitsConverter NANO = new ScaleOffset(1.0E9, 0.0);
    public static final UnitsConverter PICO = new ScaleOffset(1.0E12, 0.0);
    protected UnitsConverter inverse;

    protected UnitsConverter() {
    }

    protected UnitsConverter(UnitsConverter inverse) {
        this.inverse = inverse;
    }

    public abstract UnitsConverter getInverse();

    public abstract double convert(double var1);

    public Number convert(Number number) {
        double value = number.doubleValue();
        value = this.convert(value);
        if (number instanceof Integer) {
            return (int)value;
        }
        if (number instanceof Long) {
            return (long)value;
        }
        return value;
    }

    public UnitsConverter append(UnitsConverter that) {
        return new Appended(this, that);
    }

    public static UnitsConverter getConverter(Units fromUnits, Units toUnits) {
        if (fromUnits == toUnits) {
            return IDENTITY;
        }
        return Units.getConverter(fromUnits, toUnits);
    }

    public static class Appended
    extends UnitsConverter {
        UnitsConverter[] converters;

        public Appended(UnitsConverter uc1, UnitsConverter uc2) {
            UnitsConverter[] a1 = Appended.ucToArray(uc1);
            UnitsConverter[] a2 = Appended.ucToArray(uc2);
            this.converters = new UnitsConverter[a1.length + a2.length];
            System.arraycopy(a1, 0, this.converters, 0, a1.length);
            System.arraycopy(a2, 0, this.converters, a1.length, a2.length);
        }

        private Appended(UnitsConverter[] array, UnitsConverter inverse) {
            super(inverse);
            this.converters = array;
        }

        @Override
        public double convert(double value) {
            for (UnitsConverter converter : this.converters) {
                value = converter.convert(value);
            }
            return value;
        }

        @Override
        public Number convert(Number value) {
            for (UnitsConverter converter : this.converters) {
                value = converter.convert(value);
            }
            return value;
        }

        @Override
        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                int length = this.converters.length;
                UnitsConverter[] inverseArray = new UnitsConverter[length];
                for (int i = 0; i < length; ++i) {
                    inverseArray[i] = this.converters[length - i - 1].getInverse();
                }
                this.inverse = new Appended(inverseArray, (UnitsConverter)this);
            }
            return this.inverse;
        }

        private static UnitsConverter[] ucToArray(UnitsConverter uc) {
            if (uc instanceof Appended) {
                return ((Appended)uc).converters;
            }
            return new UnitsConverter[]{uc};
        }

        public String toString() {
            StringBuilder result = new StringBuilder("UnitsConverted$Appended[");
            for (UnitsConverter uc1 : this.converters) {
                result.append(" ").append(uc1).append(" ");
            }
            result.append("]");
            return result.toString();
        }
    }

    public static class ScaleOffset
    extends UnitsConverter {
        private final double offset;
        private final double scale;
        private final int hashCode;

        public ScaleOffset(double scale, double offset) {
            this(scale, offset, null);
        }

        private ScaleOffset(double scale, double offset, UnitsConverter inverse) {
            super(inverse);
            this.scale = scale;
            this.offset = offset;
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            long scaleBits = Double.doubleToLongBits(this.scale);
            long offsetBits = Double.doubleToLongBits(this.offset);
            long code = 1859L + 13L * scaleBits + offsetBits;
            int a = (int)(code >> 32);
            int b = (int)(0xFFFFFFFFL & code);
            return a + b;
        }

        @Override
        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new ScaleOffset(1.0 / this.scale, -(this.offset / this.scale), this);
            }
            return this.inverse;
        }

        @Override
        public double convert(double value) {
            return this.scale * value + this.offset;
        }

        @Override
        public UnitsConverter append(UnitsConverter that) {
            if (that == IDENTITY) {
                return this;
            }
            if (that instanceof ScaleOffset) {
                ScaleOffset so = (ScaleOffset)that;
                double aScale = this.scale * so.scale;
                double aOffset = this.offset * so.scale + so.offset;
                return new ScaleOffset(aScale, aOffset);
            }
            return super.append(that);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScaleOffset)) {
                return false;
            }
            ScaleOffset that = (ScaleOffset)o;
            return this.scale == that.scale && this.offset == that.offset;
        }

        public String toString() {
            return this.getClass().getName() + "[scale=" + this.scale + ",offset=" + this.offset + "]";
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

