/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.Normalizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Basis;
import org.das2.datum.CurrencyUnits;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LeapSecondsConverter;
import org.das2.datum.LocationUnits;
import org.das2.datum.NumberUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.UnitsConverter;
import org.das2.datum.format.DatumFormatterFactory;

public abstract class Units {
    private static final Logger logger = Logger.getLogger("datum.units");
    private static Map unitsMap = new HashMap();
    public static final Units dimensionless = new NumberUnits("", "dimensionless quantities");
    public static final Units radians = new NumberUnits("radian");
    public static final Units degrees = new NumberUnits("degrees");
    public static final Units deg = new NumberUnits("deg");
    public static final Units rgbColor;
    public static final Units celciusDegrees;
    public static final Units fahrenheitDegrees;
    public static final Units hours;
    public static final Units minutes;
    public static final Units seconds;
    public static final Units seconds2;
    public static final Units milliseconds;
    public static final Units milliseconds2;
    public static final Units microseconds;
    public static final Units microseconds2;
    public static final Units microseconds3;
    public static final Units nanoseconds;
    public static final Units ns;
    public static final Units picoseconds;
    public static final Units days;
    public static final Units bytesPerSecond;
    public static final Units kiloBytesPerSecond;
    public static final Units bytes;
    public static final Units kiloBytes;
    public static final Units hertz;
    public static final Units kiloHertz;
    public static final Units megaHertz;
    public static final Units gigaHertz;
    public static final Units eV;
    public static final Units ev;
    public static final Units keV;
    public static final Units MeV;
    public static final Units pcm3;
    public static final Units kelvin;
    public static final Units cm_2s_1keV_1;
    public static final Units cm_2s_1MeV_1;
    public static final Units v2pm2Hz;
    public static final Units wpm2;
    public static final Units meters;
    public static final Units millimeters;
    public static final Units centimeters;
    public static final Units kiloMeters;
    public static final Units inches;
    public static final Units typographicPoints;
    public static final Units nT;
    public static final Units cmps;
    public static final Units mps;
    public static final Units centigrade;
    public static final Units fahrenheitScale;
    public static final Units dollars;
    public static final Units euros;
    public static final Units yen;
    public static final Units rupee;
    public static final TimeLocationUnits us2000;
    public static final TimeLocationUnits us1980;
    public static final TimeLocationUnits t2010;
    public static final TimeLocationUnits t2000;
    public static final TimeLocationUnits t1970;
    public static final TimeLocationUnits ms1970;
    public static final TimeLocationUnits mj1958;
    public static final TimeLocationUnits mjd;
    public static final TimeLocationUnits julianDay;
    public static final TimeLocationUnits cdfEpoch;
    public static final TimeLocationUnits cdfTT2000;
    public static final Units percent;
    public static final Units dB;
    public static final Units ampRatio;
    public static final Units percentIncrease;
    public static final Units log10Ratio;
    public static final Units logERatio;
    private String id;
    private String description;
    private final Map<Units, UnitsConverter> conversionMap = new ConcurrentHashMap<Units, UnitsConverter>();
    private static final double FILL_DOUBLE = -1.0E31;

    protected Units(String id) {
        this(id, "");
    }

    protected Units(String id, String description) {
        this.id = id;
        this.description = description;
        unitsMap.put(id, this);
    }

    public String getId() {
        return this.id;
    }

    public void registerConverter(Units toUnits, UnitsConverter converter) {
        this.conversionMap.put(toUnits, converter);
        UnitsConverter inverse = toUnits.conversionMap.get(this);
        if (inverse == null || inverse.getInverse() != converter) {
            toUnits.registerConverter(this, converter.getInverse());
        }
    }

    public Units[] getConvertableUnits() {
        return this.getConvertibleUnits();
    }

    public Units[] getConvertibleUnits() {
        HashSet<Units> result = new HashSet<Units>();
        LinkedList<Units> queue = new LinkedList<Units>();
        queue.add(this);
        while (!queue.isEmpty()) {
            Units current = (Units)queue.removeFirst();
            for (Map.Entry<Units, UnitsConverter> entry : current.conversionMap.entrySet()) {
                Units next = entry.getKey();
                if (result.contains(next)) continue;
                queue.add(next);
                result.add(next);
            }
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Units u1 = (Units)o1;
                Units u2 = (Units)o2;
                return u1.convertDoubleTo(u2, 1.0) < 1.0 ? -1 : 1;
            }
        };
        Units[] resultArray = result.toArray(new Units[result.size()]);
        Arrays.sort(resultArray, c);
        return resultArray;
    }

    public boolean isConvertableTo(Units toUnits) {
        UnitsConverter result = Units.getConverterInternal(this, toUnits);
        return result != null;
    }

    public boolean isConvertibleTo(Units toUnits) {
        UnitsConverter result = Units.getConverterInternal(this, toUnits);
        return result != null;
    }

    public static UnitsConverter getConverter(Units fromUnits, Units toUnits) {
        logger.log(Level.FINER, "getConverter( {0} to {1} )", new Object[]{fromUnits, toUnits});
        UnitsConverter result = Units.getConverterInternal(fromUnits, toUnits);
        if (result == null) {
            throw new InconvertibleUnitsException(fromUnits, toUnits);
        }
        return result;
    }

    private static UnitsConverter getConverterInternal(Units fromUnits, Units toUnits) {
        logger.log(Level.FINE, "fromUnits={0} {1} toUnits={2} {3}", new Object[]{fromUnits, fromUnits.hashCode(), toUnits, toUnits.hashCode()});
        if (fromUnits == toUnits) {
            return UnitsConverter.IDENTITY;
        }
        UnitsConverter o = fromUnits.conversionMap.get(toUnits);
        if (o != null) {
            return o;
        }
        HashMap<Units, Units> visited = new HashMap<Units, Units>();
        visited.put(fromUnits, null);
        LinkedList<Units> queue = new LinkedList<Units>();
        queue.add(fromUnits);
        while (!queue.isEmpty()) {
            Units current = (Units)queue.removeFirst();
            for (Map.Entry<Units, UnitsConverter> entry : current.conversionMap.entrySet()) {
                Units next = entry.getKey();
                if (visited.containsKey(next)) continue;
                visited.put(next, current);
                queue.add(next);
                if (next != toUnits) continue;
                logger.log(Level.FINE, "build conversion from {0} to {1}", new Object[]{fromUnits, toUnits});
                return Units.buildConversion(fromUnits, toUnits, visited);
            }
        }
        return null;
    }

    private static UnitsConverter buildConversion(Units fromUnits, Units toUnits, Map parentMap) {
        ArrayList<Units> list = new ArrayList<Units>();
        Units current = toUnits;
        while (current != null) {
            list.add(current);
            current = (Units)parentMap.get(current);
        }
        UnitsConverter converter = UnitsConverter.IDENTITY;
        for (int i = list.size() - 1; i > 0; --i) {
            Units a = (Units)list.get(i);
            Units b = (Units)list.get(i - 1);
            UnitsConverter c = a.conversionMap.get(b);
            converter = converter.append(c);
        }
        fromUnits.registerConverter(toUnits, converter);
        return converter;
    }

    public UnitsConverter getConverter(Units toUnits) {
        return Units.getConverter(this, toUnits);
    }

    public double convertDoubleTo(Units toUnits, double value) {
        if (this == toUnits) {
            return value;
        }
        return Units.getConverter(this, toUnits).convert(value);
    }

    public String toString() {
        return this.id;
    }

    public Units getOffsetUnits() {
        return this;
    }

    public Basis getBasis() {
        return Basis.physicalZero;
    }

    public abstract Datum createDatum(double var1);

    public abstract Datum createDatum(int var1);

    public abstract Datum createDatum(long var1);

    public abstract Datum createDatum(Number var1);

    public abstract Datum createDatum(double var1, double var3);

    public double getFillDouble() {
        return -1.0E31;
    }

    public Datum getFillDatum() {
        return this.createDatum(-1.0E31);
    }

    public boolean isFill(double value) {
        return value < -1.0E30 || Double.isNaN(value);
    }

    public boolean isFill(Number value) {
        return this.isFill(value.doubleValue());
    }

    public boolean isValid(double value) {
        return !Double.isNaN(value) && value > -1.0E30;
    }

    public abstract DatumFormatterFactory getDatumFormatterFactory();

    public abstract Datum parse(String var1) throws ParseException;

    public String format(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().format(datum);
    }

    public String grannyFormat(Datum datum) {
        return this.getDatumFormatterFactory().defaultFormatter().grannyFormat(datum);
    }

    public abstract Datum add(Number var1, Number var2, Units var3);

    public abstract Datum subtract(Number var1, Number var2, Units var3);

    public abstract Datum multiply(Number var1, Number var2, Units var3);

    public abstract Datum divide(Number var1, Number var2, Units var3);

    public static List<Units> getAllUnits() {
        return new ArrayList<Units>(unitsMap.values());
    }

    public static Units getByName(String s) {
        Units units = (Units)unitsMap.get(s);
        if (units == null) {
            throw new IllegalArgumentException("Unrecognized units: " + s);
        }
        return units;
    }

    public static Units lookupTimeLengthUnit(String s) throws ParseException {
        if ((s = s.toLowerCase().trim()).startsWith("sec") || s.equals("s")) {
            return seconds;
        }
        if (s.startsWith("ms") || s.startsWith("millisec") || s.startsWith("milliseconds")) {
            return milliseconds;
        }
        if (s.equals("hr") || s.startsWith("hour")) {
            return hours;
        }
        if (s.equals("mn") || s.startsWith("min")) {
            return minutes;
        }
        if (s.startsWith("us") || s.startsWith("\u00b5s") || s.startsWith("micros")) {
            return microseconds;
        }
        if (s.startsWith("ns") || s.startsWith("nanos")) {
            return nanoseconds;
        }
        if (s.startsWith("d")) {
            return days;
        }
        throw new ParseException("failed to identify unit: " + s, 0);
    }

    public static synchronized Units lookupTimeUnits(Datum base, Units offsetUnits) {
        String canonicalName = "" + offsetUnits + " since " + base;
        try {
            Units result = Units.getByName(canonicalName);
            return result;
        }
        catch (IllegalArgumentException ex) {
            Basis basis = new Basis("since " + base, "since " + base, Basis.since2000, base.doubleValue(us2000), us2000.getOffsetUnits());
            TimeLocationUnits result = new TimeLocationUnits(canonicalName, canonicalName, offsetUnits, basis);
            result.registerConverter(us2000, new UnitsConverter.ScaleOffset(offsetUnits.convertDoubleTo(microseconds, 1.0), base.doubleValue(us2000)));
            return result;
        }
    }

    public static synchronized Units lookupTimeUnits(String units) throws ParseException {
        try {
            Units result = Units.getByName(units);
            return result;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (units.trim().equalsIgnoreCase("UTC")) {
                return us2000;
            }
            String[] ss = units.split("since");
            Units offsetUnits = Units.lookupTimeLengthUnit(ss[0]);
            if (ss[1].equals(" 1-1-1 00:00:00")) {
                ss[1] = "1901-01-01 00:00:00";
            }
            if (ss[1].contains("1970-01-01 00:00:00.0 0:00")) {
                ss[1] = "1970-01-01 00:00:00";
            }
            if (ss[1].endsWith(" UTC")) {
                ss[1] = ss[1].substring(0, ss[1].length() - 4);
            }
            Datum datum = TimeUtil.create(ss[1]);
            return Units.lookupTimeUnits(datum, offsetUnits);
        }
    }

    public static synchronized Units lookupUnits(String sunits) {
        Units stdUnit;
        Units result;
        block17: {
            sunits = sunits.trim();
            try {
                result = Units.getByName(sunits);
            }
            catch (IllegalArgumentException ex) {
                sunits = Normalizer.normalize(sunits, Normalizer.Form.NFC);
                try {
                    Units result2 = Units.getByName(sunits);
                    return result2;
                }
                catch (IllegalArgumentException ex2) {
                    logger.fine("normalized version did not fix");
                    if (sunits.contains(" since ") || sunits.equalsIgnoreCase("UTC")) {
                        try {
                            result = Units.lookupTimeUnits(sunits);
                        }
                        catch (ParseException ex1) {
                            result = new NumberUnits(sunits);
                        }
                        break block17;
                    }
                    if (sunits.equals("sec")) {
                        result = seconds;
                        break block17;
                    }
                    if (sunits.equals("msec")) {
                        result = milliseconds;
                        break block17;
                    }
                    if (sunits.contains("(All Qs)")) {
                        result = new NumberUnits(sunits);
                        Units targetUnits = Units.lookupUnits(sunits.replace("(All Qs)", "").trim());
                        result.registerConverter(targetUnits, UnitsConverter.IDENTITY);
                        break block17;
                    }
                    Pattern multPattern = Pattern.compile("([.0-9]+)\\s*([a-zA-Z]+)");
                    Matcher m = multPattern.matcher(sunits);
                    if (m.matches()) {
                        try {
                            Units convTo = Units.lookupUnits(m.group(2));
                            if (convTo != null) {
                                double fact = Double.parseDouble(m.group(1));
                                result = new NumberUnits(sunits);
                                result.registerConverter(convTo, new UnitsConverter.ScaleOffset(fact, 0.0));
                                break block17;
                            }
                            result = Units.lookupUnits(sunits);
                        }
                        catch (NumberFormatException ex22) {
                            result = Units.lookupUnits(sunits);
                        }
                        break block17;
                    }
                    result = new NumberUnits(sunits);
                }
            }
        }
        String stdunits = sunits;
        if (stdunits.startsWith("[") && stdunits.endsWith("]")) {
            stdunits = stdunits.substring(1, stdunits.length() - 1);
        }
        if (stdunits.startsWith("(") && stdunits.endsWith(")")) {
            stdunits = stdunits.substring(1, stdunits.length() - 1);
        }
        if (!stdunits.equals(sunits) && !(stdUnit = Units.lookupUnits(stdunits)).isConvertibleTo(result)) {
            logger.log(Level.FINE, "registering identity converter {0} -> {1}", new Object[]{stdUnit, result});
            stdUnit.registerConverter(result, UnitsConverter.IDENTITY);
            stdUnit.getConverter(result);
        }
        return result;
    }

    public static void main(String[] args) throws ParseException {
        Datum ratio = ampRatio.createDatum(100);
        Datum db = ratio.convertTo(dB);
        System.out.println("ratio: " + ratio);
        System.out.println("dB: " + db);
        Datum Hz = Datum.create(1000000.0, hertz);
        Datum kHz = Hz.convertTo(kiloHertz);
        Datum MHz = kHz.convertTo(megaHertz);
        System.out.println("Hz: " + Hz);
        System.out.println("kHz: " + kHz);
        System.out.println("MHz: " + MHz);
        System.err.println(ms1970.createDatum(1000));
    }

    static {
        degrees.registerConverter(radians, new UnitsConverter.ScaleOffset(Math.PI / 180, 0.0));
        degrees.registerConverter(deg, UnitsConverter.IDENTITY);
        rgbColor = new NumberUnits("rgbColor", "256*256*red+256*green+blue");
        celciusDegrees = new NumberUnits("celcius degrees");
        fahrenheitDegrees = new NumberUnits("fahrenheit degrees");
        hours = new NumberUnits("hr");
        minutes = new NumberUnits("min");
        seconds = new NumberUnits("s");
        seconds2 = new NumberUnits("sec");
        milliseconds = new NumberUnits("ms", "milliseconds");
        milliseconds2 = new NumberUnits("msec");
        microseconds = new NumberUnits("microseconds");
        microseconds2 = new NumberUnits("\u00b5s");
        microseconds3 = new NumberUnits("\u03bcs");
        nanoseconds = new NumberUnits("nanoseconds");
        ns = new NumberUnits("ns", "nanoseconds");
        picoseconds = new NumberUnits("picoseconds");
        days = new NumberUnits("days");
        seconds.registerConverter(milliseconds, UnitsConverter.MILLI);
        seconds.registerConverter(microseconds, UnitsConverter.MICRO);
        seconds.registerConverter(nanoseconds, UnitsConverter.NANO);
        seconds.registerConverter(ns, UnitsConverter.NANO);
        nanoseconds.registerConverter(ns, UnitsConverter.IDENTITY);
        seconds.registerConverter(picoseconds, UnitsConverter.PICO);
        seconds.registerConverter(seconds2, UnitsConverter.IDENTITY);
        microseconds.registerConverter(nanoseconds, UnitsConverter.MILLI);
        microseconds.registerConverter(microseconds2, UnitsConverter.IDENTITY);
        microseconds.registerConverter(microseconds3, UnitsConverter.IDENTITY);
        milliseconds.registerConverter(milliseconds2, UnitsConverter.IDENTITY);
        hours.registerConverter(seconds, new UnitsConverter.ScaleOffset(3600.0, 0.0));
        minutes.registerConverter(seconds, new UnitsConverter.ScaleOffset(60.0, 0.0));
        days.registerConverter(seconds, new UnitsConverter.ScaleOffset(86400.0, 0.0));
        bytesPerSecond = new NumberUnits("bytes/s");
        kiloBytesPerSecond = new NumberUnits("KBytes/s");
        bytes = new NumberUnits("bytes");
        kiloBytes = new NumberUnits("KBytes");
        bytesPerSecond.registerConverter(kiloBytesPerSecond, UnitsConverter.KILO);
        bytes.registerConverter(kiloBytes, UnitsConverter.KILO);
        hertz = new NumberUnits("Hz");
        kiloHertz = new NumberUnits("kHz");
        megaHertz = new NumberUnits("MHz");
        gigaHertz = new NumberUnits("GHz");
        hertz.registerConverter(kiloHertz, UnitsConverter.KILO);
        hertz.registerConverter(megaHertz, UnitsConverter.MEGA);
        hertz.registerConverter(gigaHertz, UnitsConverter.GIGA);
        eV = new NumberUnits("eV");
        ev = new NumberUnits("ev");
        keV = new NumberUnits("keV");
        MeV = new NumberUnits("MeV");
        eV.registerConverter(ev, UnitsConverter.IDENTITY);
        eV.registerConverter(keV, UnitsConverter.KILO);
        eV.registerConverter(MeV, UnitsConverter.MEGA);
        pcm3 = new NumberUnits("cm!a-3!n");
        kelvin = new NumberUnits("K");
        cm_2s_1keV_1 = new NumberUnits("cm!U-2!N s!U-1!N keV!U-1!N");
        cm_2s_1MeV_1 = new NumberUnits("cm!U-2!N s!U-1!N MeV!U-1!N");
        cm_2s_1keV_1.registerConverter(cm_2s_1MeV_1, UnitsConverter.KILO);
        v2pm2Hz = new NumberUnits("V!a2!nm!a-2!nHz!a-1");
        wpm2 = new NumberUnits("W/m!a-2!n");
        meters = new NumberUnits("m");
        millimeters = new NumberUnits("mm");
        centimeters = new NumberUnits("cm");
        kiloMeters = new NumberUnits("km");
        inches = new NumberUnits("inch");
        typographicPoints = new NumberUnits("points");
        meters.registerConverter(kiloMeters, UnitsConverter.KILO);
        meters.registerConverter(centimeters, UnitsConverter.CENTI);
        meters.registerConverter(millimeters, UnitsConverter.MILLI);
        inches.registerConverter(meters, new UnitsConverter.ScaleOffset(0.0254, 0.0));
        inches.registerConverter(typographicPoints, new UnitsConverter.ScaleOffset(72.0, 0.0));
        nT = new NumberUnits("nT", "nanoTesla");
        cmps = new NumberUnits("cm/s");
        mps = new NumberUnits("m s!a-1!n", "meters per second");
        mps.registerConverter(cmps, UnitsConverter.CENTI);
        centigrade = new LocationUnits("centigrade", "centigrade", celciusDegrees, Basis.centigrade);
        fahrenheitScale = new LocationUnits("deg F", "deg F", fahrenheitDegrees, Basis.fahrenheit);
        centigrade.registerConverter(fahrenheitScale, new UnitsConverter.ScaleOffset(1.8, 32.0));
        celciusDegrees.registerConverter(fahrenheitDegrees, new UnitsConverter.ScaleOffset(1.8, 0.0));
        dollars = new CurrencyUnits("dollars", "$", "United States Dollars");
        euros = new CurrencyUnits("euros", "\u20ac", "Euro Dollars");
        yen = new CurrencyUnits("yen", "\uffe5", "Japanese Yen");
        rupee = new CurrencyUnits("rupee", "\u20b9", "Indian Rupee");
        us2000 = new TimeLocationUnits("us2000", "Microseconds since midnight Jan 1, 2000.", microseconds, Basis.since2000);
        us1980 = new TimeLocationUnits("us1980", "Microseconds since midnight Jan 1, 1980.", microseconds, Basis.since1980);
        t2010 = new TimeLocationUnits("t2010", "Seconds since midnight Jan 1, 2010.", seconds, Basis.since2010);
        t2000 = new TimeLocationUnits("t2000", "Seconds since midnight Jan 1, 2000.", seconds, Basis.since2000);
        t1970 = new TimeLocationUnits("t1970", "Seconds since midnight Jan 1, 1970", seconds, Basis.since1970);
        ms1970 = new TimeLocationUnits("ms1970", "Milliseconds since midnight Jan 1, 1970", milliseconds, Basis.since1970);
        mj1958 = new TimeLocationUnits("mj1958", "days since 1958-01-01T00:00Z, or Julian - 2436204.5", days, Basis.since1958);
        mjd = new TimeLocationUnits("mjd", "days since midnight November 17, 1858.", days, Basis.modifiedJulian);
        julianDay = new TimeLocationUnits("julianDay", "days since noon January 1, 4713 BCE", days, Basis.julian);
        cdfEpoch = new TimeLocationUnits("cdfEpoch", "milliseconds since 01-Jan-0000", milliseconds, Basis.since0000);
        cdfTT2000 = new TimeLocationUnits("cdfTT2000", "nanoseconds since 01-Jan-2000, including leap seconds", nanoseconds, Basis.since2000);
        t2000.registerConverter(us2000, UnitsConverter.MICRO);
        us1980.registerConverter(us2000, new UnitsConverter.ScaleOffset(1.0, -6.31152E14));
        us2000.registerConverter(cdfEpoch, new UnitsConverter.ScaleOffset(0.001, 6.3113904E13));
        us2000.registerConverter(cdfTT2000, new LeapSecondsConverter(true));
        t2000.registerConverter(t1970, new UnitsConverter.ScaleOffset(1.0, 9.466848E8));
        t1970.registerConverter(ms1970, UnitsConverter.MILLI);
        t2000.registerConverter(t2010, new UnitsConverter.ScaleOffset(1.0, -3.156192E8));
        t2000.registerConverter(mj1958, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 15340.0));
        t2000.registerConverter(mjd, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 51544.0));
        t2000.registerConverter(julianDay, new UnitsConverter.ScaleOffset(1.1574074074074073E-5, 2451544.5));
        percent = new NumberUnits("%", "");
        dB = new NumberUnits("dB", "decibels");
        ampRatio = new NumberUnits("ampratio", "amplitude ratio");
        percentIncrease = new NumberUnits("% diff", "Special dimensionless number, useful for expressing on logarithmic scale.  100% indicates a doubling");
        log10Ratio = new NumberUnits("log10Ratio", "Special dimensionless number, useful for expressing distances on a log10 scale");
        logERatio = new NumberUnits("logERatio", "Special dimensionless number, useful for expressing distances on a logE scale");
        log10Ratio.registerConverter(logERatio, new UnitsConverter.ScaleOffset(Math.log(10.0), 0.0));
        logERatio.registerConverter(percentIncrease, new PercentRatioConverter());
        dB.registerConverter(log10Ratio, new UnitsConverter.ScaleOffset(10.0, 0.0));
        dB.registerConverter(ampRatio, new AmpRatioConverter());
    }

    private static class AmpRatioConverter
    extends UnitsConverter {
        private AmpRatioConverter() {
        }

        @Override
        public double convert(double value) {
            return Math.pow(10.0, value / 20.0);
        }

        @Override
        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    @Override
                    public double convert(double value) {
                        return 20.0 * Math.log10(value);
                    }

                    @Override
                    public UnitsConverter getInverse() {
                        return AmpRatioConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }

    private static class PercentRatioConverter
    extends UnitsConverter {
        private PercentRatioConverter() {
        }

        @Override
        public double convert(double value) {
            return (Math.exp(value) - 1.0) * 100.0;
        }

        @Override
        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    @Override
                    public double convert(double value) {
                        return Math.log(value / 100.0 + 1.0);
                    }

                    @Override
                    public UnitsConverter getInverse() {
                        return PercentRatioConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }

    private static final class dBConverter
    extends UnitsConverter {
        private dBConverter() {
        }

        @Override
        public double convert(double value) {
            return 10.0 * Math.log10(value);
        }

        @Override
        public UnitsConverter getInverse() {
            if (this.inverse == null) {
                this.inverse = new UnitsConverter(){

                    @Override
                    public double convert(double value) {
                        return Math.pow(10.0, value / 10.0);
                    }

                    @Override
                    public UnitsConverter getInverse() {
                        return dBConverter.this;
                    }
                };
            }
            return this.inverse;
        }
    }
}

