/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.LoggerManager;
import org.das2.datum.MonthDatumRange;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.Orbits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;

public class TimeParser {
    static final Logger logger = LoggerManager.getLogger("das2.datum.timeparser");
    public static final String TIMEFORMAT_Z = "$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z";
    private static final int AFTERSTOP_INIT = 999;
    private TimeUtil.TimeStruct startTime;
    private TimeUtil.TimeStruct stopTime;
    private TimeUtil.TimeStruct timeWidth;
    private TimeUtil.TimeStruct context;
    private String lock = "";
    private OrbitDatumRange orbitDatumRange;
    private int ndigits;
    private String[] valid_formatCodes = new String[]{"Y", "y", "j", "m", "d", "H", "M", "S", "milli", "micro", "p", "z", "ignore", "b", "X", "x"};
    private String[] formatName = new String[]{"Year", "2-digit-year", "day-of-year", "month", "day", "Hour", "Minute", "Second", "millisecond", "microsecond", "am/pm", "RFC-822 numeric time zone", "ignore", "3-char-month-name", "ignore", "ignore"};
    private int[] formatCode_lengths = new int[]{4, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 5, -1, 3, -1, -1};
    private int[] precision = new int[]{0, 0, 2, 1, 2, 3, 4, 5, 6, 7, -1, -1, -1, 1, -1, -1};
    private int[] handlers;
    private Map<String, FieldHandler> fieldHandlers;
    private Map<String, FieldHandler> fieldHandlersById;
    private int[] offsets;
    private int[] lengths;
    private int[] shift;
    private final String[] delims;
    private String[] fc;
    private String[] qualifiers;
    private final String regex;
    private int stopTimeDigit = 999;
    private int lsd;
    private int startLsd;
    public static final FieldHandler IGNORE_FIELD_HANDLER = new FieldHandler(){
        String regex;

        @Override
        public String configure(Map<String, String> args) {
            this.regex = args.get("regex");
            return null;
        }

        @Override
        public String getRegex() {
            return this.regex;
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            return null;
        }
    };
    private char startTimeOnly = '\u0000';
    private static final int MAX_VALID_YEAR = 9000;
    private static final int MIN_VALID_YEAR = 1000;

    public static boolean isIso8601String(String exampleTime) {
        try {
            TimeParser.iso8601String(exampleTime);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static String iso8601String(String exampleTime) {
        int i = exampleTime.indexOf("T");
        if (i == -1) {
            i = exampleTime.indexOf(" ");
        }
        String date = null;
        String time = null;
        if (i != -1 && i > 5) {
            char dateTimeDelim = exampleTime.charAt(i);
            String datePart = exampleTime.substring(0, i);
            boolean hasDelim = !datePart.matches("\\d+");
            char delim = '\u0000';
            if (hasDelim) {
                delim = datePart.charAt(4);
            }
            switch (datePart.length()) {
                case 10: {
                    date = "$Y" + delim + "$m" + delim + "$d";
                    break;
                }
                case 9: {
                    date = "$Y" + delim + "$j";
                    break;
                }
                case 8: {
                    date = hasDelim ? "$Y" + delim + "$j" : "$Y$m$d";
                    break;
                }
                case 7: {
                    date = "$Y$j";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unable to identify date format for " + exampleTime);
                }
            }
            String timePart = exampleTime.substring(i + 1);
            boolean addZ = false;
            if (timePart.endsWith("Z")) {
                timePart = timePart.substring(0, timePart.length() - 1);
                addZ = true;
            }
            hasDelim = !timePart.matches("\\d+");
            delim = '\u0000';
            if (hasDelim && timePart.length() > 2) {
                delim = timePart.charAt(2);
            }
            switch (timePart.length()) {
                case 4: {
                    time = "$H$M";
                    break;
                }
                case 5: {
                    time = "$H" + delim + "$M";
                    break;
                }
                case 6: {
                    time = "$H$M$S";
                    break;
                }
                case 8: {
                    time = "$H" + delim + "$M" + delim + "$S";
                    break;
                }
                case 12: {
                    time = "$H" + delim + "$M" + delim + "$S.$(subsec,places=3)";
                    break;
                }
                case 15: {
                    time = "$H" + delim + "$M" + delim + "$S.$(subsec,places=6)";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unable to identify time format for " + exampleTime);
                }
            }
            if (addZ) {
                time = time + "Z";
            }
            return date + dateTimeDelim + time;
        }
        throw new IllegalArgumentException("example time must contain T or space.");
    }

    public boolean isNested() {
        int resolution = -9999;
        for (int i = 1; i < this.fc.length; ++i) {
            if (this.handlers[i] < 0 || this.handlers[i] >= 8) continue;
            if (this.handlers[i] > resolution) {
                resolution = this.handlers[i];
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isStartTimeOnly() {
        return this.startTimeOnly > '\u0000';
    }

    private static String makeCanonical(String formatString) {
        boolean wildcard = formatString.contains("*");
        boolean oldSpec = formatString.contains("${");
        Pattern p = Pattern.compile("\\$[0-9]+\\{");
        boolean oldSpec2 = p.matcher(formatString).find();
        if (formatString.startsWith("$") && !wildcard && !oldSpec && !oldSpec2) {
            return formatString;
        }
        if (formatString.contains("%") && !formatString.contains("$")) {
            formatString = formatString.replaceAll("\\%", "\\$");
        }
        if ((oldSpec = formatString.contains("${")) && !formatString.contains("$(")) {
            formatString = formatString.replaceAll("\\$\\{", "\\$(");
            formatString = formatString.replaceAll("\\}", "\\)");
        }
        if (oldSpec2 && !formatString.contains("$(")) {
            formatString = formatString.replaceAll("\\$([0-9]+)\\{", "\\$$1(");
            formatString = formatString.replaceAll("\\}", "\\)");
        }
        if (wildcard) {
            formatString = formatString.replaceAll("\\*", "\\$x");
        }
        return formatString;
    }

    private static String makeQualifiersCanonical(String qualifiers) {
        int istart;
        boolean noDelimiters = true;
        for (int i = 0; noDelimiters && i < qualifiers.length(); ++i) {
            if (qualifiers.charAt(i) != ',' && qualifiers.charAt(i) != ';') continue;
            noDelimiters = false;
        }
        if (noDelimiters) {
            return qualifiers;
        }
        char[] result = new char[qualifiers.length()];
        result[0] = qualifiers.charAt(0);
        for (istart = 1; istart < qualifiers.length(); ++istart) {
            char ch = qualifiers.charAt(istart);
            if (ch == ';') {
                return qualifiers;
            }
            if (ch == ',') {
                result[istart] = 59;
                break;
            }
            if (!Character.isLetter(ch)) continue;
            result[istart] = ch;
        }
        boolean expectSemi = false;
        for (int i = qualifiers.length() - 1; i > istart; --i) {
            result[i] = qualifiers.charAt(i);
            char ch = qualifiers.charAt(i);
            if (ch == '=') {
                expectSemi = true;
                continue;
            }
            if (ch == ',' && expectSemi) {
                result[i] = 59;
                continue;
            }
            if (ch != ';') continue;
            expectSemi = false;
        }
        return new String(result);
    }

    private TimeParser(String formatString, Map<String, FieldHandler> fieldHandlers) {
        int pos;
        int i;
        if (fieldHandlers.get("o") == null) {
            fieldHandlers.put("o", new Orbits.OrbitFieldHandler());
        }
        if (fieldHandlers.get("subsec") == null) {
            fieldHandlers.put("subsec", new SubsecFieldHandler());
        }
        if (fieldHandlers.get("hrinterval") == null) {
            fieldHandlers.put("hrinterval", new HrintervalFieldHandler());
        }
        if (fieldHandlers.get("periodic") == null) {
            fieldHandlers.put("periodic", new PeriodicFieldHandler());
        }
        if (fieldHandlers.get("enum") == null) {
            fieldHandlers.put("enum", new EnumFieldHandler());
        }
        logger.log(Level.FINE, "new TimeParser({0},...)", formatString);
        this.startTime = new TimeUtil.TimeStruct();
        this.startTime.year = 1000;
        this.startTime.month = 1;
        this.startTime.day = 1;
        this.startTime.doy = 1;
        this.startTime.isLocation = true;
        this.stopTime = new TimeUtil.TimeStruct();
        this.stopTime.isLocation = true;
        this.stopTime.year = 9000;
        this.stopTime.month = 1;
        this.stopTime.day = 1;
        this.stopTime.doy = 1;
        this.stopTime.isLocation = true;
        this.fieldHandlers = fieldHandlers;
        this.fieldHandlersById = new HashMap<String, FieldHandler>();
        formatString = TimeParser.makeCanonical(formatString);
        String[] ss = formatString.split("\\$");
        this.fc = new String[ss.length];
        this.qualifiers = new String[ss.length];
        String[] delim = new String[ss.length + 1];
        this.ndigits = ss.length;
        StringBuilder regex1 = new StringBuilder(100);
        regex1.append(ss[0].replaceAll("\\+", "\\\\+"));
        this.lengths = new int[this.ndigits];
        for (i = 0; i < this.lengths.length; ++i) {
            this.lengths[i] = -1;
        }
        this.shift = new int[this.ndigits];
        delim[0] = ss[0];
        for (i = 1; i < this.ndigits; ++i) {
            int pp = 0;
            while (Character.isDigit(ss[i].charAt(pp)) || ss[i].charAt(pp) == '-') {
                ++pp;
            }
            this.lengths[i] = pp > 0 ? Integer.parseInt(ss[i].substring(0, pp)) : 0;
            ss[i] = TimeParser.makeQualifiersCanonical(ss[i]);
            logger.log(Level.FINE, "ss[i]={0}", ss[i]);
            if (ss[i].charAt(pp) != '(') {
                this.fc[i] = ss[i].substring(pp, pp + 1);
                delim[i] = ss[i].substring(pp + 1);
                continue;
            }
            if (ss[i].charAt(pp) != '(') continue;
            int endIndex = ss[i].indexOf(41, pp);
            if (endIndex == -1) {
                throw new IllegalArgumentException("opening paren but no closing paren in \"" + ss[i] + "\"");
            }
            int semi = ss[i].indexOf(";", pp);
            if (semi != -1) {
                this.fc[i] = ss[i].substring(pp + 1, semi);
                this.qualifiers[i] = ss[i].substring(semi + 1, endIndex);
            } else {
                this.fc[i] = ss[i].substring(pp + 1, endIndex);
            }
            delim[i] = ss[i].substring(endIndex + 1);
        }
        this.handlers = new int[this.ndigits];
        this.offsets = new int[this.ndigits];
        this.offsets[0] = pos = 0;
        this.lsd = -1;
        int lsdMult = 1;
        this.context = new TimeUtil.TimeStruct();
        this.copyTime(this.startTime, this.context);
        for (int i2 = 1; i2 < this.ndigits; ++i2) {
            if (pos != -1) {
                pos += delim[i2 - 1].length();
            }
            int handler = 9999;
            for (int j = 0; j < this.valid_formatCodes.length; ++j) {
                if (!this.valid_formatCodes[j].equals(this.fc[i2])) continue;
                handler = j;
                break;
            }
            if (handler == 9999) {
                String errm;
                if (!fieldHandlers.containsKey(this.fc[i2])) {
                    throw new IllegalArgumentException("bad format code: \"" + this.fc[i2] + "\"");
                }
                handler = 100;
                this.handlers[i2] = 100;
                this.offsets[i2] = pos;
                if (this.lengths[i2] < 1 || pos == -1) {
                    pos = -1;
                    this.lengths[i2] = -1;
                } else {
                    pos += this.lengths[i2];
                }
                FieldHandler fh = fieldHandlers.get(this.fc[i2]);
                String args = this.qualifiers[i2];
                HashMap argv = new HashMap();
                if (args != null) {
                    String[] ss2;
                    for (String ss21 : ss2 = args.split(";", -2)) {
                        int i3 = ss21.indexOf("=");
                        if (i3 == -1) {
                            argv.put(ss21.trim(), "");
                            continue;
                        }
                        argv.put(ss21.substring(0, i3).trim(), ss21.substring(i3 + 1).trim());
                    }
                }
                if ((errm = fh.configure(argv)) != null) {
                    throw new IllegalArgumentException(errm);
                }
                String id = (String)argv.get("id");
                if (id != null) {
                    this.fieldHandlersById.put(id, fh);
                }
            } else {
                this.handlers[i2] = handler;
                if (this.lengths[i2] == 0) {
                    this.lengths[i2] = this.formatCode_lengths[handler];
                }
                this.offsets[i2] = pos;
                pos = this.lengths[i2] < 1 || pos == -1 ? -1 : (pos += this.lengths[i2]);
            }
            int span = 1;
            if (this.qualifiers[i2] != null) {
                String[] ss2 = this.qualifiers[i2].split(";");
                for (String ss21 : ss2) {
                    String name;
                    boolean okay = false;
                    String qual = ss21.trim();
                    if (qual.equals("startTimeOnly")) {
                        this.startTimeOnly = this.fc[i2].charAt(0);
                        okay = true;
                    }
                    int idx = qual.indexOf("=");
                    if (!okay && idx > -1) {
                        name = qual.substring(0, idx).trim();
                        String val = qual.substring(idx + 1).trim();
                        block21 : switch (name) {
                            case "Y": {
                                this.context.year = Integer.parseInt(val);
                                break;
                            }
                            case "m": {
                                this.context.month = Integer.parseInt(val);
                                break;
                            }
                            case "d": {
                                this.context.day = Integer.parseInt(val);
                                break;
                            }
                            case "j": {
                                this.context.doy = Integer.parseInt(val);
                                break;
                            }
                            case "H": {
                                this.context.hour = Integer.parseInt(val);
                                break;
                            }
                            case "M": {
                                this.context.minute = Integer.parseInt(val);
                                break;
                            }
                            case "S": {
                                this.context.seconds = Integer.parseInt(val);
                                break;
                            }
                            case "cadence": {
                                span = Integer.parseInt(val);
                                break;
                            }
                            case "span": {
                                span = Integer.parseInt(val);
                                break;
                            }
                            case "delta": {
                                span = Integer.parseInt(val);
                                break;
                            }
                            case "resolution": {
                                span = Integer.parseInt(val);
                                break;
                            }
                            case "period": {
                                if (val.startsWith("P")) {
                                    try {
                                        int[] r = DatumRangeUtil.parseISO8601Duration(val);
                                        for (int j = 0; j < 6; ++j) {
                                            if (r[j] <= 0) continue;
                                            this.lsd = j;
                                            lsdMult = r[j];
                                            logger.log(Level.FINER, "lsd is now {0}, width={1}", new Object[]{this.lsd, lsdMult});
                                            break block21;
                                        }
                                        break;
                                    }
                                    catch (ParseException ex) {
                                        Logger.getLogger(TimeParser.class.getName()).log(Level.SEVERE, null, ex);
                                        break;
                                    }
                                }
                                char code = val.charAt(val.length() - 1);
                                switch (code) {
                                    case 'Y': {
                                        this.lsd = 0;
                                        break;
                                    }
                                    case 'm': {
                                        this.lsd = 1;
                                        break;
                                    }
                                    case 'd': {
                                        this.lsd = 2;
                                        break;
                                    }
                                    case 'j': {
                                        this.lsd = 2;
                                        break;
                                    }
                                    case 'H': {
                                        this.lsd = 3;
                                        break;
                                    }
                                    case 'M': {
                                        this.lsd = 4;
                                        break;
                                    }
                                    case 'S': {
                                        this.lsd = 5;
                                        break;
                                    }
                                }
                                lsdMult = Integer.parseInt(val.substring(0, val.length() - 1));
                                logger.log(Level.FINER, "lsd is now {0}, width={1}", new Object[]{this.lsd, lsdMult});
                                break;
                            }
                            case "id": {
                                break;
                            }
                            case "places": {
                                break;
                            }
                            case "phasestart": {
                                break;
                            }
                            case "shift": {
                                this.shift[i2] = Integer.parseInt(val);
                                break;
                            }
                            case "": {
                                break;
                            }
                            case "end": {
                                if (this.stopTimeDigit != 999) break;
                                this.startLsd = this.lsd;
                                this.stopTimeDigit = i2;
                                break;
                            }
                            default: {
                                if (fieldHandlers.containsKey(this.fc[i2])) break;
                                throw new IllegalArgumentException("unrecognized/unsupported field: " + name + " in " + qual);
                            }
                        }
                        okay = true;
                    } else if (!okay && (name = qual.trim()).equals("end")) {
                        if (this.stopTimeDigit == 999) {
                            this.startLsd = this.lsd;
                            this.stopTimeDigit = i2;
                        }
                        okay = true;
                    }
                    if (!okay && (qual.equals("Y") || qual.equals("m") || qual.equals("d") || qual.equals("j") || qual.equals("H") || qual.equals("M") || qual.equals("S"))) {
                        throw new IllegalArgumentException(String.format("%s must be assigned an integer value (e.g. %s=1) in %s", qual, qual, ss[i2]));
                    }
                    if (okay || fieldHandlers.containsKey(this.fc[i2])) continue;
                    logger.log(Level.WARNING, "unrecognized/unsupported field:{0} in {1}", new Object[]{qual, ss[i2]});
                }
            } else if (this.fc[i2].length() == 1) {
                char code = this.fc[i2].charAt(0);
                int thisLsd = -1;
                switch (code) {
                    case 'Y': {
                        thisLsd = 0;
                        break;
                    }
                    case 'm': {
                        thisLsd = 1;
                        break;
                    }
                    case 'd': {
                        thisLsd = 2;
                        break;
                    }
                    case 'j': {
                        thisLsd = 2;
                        break;
                    }
                    case 'H': {
                        thisLsd = 3;
                        break;
                    }
                    case 'M': {
                        thisLsd = 4;
                        break;
                    }
                    case 'S': {
                        thisLsd = 5;
                        break;
                    }
                }
                if (thisLsd == this.lsd) {
                    lsdMult = 1;
                }
            }
            if (handler < 100 && this.precision[handler] > this.lsd && lsdMult == 1) {
                this.lsd = this.precision[handler];
                lsdMult = span;
                logger.log(Level.FINER, "lsd is now {0}, width={1}", new Object[]{this.lsd, lsdMult});
            }
            String dots = ".........";
            if (this.lengths[i2] == -1) {
                regex1.append("(.*)");
            } else {
                regex1.append("(").append(dots.substring(0, this.lengths[i2])).append(")");
            }
            regex1.append(delim[i2].replaceAll("\\+", "\\\\+"));
        }
        this.timeWidth = new TimeUtil.TimeStruct();
        switch (this.lsd) {
            case 0: {
                this.timeWidth.year = lsdMult;
                break;
            }
            case 1: {
                this.timeWidth.month = lsdMult;
                break;
            }
            case 2: {
                this.timeWidth.day = lsdMult;
                break;
            }
            case 3: {
                this.timeWidth.hour = lsdMult;
                break;
            }
            case 4: {
                this.timeWidth.minute = lsdMult;
                break;
            }
            case 5: {
                this.timeWidth.seconds = lsdMult;
                break;
            }
            case 6: {
                this.timeWidth.millis = lsdMult;
                break;
            }
            case 7: {
                this.timeWidth.micros = lsdMult;
                break;
            }
            case -1: {
                this.timeWidth.year = 8000;
                break;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder canonical = new StringBuilder(delim[0]);
            for (int i3 = 1; i3 < this.ndigits; ++i3) {
                canonical.append("$");
                if (this.qualifiers[i3] == null) {
                    canonical.append(this.fc[i3]);
                } else {
                    canonical.append("(").append(this.fc[i3]).append(";").append(this.qualifiers[i3]).append(")");
                }
                canonical.append(delim[i3]);
            }
            logger.log(Level.FINE, "Canonical: {0}", canonical.toString());
        }
        this.delims = delim;
        this.regex = regex1.toString();
    }

    public static boolean isSpec(String spec) {
        spec = TimeParser.makeCanonical(spec);
        if ((spec = spec.replaceAll(",", ";")).contains("$Y") || spec.contains("$y") || spec.contains("$(Y;") || spec.contains("$(y;")) {
            return true;
        }
        if (spec.contains(";Y=")) {
            return true;
        }
        if (spec.contains("$o;") || spec.contains("$(o;")) {
            return true;
        }
        return spec.contains("$(periodic;");
    }

    public static TimeParser create(String formatString) {
        if (formatString.length() == 0) {
            throw new IllegalArgumentException("formatString length must be at least one character");
        }
        HashMap<String, FieldHandler> map = new HashMap<String, FieldHandler>();
        map.put("o", new Orbits.OrbitFieldHandler());
        map.put("v", new IgnoreFieldHandler());
        return new TimeParser(formatString, map);
    }

    public static TimeParser create(String formatString, String fieldName, FieldHandler handler, Object ... moreHandler) {
        if (formatString.length() == 0) {
            throw new IllegalArgumentException("formatString length must be at least one character");
        }
        HashMap<String, FieldHandler> map = new HashMap<String, FieldHandler>();
        map.put(fieldName, handler);
        if (moreHandler != null) {
            for (int i = 0; i < moreHandler.length; i += 2) {
                fieldName = (String)moreHandler[i];
                handler = (FieldHandler)moreHandler[i + 1];
                map.put(fieldName, handler);
            }
        }
        return new TimeParser(formatString, map);
    }

    private double toUs2000(TimeUtil.TimeStruct d) {
        int year = d.year;
        int month = d.month;
        int day = d.day;
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = d.hour;
        int minute = d.minute;
        double seconds = d.seconds + (double)((float)hour * 3600.0f) + (double)((float)minute * 60.0f);
        int mjd1958 = jd - 2436205;
        double us2000 = (double)(mjd1958 - 15340) * 8.64E10 + seconds * 1000000.0 + (double)(d.millis * 1000) + (double)d.micros;
        return us2000;
    }

    private double toUs1980(TimeUtil.TimeStruct d) {
        int year = d.year;
        int month = d.month;
        int day = d.day;
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        int hour = d.hour;
        int minute = d.minute;
        double seconds = d.seconds + (double)((float)hour * 3600.0f) + (double)((float)minute * 60.0f);
        double us1980 = (double)(jd - 2436205 - 8035) * 8.64E10 + seconds * 1000000.0 + (double)d.millis * 1000.0 + (double)d.micros;
        return us1980;
    }

    public void resetSeconds() {
        this.startTime.seconds = 0.0;
    }

    public void sloppyColumns() {
        this.lengths[0] = -1;
        for (int i = 1; i < this.offsets.length; ++i) {
            this.offsets[i] = -1;
            this.lengths[i] = -1;
        }
    }

    public TimeParser parse(String timeString) throws ParseException {
        return this.parse(timeString, null);
    }

    private void copyTime(TimeUtil.TimeStruct src, TimeUtil.TimeStruct dst) {
        dst.year = src.year;
        dst.month = src.month;
        dst.day = src.day;
        dst.hour = src.hour;
        dst.minute = src.minute;
        dst.seconds = src.seconds;
        dst.micros = src.micros;
        dst.isLocation = src.isLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized TimeParser parse(String timeString, Map<String, String> extra) throws ParseException {
        this.lock = Thread.currentThread().getName();
        int offs = 0;
        int len = 0;
        if (extra == null) {
            extra = new HashMap<String, String>();
        }
        this.orbitDatumRange = null;
        TimeUtil.TimeStruct time = this.startTime;
        this.copyTime(this.context, this.startTime);
        for (int idigit = 1; idigit < this.ndigits; ++idigit) {
            if (idigit == this.stopTimeDigit) {
                this.copyTime(this.startTime, this.stopTime);
                time = this.stopTime;
            }
            offs = this.offsets[idigit] != -1 ? this.offsets[idigit] : (offs += len + this.delims[idigit - 1].length());
            if (this.lengths[idigit] != -1) {
                len = this.lengths[idigit];
            } else if (this.delims[idigit].equals("")) {
                if (idigit != this.ndigits - 1) throw new IllegalArgumentException("No delimer specified after unknown length field, \"" + this.formatName[this.handlers[idigit]] + "\", field number=" + (1 + idigit) + "");
                len = timeString.length() - offs;
            } else {
                while (offs < timeString.length() && Character.isWhitespace(timeString.charAt(offs))) {
                    ++offs;
                }
                if (offs >= timeString.length()) {
                    throw new ParseException("expected delimiter \"" + this.delims[idigit] + "\" but reached end of string", offs);
                }
                int i = timeString.indexOf(this.delims[idigit], offs);
                if (i == -1) {
                    throw new ParseException("expected delimiter \"" + this.delims[idigit] + "\"", offs);
                }
                len = i - offs;
            }
            if (timeString.length() < offs + len) {
                throw new ParseException("string is too short: " + timeString, timeString.length());
            }
            String field = timeString.substring(offs, offs + len).trim();
            logger.log(Level.FINE, "handling {0} with {1}", new Object[]{field, this.handlers[idigit]});
            try {
                if (this.handlers[idigit] < 10) {
                    int digit = Integer.parseInt(field) + this.shift[idigit];
                    switch (this.handlers[idigit]) {
                        case 0: {
                            time.year = digit;
                            break;
                        }
                        case 1: {
                            time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                            break;
                        }
                        case 2: {
                            time.month = 1;
                            time.day = digit;
                            break;
                        }
                        case 3: {
                            time.month = digit;
                            break;
                        }
                        case 4: {
                            time.day = digit;
                            break;
                        }
                        case 5: {
                            time.hour = digit;
                            break;
                        }
                        case 6: {
                            time.minute = digit;
                            break;
                        }
                        case 7: {
                            time.seconds = digit;
                            break;
                        }
                        case 8: {
                            time.millis = digit;
                            break;
                        }
                        case 9: {
                            time.micros = digit;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("handlers[idigit] was not expected value (which shouldn't happen)");
                        }
                    }
                    continue;
                }
                if (this.handlers[idigit] == 100) {
                    FieldHandler handler = this.fieldHandlers.get(this.fc[idigit]);
                    handler.parse(timeString.substring(offs, offs + len), time, this.timeWidth, extra);
                    if (!(handler instanceof Orbits.OrbitFieldHandler)) continue;
                    this.orbitDatumRange = ((Orbits.OrbitFieldHandler)handler).getOrbitRange();
                    continue;
                }
                if (this.handlers[idigit] == 10) {
                    char ch = timeString.charAt(offs);
                    if (ch != 'P' && ch != 'p') continue;
                    time.hour += 12;
                    continue;
                }
                if (this.handlers[idigit] == 11) {
                    int offset = Integer.parseInt(timeString.substring(offs, offs + len));
                    time.hour -= offset / 100;
                    time.minute -= offset % 100;
                    continue;
                }
                if (this.handlers[idigit] == 12) continue;
                if (this.handlers[idigit] == 13) {
                    time.month = TimeUtil.monthNumber(timeString.substring(offs, offs + len));
                    continue;
                }
                if (this.handlers[idigit] != 14 && this.handlers[idigit] != 15) continue;
            }
            catch (NumberFormatException ex) {
                throw new ParseException(String.format("fail to parse digit number %d: %s", idigit, field), offs);
            }
        }
        this.lock = "";
        return this;
    }

    public static char getPad(Map<String, String> args) {
        String spad = args.get("pad");
        if (spad == null || spad.equals("underscore")) {
            return '_';
        }
        if (spad.equals("space")) {
            return ' ';
        }
        if (spad.equals("zero")) {
            return '0';
        }
        if (spad.equals("none")) {
            return ' ';
        }
        if (spad.length() > 1) {
            throw new IllegalArgumentException("unrecognized pad: " + spad);
        }
        return spad.charAt(0);
    }

    private FieldSpec parseSpec(String spec) {
        String fieldType;
        int ibrace;
        FieldSpec result = new FieldSpec();
        int i0 = spec.charAt(0) == '%' ? 1 : 0;
        result.spec = spec.substring(i0);
        int i1 = i0;
        while (Character.isDigit(spec.charAt(i1))) {
            ++i1;
        }
        if (i1 > i0) {
            result.length = Integer.parseInt(spec.substring(i0, i1));
            i0 = i1;
        }
        int isemi = spec.indexOf(59, i0);
        i1 = ibrace = spec.indexOf(125, i0);
        if (isemi > -1 && isemi < ibrace) {
            i1 = isemi;
            result.params = spec.substring(isemi, ibrace);
        } else {
            result.params = "";
        }
        result.fieldType = fieldType = spec.substring(1, i1);
        return result;
    }

    public void setDigit(String format, double value) {
        TimeUtil.TimeStruct time = this.startTime;
        if ((format = TimeParser.makeCanonical(format)).equals("$(ignore)") || format.equals("$X") || format.equals("$x")) {
            return;
        }
        if (value < 0.0) {
            throw new IllegalArgumentException("value must not be negative on field:" + format + " value:" + value);
        }
        String[] ss = format.split("\\$", -2);
        if (ss.length > 2) {
            throw new IllegalArgumentException("multiple fields not supported");
        }
        block13: for (int i = ss.length - 1; i > 0; --i) {
            int digit = (int)value;
            double fp = value - (double)digit;
            switch (ss[i].charAt(0)) {
                case 'Y': {
                    time.year = digit;
                    if (TimeUtil.isLeapYear(time.year)) {
                        time.seconds += 3.16224E7 * fp;
                        continue block13;
                    }
                    time.seconds += 3.1536E7 * fp;
                    continue block13;
                }
                case 'y': {
                    int n = time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                    if (TimeUtil.isLeapYear(time.year)) {
                        time.seconds += 3.16224E7 * fp;
                        continue block13;
                    }
                    time.seconds += 3.1536E7 * fp;
                    continue block13;
                }
                case 'j': {
                    time.month = 1;
                    time.day = digit;
                    time.seconds += 86400.0 * fp;
                    continue block13;
                }
                case 'm': {
                    time.month = digit;
                    time.seconds += (double)(TimeUtil.daysInMonth(time.month, time.year) * 24 * 3600) * fp;
                    continue block13;
                }
                case 'b': {
                    time.month = digit;
                    continue block13;
                }
                case 'd': {
                    time.day = digit;
                    time.seconds += 86400.0 * fp;
                    continue block13;
                }
                case 'H': {
                    time.hour = digit;
                    time.seconds += 3600.0 * fp;
                    continue block13;
                }
                case 'M': {
                    time.minute = digit;
                    time.seconds += 60.0 * fp;
                    continue block13;
                }
                case 'S': {
                    time.seconds = (double)digit + fp;
                    continue block13;
                }
                case '{': {
                    FieldSpec fs = this.parseSpec(ss[i]);
                    if (fs.fieldType.equals("milli")) {
                        time.millis = digit;
                        time.micros = (int)((double)time.micros + 1000.0 * fp);
                        time.seconds += (1000.0 * fp - (double)time.micros) * 1.0E-6;
                        continue block13;
                    }
                    if (fs.fieldType.equals("micro")) {
                        time.micros = digit;
                        time.seconds += fp * 1.0E-6;
                        continue block13;
                    }
                    if (!fs.fieldType.equals("ignore")) continue block13;
                    continue block13;
                }
                case '(': {
                    FieldSpec fs = this.parseSpec(ss[i]);
                    if (fs.fieldType.equals("milli")) {
                        time.millis = digit;
                        time.micros = (int)((double)time.micros + 1000.0 * fp);
                        time.seconds += (1000.0 * fp - (double)time.micros) * 1.0E-6;
                        continue block13;
                    }
                    if (fs.fieldType.equals("micro")) {
                        time.micros = digit;
                        time.seconds += fp * 1.0E-6;
                        continue block13;
                    }
                    if (!fs.fieldType.equals("ignore")) continue block13;
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("format code not supported");
                }
            }
        }
    }

    public TimeParser setDigit(String format, int value) {
        TimeUtil.TimeStruct time = this.startTime;
        String[] ss = format.split("%", -2);
        for (int i = ss.length - 1; i > 0; --i) {
            int mod = 0;
            switch (ss[i].charAt(0)) {
                case 'Y': {
                    int digit;
                    mod = 10000;
                    time.year = digit = value % mod;
                    break;
                }
                case 'y': {
                    mod = 100;
                    int digit = value % mod;
                    time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                    break;
                }
                case 'j': {
                    mod = 1000;
                    int digit = value % mod;
                    time.month = 1;
                    time.day = digit;
                    break;
                }
                case 'm': {
                    int digit;
                    mod = 100;
                    time.month = digit = value % mod;
                    break;
                }
                case 'b': {
                    int digit;
                    mod = 100;
                    time.month = digit = value % mod;
                    break;
                }
                case 'd': {
                    int digit;
                    mod = 100;
                    time.day = digit = value % mod;
                    break;
                }
                case 'H': {
                    int digit;
                    mod = 100;
                    time.hour = digit = value % mod;
                    break;
                }
                case 'M': {
                    int digit;
                    mod = 100;
                    time.minute = digit = value % mod;
                    break;
                }
                case 'S': {
                    mod = 100;
                    int digit = value % mod;
                    time.seconds = digit;
                    break;
                }
                case 'X': {
                    break;
                }
                case '{': {
                    FieldSpec fs = this.parseSpec(ss[i]);
                    mod = fs.fieldType.equals("milli") ? 1000 : (fs.fieldType.equals("micros") ? 1000 : (int)Math.pow(10.0, fs.length));
                    int digit = value % mod;
                    if (fs.fieldType.equals("milli")) {
                        time.millis = digit;
                        break;
                    }
                    if (fs.fieldType.equals("micros")) {
                        time.micros = digit;
                        break;
                    }
                    if (!fs.fieldType.equals("ignore")) break;
                    break;
                }
                case '(': {
                    FieldSpec fs = this.parseSpec(ss[i]);
                    mod = fs.fieldType.equals("milli") ? 1000 : (fs.fieldType.equals("micros") ? 1000 : (int)Math.pow(10.0, fs.length));
                    int digit = value % mod;
                    if (fs.fieldType.equals("milli")) {
                        time.millis = digit;
                        break;
                    }
                    if (fs.fieldType.equals("micros")) {
                        time.micros = digit;
                        break;
                    }
                    if (!fs.fieldType.equals("ignore")) break;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("format code not supported");
                }
            }
            value /= mod;
        }
        return this;
    }

    public TimeParser setDigit(int digitNumber, int digit) {
        TimeUtil.TimeStruct time = this.startTime;
        switch (this.handlers[digitNumber + 1]) {
            case 0: {
                time.year = digit;
                break;
            }
            case 1: {
                time.year = digit < 58 ? 2000 + digit : 1900 + digit;
                break;
            }
            case 2: {
                time.month = 1;
                time.day = digit;
                break;
            }
            case 3: {
                time.month = digit;
                break;
            }
            case 4: {
                time.day = digit;
                break;
            }
            case 5: {
                time.hour = digit;
                break;
            }
            case 6: {
                time.minute = digit;
                break;
            }
            case 7: {
                time.seconds = digit;
                break;
            }
            case 8: {
                time.millis = digit;
                break;
            }
            case 9: {
                time.micros = digit;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                time.month = digit;
                break;
            }
        }
        return this;
    }

    public void setContext(DatumRange tr) {
        this.context = TimeUtil.toTimeStruct(tr.min());
    }

    public double getTime(Units units) {
        return Units.us2000.convertDoubleTo(units, this.toUs2000(this.startTime));
    }

    public Datum getTimeDatum() {
        if (this.startTime.year < 1990) {
            return Units.us1980.createDatum(this.toUs1980(this.startTime));
        }
        return Units.us2000.createDatum(this.toUs2000(this.startTime));
    }

    public DatumRange getValidRange() {
        if (this.fieldHandlers.size() == 1 && this.fieldHandlers.get("o") instanceof Orbits.OrbitFieldHandler) {
            Orbits.OrbitFieldHandler ofh = (Orbits.OrbitFieldHandler)this.fieldHandlers.get("o");
            try {
                OrbitDatumRange d1 = new OrbitDatumRange(ofh.o.getSpacecraft(), ofh.o.first());
                OrbitDatumRange d2 = new OrbitDatumRange(ofh.o.getSpacecraft(), ofh.o.last());
                return DatumRangeUtil.union((DatumRange)d1, d2);
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return DatumRangeUtil.parseTimeRangeValid("1000-9000");
            }
        }
        return DatumRangeUtil.parseTimeRangeValid("1000-9000");
    }

    public DatumRange getTimeRange() {
        if (!this.lock.equals("")) {
            throw new IllegalArgumentException("someone is messing with the parser on a different thread " + this.lock + " this thread is " + Thread.currentThread().getName());
        }
        if (this.stopTimeDigit == 999 && this.startTime.day == 1 && this.startTime.hour == 0 && this.startTime.minute == 0 && this.startTime.seconds == 0.0 && this.startTime.millis == 0 && this.startTime.micros == 0 && this.timeWidth.day == 0 && this.timeWidth.hour == 0 && this.timeWidth.minute == 0 && this.timeWidth.seconds == 0.0 && this.timeWidth.millis == 0 && this.timeWidth.micros == 0) {
            TimeUtil.TimeStruct lstopTime = this.startTime.add(this.timeWidth);
            lstopTime = TimeUtil.carry(lstopTime);
            int[] t1 = new int[]{this.startTime.year, this.startTime.month, this.startTime.day, this.startTime.hour, this.startTime.minute, (int)this.startTime.seconds, this.startTime.millis * 1000000 + this.startTime.micros * 1000};
            int[] t2 = new int[]{lstopTime.year, lstopTime.month, lstopTime.day, lstopTime.hour, lstopTime.minute, (int)lstopTime.seconds, lstopTime.millis * 1000000 + lstopTime.micros * 1000};
            return new MonthDatumRange(t1, t2);
        }
        if (this.orbitDatumRange != null) {
            return this.orbitDatumRange;
        }
        if (this.stopTimeDigit < 999) {
            if (this.lsd <= this.startLsd) {
                double t1 = this.toUs2000(this.startTime);
                double t2 = this.toUs2000(this.stopTime);
                return new DatumRange(t1, t2, Units.us2000);
            }
            TimeUtil.TimeStruct lstartTime = TimeUtil.normalize(this.stopTime);
            int julianDay = TimeUtil.julianDay(lstartTime.year, lstartTime.month, lstartTime.day);
            long micros = (long)(this.timeWidth.micros + this.timeWidth.millis * 1000) + (long)((int)this.timeWidth.seconds) * 1000000L + (long)this.timeWidth.minute * 60000000L + (long)this.timeWidth.hour * 3600000000L;
            long lstartTimeMicros = (long)(lstartTime.micros + lstartTime.millis * 1000) + (long)((int)lstartTime.seconds) * 1000000L + (long)lstartTime.minute * 60000000L + (long)lstartTime.hour * 3600000000L;
            lstartTimeMicros -= micros;
            julianDay -= this.timeWidth.day;
            while (lstartTimeMicros < 0L) {
                --julianDay;
                lstartTimeMicros += 86400000000L;
            }
            lstartTime = TimeUtil.julianToGregorian(julianDay);
            lstartTime.hour = (int)(lstartTimeMicros / 3600000000L);
            lstartTime.minute = (int)((lstartTimeMicros -= (long)lstartTime.hour * 3600000000L) / 60000000L);
            lstartTime.seconds = (int)((lstartTimeMicros -= (long)lstartTime.minute * 60000000L) / 1000000L);
            lstartTimeMicros = (long)((double)lstartTimeMicros - lstartTime.seconds * 1000000.0);
            lstartTime.millis = (int)(lstartTimeMicros / 1000L);
            lstartTime.micros = (int)(lstartTimeMicros -= (long)lstartTime.millis * 1000L);
            lstartTime.month -= this.timeWidth.month;
            while (lstartTime.month < 1) {
                --lstartTime.year;
                lstartTime.month += 12;
            }
            lstartTime.year -= this.timeWidth.year;
            double t1 = this.toUs2000(lstartTime);
            double t2 = this.toUs2000(this.stopTime);
            return new DatumRange(t1, t2, Units.us2000);
        }
        TimeUtil.TimeStruct lstopTime = this.startTime.add(this.timeWidth);
        double t1 = this.toUs2000(this.startTime);
        double t2 = this.toUs2000(lstopTime);
        return new DatumRange(t1, t2, Units.us2000);
    }

    public double getEndTime(Units units) {
        DatumRange dr = this.getTimeRange();
        return dr.max().doubleValue(units);
    }

    public String getRegex() {
        return this.regex;
    }

    public String format(DatumRange range) {
        return this.format(range.min(), range.max());
    }

    public String format(Datum start) {
        return this.format(start, null);
    }

    public String format(Datum start, Datum stop) {
        return this.format(start, stop, new HashMap<String, String>());
    }

    private void normalizeSeconds(TimeUtil.TimeStruct timel) {
        double dextraMicros = 1000000.0 * (timel.seconds - (double)((int)timel.seconds));
        timel.seconds = (int)timel.seconds;
        timel.micros = (int)((long)timel.micros + Math.round(dextraMicros));
        int millis = timel.micros / 1000;
        timel.millis += millis;
        timel.micros -= millis * 1000;
    }

    public String format(Datum start, Datum stop, Map<String, String> extra) {
        StringBuilder result = new StringBuilder(100);
        int offs = 0;
        TimeUtil.TimeStruct timel = TimeUtil.toTimeStruct(start);
        TimeUtil.TimeStruct timeWidthl = new TimeUtil.TimeStruct();
        this.copyTime(this.timeWidth, timeWidthl);
        extra = new HashMap<String, String>(extra);
        TimeUtil.TimeStruct stopTimel = stop == null ? (this.timeWidth.year == 8000 ? timel : TimeUtil.add(timel, this.timeWidth)) : TimeUtil.toTimeStruct(stop);
        this.normalizeSeconds(stopTimel);
        this.normalizeSeconds(timel);
        NumberFormat[] nf = new NumberFormat[5];
        nf[2] = new DecimalFormat("00");
        nf[3] = new DecimalFormat("000");
        nf[4] = new DecimalFormat("0000");
        for (int idigit = 1; idigit < this.ndigits; ++idigit) {
            if (idigit == this.stopTimeDigit) {
                timel = stopTimel;
            }
            result.insert(offs, this.delims[idigit - 1]);
            offs = this.offsets[idigit] != -1 ? this.offsets[idigit] : (offs += this.delims[idigit - 1].length());
            int len = this.lengths[idigit] != -1 ? this.lengths[idigit] : -9999;
            if (this.handlers[idigit] < 10) {
                int digit;
                Pattern p;
                Matcher m;
                String qual = this.qualifiers[idigit];
                int span = 1;
                if (qual != null && (m = (p = Pattern.compile("span=(\\d+)")).matcher(qual)).matches()) {
                    span = Integer.parseInt(m.group(1));
                }
                switch (this.handlers[idigit]) {
                    case 0: {
                        digit = timel.year;
                        break;
                    }
                    case 1: {
                        digit = timel.year < 2000 ? timel.year - 1900 : timel.year - 2000;
                        break;
                    }
                    case 2: {
                        digit = TimeUtil.dayOfYear(timel.month, timel.day, timel.year);
                        break;
                    }
                    case 3: {
                        digit = timel.month;
                        break;
                    }
                    case 4: {
                        digit = timel.day;
                        break;
                    }
                    case 5: {
                        digit = timel.hour;
                        break;
                    }
                    case 6: {
                        digit = timel.minute;
                        break;
                    }
                    case 7: {
                        digit = (int)timel.seconds;
                        break;
                    }
                    case 8: {
                        digit = timel.millis;
                        break;
                    }
                    case 9: {
                        digit = timel.micros;
                        break;
                    }
                    default: {
                        throw new RuntimeException("shouldn't get here");
                    }
                }
                if (span > 1) {
                    if (this.handlers[idigit] > 0 && this.handlers[idigit] < 5) {
                        logger.fine("uh-oh, span used on ordinal like month, day.  Just leave it alone.");
                    } else {
                        digit = digit / span * span;
                    }
                }
                if (len < 0) {
                    String ss = String.valueOf(digit);
                    result.insert(offs, ss);
                    offs += ss.length();
                    continue;
                }
                result.insert(offs, nf[len].format(digit));
                offs += len;
                continue;
            }
            if (this.handlers[idigit] == 13) {
                result.insert(offs, TimeUtil.monthNameAbbrev(timel.month));
                offs += len;
                continue;
            }
            if (this.handlers[idigit] == 12 || this.handlers[idigit] == 14) {
                throw new RuntimeException("cannot format spec containing ignore");
            }
            if (this.handlers[idigit] == 100) {
                if (this.fc[idigit].equals("v")) {
                    String ins = "00";
                    if (len > -1) {
                        if (len > 20) {
                            throw new IllegalArgumentException("version lengths>20 not supported");
                        }
                        ins = "00000000000000000000".substring(0, len);
                    }
                    result.insert(offs, ins);
                    offs += ins.length();
                    continue;
                }
                FieldHandler fh1 = this.fieldHandlers.get(this.fc[idigit]);
                TimeUtil.TimeStruct timeEnd = stopTimel;
                String ins = fh1.format(timel, TimeUtil.subtract(timeEnd, timel), len, extra);
                TimeUtil.TimeStruct startTimeTest = new TimeUtil.TimeStruct();
                this.copyTime(timel, startTimeTest);
                TimeUtil.TimeStruct timeWidthTest = new TimeUtil.TimeStruct();
                this.copyTime(timeWidthl, timeWidthTest);
                try {
                    fh1.parse(ins, startTimeTest, timeWidthTest, extra);
                    this.copyTime(startTimeTest, timel);
                    this.copyTime(timeWidthTest, timeWidthl);
                    this.copyTime(TimeUtil.add(timel, timeWidthl), stopTimel);
                }
                catch (ParseException ex) {
                    Logger.getLogger(TimeParser.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (len > -1 && ins.length() != len) {
                    throw new IllegalArgumentException("length of fh is incorrect, should be " + len + ", got \"" + ins + "\"");
                }
                result.insert(offs, ins);
                offs += ins.length();
                continue;
            }
            if (this.handlers[idigit] == 10) {
                throw new RuntimeException("AM/PM not supported");
            }
            if (this.handlers[idigit] != 11) continue;
            throw new RuntimeException("Time Zones not supported");
        }
        result.insert(offs, this.delims[this.ndigits - 1]);
        return result.toString().trim();
    }

    public FieldHandler getFieldHandlerByCode(String code) {
        return this.fieldHandlers.get(code);
    }

    public FieldHandler getFieldHandlerById(String id) {
        return this.fieldHandlersById.get(id);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.fc.length; ++i) {
            if (this.fc[i] != null) {
                result.append("$").append(this.fc[i]);
            }
            result.append(this.delims[i]);
        }
        return result.toString();
    }

    static boolean testTimeParser1(String spec, String test, String norm) throws Exception {
        DatumRange drnorm;
        TimeParser tp = TimeParser.create(spec);
        DatumRange dr = tp.parse(test).getTimeRange();
        if (!dr.equals(drnorm = DatumRangeUtil.parseTimeRangeValid(norm))) {
            tp = TimeParser.create(spec);
            dr = tp.parse(test).getTimeRange();
            throw new IllegalStateException("ranges do not match: " + spec + " " + test + "--> " + dr + ", should be " + norm);
        }
        return true;
    }

    public static void main(String[] aa) throws Exception {
        TimeParser.testTimeParser();
    }

    public static void testTimeParser() throws Exception {
        LoggerManager.getLogger("datum.timeparser").setLevel(Level.ALL);
        logger.addHandler(new ConsoleHandler());
        logger.getHandlers()[0].setLevel(Level.ALL);
        DatumRangeUtil.parseTimeRangeValid("2000-022/P1D");
        System.err.println(TimeParser.makeCanonical("$Y-$3{J}"));
        TimeParser.testTimeParser1("$Y$m$d-$(Y,end)$m$d", "20130202-20140303", "2013-02-02/2014-03-03");
        TimeParser.testTimeParser1("$Y$m$d-$(d,end)", "20130202-13", "2013-02-02/2013-02-13");
        TimeParser.testTimeParser1("$(periodic;offset=0;start=2000-001;period=P1D)", "0", "2000-001");
        TimeParser.testTimeParser1("$(periodic;offset=0;start=2000-001;period=P1D)", "20", "2000-021");
        TimeParser.testTimeParser1("$(periodic,offset=2285,start=2000-346,period=P27D)", "1", "1832-02-08/P27D");
        TimeParser.testTimeParser1("$(periodic;offset=2285;start=2000-346;period=P27D)", "2286", "2001-007/P27D");
        TimeParser.testTimeParser1("$Y-$m-$dT$H:$M:$S.$(subsec,places=6)", "2000-01-01T00:00:00.000001", "2000-001T00:00:00.000001/PT.000001S");
        TimeParser.testTimeParser1("$Y-$m-$dT$H:$M:$S.$(subsec,places=6)", "2000-01-01T00:00:05.000001", "2000-001T00:00:05.000001/PT.000001S");
        TimeParser tp = TimeParser.create("$Y$m$d_v$v.dat");
        System.err.println(tp.parse("20130618_v4.05.dat").getTimeRange());
        System.err.println(TimeParser.makeCanonical("%Y-%m-%dT%H:%M:%S.%{milli}Z"));
    }

    public static class EnumFieldHandler
    implements FieldHandler {
        LinkedHashSet<String> values;
        String id;

        @Override
        public String configure(Map<String, String> args) {
            String[] ss2;
            this.values = new LinkedHashSet();
            String svalues = args.get("values");
            String[] ss = svalues.split(",", -2);
            if (ss.length == 1 && (ss2 = svalues.split("|", -2)).length > 1) {
                logger.fine("supporting legacy value containing pipes for values");
                ss = ss2;
            }
            this.values.addAll(Arrays.asList(ss));
            String s = args.get("id");
            this.id = s != null ? s : "unindentifiedEnum";
            return null;
        }

        @Override
        public String getRegex() {
            Iterator it = this.values.iterator();
            StringBuilder b = new StringBuilder("[").append((String)it.next());
            while (it.hasNext()) {
                b.append("|").append(Pattern.quote((String)it.next()));
            }
            b.append("]");
            return b.toString();
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
            if (!this.values.contains(fieldContent)) {
                throw new ParseException("value is not in enum: " + fieldContent, 0);
            }
            extra.put(this.id, fieldContent);
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            String v = extra.get(this.id);
            if (v == null) {
                throw new IllegalArgumentException("\"" + this.id + " is undefined in extras.");
            }
            if (this.values.contains(v)) {
                return v;
            }
            throw new IllegalArgumentException(this.id + " value is not within enum: " + this.values);
        }

        public String[] getValues() {
            return this.values.toArray(new String[this.values.size()]);
        }

        public String getId() {
            return this.id;
        }
    }

    public static interface FieldHandler {
        public String configure(Map<String, String> var1);

        public String getRegex();

        public void parse(String var1, TimeUtil.TimeStruct var2, TimeUtil.TimeStruct var3, Map<String, String> var4) throws ParseException;

        public String format(TimeUtil.TimeStruct var1, TimeUtil.TimeStruct var2, int var3, Map<String, String> var4) throws IllegalArgumentException;
    }

    private static class FieldSpec {
        String spec = null;
        String fieldType = null;
        int length = -1;
        String params = null;

        private FieldSpec() {
        }

        public String toString() {
            return String.valueOf(this.spec) + String.valueOf(this.params);
        }
    }

    public static class HrintervalFieldHandler
    implements FieldHandler {
        Map<String, Integer> values;
        Map<Integer, String> revvalues;
        int mult;

        @Override
        public String configure(Map<String, String> args) {
            String vs = args.get("values");
            if (vs == null) {
                vs = args.get("names");
            }
            if (vs == null) {
                return "values must be specified for hrinterval";
            }
            String[] values1 = vs.split(",", -2);
            this.mult = 24 / values1.length;
            if (24 - this.mult * values1.length != 0) {
                throw new IllegalArgumentException("only 1,2,3,4,6,8 or 12 intervals");
            }
            this.values = new HashMap<String, Integer>();
            this.revvalues = new HashMap<Integer, String>();
            for (int i = 0; i < values1.length; ++i) {
                this.values.put(values1[i], i);
                this.revvalues.put(i, values1[i]);
            }
            return null;
        }

        @Override
        public String getRegex() {
            Iterator<String> vv = this.values.keySet().iterator();
            StringBuilder r = new StringBuilder(vv.next());
            while (vv.hasNext()) {
                r.append("|").append(vv.next());
            }
            return r.toString();
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
            int hour;
            Integer ii = this.values.get(fieldContent);
            if (ii == null) {
                throw new ParseException("expected one of " + this.getRegex(), 0);
            }
            startTime.hour = hour = this.mult * ii;
            timeWidth.hour = this.mult;
            timeWidth.year = 0;
            timeWidth.month = 0;
            timeWidth.day = 0;
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            String v = this.revvalues.get(startTime.hour / this.mult);
            if (v == null) {
                throw new IllegalArgumentException("unable to identify enum for hour " + startTime.hour);
            }
            return v;
        }
    }

    public static class IgnoreFieldHandler
    implements FieldHandler {
        String regex;

        @Override
        public String configure(Map<String, String> args) {
            this.regex = args.get("regex");
            return null;
        }

        @Override
        public String getRegex() {
            return this.regex;
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            return "";
        }
    }

    public static class PeriodicFieldHandler
    implements FieldHandler {
        int offset;
        int[] start;
        int julday;
        int[] period;

        @Override
        public String configure(Map<String, String> args) {
            String s = args.get("start");
            if (s == null) {
                return "periodic field needs start";
            }
            this.start = DatumRangeUtil.parseISO8601(s);
            this.julday = TimeUtil.julianDay(this.start[0], this.start[1], this.start[2]);
            this.start[0] = 0;
            this.start[1] = 0;
            this.start[2] = 0;
            s = args.get("offset");
            if (s == null) {
                return "periodic field needs offset";
            }
            this.offset = Integer.parseInt(s);
            s = args.get("period");
            if (s == null) {
                return "periodic field needs period";
            }
            if (!s.startsWith("P")) {
                if (s.endsWith("D")) {
                    throw new IllegalArgumentException("periodic unit for day is d, not D");
                }
                s = s.endsWith("d") ? "P" + s.toUpperCase() : "PT" + s.toUpperCase();
            }
            try {
                this.period = DatumRangeUtil.parseISO8601Duration(s);
            }
            catch (ParseException ex) {
                return "unable to parse period: " + s + "\n" + ex.getMessage();
            }
            return null;
        }

        @Override
        public String getRegex() {
            return "[0-9]+";
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
            int i = Integer.parseInt(fieldContent);
            int addOffset = i - this.offset;
            int[] t = new int[7];
            int[] limits = new int[]{-1, -1, 0, 24, 60, 60, 1000000};
            timeWidth.day = this.period[2];
            for (i = 6; i > 2; --i) {
                t[i] = this.start[i] + addOffset * this.period[i];
                while (t[i] > limits[i]) {
                    int n = i - 1;
                    t[n] = t[n] + 1;
                    int n2 = i;
                    t[n2] = t[n2] - limits[i];
                }
            }
            timeWidth.year = 0;
            timeWidth.month = 0;
            timeWidth.hour = this.period[3];
            timeWidth.minute = this.period[4];
            timeWidth.seconds = this.period[5];
            timeWidth.micros = this.period[6] / 1000;
            TimeUtil.TimeStruct ts = TimeUtil.julianToGregorian(this.julday + timeWidth.day * addOffset + t[2]);
            startTime.year = ts.year;
            startTime.month = ts.month;
            startTime.day = ts.day;
            startTime.hour = t[3];
            startTime.minute = t[4];
            startTime.seconds = t[5];
            startTime.millis = t[6];
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            int jd = TimeUtil.julianDay(startTime.year, startTime.month, startTime.day);
            if (this.period[1] != 0 || this.period[3] != 0 || this.period[4] != 0 || this.period[5] != 0 || this.period[6] != 0) {
                throw new IllegalArgumentException("under implemented, only integer number of days supported for formatting.");
            }
            int deltad = (int)Math.floor((float)(jd - this.julday) / (float)this.period[2]) + this.offset;
            String result = String.format("%d", deltad);
            if (length > 16) {
                throw new IllegalArgumentException("length>16 not supported");
            }
            if (length > -1) {
                result = "_________________".substring(0, length - result.length()) + result;
            }
            return result;
        }
    }

    public static class SubsecFieldHandler
    implements FieldHandler {
        int places;
        double factor;
        String format;

        @Override
        public String configure(Map<String, String> args) {
            this.places = Integer.parseInt(args.get("places"));
            if (this.places > 6) {
                throw new IllegalArgumentException("only six places allowed.");
            }
            this.factor = Math.pow(10.0, 6 - this.places);
            this.format = "%0" + this.places + "d";
            return null;
        }

        @Override
        public String getRegex() {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.places; ++i) {
                b.append("[0-9]");
            }
            return b.toString();
        }

        @Override
        public void parse(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) throws ParseException {
            double value = Double.parseDouble(fieldContent);
            startTime.micros = (int)(value * this.factor);
            timeWidth.seconds = 0.0;
            timeWidth.micros = (int)(1.0 * this.factor);
        }

        @Override
        public String format(TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, int length, Map<String, String> extra) throws IllegalArgumentException {
            double nn = (startTime.seconds - (double)((int)startTime.seconds)) * (1000000.0 / this.factor) + (double)(startTime.millis * 1000) / this.factor + (double)startTime.micros / this.factor;
            return String.format(this.format, (int)Math.round(nn));
        }
    }
}

