/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import org.das2.datum.Basis;
import org.das2.datum.Datum;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.LocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.TimeDatumFormatterFactory;

public class TimeLocationUnits
extends LocationUnits {
    double vmin;
    double vmax;
    private Datum fill = this.createDatum(Double.NaN);

    public TimeLocationUnits(String id, String description, Units offsetUnits, Basis basis) {
        super(id, description, offsetUnits, basis);
        if (id.equals("us2000")) {
            this.vmin = -3.15569088E16;
            this.vmax = 2.208987072E17;
        } else {
            this.vmin = Double.NaN;
            this.vmax = Double.NaN;
        }
    }

    @Override
    public DatumFormatterFactory getDatumFormatterFactory() {
        return TimeDatumFormatterFactory.getInstance();
    }

    @Override
    public Datum parse(String s) throws ParseException {
        if (s.equals("NaN")) {
            return this.fill;
        }
        int[] rr = DatumRangeUtil.parseISO8601(s);
        if (rr != null) {
            return TimeUtil.toDatum(rr, (Units)this);
        }
        return TimeUtil.toDatum(TimeUtil.parseTime(s), (Units)this);
    }

    @Override
    public Datum getFillDatum() {
        return this.fill;
    }

    @Override
    public double getFillDouble() {
        return this.fill.doubleValue(this);
    }

    public String getTimeZone() {
        return "UT";
    }

    private void calculateRange() {
        this.vmin = Units.us2000.convertDoubleTo(this, Units.us2000.vmin);
        this.vmax = Units.us2000.convertDoubleTo(this, Units.us2000.vmax);
    }

    @Override
    public boolean isFill(double value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return value < this.vmin || value > this.vmax || Double.isNaN(value);
    }

    @Override
    public boolean isValid(double value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return value >= this.vmin && value <= this.vmax && !Double.isNaN(value);
    }

    public double validMin() {
        return this.vmin;
    }

    public double validMax() {
        return this.vmax;
    }
}

