/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Ratio;

public class RationalNumber {
    Ratio n;
    Ratio exp;

    public RationalNumber(double d) {
        int iexp = (int)Math.log10(Math.abs(d));
        this.exp = new Ratio(iexp);
        this.n = Ratio.create(d /= Math.pow(10.0, iexp));
    }

    public RationalNumber(Ratio n, Ratio exp) {
        this.exp = exp;
        this.n = n;
    }

    public RationalNumber(Ratio n) {
        this.exp = Ratio.zero;
        this.n = n;
    }

    public RationalNumber(int n) {
        this.exp = Ratio.zero;
        this.n = new Ratio(n);
    }

    public RationalNumber(int n, int d) {
        this.exp = Ratio.zero;
        this.n = new Ratio(n, d);
    }

    public double doubleValue() {
        return (double)this.n.numerator * Math.pow(10.0, (double)this.exp.numerator / (double)this.exp.denominator) / (double)this.n.denominator;
    }

    public String toString() {
        return String.valueOf(this.n.doubleValue() * Math.pow(10.0, this.exp.doubleValue()));
    }

    public static RationalNumber parse(String s) throws NumberFormatException {
        return new RationalNumber(Ratio.create(s));
    }

    public RationalNumber divide(RationalNumber number) {
        return new RationalNumber(this.n.divide(number.n), this.exp.subtract(number.exp));
    }

    public RationalNumber multiply(RationalNumber number) {
        return new RationalNumber(this.n.multiply(number.n), this.exp.add(number.exp));
    }

    public RationalNumber pow(Ratio r) {
        return new RationalNumber(this.n.pow(r), this.exp.multiply(r));
    }

    public RationalNumber sqrt() {
        return new RationalNumber(this.n.sqrt(), this.exp.divide(new Ratio(2)));
    }

    public boolean isOne() {
        return this.n.isOne() && this.exp.isZero();
    }

    public boolean isZero() {
        return this.n.isZero();
    }
}

