/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.util.ArrayList;
import java.util.List;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.LinearDomainDivider;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;

public class OrdinalTimeDomainDivider
implements DomainDivider {
    private static final int[] ZEROONE = new int[]{0, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] MODULO = new int[]{10000, 12, 30, 24, 60, 60, 1000, 1000};
    private static int N_DIGITS = 8;
    private static final List<Integer>[] FACTORS = new List[N_DIGITS];
    private int significand;
    private int digit;
    private static final int ARR_YEAR = 0;
    private static final int ARR_MONTH = 1;
    private static final int ARR_DAY = 2;
    private static final int ARR_HOUR = 3;
    private static final int ARR_MINUTE = 4;
    private static final int ARR_SECOND = 5;
    private static final int ARR_MILLIS = 6;
    private static final int ARR_MICROS = 7;
    private LinearDomainDivider ysDivider;

    private OrdinalTimeDomainDivider(int significand, int digit, LinearDomainDivider secondsDivider) {
        this.significand = significand;
        this.digit = digit;
        this.ysDivider = secondsDivider;
    }

    protected OrdinalTimeDomainDivider() {
        this(1, 3, null);
    }

    private static List<Integer> primeFactors(int N) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (N % 10 == 0) {
            result.add(2);
            result.add(5);
            N /= 10;
        }
        for (int i = 2; i <= N; ++i) {
            while (N % i == 0) {
                result.add(i);
                N /= i;
            }
        }
        return result;
    }

    private static List<Integer> factors(List<Integer> primeFactors) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(1);
        int count = 1;
        int c = (int)Math.pow(2.0, primeFactors.size());
        for (int i = 0; i < c; ++i) {
            int r1 = 1;
            String sb = Integer.toBinaryString(i);
            int nsb = sb.length() - 1;
            for (int j = 0; j < sb.length(); ++j) {
                if (sb.charAt(nsb - j) != '1') continue;
                r1 *= primeFactors.get(j).intValue();
            }
            if (r1 <= (Integer)result.get(count - 1)) continue;
            result.add(r1);
            ++count;
        }
        result.remove(result.size() - 1);
        return result;
    }

    @Override
    public DomainDivider finerDivider(boolean superset) {
        int newSignificand;
        int newDigit = this.digit;
        if (this.ysDivider != null) {
            if (this.digit == 0 && (this.ysDivider.getSignificand() > 1 || this.ysDivider.getExponent() > 0)) {
                return new OrdinalTimeDomainDivider(this.significand, this.digit, (LinearDomainDivider)this.ysDivider.finerDivider(superset));
            }
            if (this.digit == 5) {
                if (Math.abs(this.ysDivider.getExponent()) > 1000) {
                    throw new IllegalArgumentException("something has gone wrong in OrdinalTimeDomainDivider");
                }
                return new OrdinalTimeDomainDivider(this.significand, this.digit, (LinearDomainDivider)this.ysDivider.finerDivider(superset));
            }
        }
        List<Integer> factors = FACTORS[this.digit];
        int i = factors.indexOf(this.significand);
        do {
            if (--i == -1) {
                newDigit = this.digit + 1;
                factors = FACTORS[newDigit];
                newSignificand = factors.get(factors.size() - 1);
                if (newDigit != 2 || !superset) break;
                newSignificand = 1;
                break;
            }
            newSignificand = factors.get(i);
        } while (superset && this.significand % newSignificand > 0);
        if (newDigit == 5 && (double)newSignificand == 1.0) {
            return new OrdinalTimeDomainDivider(newSignificand, newDigit, new LinearDomainDivider());
        }
        return new OrdinalTimeDomainDivider(newSignificand, newDigit, null);
    }

    @Override
    public DomainDivider coarserDivider(boolean superset) {
        int newSignificand = 0;
        int newDigit = this.digit;
        List<Integer> factors = FACTORS[this.digit];
        int i = factors.indexOf(this.significand);
        if (this.ysDivider != null) {
            if (this.digit == 5 && this.ysDivider.getExponent() < 0) {
                return new OrdinalTimeDomainDivider(this.significand, this.digit, (LinearDomainDivider)this.ysDivider.coarserDivider(superset));
            }
            if (this.digit == 0) {
                return new OrdinalTimeDomainDivider(this.significand, this.digit, (LinearDomainDivider)this.ysDivider.coarserDivider(superset));
            }
        }
        do {
            if (++i == factors.size()) {
                newDigit = this.digit - 1;
                newSignificand = 1;
                if (this.digit == 2 && superset) {
                    newDigit = this.digit - 1;
                    newSignificand = 1;
                    break;
                }
                newDigit = this.digit - 1;
                newSignificand = 1;
                break;
            }
            newSignificand = factors.get(i);
        } while (superset && newSignificand % this.significand > 0);
        if (newDigit == 0 && (double)newSignificand == 1.0) {
            return new OrdinalTimeDomainDivider(newSignificand, newDigit, new LinearDomainDivider());
        }
        return new OrdinalTimeDomainDivider(newSignificand, newDigit, null);
    }

    private static int[] floor(int[] tarr, int significand, int digit) {
        tarr[digit] = (tarr[digit] - ZEROONE[digit]) / significand * significand + ZEROONE[digit];
        for (int i = digit + 1; i < N_DIGITS; ++i) {
            tarr[i] = ZEROONE[i];
        }
        return tarr;
    }

    private static int[] ceil(int[] tarr, int significand, int digit) {
        int d0 = tarr[digit] - ZEROONE[digit];
        int ceil = d0 % significand == 0 ? 0 : 1;
        for (int i = digit + 1; i < N_DIGITS; ++i) {
            if (tarr[i] > ZEROONE[i]) {
                ceil = 1;
            }
            tarr[i] = ZEROONE[i];
        }
        tarr[digit] = (d0 / significand + ceil) * significand + ZEROONE[digit];
        OrdinalTimeDomainDivider.carry(tarr);
        return tarr;
    }

    private static int[] carry(int[] tarr) {
        int dim;
        for (int i = 5; i > 2; --i) {
            if (tarr[i] <= MODULO[i]) continue;
            int n = i - 1;
            tarr[n] = tarr[n] + 1;
            int n2 = i;
            tarr[n2] = tarr[n2] - MODULO[i];
        }
        if (tarr[1] > 12) {
            tarr[1] = tarr[1] - 12;
            tarr[0] = tarr[0] + 1;
        }
        if (tarr[2] > (dim = TimeUtil.daysInMonth(tarr[1], tarr[0]))) {
            tarr[1] = tarr[1] + 1;
            tarr[2] = tarr[2] - dim;
        }
        if (tarr[1] > 12) {
            tarr[1] = tarr[1] - 12;
            tarr[0] = tarr[0] + 1;
        }
        return tarr;
    }

    @Override
    public DatumVector boundaries(Datum min, Datum max) {
        if (!min.isFinite() || !max.isFinite()) {
            System.err.println("min and max must be finite");
        }
        if (this.digit == 5 && this.ysDivider != null) {
            Datum t = TimeUtil.prevMidnight(min).convertTo(Units.t2000);
            DatumVector secs = this.ysDivider.boundaries(min.subtract(t).convertTo(Units.seconds), max.subtract(t).convertTo(Units.seconds));
            return secs.add(t);
        }
        if (this.digit == 0 && this.ysDivider != null) {
            int yearMin = TimeUtil.toTimeStruct((Datum)min).year;
            int yearMax = TimeUtil.toTimeStruct((Datum)max).year;
            Units u = Units.dimensionless;
            DatumVector years = this.ysDivider.boundaries(u.createDatum(yearMin), u.createDatum(yearMax));
            Units out = min.getUnits();
            double[] tickV = years.toDoubleArray(Units.dimensionless);
            for (int i = 0; i < tickV.length; ++i) {
                int iyear = (int)tickV[i];
                tickV[i] = TimeUtil.convert(iyear, 1, 1, 0, 0, 0.0, (TimeLocationUnits)out);
            }
            return DatumVector.newDatumVector(tickV, out);
        }
        if (this.digit == 2) {
            long nb = this.boundaryCount(min, max);
            if (nb > 1000000L) {
                throw new IllegalArgumentException("LinearDomainDivider: too many divisions requested (" + this.boundaryCount(min, max) + ")");
            }
            double[] values = new double[(int)nb];
            Units units = min.getUnits();
            int[] tmin = OrdinalTimeDomainDivider.ceil(TimeUtil.toTimeArray(min), 1, this.digit);
            tmin = OrdinalTimeDomainDivider.ceil(tmin, this.significand, this.digit);
            int i = 0;
            while ((long)i < nb) {
                values[i] = TimeUtil.toDatum(tmin).doubleValue(units);
                int n = this.digit;
                tmin[n] = tmin[n] + this.significand;
                OrdinalTimeDomainDivider.carry(tmin);
                ++i;
            }
            return DatumVector.newDatumVector(values, units);
        }
        long nb = this.boundaryCount(min, max);
        if (nb > 1000000L) {
            throw new IllegalArgumentException("LinearDomainDivider: too many divisions requested (" + this.boundaryCount(min, max) + ")");
        }
        double[] values = new double[(int)nb];
        Units units = min.getUnits();
        int[] tmin = OrdinalTimeDomainDivider.ceil(TimeUtil.toTimeArray(min), this.significand, this.digit);
        int i = 0;
        while ((long)i < nb) {
            values[i] = TimeUtil.toDatum(tmin).doubleValue(units);
            tmin[this.digit] = tmin[this.digit] + this.significand;
            OrdinalTimeDomainDivider.carry(tmin);
            ++i;
        }
        return DatumVector.newDatumVector(values, units);
    }

    @Override
    public long boundaryCount(Datum min, Datum max) {
        if (this.digit == 5 && this.ysDivider != null) {
            Datum t = TimeUtil.prevMidnight(min).convertTo(Units.t2000);
            return this.ysDivider.boundaryCount(min.subtract(t).convertTo(Units.seconds), max.subtract(t).convertTo(Units.seconds));
        }
        if (this.digit == 0 && this.ysDivider != null) {
            int yearMin = TimeUtil.toTimeStruct((Datum)min).year;
            int yearMax = TimeUtil.toTimeStruct((Datum)max).year;
            Units u = Units.dimensionless;
            return this.ysDivider.boundaryCount(u.createDatum(yearMin), u.createDatum(yearMax));
        }
        int[] tmin = OrdinalTimeDomainDivider.ceil(TimeUtil.toTimeArray(min), this.significand, this.digit);
        int[] tmax = OrdinalTimeDomainDivider.floor(TimeUtil.toTimeArray(max), this.significand, this.digit);
        if (this.digit < 2) {
            long result = tmax[0] - tmin[0];
            for (int i = 1; i <= this.digit; ++i) {
                result = result * (long)MODULO[i] + (long)(tmax[i] - tmin[i]);
            }
            return result / (long)this.significand + 1L;
        }
        if (this.digit == 2) {
            tmin = OrdinalTimeDomainDivider.ceil(TimeUtil.toTimeArray(min), 1, this.digit);
            tmax = OrdinalTimeDomainDivider.floor(TimeUtil.toTimeArray(max), 1, this.digit);
            int jmin = TimeUtil.julianDay(tmin[0], tmin[1], tmin[2]);
            int jmax = TimeUtil.julianDay(tmax[0], tmax[1], tmax[2]);
            long result = (jmax - jmin) / this.significand + 1;
            return result;
        }
        int jmin = TimeUtil.julianDay(tmin[0], tmin[1], tmin[2]);
        int jmax = TimeUtil.julianDay(tmax[0], tmax[1], tmax[2]);
        long result = jmax - jmin;
        for (int i = 3; i <= this.digit; ++i) {
            result = result * (long)MODULO[i] + (long)(tmax[i] - tmin[i]);
        }
        return result / (long)this.significand + 1L;
    }

    @Override
    public DatumRange rangeContaining(Datum v) {
        if (this.digit == 5 && this.ysDivider != null) {
            Datum t = TimeUtil.prevMidnight(v);
            DatumRange r = this.ysDivider.rangeContaining(v.subtract(t).convertTo(Units.seconds));
            return new DatumRange(t.add(r.min()), t.add(r.max()));
        }
        if (this.digit == 0 && this.ysDivider != null) {
            int yearMin = TimeUtil.toTimeStruct((Datum)v).year;
            DatumRange r = this.ysDivider.rangeContaining(Units.dimensionless.createDatum(yearMin));
            TimeLocationUnits out = (TimeLocationUnits)v.getUnits();
            double tmin = TimeUtil.convert((int)r.min().doubleValue(), 1, 1, 0, 0, 0.0, out);
            double tmax = TimeUtil.convert((int)r.max().doubleValue(), 1, 1, 0, 0, 0.0, out);
            return new DatumRange(tmin, tmax, out);
        }
        int[] tarr = OrdinalTimeDomainDivider.floor(TimeUtil.toTimeArray(v), this.significand, this.digit);
        Datum dstart = TimeUtil.toDatum(tarr);
        tarr[this.digit] = tarr[this.digit] + this.significand;
        Datum dstop = TimeUtil.toDatum(tarr);
        return new DatumRange(dstart, dstop);
    }

    public String toString() {
        if (this.ysDivider != null) {
            return "OTDomainDivider delegate offset to " + this.ysDivider + " " + TimeUtil.TimeDigit.fromOrdinal(this.digit + 1);
        }
        return "OTDomainDivider by " + this.significand + " " + TimeUtil.TimeDigit.fromOrdinal(this.digit + 1);
    }

    public DatumFormatter getFormatter(DatumRange range) {
        if (this.ysDivider != null) {
            if (this.digit == 5) {
                if (this.ysDivider.getExponent() < -6) {
                    return TimeDatumFormatter.NANOSECONDS;
                }
                if (this.ysDivider.getExponent() < -3) {
                    return TimeDatumFormatter.MICROSECONDS;
                }
                if (this.ysDivider.getExponent() < 0) {
                    return TimeDatumFormatter.MILLISECONDS;
                }
                return TimeDatumFormatter.SECONDS;
            }
            return TimeDatumFormatter.YEARS;
        }
        return TimeDatumFormatter.formatterForScale(this.digit + 1, range);
    }

    public static void main(String[] args) throws Exception {
        int i;
        System.err.println(OrdinalTimeDomainDivider.primeFactors(1000));
        List<Integer> factors = OrdinalTimeDomainDivider.factors(OrdinalTimeDomainDivider.primeFactors(1000));
        for (int i2 = 0; i2 < factors.size(); ++i2) {
            System.err.print(" " + factors.get(i2));
        }
        System.err.println("");
        DomainDivider div = new OrdinalTimeDomainDivider();
        DatumRange dr = DatumRangeUtil.parseTimeRange("2009");
        System.err.println(div.boundaryCount(dr.min(), dr.max()));
        System.err.println(div.boundaries(dr.min(), dr.max()));
        System.err.println(div.rangeContaining(dr.min()));
        System.err.println(div.coarserDivider(false).boundaryCount(dr.min(), dr.max()));
        System.err.println(div.finerDivider(false).boundaryCount(dr.min(), dr.max()));
        div = new OrdinalTimeDomainDivider(1000, 0, null);
        for (i = 0; i < 100; ++i) {
            System.err.println(div);
            div = div.finerDivider(false);
        }
        for (i = 0; i < 100; ++i) {
            div = div.coarserDivider(false);
            System.err.println(div);
        }
        for (i = 0; i < 30; ++i) {
            System.err.println(div);
            div = div.finerDivider(true);
        }
        for (i = 0; i < 30; ++i) {
            div = div.coarserDivider(true);
            System.err.println(div);
        }
    }

    static {
        for (int i = 0; i < N_DIGITS; ++i) {
            OrdinalTimeDomainDivider.FACTORS[i] = OrdinalTimeDomainDivider.factors(OrdinalTimeDomainDivider.primeFactors(MODULO[i]));
        }
    }
}

