/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.EnumerationDatumFormatterFactory;

public class EnumerationUnits
extends Units {
    private static final Logger logger = LoggerManager.getLogger("das2.datum.enum");
    private Map<Integer, Datum> ordinals;
    private int highestOrdinal;
    private Map<Object, Datum> objects;
    private Map<Datum, Object> invObjects;
    private Map<Integer, Integer> colors;
    private static Map<String, EnumerationUnits> unitsInstances;

    public EnumerationUnits(String id) {
        this(id, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumerationUnits(String id, String description) {
        super(id, description);
        EnumerationUnits enumerationUnits = this;
        synchronized (enumerationUnits) {
            if (unitsInstances == null) {
                unitsInstances = new HashMap<String, EnumerationUnits>();
            }
        }
        this.highestOrdinal = 0;
        this.ordinals = new ConcurrentHashMap<Integer, Datum>();
        this.objects = new ConcurrentHashMap<Object, Datum>();
        this.invObjects = new ConcurrentHashMap<Datum, Object>();
        this.colors = new ConcurrentHashMap<Integer, Integer>();
        unitsInstances.put(id, this);
    }

    public static Datum createDatumAndUnits(Object object) {
        return EnumerationUnits.create(object).createDatum(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum createDatum(int ival, Object sval, int color) {
        if (sval instanceof String) {
            sval = ((String)sval).trim();
        }
        if (this.objects.containsKey(sval)) {
            return this.objects.get(sval);
        }
        EnumerationUnits enumerationUnits = this;
        synchronized (enumerationUnits) {
            Datum d;
            if (this.objects.containsKey(sval)) {
                return this.objects.get(sval);
            }
            if (this.highestOrdinal < ival) {
                this.highestOrdinal = ival;
            }
            Integer ordinal = ival;
            Datum.Double result = new Datum.Double(ordinal, (Units)this);
            if (this.ordinals.containsKey(ordinal) && !this.invObjects.get(d = this.ordinals.get(ordinal)).equals(sval)) {
                throw new IllegalArgumentException("value already exists for this ordinal!");
            }
            this.ordinals.put(ordinal, result);
            this.invObjects.put(result, sval);
            this.objects.put(sval, result);
            this.colors.put(ordinal, color);
            return result;
        }
    }

    public int getColor(Datum d) {
        if (this.colors == null) {
            return 0xA0A0A0;
        }
        Integer c = this.colors.get((int)d.doubleValue(this));
        if (c == null) {
            return 0xA0A0A0;
        }
        return c;
    }

    public Datum createDatum(int ival, Object sval) {
        return this.createDatum(ival, sval, 0xA0A0A0);
    }

    public DatumVector createDatumVector(Object[] objects) {
        double[] doubles = new double[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            doubles[i] = this.createDatum(objects[i]).doubleValue(this);
        }
        return DatumVector.newDatumVector(doubles, (Units)this);
    }

    public boolean hasFillDatum() {
        return this.objects.containsKey("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum createDatum(Object object) {
        if (object instanceof String) {
            object = ((String)object).trim();
        }
        if (this.objects.containsKey(object)) {
            return this.objects.get(object);
        }
        EnumerationUnits enumerationUnits = this;
        synchronized (enumerationUnits) {
            if (this.objects.containsKey(object)) {
                return this.objects.get(object);
            }
            ++this.highestOrdinal;
            Integer ordinal = this.highestOrdinal;
            Datum.Double result = new Datum.Double(ordinal, (Units)this);
            this.ordinals.put(ordinal, result);
            this.invObjects.put(result, object);
            this.objects.put(object, result);
            return result;
        }
    }

    public synchronized Map<Integer, Datum> getValues() {
        return Collections.unmodifiableMap(this.ordinals);
    }

    @Override
    public Datum createDatum(int value) {
        Integer key = value;
        Datum d = this.ordinals.get(key);
        if (d != null) {
            return d;
        }
        throw new IllegalArgumentException("No Datum exists for this ordinal: " + value);
    }

    @Override
    public Datum createDatum(long value) {
        return this.createDatum((int)value);
    }

    @Override
    public Datum createDatum(Number value) {
        return this.createDatum(value.intValue());
    }

    public Object getObject(Datum datum) {
        if (this.invObjects.containsKey(datum)) {
            return this.invObjects.get(datum);
        }
        throw new IllegalArgumentException("This Datum doesn't map back to an object!  This shouldn't happen!");
    }

    public static synchronized EnumerationUnits create(Object o) {
        String ss = o.toString();
        ss = ss.trim();
        if (unitsInstances == null) {
            unitsInstances = new HashMap<String, EnumerationUnits>();
        }
        if (unitsInstances.containsKey(ss)) {
            return unitsInstances.get(ss);
        }
        EnumerationUnits result = new EnumerationUnits(ss);
        unitsInstances.put(ss, result);
        return result;
    }

    @Override
    public Datum createDatum(double d) {
        return this.createDatum((int)d);
    }

    @Override
    public Datum createDatum(double d, double resolution) {
        return this.createDatum((int)d);
    }

    @Override
    public DatumFormatterFactory getDatumFormatterFactory() {
        return EnumerationDatumFormatterFactory.getInstance();
    }

    @Override
    public Datum subtract(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("subtract on EnumerationUnit");
    }

    @Override
    public Datum add(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("add on EnumerationUnit");
    }

    @Override
    public Datum divide(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("divide on EnumerationUnit");
    }

    @Override
    public Datum multiply(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("multiply on EnumerationUnit");
    }

    @Override
    public Datum parse(String s) throws ParseException {
        Datum result = null;
        for (Object key : this.objects.keySet()) {
            if (!key.toString().equals(s)) continue;
            if (result == null) {
                result = this.objects.get(key);
                continue;
            }
            throw new IllegalStateException("Multiple Objects' string representations match");
        }
        if (result == null) {
            throw new ParseException("no objects match \"" + s + "\"", 0);
        }
        return result;
    }

    public synchronized int getHighestOrdinal() {
        return this.highestOrdinal;
    }

    @Override
    public double getFillDouble() {
        return this.createDatum("").doubleValue(this);
    }

    @Override
    public Datum getFillDatum() {
        return this.createDatum("");
    }

    @Override
    public boolean isFill(Number value) {
        return value.doubleValue() == this.getFillDouble();
    }

    @Override
    public double convertDoubleTo(Units toUnits, double value) {
        if (!(toUnits instanceof EnumerationUnits)) {
            throw new IllegalArgumentException("unable to convert ordinal data");
        }
        if (this == toUnits) {
            return value;
        }
        return ((EnumerationUnits)toUnits).createDatum(this.createDatum(value).toString()).doubleValue(toUnits);
    }

    @Override
    public String toString() {
        return this.getId() + "(ordinal)";
    }
}

