/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.LinearDomainDivider;
import org.das2.datum.LogDomainDivider;
import org.das2.datum.LogLinDomainDivider;
import org.das2.datum.LoggerManager;
import org.das2.datum.OrdinalTimeDomainDivider;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.DefaultDatumFormatter;

public final class DomainDividerUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.datum.ddiv");
    private static final String zeros100 = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

    public static DomainDivider getDomainDivider(Datum min, Datum max, boolean log) {
        if (UnitsUtil.isTimeLocation(min.getUnits())) {
            return new OrdinalTimeDomainDivider();
        }
        if (log) {
            return new LogDomainDivider();
        }
        return new LinearDomainDivider();
    }

    public static DomainDivider getDomainDivider(Datum min, Datum max) {
        return DomainDividerUtil.getDomainDivider(min, max, false);
    }

    private static String exp(int power) {
        StringBuilder buffer = new StringBuilder(power + 4);
        for (int i = 0; i < power - 1; ++i) {
            buffer.append('#');
        }
        buffer.append("0.#E0");
        return buffer.toString();
    }

    private static String zeros(int count) {
        if (count < 0) {
            return "0";
        }
        if (count <= 100) {
            return zeros100.substring(0, count + 2);
        }
        StringBuffer buff = new StringBuffer(count + 2).append("0.");
        for (int index = 0; index < count; ++index) {
            buff.append('0');
        }
        return buff.toString();
    }

    public static DatumFormatter getDatumFormatter(DomainDivider div, DatumRange range) {
        if (div instanceof OrdinalTimeDomainDivider) {
            OrdinalTimeDomainDivider otdiv = (OrdinalTimeDomainDivider)div;
            return otdiv.getFormatter(range);
        }
        if (div instanceof LogLinDomainDivider) {
            LogLinDomainDivider lldiv = (LogLinDomainDivider)div;
            int nFraction = lldiv.sigFigs();
            String format = DomainDividerUtil.exp(nFraction);
            DatumFormatterFactory factory = range.getUnits().getDatumFormatterFactory();
            try {
                return factory.newFormatter(format);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (div instanceof LogDomainDivider) {
            String format = "0.#E0";
            DatumFormatterFactory factory = range.getUnits().getDatumFormatterFactory();
            try {
                return factory.newFormatter(format);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        LinearDomainDivider ldiv = (LinearDomainDivider)div;
        DatumVector boundaries = ldiv.boundaries(range.min(), range.max());
        if (boundaries.getLength() <= 1) {
            try {
                logger.info("fall back to here, no formatting");
                return new DefaultDatumFormatter("0");
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        double stepSize = boundaries.get(1).subtract(boundaries.get(0)).doubleValue();
        int nsteps = (int)Math.round(boundaries.get(boundaries.getLength() - 1).subtract(boundaries.get(0)).divide(stepSize).doubleValue());
        DatumFormatter result = DatumUtil.bestFormatter(boundaries.get(0), boundaries.get(boundaries.getLength() - 1), nsteps);
        return result;
    }

    public static void main(String[] args) throws ParseException {
        DomainDivider ldd = new LinearDomainDivider();
        for (int i = 0; i < 12; ++i) {
            ldd = ldd.coarserDivider(false);
        }
        DatumRange range = new DatumRange(1.0E8, 2.0E8, Units.dimensionless);
        DatumFormatter df = DomainDividerUtil.getDatumFormatter(ldd, range);
        DatumVector dv = ldd.boundaries(range.min(), range.max());
        for (int i = 0; i < dv.getLength(); ++i) {
            System.err.println(df.format(dv.get(i)));
        }
    }
}

