/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.Serializable;
import java.util.Locale;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;

public class DatumRange
implements Comparable,
Serializable {
    private static final Logger logger = LoggerManager.getLogger("das2.datum");
    Datum s1;
    Datum s2;

    public DatumRange(Datum s1, Datum s2) {
        if (s2.lt(s1)) {
            throw new IllegalArgumentException("min > max: " + s1 + " > " + s2 + " width=" + DatumUtil.asOrderOneUnits(s2.subtract(s1)));
        }
        if (!s1.isFinite() || s1.isFill()) {
            // empty if block
        }
        if (!s2.isFinite() || s2.isFill()) {
            // empty if block
        }
        this.s1 = s1;
        this.s2 = s2.convertTo(s1.getUnits());
    }

    public DatumRange(double s1, double s2, Units units) {
        this(Datum.create(s1, units), Datum.create(s2, units));
    }

    public boolean intersects(DatumRange dr) {
        return this.s2.gt(dr.s1) && this.s1.lt(dr.s2);
    }

    public DatumRange intersection(DatumRange dr) {
        if (this.intersects(dr)) {
            Units units = this.getUnits();
            double s11 = this.s1.doubleValue(units);
            double s12 = dr.s1.doubleValue(units);
            double ls1 = Math.max(s11, s12);
            double s21 = this.s2.doubleValue(units);
            double s22 = dr.s2.doubleValue(units);
            double ls2 = Math.min(s21, s22);
            return new DatumRange(ls1, ls2, units);
        }
        throw new IllegalArgumentException("does not intersect: " + dr);
    }

    public boolean contains(DatumRange dr) {
        return this.s1.le(dr.s1) && dr.s2.le(this.s2);
    }

    public DatumRange union(DatumRange dr) {
        if (this.intersects(dr) || this.max().equals(dr.min()) || this.min().equals(dr.max())) {
            Units units = this.getUnits();
            double s11 = this.s1.doubleValue(units);
            double s12 = dr.s1.doubleValue(units);
            double s21 = this.s2.doubleValue(units);
            double s22 = dr.s2.doubleValue(units);
            return new DatumRange(Math.min(s11, s12), Math.max(s21, s22), units);
        }
        throw new IllegalArgumentException("does not intersect or touch: " + dr);
    }

    public boolean contains(Datum d) {
        return this.s1.le(d) && d.lt(this.s2);
    }

    public Datum width() {
        return this.s2.subtract(this.s1);
    }

    public String toString() {
        if (this.s1.getUnits() instanceof TimeLocationUnits) {
            try {
                return DatumRangeUtil.formatTimeRange(this);
            }
            catch (IllegalArgumentException ex) {
                return String.format(Locale.US, "%f %f \"%s\"", this.s1.doubleValue(this.getUnits()), this.s2.doubleValue(this.getUnits()), this.getUnits());
            }
        }
        Units u = this.getUnits();
        return "" + this.s1.getFormatter().format(this.s1, u) + " to " + this.s1.getFormatter().format(this.s2, u) + " " + u;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.s1 != null ? this.s1.hashCode() : 0);
        hash = 67 * hash + (this.s2 != null ? this.s2.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatumRange)) {
            return false;
        }
        if (!this.getUnits().isConvertibleTo(((DatumRange)o).getUnits())) {
            return false;
        }
        return this == o || 0 == this.compareTo(o);
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot compare to null");
        }
        if (!(o instanceof DatumRange)) {
            throw new IllegalArgumentException("argument is not a DatumRange");
        }
        DatumRange dr = (DatumRange)o;
        int comp = this.s1.compareTo(dr.s1);
        if (comp != 0) {
            return comp;
        }
        return this.s2.compareTo(dr.s2);
    }

    public DatumRange zoomOut(double factor) {
        double add = (factor - 1.0) / 2.0;
        return this.rescale(-add, 1.0 + add);
    }

    public DatumRange rescale(double min, double max) {
        Datum w = this.width();
        if (!w.isFinite()) {
            throw new RuntimeException("width is not finite");
        }
        if (w.doubleValue(w.getUnits()) == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        return new DatumRange(this.s1.add(w.multiply(min)), this.s1.add(w.multiply(max)));
    }

    public double normalize(Datum d) {
        return d.subtract(this.s1).divide(this.width()).doubleValue(Units.dimensionless);
    }

    public Datum min() {
        return this.s1;
    }

    public Datum max() {
        return this.s2;
    }

    public Datum middle() {
        return this.s1.add(this.s2.subtract(this.s1).divide(2.0));
    }

    public DatumRange next() {
        return this.rescale(1.0, 2.0);
    }

    public DatumRange previous() {
        return this.rescale(-1.0, 0.0);
    }

    public DatumRange convertTo(Units u) {
        return new DatumRange(this.min().convertTo(u), this.max().convertTo(u));
    }

    public DatumRange include(Datum d) {
        if (d.isFill()) {
            return this;
        }
        if (this.contains(d) || this.max().equals(d)) {
            return this;
        }
        Datum min = this.min().le(d) ? this.min() : d;
        Datum max = this.max().ge(d) ? this.max() : d;
        return new DatumRange(min, max);
    }

    public Units getUnits() {
        return this.s1.getUnits();
    }

    public static DatumRange newDatumRange(double min, double max, Units units) {
        return new DatumRange(Datum.create(min, units), Datum.create(max, units));
    }
}

