/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.io.Serializable;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;

public class Datum
implements Comparable,
Serializable {
    private Units units;
    private Number value;
    private double resolution;
    private transient DatumFormatter formatter;

    private Datum(Number value, Units units, double resolution) {
        this(value, units, units.getDatumFormatterFactory().defaultFormatter(), resolution);
    }

    private Datum(Number value, Units units, DatumFormatter formatter, double resolution) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = value;
        this.units = units;
        this.resolution = resolution;
        this.formatter = formatter;
    }

    protected double doubleValue() {
        return this.getValue().doubleValue();
    }

    public double doubleValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).doubleValue();
        }
        return this.getValue().doubleValue();
    }

    public double value() {
        if (UnitsUtil.isRatioMeasurement(this.units)) {
            return this.doubleValue(this.getUnits());
        }
        throw new IllegalArgumentException("datum is not ratio measurement: " + this);
    }

    public Datum abs() {
        if (UnitsUtil.isRatioMeasurement(this.units)) {
            if (this.getUnits().isFill(this.value)) {
                return this;
            }
            if (this.value.doubleValue() >= 0.0) {
                return this;
            }
            return this.getUnits().createDatum(Math.abs(this.value.doubleValue()));
        }
        throw new IllegalArgumentException("datum is not a ratio measurement: " + this);
    }

    public double getResolution(Units units) {
        Units offsetUnits = this.getUnits().getOffsetUnits();
        if (units != offsetUnits) {
            return offsetUnits.getConverter(units).convert(this.resolution);
        }
        return this.resolution;
    }

    protected int intValue() {
        return this.getValue().intValue();
    }

    public int intValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).intValue();
        }
        return this.getValue().intValue();
    }

    public Units getUnits() {
        return this.units;
    }

    protected Number getValue() {
        return this.value;
    }

    public boolean isFill() {
        return this.getUnits().isFill(this.getValue());
    }

    public Datum plus(Datum datum) {
        return this.add(datum);
    }

    public Datum minus(Datum datum) {
        return this.subtract(datum);
    }

    public Datum div(Datum datum) {
        return this.divide(datum);
    }

    public Datum power(double b) {
        if (UnitsUtil.isRatioMeasurement(this.units)) {
            return Datum.create(Math.pow(this.value(), 2.0), Units.dimensionless);
        }
        throw new IllegalArgumentException("power argument must be dimensionless");
    }

    public Datum power(Datum datum) {
        if (datum.getUnits() == Units.dimensionless && UnitsUtil.isRatioMeasurement(this.units)) {
            return Datum.create(Math.pow(this.value(), datum.value()), Units.dimensionless);
        }
        throw new IllegalArgumentException("power argument must be dimensionless");
    }

    public Datum negative() {
        if (UnitsUtil.isRatioMeasurement(this.units)) {
            return Datum.create(-1.0 * this.value(), this.units);
        }
        if (UnitsUtil.isNominalMeasurement(this.units)) {
            throw new IllegalArgumentException("units are Stevens ordinal");
        }
        if (UnitsUtil.isIntervalMeasurement(this.units)) {
            throw new IllegalArgumentException("units are Stevens interval measurement");
        }
        throw new IllegalArgumentException("units are not Stevens ratio measurement");
    }

    public Datum positive() {
        return this;
    }

    public Datum add(Datum datum) {
        Datum result = this.add(datum.getValue(), datum.getUnits());
        result.resolution = Math.sqrt(datum.resolution * datum.resolution + this.resolution * this.resolution);
        return result;
    }

    public Datum add(Number value, Units units) {
        return this.getUnits().add(this.getValue(), value, units);
    }

    public Datum add(double d, Units units) {
        return this.add(new java.lang.Double(d), units);
    }

    public Datum subtract(Datum datum) {
        Datum result = this.subtract(datum.getValue(), datum.getUnits());
        result.resolution = Math.sqrt(datum.resolution * datum.resolution + this.resolution * this.resolution);
        return result;
    }

    public Datum subtract(Number a, Units units) {
        Datum result = this.getUnits().subtract(this.getValue(), a, units);
        return result;
    }

    public Datum subtract(double d, Units units) {
        return this.subtract(new java.lang.Double(d), units);
    }

    private static double relativeErrorMult(double x, double dx, double y, double dy) {
        return Math.sqrt(dx / x * dx / x + dy / y * dy / y);
    }

    public Datum divide(Datum a) {
        Datum result = this.divide(a.getValue(), a.getUnits());
        result.resolution = Math.abs(result.doubleValue()) * Datum.relativeErrorMult(this.doubleValue(), this.resolution, a.doubleValue(), a.resolution);
        return result;
    }

    public Datum divide(Number a, Units units) {
        return this.getUnits().divide(this.getValue(), a, units);
    }

    public Datum divide(double d) {
        return this.divide(d, Units.dimensionless);
    }

    public Datum multiply(Datum a) {
        Datum result = this.multiply(a.getValue(), a.getUnits());
        result.resolution = result.doubleValue() * Datum.relativeErrorMult(this.doubleValue(), this.resolution, a.doubleValue(), a.resolution);
        return result;
    }

    public Datum multiply(Number a, Units units) {
        return this.getUnits().multiply(this.getValue(), a, units);
    }

    public Datum multiply(double d) {
        return this.multiply(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum convertTo(Units units) throws IllegalArgumentException {
        UnitsConverter muc = this.units.getConverter(units);
        Datum result = units.createDatum(muc.convert(this.getValue()));
        if (this.resolution != 0.0) {
            muc = this.units.getOffsetUnits().getConverter(units.getOffsetUnits());
            result.resolution = muc.convert(this.resolution);
        }
        return result;
    }

    public int hashCode() {
        long bits = this.getValue().hashCode();
        int doubleHash = (int)(bits ^ bits >>> 32);
        int unitsHash = this.units.hashCode();
        return doubleHash ^ unitsHash;
    }

    public boolean equals(Object a) throws IllegalArgumentException {
        return a != null && a instanceof Datum && this.equals((Datum)a);
    }

    public boolean equals(Datum a) throws IllegalArgumentException {
        return a != null && this.getUnits().isConvertibleTo(a.getUnits()) && this.compareTo(a) == 0;
    }

    public boolean lt(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) < 0;
    }

    public boolean gt(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) > 0;
    }

    public boolean le(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) <= 0;
    }

    public boolean ge(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) >= 0;
    }

    public int compareTo(Object a) throws IllegalArgumentException {
        if (!(a instanceof Datum)) {
            throw new IllegalArgumentException("comparable type mismatch");
        }
        return this.compareTo((Datum)a);
    }

    public int compareTo(Datum a) throws IllegalArgumentException {
        double d;
        if (this.units != a.units) {
            a = a.convertTo(this.units);
        }
        if ((d = this.getValue().doubleValue() - a.getValue().doubleValue()) == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public boolean isFinite() {
        return this.value.doubleValue() != java.lang.Double.POSITIVE_INFINITY && this.value.doubleValue() != java.lang.Double.NEGATIVE_INFINITY && !java.lang.Double.isNaN(this.value.doubleValue());
    }

    public String toString() {
        Datum d = this;
        if (this.getUnits().isConvertibleTo(Units.seconds)) {
            d = DatumUtil.asOrderOneUnits(d);
        }
        if (this.formatter == null) {
            return this.units.getDatumFormatterFactory().defaultFormatter().format(d);
        }
        return this.formatter.format(d);
    }

    public static Datum create(double value) {
        return Units.dimensionless.createDatum(value);
    }

    public static Datum create(double value, Units units) {
        if (units == null) {
            throw new NullPointerException("Units are null");
        }
        return units.createDatum(value);
    }

    public static Datum create(double value, Units units, DatumFormatter formatter) {
        Datum result = Datum.create(value, units);
        result.formatter = formatter;
        return result;
    }

    public static Datum create(double value, Units units, double resolution) {
        Datum result = units.createDatum(value, resolution);
        result.formatter = units.getDatumFormatterFactory().defaultFormatter();
        return result;
    }

    public static Datum create(double value, Units units, double resolution, DatumFormatter formatter) {
        Datum result = units.createDatum(value, resolution);
        result.formatter = formatter;
        return result;
    }

    public static Datum create(int value) {
        return Units.dimensionless.createDatum(value);
    }

    public static Datum create(int value, Units units) {
        return units.createDatum(value);
    }

    public DatumFormatter getFormatter() {
        return this.formatter;
    }

    public static class Double
    extends Datum {
        Double(Number value, Units units) {
            super(value, units, 0.0);
        }

        Double(double value, Units units) {
            super((Number)new java.lang.Double(value), units, 0.0);
        }

        Double(double value) {
            super((Number)new java.lang.Double(value), Units.dimensionless, 0.0);
        }

        Double(double value, Units units, double resolution) {
            super(new java.lang.Double(value), units, units.getDatumFormatterFactory().defaultFormatter(), resolution);
        }
    }
}

