/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;

public class Das2ServerTimeSeriesBrowse
implements TimeSeriesBrowse {
    DatumRange timeRange;
    Datum resolution;
    String uri;
    private static final Logger logger = LoggerManager.getLogger("apdss.das2server");

    @Override
    public void setTimeRange(DatumRange dr) {
        this.timeRange = dr;
    }

    @Override
    public void setTimeResolution(Datum d) {
        this.resolution = d;
    }

    @Override
    public String getURI() {
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        if (this.timeRange == null) {
            throw new IllegalArgumentException("either setTimeRange or setURI must be called to set the timeRange");
        }
        String stime = this.timeRange.min().toString().replace(" ", "+");
        String etime = this.timeRange.max().toString().replace(" ", "+");
        params.put("start_time", stime);
        params.put("end_time", etime);
        if (this.resolution == null) {
            params.remove("resolution");
        } else {
            params.put("resolution", String.valueOf(this.resolution.doubleValue(Units.seconds)));
        }
        split.params = URISplit.formatParams(params);
        String suri = URISplit.format(split);
        logger.log(Level.FINER, "tsb getURI->{0}", suri);
        return suri;
    }

    @Override
    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public Datum getTimeResolution() {
        return this.resolution;
    }

    @Override
    public void setURI(String suri) throws ParseException {
        logger.log(Level.FINER, "tsb setURI {0}", suri);
        this.uri = suri;
        URISplit split = URISplit.parse(suri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String startTime = (String)params.remove("start_time");
        String endTime = (String)params.get("end_time");
        String sresolution = (String)params.get("resolution");
        if (startTime != null && endTime != null) {
            this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
        }
        if (sresolution != null) {
            this.resolution = Units.seconds.parse(sresolution);
        }
    }

    @Override
    public String blurURI() {
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        params.remove("start_time");
        params.remove("end_time");
        params.remove("resolution");
        split.params = URISplit.formatParams(params);
        String suri = URISplit.format(split);
        logger.log(Level.FINER, "tsb blurURI->{0}", suri);
        return suri;
    }
}

