/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.CancelledOperationException;
import org.das2.DasException;
import org.das2.client.AccessDeniedException;
import org.das2.client.Authenticator;
import org.das2.client.DasServer;
import org.das2.client.DasServerException;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;
import org.das2.stream.MIME;
import org.das2.stream.StreamDescriptor;
import org.das2.util.CredentialsManager;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class Das2ServerDataSource
extends AbstractDataSource {
    private static final Map<String, String> keys = new HashMap<String, String>();
    private static final Logger logger = LoggerManager.getLogger("apdss.das2server");
    DatumRange timeRange;
    Datum resolution;
    String dsParams;
    List<String> tcaDesc;
    Map dsdfParams = null;

    public Das2ServerDataSource(URI uri) throws ParseException {
        super(uri);
        String str;
        String dataset;
        if (!"no".equals(this.params.get("tsb"))) {
            this.addCapability(TimeSeriesBrowse.class, this.getTimeSeriesBrowse());
        }
        HashMap<String, String> params2 = new HashMap<String, String>(this.params);
        params2.put("server", "dataset");
        if (this.params.get("dataset") == null && (dataset = (String)this.params.remove("arg_0")) != null) {
            this.params.put("dataset", dataset);
            params2.put("dataset", dataset);
            params2.remove("arg_0");
        }
        if ((str = (String)this.params.get("timerange")) != null) {
            str = str.replaceAll("\\+", " ");
            try {
                DatumRange tr = DatumRangeUtil.parseTimeRange(str);
                params2.put("start_time", tr.min().toString());
                params2.put("end_time", tr.max().toString());
                params2.remove("timerange");
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "unable to parse timerange {0}", str);
            }
        }
        LinkedHashMap<String, String> otherParams = new LinkedHashMap<String, String>(this.params);
        otherParams.remove("start_time");
        otherParams.remove("end_time");
        otherParams.remove("resolution");
        otherParams.remove("dataset");
        otherParams.remove("tsb");
        otherParams.remove("timerange");
        otherParams.remove("_res");
        otherParams.remove("intrinsic");
        otherParams.remove("item");
        otherParams.remove("interval");
        otherParams.remove("key");
        this.dsParams = URISplit.formatParams(otherParams);
        if (params2.get("start_time") != null && params2.get("end_time") != null) {
            this.timeRange = new DatumRange(Units.us2000.parse((String)params2.get("start_time")), Units.us2000.parse((String)params2.get("end_time")));
        }
        this.resolution = null;
        if (params2.get("resolution") != null) {
            this.resolution = Units.seconds.parse((String)params2.get("resolution"));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized QDataSet getDataSet(final ProgressMonitor mon) throws Exception {
        mon.started();
        params2 = new LinkedHashMap<String, String>();
        otherParams = new LinkedHashMap<String, String>(this.params);
        otherParams.remove("start_time");
        otherParams.remove("end_time");
        otherParams.remove("resolution");
        otherParams.remove("dataset");
        otherParams.remove("tsb");
        otherParams.remove("timerange");
        otherParams.remove("_res");
        otherParams.remove("intrinsic");
        item = (String)otherParams.remove("item");
        interval = (String)otherParams.remove("interval");
        key1 = (String)otherParams.remove("key");
        this.dsParams = URISplit.formatParams(otherParams);
        params2.put("server", "dataset");
        if (this.timeRange == null) {
            throw new IllegalArgumentException("timeRange is null");
        }
        params2.put("start_time", URLEncoder.encode(this.timeRange.min().toString(), "US-ASCII"));
        params2.put("end_time", URLEncoder.encode(this.timeRange.max().toString(), "US-ASCII"));
        sresolution = (String)this.params.get("_res");
        if (sresolution != null) {
            params2.remove("_res");
        }
        if ("true".equals(this.params.get("intrinsic"))) {
            sresolution = "0";
            params2.remove("intrinsic");
        }
        if (sresolution != null) {
            this.resolution = sresolution.trim().length() == 0 || sresolution.equals("0") != false ? null : Units.seconds.parse(sresolution);
        }
        if (this.resolution != null) {
            params2.put("resolution", "" + this.resolution.doubleValue(Units.seconds));
        } else {
            Das2ServerDataSource.logger.fine("resolution is not available, loading at intrinsic resolution");
        }
        dataset = (String)this.params.get("dataset");
        if (dataset == null) {
            dataset = (String)this.params.get("arg_0");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("dataset is not specified");
        }
        mon.setProgressMessage("request " + dataset);
        if (interval != null) {
            Das2ServerDataSource.logger.finer("dataset is a TCA, so do not use resolution");
            dsec = this.resolution == null ? Double.parseDouble(interval) : this.resolution.doubleValue(Units.seconds);
            iinterval = (int)dsec;
            if (iinterval < 1) {
                iinterval = 1;
            }
            params2.put("interval", URLEncoder.encode(String.valueOf(iinterval), "US-ASCII"));
            params2.remove("resolution");
        } else {
            Das2ServerDataSource.logger.finer("dataset is not a TCA, interval parameter is null");
        }
        params2.put("dataset", URLEncoder.encode(dataset, "US-ASCII"));
        if (this.dsParams.length() > 0) {
            if (this.dsParams.contains("+-") && !this.dsParams.startsWith("+")) {
                params2.put("params", this.dsParams);
            } else {
                params2.put("params", URLEncoder.encode(this.dsParams, "US-ASCII"));
            }
        }
        url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
        if (this.dsdfParams == null) {
            dsdfURL = this.resourceURI + "?server=dsdf&dataset=" + dataset;
            url3 = new URL(dsdfURL);
            Das2ServerDataSource.logger.log(Level.FINE, "opening {0}", url3);
            in = this.getInputStream(url3, dataset);
            channel = Channels.newChannel(in);
            map = new LinkedHashMap<K, V>();
            handler = new DataSetStreamHandler(new HashMap<K, V>(), mon){

                @Override
                public void streamDescriptor(StreamDescriptor sd) throws org.das2.stream.StreamException {
                    super.streamDescriptor(sd);
                    map.putAll(sd.getProperties());
                }
            };
            try {
                org.das2.stream.StreamTool.readStream(channel, handler);
            }
            catch (org.das2.stream.StreamException ex) {
                if (ex.getMessage().equals("noSuchDataSet")) {
                    throw new org.das2.stream.StreamException("noSuchDataSet: " + dataset);
                }
                throw new org.das2.stream.StreamException(ex.getMessage() + "\ndsdf request was\n" + url3);
            }
            finally {
                channel.close();
            }
            this.dsdfParams = map;
        }
        this.tcaDesc = new ArrayList<String>();
        iplane = 0;
        label = (String)this.dsdfParams.get("label");
        while (label != null) {
            this.tcaDesc.add(label);
            label = (String)this.dsdfParams.get("plane_" + ++iplane + ".label");
        }
        groupAccess = (String)this.dsdfParams.get("groupAccess");
        if (groupAccess != null && groupAccess.trim().length() > 0) {
            if (key1 == null) {
                k = this.resourceURI.toString() + "?" + (String)this.params.get("dataset");
                t = Das2ServerDataSource.keys.get(k);
                if (t == null) {
                    authenticator = new Authenticator(DasServer.create(this.resourceURI.toURL()), groupAccess);
                    key2 = authenticator.authenticate();
                    if (key2 != null) {
                        params2.put("key", key2.toString());
                        url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
                        Das2ServerDataSource.keys.put(k, key2.toString());
                    }
                } else {
                    params2.put("key", t);
                    url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
                }
            } else {
                params2.put("key", key1);
                url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
            }
        }
        qds = "1".equals(this.dsdfParams.get("qstream"));
        Das2ServerDataSource.logger.log(Level.FINE, "opening {0} {1}", new Object[]{qds != false ? "as qstream" : "as das2stream", url2});
        in = this.getInputStream(url2, dataset);
        mpin = new DasProgressMonitorInputStream(in, mon);
        channel = Channels.newChannel(mpin);
        mon.setProgressMessage("reading " + dataset);
        techContact = (String)this.dsdfParams.get("techContact");
        techContact = techContact == null ? "" : "\nTechnical Contact: " + techContact;
        if (qds) {
            try {
                eh = new QDataSetStreamHandler();
                StreamTool.readStream(channel, eh);
                result1 = eh.getDataSet();
                if (!QDataSetStreamHandler.isFlattenableJoin(result1)) ** GOTO lbl226
                result1 = eh.flattenJoin(result1);
            }
            catch (StreamException ex) {
                cause = ex.getCause();
                if (!mon.isFinished()) {
                    mon.finished();
                }
                if (cause != null && cause instanceof InterruptedIOException) {
                    Das2ServerDataSource.logger.log(Level.WARNING, ex.getMessage(), ex);
                    throw (InterruptedIOException)ex.getCause();
                }
                if (cause != null && cause instanceof NoDataInIntervalException) {
                    throw (NoDataInIntervalException)ex.getCause();
                }
                if (ex.getMessage().contains("Empty response from reader")) {
                    throw new NoDataInIntervalException(ex.getMessage() + techContact);
                }
                if (ex.getMessage().contains("No data found")) {
                    throw new NoDataInIntervalException(ex.getMessage());
                }
                throw new org.das2.stream.StreamException(ex.getMessage() + "\ndataset request was\n" + url2 + techContact);
            }
        } else {
            handler = new DataSetStreamHandler(new HashMap<K, V>(), mon){

                @Override
                public void streamDescriptor(StreamDescriptor sd) throws org.das2.stream.StreamException {
                    super.streamDescriptor(sd);
                    if (mon.getTaskSize() != -1L) {
                        mpin.setEnableProgressPosition(false);
                    }
                }
            };
            try {
                org.das2.stream.StreamTool.readStream(channel, handler);
            }
            catch (org.das2.stream.StreamException ex) {
                mon.finished();
                cause = ex.getCause();
                if (ex.getCause() != null && ex.getCause() instanceof InterruptedIOException) {
                    Das2ServerDataSource.logger.log(Level.INFO, ex.getMessage(), ex);
                    if (ex.getMessage().contains("Operation cancelled")) {
                        throw new CancelledOperationException(techContact);
                    }
                    throw (InterruptedIOException)ex.getCause();
                }
                if (cause != null && cause instanceof NoDataInIntervalException) {
                    throw (NoDataInIntervalException)ex.getCause();
                }
                if (ex.getMessage().contains("Empty response from reader")) {
                    throw new NoDataInIntervalException(ex.getMessage() + " " + techContact);
                }
                if (ex.getMessage().contains("No data found")) {
                    throw new NoDataInIntervalException(ex.getMessage());
                }
                ex = new org.das2.stream.StreamException(ex.getMessage() + "\ndataset request was \n" + url2 + " " + techContact);
                Das2ServerDataSource.logger.log(Level.INFO, ex.getMessage(), ex);
                throw ex;
            }
            if (!mon.isFinished()) {
                mon.finished();
            }
            if ((ds = handler.getDataSet()) == null) {
                return null;
            }
            if (ds.getXLength() == 0) {
                throw new RuntimeException("empty dataset returned");
            }
            if (item == null || item.equals("")) {
                result = DataSetAdapter.create(ds);
            } else {
                das2ds = ds.getPlanarView(item);
                if (das2ds == null) {
                    if (item.contains(",")) {
                        bds = null;
                        for (String s : ss = item.split(",")) {
                            das2ds = ds.getPlanarView(s);
                            if (das2ds == null) {
                                iitem = Integer.parseInt(s);
                                das2ds = iitem == 0 ? ds.getPlanarView("") : ds.getPlanarView("plane_" + iitem);
                            }
                            bds1 = DataSetAdapter.create(das2ds);
                            bds = (BundleDataSet)Ops.bundle(bds, bds1);
                        }
                        result = bds;
                    } else {
                        try {
                            iitem = Integer.parseInt(item);
                            das2ds = iitem == 0 ? ds.getPlanarView("") : ds.getPlanarView("plane_" + iitem);
                            if (das2ds == null) {
                                ss = ds.getPlaneIds();
                                das2ds = ds.getPlanarView(ss[iitem]);
                            }
                            if (das2ds == null) {
                                throw new IllegalArgumentException("no such plane, looking for " + item);
                            }
                            result = DataSetAdapter.create(das2ds);
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalArgumentException("unable to find component \"" + item + "\"");
                        }
                    }
                } else {
                    result = DataSetAdapter.create(das2ds);
                }
            }
            if (this.tcaDesc != null && this.tcaDesc.size() > 0) {
                if (item == null || item.equals("") || item.equals("0")) {
                    bds = (QDataSet)result.property("BUNDLE_1");
                    if (bds != null && bds instanceof BundleDataSet.BundleDescriptor) {
                        bds1 = (BundleDataSet.BundleDescriptor)bds;
                        for (i = 0; i < bds1.length(); ++i) {
                            bds1.putProperty("LABEL", i, this.tcaDesc.get(i));
                        }
                    } else {
                        result.putProperty("LABEL", this.tcaDesc.get(0));
                    }
                } else if (!item.contains(",")) {
                    result.putProperty("LABEL", this.tcaDesc.get(Integer.parseInt(item)));
                }
            }
            result1 = result;
        }
lbl226:
        // 3 sources

        Das2ServerDataSource.logger.fine("  done. ");
        try {
            prop = "DEPEND_0";
            dep = (QDataSet)result1.property(prop);
            if (dep == null && (o = result1.property(prop = "JOIN_0")) instanceof QDataSet) {
                dep = (QDataSet)o;
            }
            if (dep != null && dep.property("CACHE_TAG") == null) {
                if (SemanticOps.isBundle(result1)) {
                    bounds = SemanticOps.bounds(dep);
                    ct = new CacheTag(DataSetUtil.asDatumRange(bounds.slice(1), true), this.resolution);
                } else {
                    bounds = SemanticOps.bounds(result1);
                    ct = new CacheTag(DataSetUtil.asDatumRange(bounds.slice(0), true), this.resolution);
                }
                dep2 = DataSetOps.makePropertiesMutable(dep);
                dep2.putProperty("CACHE_TAG", ct);
                result2 = DataSetOps.makePropertiesMutable(result1);
                result2.putProperty(prop, dep2);
                return result2;
            }
        }
        catch (IllegalArgumentException ex) {
            Das2ServerDataSource.logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        if (!mon.isFinished()) {
            mon.finished();
        }
        return result1;
    }

    private InputStream getInputStream(URL url, String sDataSetId) throws IOException, DasException {
        InputStream in;
        block13: {
            int nStatus;
            block14: {
                in = null;
                int nRedirects = 0;
                String sLocId = null;
                String sBasicHash = null;
                CredentialsManager cm = CredentialsManager.getMannager();
                while (true) {
                    URLConnection conn = url.openConnection();
                    if (sBasicHash != null) {
                        conn.setRequestProperty("Authorization", "Basic " + sBasicHash);
                    }
                    conn.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                    conn.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
                    if (!(conn instanceof HttpURLConnection)) {
                        in = conn.getInputStream();
                        break block13;
                    }
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    nStatus = httpConn.getResponseCode();
                    if (nStatus / 100 == 2) {
                        in = conn.getInputStream();
                        break block13;
                    }
                    if (nStatus / 100 == 3) {
                        String sLoc = httpConn.getHeaderField("Location");
                        if (sLoc == null) {
                            throw new DasServerException("Redirection response missing location header");
                        }
                        if (nRedirects > 20) {
                            throw new DasServerException("Client has been redirected more than 20 times");
                        }
                        url = new URL(sLoc);
                        ++nRedirects;
                        continue;
                    }
                    if (nStatus / 100 == 5) {
                        String sMime = httpConn.getContentType();
                        if (!MIME.isDataStream(sMime)) {
                            throw new DasServerException(String.format("Server error encountered accessing URL %s", url.toString()));
                        }
                        in = httpConn.getErrorStream();
                        break block13;
                    }
                    if (nStatus != 401) break block14;
                    if (sLocId != null) {
                        cm.invalidate(sLocId);
                    }
                    String auth = httpConn.getHeaderField("WWW-Authenticate");
                    Pattern p = Pattern.compile("Basic realm=\"(.*)\"");
                    Matcher m = p.matcher(auth);
                    String readAccessGroup = m.matches() ? m.group(1) : "das2 server";
                    sLocId = this.resourceURI.toURL().toString() + "|" + readAccessGroup;
                    if (!cm.hasCredentials(sLocId)) {
                        DasServer svr = DasServer.create(url);
                        String sDesc = String.format("<html><h3>%s</h3><hr>Server: <b>%s</b><br>Data Set: <b>%s</b>", svr.getName(), svr.getHost(), sDataSetId);
                        cm.setDescription(sLocId, sDesc, svr.getLogo());
                    }
                    if ((sBasicHash = cm.getHttpBasicHash(sLocId)) == null) break;
                }
                throw new AccessDeniedException("User credentials are not available for URL: " + url);
            }
            if (nStatus == 400 || nStatus == 404) {
                throw new DasServerException("Query error in request for URL: " + url);
            }
            if (nStatus == 403) {
                throw new AccessDeniedException("Access denied for URL:" + url);
            }
            throw new DasServerException(String.format("Completly unexpected server error encountered accessing URL %s, status code %d received from server.", url.toString(), nStatus));
        }
        return in;
    }

    public final TimeSeriesBrowse getTimeSeriesBrowse() {
        return new TimeSeriesBrowse(){

            @Override
            public void setTimeRange(DatumRange dr) {
                logger.log(Level.FINE, "setTimeRange to {0} ({1})", new Object[]{dr, dr.width().toString()});
                Das2ServerDataSource.this.timeRange = dr;
            }

            @Override
            public void setTimeResolution(Datum d) {
                logger.log(Level.FINE, "setTimeResolution to {0}", d);
                Das2ServerDataSource.this.resolution = d;
            }

            @Override
            public String getURI() {
                LinkedHashMap<String, String> c = new LinkedHashMap<String, String>(Das2ServerDataSource.this.params);
                String stime = Das2ServerDataSource.this.timeRange.min().toString().replace(" ", "+");
                String etime = Das2ServerDataSource.this.timeRange.max().toString().replace(" ", "+");
                c.put("start_time", stime);
                c.put("end_time", etime);
                if (Das2ServerDataSource.this.resolution != null) {
                    double resSec = Das2ServerDataSource.this.resolution.doubleValue(Units.seconds);
                    resSec = (double)Math.round(resSec * 1000.0) / 1000.0;
                    c.put("resolution", String.valueOf(resSec));
                } else {
                    logger.fine("no resolution specified");
                }
                if (Das2ServerDataSource.this.params.containsKey("interval")) {
                    c.put("interval", (String)Das2ServerDataSource.this.params.get("interval"));
                }
                String sparams = URISplit.formatParams(c);
                return "vap+das2server:" + Das2ServerDataSource.this.resourceURI + "?" + sparams;
            }

            @Override
            public String blurURI() {
                String sparams = "dataset=" + (String)Das2ServerDataSource.this.params.get("dataset");
                if (Das2ServerDataSource.this.params.containsKey("interval")) {
                    sparams = sparams + "&interval=" + (String)Das2ServerDataSource.this.params.get("interval");
                }
                if (Das2ServerDataSource.this.dsParams != null && Das2ServerDataSource.this.dsParams.trim().length() > 0) {
                    sparams = sparams + "&" + Das2ServerDataSource.this.dsParams;
                }
                return "vap+das2server:" + Das2ServerDataSource.this.resourceURI + "?" + sparams;
            }

            @Override
            public DatumRange getTimeRange() {
                return Das2ServerDataSource.this.timeRange;
            }

            @Override
            public Datum getTimeResolution() {
                return Das2ServerDataSource.this.resolution;
            }

            @Override
            public void setURI(String suri) throws ParseException {
                URISplit split = URISplit.parse(Das2ServerDataSource.this.uri);
                LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
                String startTime = (String)params.remove("start_time");
                String endTime = (String)params.get("end_time");
                String sresolution = (String)params.get("resolution");
                if (startTime != null && endTime != null) {
                    Das2ServerDataSource.this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
                }
                if (sresolution != null) {
                    Das2ServerDataSource.this.resolution = Units.seconds.parse(sresolution);
                }
            }
        };
    }

    @Override
    public String getURI() {
        return super.getURI();
    }

    @Override
    public String toString() {
        return this.resourceURI + "?" + (String)this.params.get("dataset");
    }
}

