/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;

public class VectorDataSetAdapter
implements VectorDataSet {
    Units xunits;
    Units yunits;
    QDataSet x;
    QDataSet y;
    HashMap<String, QDataSet> planes;
    HashMap properties = new HashMap();

    public static VectorDataSet create(QDataSet y) {
        QDataSet xds = SemanticOps.xtagsDataSet(y);
        Units xunits = SemanticOps.getUnits(xds);
        if (UnitsUtil.isTimeLocation(xunits)) {
            UnitsConverter uc = UnitsConverter.getConverter(xunits, Units.us2000);
            ArrayDataSet xx = ArrayDataSet.copy(xds);
            for (int i = 0; i < xds.length(); ++i) {
                xx.putValue(i, uc.convert(xx.value(i)));
            }
            xx.putProperty("UNITS", Units.us2000);
            xds = xx;
        }
        return new VectorDataSetAdapter(y, xds);
    }

    public static VectorDataSet createFromBundle(QDataSet bds) {
        QDataSet bdesc = (QDataSet)bds.property("BUNDLE_1");
        int dependentParameter = bdesc.length() - 1;
        QDataSet y = DataSetOps.unbundle(bds, dependentParameter);
        QDataSet x = (QDataSet)y.property("DEPEND_0");
        String context = (String)bdesc.property("CONTEXT_0", dependentParameter);
        if (context != null) {
            String[] ss = context.split(",");
            if (ss.length == 1 && x != null) {
                y = DataSetOps.unbundle(bds, ss[0]);
            } else if (ss.length == 2) {
                QDataSet z = y;
                if (x == null) {
                    x = DataSetOps.unbundle(bds, ss[0]);
                }
                y = DataSetOps.unbundle(bds, ss[1]);
                ((MutablePropertyDataSet)y).putProperty("PLANE_0", z);
            } else if (ss.length == 1) {
                x = DataSetOps.unbundle(bds, ss[0]);
            }
        }
        return new VectorDataSetAdapter(y, x);
    }

    public VectorDataSetAdapter(QDataSet y, QDataSet x) {
        QDataSet dp;
        Number n;
        RankZeroDataSet cadence;
        String name;
        QDataSet pds;
        if (y.rank() != 1) {
            throw new IllegalArgumentException("y (rank=" + y.rank() + ") is not rank 1");
        }
        if (x == null) {
            x = new IndexGenDataSet(y.length());
        }
        if (x.rank() != 1) {
            throw new IllegalArgumentException("x (rank=" + x.rank() + ") is not rank 1");
        }
        this.xunits = (Units)x.property("UNITS");
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        this.yunits = (Units)y.property("UNITS");
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.planes = new LinkedHashMap<String, QDataSet>();
        this.planes.put("", y);
        for (int i = 0; i < 50 && (pds = (QDataSet)y.property(name = "PLANE_" + i)) != null; ++i) {
            if (i == 0) {
                this.planes.put(name, pds);
            }
            if (pds.property("NAME") != null) {
                name = (String)pds.property("NAME");
            }
            this.planes.put(name, pds);
        }
        Boolean xMono = (Boolean)x.property("MONOTONIC");
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (RankZeroDataSet)x.property("CADENCE")) != null) {
            Datum dcadence = DataSetUtil.asDatum(cadence);
            this.properties.put("xTagWidth", dcadence);
        }
        if (!(y.property("FILL_VALUE") == null && y.property("VALID_MIN") == null && y.property("VALID_MAX") == null || (n = (Number)y.property("FILL_VALUE")) != null && n.doubleValue() == -1.0E31)) {
            QDataSet wds = DataSetUtil.weightsDataSet(y);
            this.planes.put("weights", wds);
        }
        if ((dp = (QDataSet)this.y.property("DELTA_PLUS")) != null) {
            if (dp.property("UNITS") == null) {
                dp = DDataSet.copy(dp);
                ((MutablePropertyDataSet)dp).putProperty("UNITS", this.yunits.getOffsetUnits());
            }
            this.planes.put("Y_DELTA_PLUS", dp);
        }
        if ((dp = (QDataSet)this.y.property("DELTA_MINUS")) != null) {
            if (dp.property("UNITS") == null) {
                dp = DDataSet.copy(dp);
                ((MutablePropertyDataSet)dp).putProperty("UNITS", this.yunits.getOffsetUnits());
            }
            this.planes.put("Y_DELTA_MINUS", dp);
        }
    }

    @Override
    public Datum getDatum(int i) {
        return this.yunits.createDatum(this.y.value(i));
    }

    @Override
    public double getDouble(int i, Units units) {
        return this.yunits.convertDoubleTo(units, this.y.value(i));
    }

    @Override
    public int getInt(int i, Units units) {
        return (int)this.yunits.convertDoubleTo(units, this.y.value(i));
    }

    @Override
    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.y.property(name);
    }

    @Override
    public Map getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("UNITS", null);
        HashMap<String, Object> m = new HashMap<String, Object>(DataSetUtil.getProperties(this.y, result));
        m.putAll(this.properties);
        return m;
    }

    @Override
    public Units getXUnits() {
        return this.xunits;
    }

    @Override
    public Units getYUnits() {
        return this.yunits;
    }

    @Override
    public Datum getXTagDatum(int i) {
        return this.xunits.createDatum(this.x.value(i));
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    @Override
    public int getXTagInt(int i, Units units) {
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    @Override
    public int getXLength() {
        return this.x.length();
    }

    @Override
    public DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        if (this.planes.containsKey(planeID)) {
            return new VectorDataSetAdapter(this.planes.get(planeID), this.x);
        }
        return null;
    }

    @Override
    public String[] getPlaneIds() {
        return this.planes.keySet().toArray(new String[this.planes.keySet().size()]);
    }

    public String toString() {
        return DataSetUtil.toString(this.y);
    }
}

