/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import ProGAL.geom2d.Point;
import ProGAL.geom2d.Triangle;
import ProGAL.geom2d.delaunay.DTWithBigPoints;
import ProGAL.geom2d.delaunay.Vertex;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;

public class TriScatRebinner
implements DataSetRebinner {
    private static final Logger logger = LoggerManager.getLogger("das2.data.rebinner");
    DTWithBigPoints triangulation = null;
    WeakReference<QDataSet> trids = null;

    private static double area(Point a, Point b, Point c) {
        return Math.abs(a.x() * (b.y() - c.y()) + b.x() * (c.y() - a.y()) + c.x() * (a.y() - b.y())) / 2.0;
    }

    private Rectangle2D getBounds(ProGAL.geom2d.delaunay.Triangle t) {
        Rectangle2D.Double r = new Rectangle2D.Double(t.getCorner(0).x(), t.getCorner(0).y(), 0.0, 0.0);
        r.add(new Point2D.Double(t.getCorner(1).x(), t.getCorner(1).y()));
        r.add(new Point2D.Double(t.getCorner(2).x(), t.getCorner(2).y()));
        return r;
    }

    @Override
    public QDataSet rebin(QDataSet ds, RebinDescriptor rebinDescX, RebinDescriptor rebinDescY) {
        DTWithBigPoints rt;
        QDataSet ds1;
        QDataSet yy;
        QDataSet xx;
        LoggerManager.resetTimer("triscat rebin");
        WritableDataSet result = Ops.zeros(rebinDescX.numberOfBins(), rebinDescY.numberOfBins());
        rebinDescX.setOutOfBoundsAction(-3);
        rebinDescY.setOutOfBoundsAction(-3);
        QDataSet zz = Schemes.isSimpleSpectrogram(ds) ? Ops.flatten(ds) : ds;
        if (Schemes.isBundleDataSet(zz)) {
            logger.fine("is bundle");
            xx = DataSetOps.slice1(zz, 0);
            yy = DataSetOps.slice1(zz, 1);
            zz = DataSetOps.slice1(zz, zz.length(0) - 1);
        } else {
            xx = zz.property("DEPEND_0") != null ? (QDataSet)zz.property("DEPEND_0") : Ops.findgen(zz.length());
            if (zz.property("DEPEND_1") != null) {
                yy = (QDataSet)zz.property("DEPEND_1");
            } else if (Schemes.isLegacyXYZScatter(zz)) {
                yy = zz;
                zz = (QDataSet)yy.property("PLANE_0");
            } else {
                yy = Ops.findgen(zz.length());
            }
        }
        LoggerManager.markTime("got X Y Z datasets");
        QDataSet extentX = Ops.extent(xx);
        QDataSet extentY = Ops.extent(yy);
        double[] dX = new double[]{extentX.value(0), extentX.value(1) - extentX.value(0)};
        double[] dY = new double[]{extentY.value(0), extentY.value(1) - extentY.value(0)};
        QDataSet qDataSet = ds1 = this.trids == null ? null : (QDataSet)this.trids.get();
        if (ds1 == null || ds1 != ds) {
            ArrayList<Point> points = new ArrayList<Point>(xx.length());
            double fuzz = 1.0E-4;
            for (int i = 0; i < xx.length(); ++i) {
                points.add(new VertexInt((xx.value(i) - dX[0]) / dX[1] + fuzz, (yy.value(i) - dY[0]) / dY[1] + fuzz, i));
                fuzz = -1.0 * fuzz;
            }
            LoggerManager.markTime("added points");
            this.triangulation = rt = new DTWithBigPoints(points);
            this.trids = new WeakReference<QDataSet>(ds);
            LoggerManager.markTime("triangulation done");
        } else {
            rt = this.triangulation;
        }
        QDataSet wds = DataSetUtil.weightsDataSet(zz);
        Number fill = (Number)wds.property("FILL_VALUE");
        double dfill = fill == null ? -1.0E38 : fill.doubleValue();
        result.putProperty("FILL_VALUE", dfill);
        boolean hasFill = false;
        Units xunits = SemanticOps.getUnits(xx);
        Units yunits = SemanticOps.getUnits(yy);
        LoggerManager.markTime("begin interp all pixels");
        Triangle t = null;
        int dir = 1;
        boolean triUsable = true;
        DataSetBuilder xs = new DataSetBuilder(1, 100);
        DataSetBuilder ys = new DataSetBuilder(1, 100);
        boolean i = false;
        for (ProGAL.geom2d.delaunay.Triangle t1 : rt.getTriangles()) {
            if (!(t1.getCorner(0) instanceof VertexInt) || !(t1.getCorner(1) instanceof VertexInt) || !(t1.getCorner(2) instanceof VertexInt)) continue;
            Rectangle2D r = this.getBounds(t1);
            xs.nextRecord(r.getWidth());
            ys.nextRecord(r.getHeight());
        }
        DDataSet xss = xs.getDataSet();
        DDataSet yss = ys.getDataSet();
        Datum dxlimit = Ops.datum(Ops.mean(xss)).add(Ops.datum(Ops.stddev(xss)).multiply(3.0));
        Datum dylimit = Ops.datum(Ops.mean(yss)).add(Ops.datum(Ops.stddev(yss)).multiply(3.0));
        double xlimit = dxlimit.doubleValue(Units.dimensionless);
        double ylimit = dylimit.doubleValue(Units.dimensionless);
        for (int ix = 0; ix < rebinDescX.numberOfBins(); ++ix) {
            int iy;
            int n = iy = dir == 1 ? 0 : rebinDescY.numberOfBins() - 1;
            while (dir == 1 ? iy < rebinDescY.numberOfBins() : iy >= 0) {
                Point thePoint = new Point((rebinDescX.binCenter(ix, xunits) - dX[0]) / dX[1], (rebinDescY.binCenter(iy, yunits) - dY[0]) / dY[1]);
                ProGAL.geom2d.delaunay.Triangle t1 = rt.walk(thePoint, null, (ProGAL.geom2d.delaunay.Triangle)t);
                if (t1 != t) {
                    Rectangle2D r = this.getBounds(t1);
                    triUsable = r.getWidth() < xlimit && r.getHeight() < ylimit;
                    t = t1;
                }
                Point[] abc = new Point[]{t.getCorner(0), t.getCorner(1), t.getCorner(2)};
                VertexInt[] abci = new VertexInt[3];
                hasFill = false;
                for (int k = 0; k < 3; ++k) {
                    if (!(abc[k] instanceof VertexInt)) {
                        result.putValue(ix, iy, dfill);
                        hasFill = true;
                        continue;
                    }
                    abci[k] = (VertexInt)abc[k];
                }
                if (hasFill || !triUsable) {
                    result.putValue(ix, iy, dfill);
                } else {
                    double d;
                    double[] w = new double[]{TriScatRebinner.area(thePoint, abc[1], abc[2]), TriScatRebinner.area(thePoint, abc[0], abc[2]), TriScatRebinner.area(thePoint, abc[0], abc[1])};
                    double n2 = w[0] + w[1] + w[2];
                    int k = 0;
                    while (k < 3) {
                        int n3 = k++;
                        w[n3] = w[n3] / n2;
                    }
                    try {
                        d = zz.value(abci[0].idx) * w[0] + zz.value(abci[1].idx) * w[1] + zz.value(abci[2].idx) * w[2];
                        result.putValue(ix, iy, d);
                    }
                    catch (NullPointerException ex) {
                        System.err.println("here151");
                        d = zz.value(abci[0].idx) * w[0] + zz.value(abci[1].idx) * w[1] + zz.value(abci[2].idx) * w[2];
                        result.putValue(ix, iy, d);
                    }
                }
                iy += dir;
            }
            dir = -dir;
        }
        LoggerManager.markTime("done interp all pixels");
        DataSetUtil.copyDimensionProperties(zz, result);
        if (!hasFill) {
            result.putProperty("FILL_VALUE", null);
        }
        result.putProperty("TRIANGULATION", rt);
        return result;
    }

    private static class VertexInt
    extends Vertex {
        int idx;

        VertexInt(double x, double y, int idx) {
            super(x, y);
            this.idx = idx;
        }

        @Override
        public String toString() {
            return String.format("(%.1f,%.1f)", this.x(), this.y());
        }
    }
}

