/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.dataset.WeightsTableDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.LocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.stream.DataTransferType;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamProducer;
import org.das2.stream.StreamXDescriptor;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.util.FixedWidthFormatter;

public class TableUtil {
    public static double[] getYTagArrayDouble(TableDataSet table, int itable, Units units) {
        double[] yy = new double[table.getYLength(itable)];
        for (int j = 0; j < yy.length; ++j) {
            yy[j] = table.getYTagDouble(itable, j, units);
        }
        return yy;
    }

    public static Datum getLargestYTag(TableDataSet tds) {
        Datum result = tds.getYTagDatum(0, tds.getYLength(0) - 1);
        for (int itable = 1; itable < tds.tableCount(); ++itable) {
            Datum r = tds.getYTagDatum(itable, tds.getYLength(itable) - 1);
            if (!r.gt(result)) continue;
            result = r;
        }
        return result;
    }

    public static Datum getSmallestYTag(TableDataSet tds) {
        Datum result = tds.getYTagDatum(0, 0);
        for (int itable = 1; itable < tds.tableCount(); ++itable) {
            Datum r = tds.getYTagDatum(itable, 0);
            if (!r.lt(result)) continue;
            result = r;
        }
        return result;
    }

    public static int closestRow(TableDataSet table, int itable, Datum datum) {
        return TableUtil.closestRow(table, itable, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestRow(TableDataSet table, int itable, double x, Units units) {
        double[] xx = TableUtil.getYTagArrayDouble(table, itable, units);
        return DataSetUtil.closest(xx, x);
    }

    public static Datum closestDatum(TableDataSet table, Datum x, Datum y) {
        int i = DataSetUtil.closestColumn(table, x);
        int j = TableUtil.closestRow(table, table.tableOfIndex(i), y);
        return table.getDatum(i, j);
    }

    public static int tableIndexAt(TableDataSet table, int i) {
        int itable = 0;
        while (table.tableEnd(itable) <= i) {
            ++itable;
        }
        return itable;
    }

    public static Datum guessYTagWidth(TableDataSet table) {
        return TableUtil.guessYTagWidth(table, 0);
    }

    public static Datum guessYTagWidth(TableDataSet table, int itable) {
        double y0 = table.getYTagDouble(itable, 0, table.getYUnits());
        double y1 = table.getYTagDouble(itable, 1, table.getYUnits());
        int n = table.getYLength(itable) - 1;
        double yn = table.getYTagDouble(itable, n, table.getYUnits());
        double cycles = (yn - y0) / ((y1 - y0) * (double)n);
        if (y1 < y0) {
            double t = y0;
            y0 = y1;
            y1 = t;
        }
        if (cycles > 10.0) {
            return Units.log10Ratio.createDatum(Math.log10(y1 / y0));
        }
        if ((yn - y0) / (double)n > y1 - y0) {
            return table.getYUnits().createDatum((yn - y0) / (double)n);
        }
        return table.getYUnits().createDatum(y1 - y0);
    }

    public static double tableMax(TableDataSet tds, Units units) {
        double result = Double.NEGATIVE_INFINITY;
        for (int itable = 0; itable < tds.tableCount(); ++itable) {
            int ny = tds.getYLength(itable);
            for (int i = tds.tableStart(itable); i < tds.tableEnd(itable); ++i) {
                for (int j = 0; j < ny; ++j) {
                    if (!(tds.getDouble(i, j, units) > result)) continue;
                    result = tds.getDouble(i, j, units);
                }
            }
        }
        return result;
    }

    public static void checkForNaN(TableDataSet tds) {
        for (int i = 0; i < tds.getXLength(); ++i) {
            for (int j = 0; j < 16; ++j) {
                double zz = tds.getDouble(i, j, tds.getZUnits());
                if (!Double.isNaN(zz)) continue;
                System.out.println("found NaN at " + i + "," + j);
                if (tds.getPlanarView("weights") == null) continue;
                System.out.println("  weight: " + ((TableDataSet)tds.getPlanarView("weights")).getDouble(i, j, Units.dimensionless));
            }
        }
    }

    protected static void checkForNaN(double[][] t) {
        for (int i = 0; i < t.length; ++i) {
            for (int j = 0; j < t[0].length; ++j) {
                double zz = t[i][j];
                if (!Double.isNaN(zz)) continue;
                System.out.println("found NaN at " + i + "," + j);
            }
        }
    }

    public static String toString(TableDataSet tds) {
        StringBuffer buffer = new StringBuffer();
        if (tds.tableCount() > 0) {
            buffer.append(tds.getYLength(0));
        }
        int tableCountLimit = 3;
        for (int i = 1; i < tds.tableCount() && i < tableCountLimit; ++i) {
            buffer.append(", " + tds.getYLength(i));
        }
        return "[" + tds.getXLength() + " xTags, " + buffer.toString() + " yTags]";
    }

    public static DatumVector getDatumVector(TableDataSet tds, int i) {
        Units zunits = tds.getZUnits();
        double[] array = new double[tds.getYLength(tds.tableOfIndex(i))];
        for (int j = 0; j < array.length; ++j) {
            array[j] = tds.getDouble(i, j, zunits);
        }
        return DatumVector.newDatumVector(array, zunits);
    }

    public static DatumVector getYTagsDatumVector(TableDataSet tds, int itable) {
        Units yunits = tds.getYUnits();
        DatumVector result = DatumVector.newDatumVector(TableUtil.getYTagArrayDouble(tds, itable, yunits), yunits);
        return result;
    }

    public static void dumpToAsciiStream(TableDataSet tds, Datum xmin, Datum xmax, OutputStream out) {
        PrintStream pout = new PrintStream(out);
        Datum base = null;
        Units offsetUnits = null;
        pout.print("This is not a das2 stream, even though it looks like it.");
        pout.print("[00]");
        pout.println("<stream start=\"" + xmin + "\" end=\"" + xmax + "\" >");
        pout.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        pout.print("</stream>");
        if (tds.getXUnits() instanceof LocationUnits && (offsetUnits = ((LocationUnits)(base = xmin).getUnits()).getOffsetUnits()) == Units.microseconds) {
            offsetUnits = Units.seconds;
        }
        pout.print("[01]<packet>\n");
        pout.print("<x type=\"asciiTab10\" ");
        if (base != null) {
            pout.print("base=\"" + base + "\" ");
            pout.print(" xUnits=\"" + offsetUnits + "\" ");
        } else {
            pout.print(" xUnits=\"" + tds.getXUnits());
        }
        pout.println(" />");
        StringBuilder yTagsString = new StringBuilder();
        yTagsString.append(tds.getYTagDatum(0, 0));
        for (int j = 1; j < tds.getYLength(0); ++j) {
            yTagsString.append(", ").append(tds.getYTagDatum(0, j));
        }
        pout.println("<yscan type=\"asciiTab10\" zUnits=\"" + tds.getZUnits() + "\" yTags=\"" + yTagsString + "\"/>");
        pout.print("</packet>");
        DecimalFormat xnf = new DecimalFormat("00000.000");
        DecimalFormat ynf = new DecimalFormat("0.00E00");
        double dx = xmax.subtract(xmin).doubleValue(offsetUnits);
        for (int i = 0; i < tds.getXLength(); ++i) {
            double x = base != null ? tds.getXTagDatum(i).subtract(base).doubleValue(offsetUnits) : tds.getXTagDouble(i, tds.getXUnits());
            if (!(x >= 0.0) || !(x < dx)) continue;
            pout.print(":01:");
            pout.print(xnf.format(x) + " ");
            int itable = tds.tableOfIndex(i);
            for (int j = 0; j < tds.getYLength(itable); ++j) {
                String delim = j + 1 == tds.getYLength(itable) ? "\n" : " ";
                pout.print(FixedWidthFormatter.format(ynf.format(tds.getDouble(i, j, tds.getZUnits())), 9) + delim);
            }
        }
        pout.close();
    }

    public static void dumpToAsciiStream(TableDataSet tds, OutputStream out) {
        TableUtil.dumpToAsciiStream(tds, Channels.newChannel(out));
    }

    public static void dumpToAsciiStream(TableDataSet tds, WritableByteChannel out) {
        TableUtil.dumpToDas2Stream(tds, out, true, true);
    }

    public static void dumpToBinaryStream(TableDataSet tds, OutputStream out) {
        TableUtil.dumpToDas2Stream(tds, Channels.newChannel(out), false, true);
    }

    public static void dumpToDas2Stream(QDataSet tds, WritableByteChannel out, boolean asciiTransferTypes, boolean sendStreamDescriptor) {
        try {
            DataTransferType zTransferType;
            DataTransferType xTransferType;
            if (tds.rank() == 2) {
                tds = Ops.join(null, tds);
            }
            QDataSet xds = SemanticOps.xtagsDataSet(tds);
            QDataSet yds = SemanticOps.ytagsDataSet(tds);
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            Units xunits = SemanticOps.getUnits(xds);
            Units yunits = SemanticOps.getUnits(yds);
            Units zunits = SemanticOps.getUnits(tds);
            properties.put("xUnits", xunits);
            properties.put("yUnits", yunits);
            properties.put("zUnits", zunits);
            Object o = xds.property("LABEL");
            properties.put("xLabel", o);
            o = yds.property("LABEL");
            properties.put("yLabel", o);
            o = tds.property("LABEL");
            properties.put("zLabel", o);
            if (asciiTransferTypes) {
                xTransferType = UnitsUtil.isTimeLocation(SemanticOps.getUnits(xds)) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii24");
                zTransferType = DataTransferType.getByName("ascii10");
            } else {
                zTransferType = DataTransferType.getByName("sun_real4");
                xTransferType = DataTransferType.getByName("sun_real8");
            }
            if (sendStreamDescriptor) {
                producer.streamDescriptor(sd);
            }
            DatumVector[] zValues = new DatumVector[1];
            for (int table = 0; table < tds.length(); ++table) {
                QDataSet tds1 = tds.slice(table);
                QDataSet xds1 = SemanticOps.xtagsDataSet(tds1);
                QDataSet yds1 = SemanticOps.ytagsDataSet(tds1);
                StreamXDescriptor xDescriptor = new StreamXDescriptor();
                xDescriptor.setUnits(xunits);
                xDescriptor.setDataTransferType(xTransferType);
                StreamYScanDescriptor yDescriptor = new StreamYScanDescriptor();
                yDescriptor.setDataTransferType(zTransferType);
                yDescriptor.setZUnits(zunits);
                yDescriptor.setYCoordinates(org.das2.qds.DataSetUtil.asDatumVector(yds1));
                PacketDescriptor pd = new PacketDescriptor();
                pd.setXDescriptor(xDescriptor);
                pd.addYDescriptor(yDescriptor);
                producer.packetDescriptor(pd);
                for (int i = 0; i < tds1.length(); ++i) {
                    Datum xTag = xunits.createDatum(xds1.value(i));
                    zValues[0] = org.das2.qds.DataSetUtil.asDatumVector(tds1.slice(i));
                    producer.packet(pd, xTag, zValues);
                }
            }
            if (sendStreamDescriptor) {
                producer.streamClosed(sd);
            }
        }
        catch (StreamException se) {
            throw new RuntimeException(se);
        }
    }

    public static void dumpToDas2Stream(TableDataSet tds, WritableByteChannel out, boolean asciiTransferTypes, boolean sendStreamDescriptor) {
        try {
            DataTransferType zTransferType;
            DataTransferType xTransferType;
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            Map properties = tds.getProperties();
            for (Map.Entry e : properties.entrySet()) {
                String key = (String)e.getKey();
                sd.setProperty(key, e.getValue());
            }
            if (asciiTransferTypes) {
                xTransferType = UnitsUtil.isTimeLocation(tds.getXUnits()) ? DataTransferType.getByName("time24") : DataTransferType.getByName("ascii24");
                zTransferType = DataTransferType.getByName("ascii10");
            } else {
                zTransferType = DataTransferType.getByName("sun_real4");
                xTransferType = DataTransferType.getByName("sun_real8");
            }
            if (sendStreamDescriptor) {
                producer.streamDescriptor(sd);
            }
            DatumVector[] zValues = new DatumVector[1];
            for (int table = 0; table < tds.tableCount(); ++table) {
                StreamXDescriptor xDescriptor = new StreamXDescriptor();
                xDescriptor.setUnits(tds.getXUnits());
                xDescriptor.setDataTransferType(xTransferType);
                StreamYScanDescriptor yDescriptor = new StreamYScanDescriptor();
                yDescriptor.setDataTransferType(zTransferType);
                yDescriptor.setZUnits(tds.getZUnits());
                yDescriptor.setYCoordinates(tds.getYTags(table));
                PacketDescriptor pd = new PacketDescriptor();
                pd.setXDescriptor(xDescriptor);
                pd.addYDescriptor(yDescriptor);
                producer.packetDescriptor(pd);
                for (int i = tds.tableStart(table); i < tds.tableEnd(table); ++i) {
                    Datum xTag = tds.getXTagDatum(i);
                    zValues[0] = tds.getScan(i);
                    producer.packet(pd, xTag, zValues);
                }
            }
            if (sendStreamDescriptor) {
                producer.streamClosed(sd);
            }
        }
        catch (StreamException se) {
            throw new RuntimeException(se);
        }
    }

    public static int getPreviousRow(TableDataSet ds, int itable, Datum datum) {
        int i = TableUtil.closestRow(ds, itable, datum);
        Units units = ds.getYUnits();
        double dir = ds.getYTagDouble(itable, 1, units) - ds.getYTagDouble(itable, 0, units);
        double dd = ds.getYTagDouble(itable, i, units) - datum.doubleValue(units);
        if (i > 0 && dir * dd > 0.0) {
            return i - 1;
        }
        return i;
    }

    public static int getNextRow(TableDataSet ds, int itable, Datum datum) {
        int i = TableUtil.closestRow(ds, itable, datum);
        Units units = ds.getYUnits();
        double dir = ds.getYTagDouble(itable, 1, units) - ds.getYTagDouble(itable, 0, units);
        double dd = ds.getYTagDouble(itable, i, units) - datum.doubleValue(units);
        if (i < ds.getYLength(itable) - 1 && dir * dd < 0.0) {
            return i + 1;
        }
        return i;
    }

    public static VectorDataSet collapse(TableDataSet ds, int offset, int length) {
        int itable = ds.tableOfIndex(offset);
        if (ds.tableOfIndex(offset + length - 1) != itable) {
            throw new IllegalArgumentException("collapse can't span multiple tables!");
        }
        int n = ds.getYLength(itable);
        Units zunits = ds.getZUnits();
        Units yunits = ds.getYUnits();
        VectorDataSetBuilder builder = new VectorDataSetBuilder(ds.getYUnits(), ds.getZUnits());
        TableDataSet weights = WeightsTableDataSet.create(ds);
        for (int j = 0; j < n; ++j) {
            double avg = 0.0;
            double weight = 0.0;
            for (int i = offset; i < offset + length; ++i) {
                double w = weights.getDouble(i, j, Units.dimensionless);
                avg += ds.getDouble(i, j, zunits) * w;
                weight += w;
            }
            double d = weight == 0.0 ? zunits.getFillDouble() : avg / weight;
            builder.insertY(ds.getYTagDouble(itable, j, yunits), d);
        }
        return builder.toVectorDataSet();
    }
}

