/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.ops.Ops;

public class ScatterRebinner
implements DataSetRebinner {
    private static final Logger logger = LoggerManager.getLogger("das2.data.rebinner");

    @Override
    public QDataSet rebin(QDataSet zds, RebinDescriptor rebinDescX, RebinDescriptor rebinDescY) {
        WritableDataSet result = Ops.zeros(rebinDescX.numberOfBins(), rebinDescY.numberOfBins());
        rebinDescX.setOutOfBoundsAction(-3);
        rebinDescY.setOutOfBoundsAction(-3);
        QDataSet xds = null;
        QDataSet yds = null;
        if (Schemes.isBundleDataSet(zds)) {
            logger.fine("is bundle");
            xds = DataSetOps.slice1(zds, 0);
            yds = DataSetOps.slice1(zds, 1);
            zds = DataSetOps.slice1(zds, zds.length(0) - 1);
        } else {
            xds = zds.property("DEPEND_0") != null ? (QDataSet)zds.property("DEPEND_0") : Ops.findgen(zds.length());
            if (zds.property("DEPEND_1") != null) {
                yds = (QDataSet)zds.property("DEPEND_1");
            } else if (Schemes.isLegacyXYZScatter(zds)) {
                yds = zds;
                zds = (QDataSet)yds.property("PLANE_0");
            } else {
                yds = Ops.findgen(zds.length());
            }
        }
        int nx = rebinDescX.numberOfBins() - 1;
        int ny = rebinDescY.numberOfBins() - 1;
        int xB = 0;
        int yB = 0;
        Units xdsUnits = SemanticOps.getUnits(xds);
        Units ydsUnits = SemanticOps.getUnits(yds);
        switch (zds.rank()) {
            case 0: {
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < zds.length(); ++i) {
                    switch (xds.rank()) {
                        case 0: {
                            xB = rebinDescX.whichBin(xds.value(), xdsUnits);
                            break;
                        }
                        case 1: {
                            xB = rebinDescX.whichBin(xds.value(i), xdsUnits);
                            break;
                        }
                        case 2: {
                            logger.fine(" Don't know what to do with rank 2 Depend 0 datasets yet.");
                            break;
                        }
                    }
                    switch (yds.rank()) {
                        case 0: {
                            yB = rebinDescY.whichBin(yds.value(), ydsUnits);
                            break;
                        }
                        case 1: {
                            yB = rebinDescY.whichBin(yds.value(i), ydsUnits);
                            break;
                        }
                        case 2: {
                            logger.fine(" Don't know what to do with rank 2 Depend 0 datasets yet.");
                            break;
                        }
                    }
                    if (xB == -1 || yB == -1) continue;
                    result.putValue(xB, yB, zds.value(i));
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < zds.length(); ++i) {
                    for (int j = 0; j < zds.length(i); ++j) {
                        switch (xds.rank()) {
                            case 0: {
                                xB = rebinDescX.whichBin(xds.value(), xdsUnits);
                                break;
                            }
                            case 1: {
                                xB = rebinDescX.whichBin(xds.value(i), xdsUnits);
                                break;
                            }
                            case 2: {
                                logger.fine(" Don't know what to do with rank 2 dataset here.");
                                break;
                            }
                        }
                        switch (yds.rank()) {
                            case 0: {
                                yB = rebinDescY.whichBin(yds.value(), ydsUnits);
                                break;
                            }
                            case 1: {
                                yB = rebinDescY.whichBin(yds.value(j), ydsUnits);
                                break;
                            }
                            case 2: {
                                logger.fine(" Don't know what to do with rank 2 dataset here.");
                                break;
                            }
                        }
                        if (xB == -1 || yB == -1) continue;
                        result.putValue(xB, yB, zds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                logger.fine("Does not support rank 3 datasets.");
                break;
            }
            default: {
                logger.fine("Rank is not 0, 1, 2 or 3 or not recognized.");
            }
        }
        int xHardBinPlus = 0;
        int xHardBinMinus = 0;
        int yHardBinPlus = 0;
        int yHardBinMinus = 0;
        int xSoftRad = 0;
        int ySoftRad = 0;
        Datum xDat = rebinDescX.binWidthDatum();
        ArrayList<Integer> xCadencesToSort = new ArrayList<Integer>();
        double[] xbinWidths = this.getBinWidths(rebinDescX);
        int[] xcadencesInBins = new int[xbinWidths.length];
        Units xoffsetUnits = xdsUnits.getOffsetUnits();
        if (xds != null) {
            QDataSet xMinus;
            QDataSet xPlus = (QDataSet)xds.property("BIN_PLUS");
            if (xPlus != null) {
                xHardBinPlus = (int)(xPlus.value() / xDat.doubleValue(xoffsetUnits));
            }
            if ((xMinus = (QDataSet)xds.property("BIN_MINUS")) != null) {
                xHardBinMinus = (int)(xMinus.value() / xDat.doubleValue(xoffsetUnits));
            }
            QDataSet xCad = (QDataSet)xds.property("CADENCE");
            double xCadenceVal = 0.0;
            if (xCad != null) {
                xCadenceVal = xCad.value();
                if (rebinDescX.isLog) {
                    xcadencesInBins = this.getCadenceValues(xbinWidths, xCadenceVal, -1);
                } else {
                    xcadencesInBins = null;
                    xSoftRad = (int)Math.round(xCadenceVal / xDat.doubleValue(xoffsetUnits));
                }
            } else {
                for (int i = 0; i < xds.length() - 1; ++i) {
                    int currentDataWidthx = rebinDescX.whichBin(xds.value(i + 1), xdsUnits) - rebinDescX.whichBin(xds.value(i), xdsUnits);
                    if (currentDataWidthx < 1) continue;
                    xCadencesToSort.add(currentDataWidthx);
                }
                Collections.sort(xCadencesToSort, Collections.reverseOrder());
                if (xCadencesToSort.size() >= 1) {
                    xCadenceVal = ((Integer)xCadencesToSort.get((int)Math.round(0.95 * (double)xCadencesToSort.size()))).intValue();
                    logger.log(Level.FINE, " X cadence from sorted list = {0}", xCadenceVal);
                } else {
                    logger.fine("No Cadences.");
                }
                if (rebinDescX.isLog) {
                    xcadencesInBins = this.getCadenceValues(xbinWidths, xCadenceVal, (Integer)xCadencesToSort.get(0));
                } else {
                    xcadencesInBins = null;
                    xSoftRad = (int)xCadenceVal;
                }
            }
        }
        Datum yDat = rebinDescY.binWidthDatum();
        ArrayList<Integer> yCadencesToSort = new ArrayList<Integer>();
        ArrayList<Double> yCadencesToSortValues = new ArrayList<Double>();
        double[] ybinWidths = this.getBinWidths(rebinDescY);
        int[] ycadencesInBins = new int[ybinWidths.length];
        Units yoffsetUnits = ydsUnits.getOffsetUnits();
        if (yds != null) {
            QDataSet yMinus;
            QDataSet yPlus = (QDataSet)yds.property("BIN_PLUS");
            if (yPlus != null) {
                yHardBinPlus = (int)(yPlus.value() / yDat.doubleValue(yoffsetUnits));
            }
            if ((yMinus = (QDataSet)yds.property("BIN_MINUS")) != null) {
                yHardBinMinus = (int)(yMinus.value() / yDat.doubleValue(yoffsetUnits));
            }
            QDataSet yCad = (QDataSet)yds.property("CADENCE");
            double yCadenceVal = 0.0;
            boolean yCadenceValueBin = false;
            if (yCad != null) {
                yCadenceVal = yCad.value();
                if (rebinDescY.isLog) {
                    ycadencesInBins = this.getCadenceValues(ybinWidths, yCadenceVal, -1);
                } else {
                    ycadencesInBins = null;
                    ySoftRad = (int)Math.round(yCadenceVal / yDat.doubleValue(yoffsetUnits));
                }
            } else {
                for (int i = 0; i < yds.length() - 1; ++i) {
                    int currentDataWidthy = rebinDescY.whichBin(yds.value(i + 1), yoffsetUnits) - rebinDescY.whichBin(yds.value(i), yoffsetUnits);
                    if (currentDataWidthy < 1) continue;
                    yCadencesToSort.add(currentDataWidthy);
                    yCadencesToSortValues.add(yds.value(i + 1) - yds.value(i));
                }
                Collections.sort(yCadencesToSort, Collections.reverseOrder());
                Collections.sort(yCadencesToSortValues, Collections.reverseOrder());
                int yCadSortIndex = 0;
                if (yCadencesToSortValues.size() >= 1) {
                    yCadSortIndex = (int)Math.round(0.95 * (double)yCadencesToSortValues.size());
                    yCadenceVal = (Double)yCadencesToSortValues.get(yCadSortIndex);
                    logger.log(Level.FINE, " Y cadence from sorted list = {0}", yCadenceVal);
                } else {
                    logger.fine("No Cadences.");
                }
                if (rebinDescY.isLog) {
                    ycadencesInBins = this.getCadenceValues(ybinWidths, yCadenceVal, (Integer)yCadencesToSort.get(yCadSortIndex));
                } else {
                    ycadencesInBins = null;
                    ySoftRad = (Integer)yCadencesToSort.get(yCadSortIndex);
                }
            }
        }
        if (xcadencesInBins != null) {
            logger.fine(" Cadences vary in X");
        } else {
            logger.log(Level.FINE, " x Cadence is = {0}", xSoftRad);
        }
        if (ycadencesInBins != null) {
            logger.fine(" Cadences vary in Y");
        } else {
            logger.log(Level.FINE, " y Cadence is = {0}", ySoftRad);
        }
        result = this.InterpolateHardAndSoftEdge(xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus, xSoftRad, ySoftRad, nx, ny, result, xcadencesInBins, ycadencesInBins);
        return result;
    }

    private WritableDataSet InterpolateHardAndSoftEdge(int xHardBinPlus, int xHardBinMinus, int yHardBinPlus, int yHardBinMinus, int xSoftRad1, int ySoftRad1, int xbins, int ybins, WritableDataSet data, int[] xVaryingCadenceBin, int[] yVaryingCadenceBin) {
        double[][] ValTimesWeightSum = new double[xbins + 1][ybins + 1];
        double[][] WeightSum = new double[xbins + 1][ybins + 1];
        int[][] count = new int[xbins + 1][ybins + 1];
        double[][] templateBox = this.CreateTemplateBox(xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus, 1, 1);
        int xSoftRad = xSoftRad1;
        int ySoftRad = ySoftRad1;
        int prevxSoftRad = 1;
        int prevySoftRad = 1;
        double value = 0.0;
        for (int ix = 0; ix <= xbins; ++ix) {
            if (xVaryingCadenceBin != null) {
                xSoftRad = xVaryingCadenceBin[ix];
            }
            for (int iy = 0; iy <= ybins; ++iy) {
                if (yVaryingCadenceBin != null) {
                    ySoftRad = yVaryingCadenceBin[iy];
                }
                if (!((value = data.value(ix, iy)) > 0.0)) continue;
                if (xSoftRad != prevxSoftRad || ySoftRad != prevySoftRad) {
                    templateBox = this.CreateTemplateBox(xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus, xSoftRad, ySoftRad);
                }
                prevxSoftRad = xSoftRad;
                prevySoftRad = ySoftRad;
                if (xSoftRad == 0 && ySoftRad == 0) continue;
                for (int i = -(xHardBinMinus + xSoftRad); i <= xHardBinPlus + xSoftRad; ++i) {
                    for (int j = -(yHardBinMinus + ySoftRad); j <= yHardBinPlus + ySoftRad; ++j) {
                        if (ix + i < 0 || ix + i > xbins || iy + j < 0 || iy + j > ybins || templateBox[i + xHardBinMinus + xSoftRad][j + yHardBinMinus + ySoftRad] == 0.0) continue;
                        double[] dArray = ValTimesWeightSum[ix + i];
                        int n = iy + j;
                        dArray[n] = dArray[n] + value * templateBox[i + xHardBinMinus + xSoftRad][j + yHardBinMinus + ySoftRad];
                        double[] dArray2 = WeightSum[ix + i];
                        int n2 = iy + j;
                        dArray2[n2] = dArray2[n2] + templateBox[i + xHardBinMinus + xSoftRad][j + yHardBinMinus + ySoftRad];
                        int[] nArray = count[ix + i];
                        int n3 = iy + j;
                        nArray[n3] = nArray[n3] + 1;
                    }
                }
            }
        }
        for (int ix2 = 0; ix2 <= xbins; ++ix2) {
            for (int iy2 = 0; iy2 <= ybins; ++iy2) {
                if (count[ix2][iy2] >= 1) {
                    data.putValue(ix2, iy2, ValTimesWeightSum[ix2][iy2] / WeightSum[ix2][iy2]);
                    continue;
                }
                data.putValue(ix2, iy2, -1.0E31);
            }
        }
        return data;
    }

    public double[][] CreateTemplateBox(int xHardBinPlus, int xHardBinMinus, int yHardBinPlus, int yHardBinMinus, int xSoftRad, int ySoftRad) {
        double[][] templateWeights = new double[xHardBinPlus + xHardBinMinus + 2 * xSoftRad + 1][yHardBinPlus + yHardBinMinus + 2 * ySoftRad + 1];
        for (int i = -(xHardBinMinus + xSoftRad); i <= xHardBinPlus + xSoftRad; ++i) {
            for (int j = -(yHardBinMinus + ySoftRad); j <= yHardBinPlus + ySoftRad; ++j) {
                if (this.InBinPlusMinuxHardEdgeBox(i, j, xHardBinPlus, xHardBinMinus, yHardBinPlus, yHardBinMinus)) {
                    templateWeights[i + (xHardBinMinus + xSoftRad)][j + (yHardBinMinus + ySoftRad)] = 1.0;
                    continue;
                }
                if (this.InEllipseCutoff(i, j, (double)(xHardBinMinus + xHardBinPlus + 2 * xSoftRad) / 2.0, (double)(yHardBinMinus + yHardBinPlus + 2 * ySoftRad) / 2.0)) {
                    templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] = 1.0 - this.EllipseValue(i, j, (double)(xHardBinMinus + xHardBinPlus + 2 * xSoftRad) / 2.0, (double)(yHardBinMinus + yHardBinPlus + 2 * ySoftRad) / 2.0);
                    if (!(templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] < 0.0)) continue;
                    templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] = 0.0;
                    continue;
                }
                templateWeights[i + (xHardBinMinus + xSoftRad)][j + yHardBinMinus + ySoftRad] = 0.0;
            }
        }
        return templateWeights;
    }

    public boolean InBinPlusMinuxHardEdgeBox(int xPlusMinus, int yPlusMinus, int xHardBinPlus, int xHardBinMinus, int yHardBinPlus, int yHardBinMinus) {
        return xPlusMinus >= -xHardBinMinus && xPlusMinus <= xHardBinPlus && yPlusMinus >= -yHardBinMinus && yPlusMinus <= yHardBinPlus;
    }

    public boolean InEllipseCutoff(int xDist, int yDist, double xR, double yR) {
        return (double)xDist * (double)xDist / (xR * xR) + (double)yDist * (double)yDist / (yR * yR) <= 1.0;
    }

    public double EllipseValue(int xDist, int yDist, double xR, double yR) {
        return (double)xDist * (double)xDist / (xR * xR) + (double)yDist * (double)yDist / (yR * yR);
    }

    public double[] getBinWidths(RebinDescriptor rebinDesc) {
        double[] binStops;
        double[] binStarts = rebinDesc.binStarts();
        if (binStarts.length != (binStops = rebinDesc.binStops()).length) {
            logger.fine("Number of start bins is not equal to number of stop bins.");
            return null;
        }
        double[] binWidths = new double[binStarts.length];
        for (int i = 0; i < binStarts.length; ++i) {
            binWidths[i] = binStops[i] - binStarts[i];
        }
        return binWidths;
    }

    public int[] getCadenceValues(double[] binWidths, double CadenceValue, int maxSep) {
        int[] cadencesIntBins = new int[binWidths.length];
        for (int i = 0; i < binWidths.length; ++i) {
            int IndexBuf = 0;
            for (double cadenceBuffer = 0.0; cadenceBuffer < CadenceValue; cadenceBuffer += binWidths[i + IndexBuf++]) {
                if (IndexBuf + i < binWidths.length) continue;
                if (i == 0) break;
                cadencesIntBins[i] = cadencesIntBins[i - 1];
                break;
            }
            cadencesIntBins[i] = IndexBuf > maxSep && maxSep != -1 ? maxSep : IndexBuf;
        }
        return cadencesIntBins;
    }
}

