/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.DatumVectorAdapter;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.Slice0DataSet;

public class Rank3TableDataSetAdapter
implements TableDataSet {
    Units xunits;
    Units yunits;
    Units zunits;
    QDataSet x;
    QDataSet y;
    QDataSet z;
    HashMap properties = new HashMap();
    int[] tables;
    HashMap<String, QDataSet> planes = new LinkedHashMap<String, QDataSet>();

    public static TableDataSet create(QDataSet z) {
        QDataSet sort;
        QDataSet yds;
        QDataSet xds = (QDataSet)z.property("DEPEND_0");
        if (xds == null) {
            xds = new IndexGenDataSet(z.length());
        }
        if ((yds = (QDataSet)z.property("DEPEND_1")) == null) {
            yds = new IndexGenDataSet(z.length(0));
        }
        if (!DataSetUtil.isMonotonic(xds)) {
            sort = DataSetOps.sort(xds);
            z = DataSetOps.applyIndex(z, 0, sort, false);
            xds = DataSetOps.applyIndex(xds, 0, sort, false);
        }
        if (!DataSetUtil.isMonotonic(yds)) {
            sort = DataSetOps.sort(yds);
            z = DataSetOps.applyIndex(z, 1, sort, false);
            yds = DataSetOps.applyIndex(yds, 0, sort, false);
        }
        return new Rank3TableDataSetAdapter(z, xds, yds);
    }

    public Rank3TableDataSetAdapter(QDataSet z, QDataSet x, QDataSet y) {
        Datum dcadence;
        QDataSet cadence;
        this.planes.put("", z);
        if (SemanticOps.isJoin(z)) {
            this.xunits = (Units)x.slice(0).property("UNITS");
            this.yunits = (Units)y.slice(0).property("UNITS");
            this.zunits = (Units)z.slice(0).property("UNITS");
        } else {
            this.xunits = (Units)x.property("UNITS");
            this.yunits = (Units)y.property("UNITS");
            this.zunits = (Units)z.property("UNITS");
        }
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        if (this.zunits == null) {
            this.zunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        Boolean xMono = (Boolean)x.property("MONOTONIC", 0);
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (QDataSet)x.property("CADENCE", 0)) != null) {
            dcadence = DataSetUtil.asDatum(cadence);
            this.properties.put("xTagWidth", dcadence);
        }
        if ((cadence = (QDataSet)y.property("CADENCE", 0)) != null) {
            dcadence = DataSetUtil.asDatum(cadence);
            this.properties.put("yTagWidth", dcadence);
        }
        if (z.property("FILL_VALUE", 0) != null || z.property("VALID_MIN", 0) != null || z.property("VALID_MAX", 0) != null) {
            QDataSet wds = DataSetUtil.weightsDataSet(z);
            this.planes.put("weights", wds);
        }
        this.tables = new int[z.length() + 1];
        for (int i = 1; i <= z.length(); ++i) {
            this.tables[i] = this.tables[i - 1] + z.length(i - 1);
        }
        String s = (String)z.slice(0).property("LABEL");
        if (s != null) {
            this.properties.put("zLabel", s);
        }
        if ((s = (String)z.slice(0).property("SCALE_TYPE")) != null) {
            this.properties.put("zScaleType", s);
        }
        if ((s = (String)z.slice(0).property("TITLE")) != null) {
            this.properties.put("title", s);
        }
        if ((s = (String)z.slice(0).property("NAME")) != null) {
            this.properties.put("name", s);
        }
        if ((s = (String)z.slice(0).property("DESCRIPTION")) != null) {
            this.properties.put("summary", s);
        }
        Number m1 = (Number)z.slice(0).property("TYPICAL_MIN");
        Number m2 = (Number)z.slice(0).property("TYPICAL_MAX");
        if (m1 != null && m2 != null) {
            this.properties.put("zRange", new DatumRange(m1.doubleValue(), m2.doubleValue(), this.zunits));
        }
        if ((s = (String)y.slice(0).property("LABEL")) != null) {
            this.properties.put("yLabel", s);
        }
        if ((s = (String)y.slice(0).property("SCALE_TYPE")) != null) {
            this.properties.put("yScaleType", s);
        }
        if ((s = (String)x.slice(0).property("LABEL")) != null) {
            this.properties.put("xLabel", s);
        }
    }

    @Override
    public Units getZUnits() {
        return this.zunits;
    }

    @Override
    public Datum getDatum(int i, int j) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.zunits.createDatum(this.z.value(i0, i1, j));
    }

    @Override
    public double getDouble(int i, int j, Units units) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.zunits.convertDoubleTo(units, this.z.value(i0, i1, j));
    }

    @Override
    public double[] getDoubleScan(int i, Units units) {
        int i0 = this.tableOfIndex(i);
        double[] zz = new double[this.getYLength(i0)];
        for (int j = 0; j < zz.length; ++j) {
            zz[j] = this.getDouble(i, j, this.getZUnits());
        }
        return zz;
    }

    @Override
    public DatumVector getScan(int i) {
        double[] zz = this.getDoubleScan(i, this.getZUnits());
        return DatumVector.newDatumVector(zz, this.getZUnits());
    }

    @Override
    public int getInt(int i, int j, Units units) {
        return (int)this.getDouble(i, j, units);
    }

    @Override
    public DatumVector getYTags(int table) {
        return DatumVectorAdapter.toDatumVector(new Slice0DataSet(this.y, table));
    }

    @Override
    public Datum getYTagDatum(int table, int j) {
        return this.yunits.createDatum(this.y.value(table, j));
    }

    @Override
    public double getYTagDouble(int table, int j, Units units) {
        return this.yunits.convertDoubleTo(units, this.y.value(table, j));
    }

    @Override
    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    @Override
    public int getYLength(int table) {
        return this.y.length(table);
    }

    @Override
    public int tableStart(int table) {
        return this.tables[table];
    }

    @Override
    public int tableEnd(int table) {
        return this.tables[table + 1];
    }

    @Override
    public int tableCount() {
        return this.z.length();
    }

    @Override
    public int tableOfIndex(int i) {
        for (int j = 0; j < this.tables.length - 1; ++j) {
            if (i < this.tables[j] || i >= this.tables[j + 1]) continue;
            return j;
        }
        throw new IndexOutOfBoundsException("index out of bounds: " + i);
    }

    @Override
    public VectorDataSet getXSlice(int i) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return new VectorDataSetAdapter(DataSetOps.slice0(DataSetOps.slice0(this.z, i0), i1), DataSetOps.slice0(this.y, i0));
    }

    @Override
    public VectorDataSet getYSlice(int j, int table) {
        return new VectorDataSetAdapter(DataSetOps.slice1(DataSetOps.slice0(this.z, table), j), DataSetOps.slice0(this.x, table));
    }

    @Override
    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.z.property(name);
    }

    @Override
    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }

    @Override
    public Map getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("UNITS", null);
        Map<String, Object> m = new HashMap<String, Object>(DataSetUtil.getProperties(this.z, result));
        if (SemanticOps.isJoin(this.z)) {
            m = DataSetUtil.getDimensionProperties(this.z.slice(0), m);
        }
        m.putAll(this.properties);
        return m;
    }

    @Override
    public Units getXUnits() {
        return this.xunits;
    }

    @Override
    public Units getYUnits() {
        return this.yunits;
    }

    @Override
    public Datum getXTagDatum(int i) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.xunits.createDatum(this.x.value(i0, i1));
    }

    @Override
    public double getXTagDouble(int i, Units units) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.xunits.convertDoubleTo(units, this.x.value(i0, i1));
    }

    @Override
    public int getXTagInt(int i, Units units) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i0, i1));
    }

    @Override
    public int getXLength() {
        return this.tables[this.tables.length - 1];
    }

    @Override
    public DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        if (this.planes.containsKey(planeID)) {
            return new TableDataSetAdapter(this.planes.get(planeID), this.x, this.y);
        }
        return null;
    }

    @Override
    public String[] getPlaneIds() {
        return this.planes.keySet().toArray(new String[this.planes.keySet().size()]);
    }

    public String toString() {
        return DataSetUtil.toString(this.z);
    }
}

