/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.system.DasLogger;

public class LanlNNRebinner
implements DataSetRebinner {
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG);
    WeakHashMap<QDataSet, QDataSet> yds0c = new WeakHashMap();
    WeakHashMap<QDataSet, QDataSet> yds1c = new WeakHashMap();
    WeakHashMap<QDataSet, QDataSet> cadence = new WeakHashMap();
    WeakHashMap<QDataSet, QDataSet> xds0c = new WeakHashMap();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private QDataSet getCadence(QDataSet ds, Datum res) {
        QDataSet dds = this.cadence.get(ds);
        if (dds == null) {
            dds = DataSetUtil.guessCadenceNew(ds, null);
            if (dds == null) {
                dds = DataSetUtil.asDataSet(res);
            }
            if (UnitsUtil.isRatiometric(SemanticOps.getUnits(dds))) {
                dds = Ops.convertUnitsTo(dds, Units.log10Ratio);
            }
            this.cadence.put(ds, dds);
        }
        return dds;
    }

    @Override
    public QDataSet rebin(QDataSet ds, RebinDescriptor ddX, RebinDescriptor ddY) throws IllegalArgumentException, DasException {
        logger.entering("org.das2.dataset.LanlNNRebinner", "rebin");
        if (ds == null) {
            throw new NullPointerException("null data set");
        }
        if (!SemanticOps.isTableDataSet(ds) && !SemanticOps.isBundle(ds)) {
            throw new IllegalArgumentException("Data set must be an instanceof TableDataSet: " + ds.getClass().getName());
        }
        QDataSet tds = ds;
        int rank = tds.rank();
        if (rank == 2) {
            JoinDataSet tdsx = new JoinDataSet(3);
            tdsx.join(tds);
            tds = tdsx;
        }
        int nx = ddX.numberOfBins();
        int ny = ddY.numberOfBins();
        DDataSet S = DDataSet.createRank2(nx, ny);
        DDataSet N = DDataSet.createRank2(nx, ny);
        boolean rs = false;
        boolean re = false;
        for (int itable = 0; itable < tds.length(); ++itable) {
            double y1;
            int nYData;
            QDataSet tds1 = tds.slice(itable);
            QDataSet weights = SemanticOps.weightsDataSet(tds1);
            QDataSet xds = SemanticOps.xtagsDataSet(tds1);
            QDataSet xds1 = (QDataSet)xds.property("BIN_MAX");
            QDataSet xds0 = (QDataSet)xds.property("BIN_MIN");
            if (xds0 == null) {
                QDataSet binPlus = (QDataSet)xds.property("BIN_PLUS");
                QDataSet binMinus = (QDataSet)xds.property("BIN_MINUS");
                if (SemanticOps.isBins(xds)) {
                    xds0 = Ops.slice1(xds, 0);
                    xds1 = Ops.slice1(xds, 1);
                } else if (binPlus != null && binMinus != null) {
                    xds0 = Ops.subtract(xds, binMinus);
                    xds1 = Ops.add(xds, binPlus);
                } else {
                    QDataSet xds2 = this.xds0c.get(xds);
                    if (xds2 == null) {
                        xds2 = DataSetUtil.inferBins(xds);
                        this.xds0c.put(xds, xds2);
                    }
                    xds0 = Ops.slice1(xds2, 0);
                    xds1 = Ops.slice1(xds2, 1);
                }
            }
            QDataSet yds = SemanticOps.ytagsDataSet(tds1);
            QDataSet yds0 = this.yds0c.get(yds);
            QDataSet yds1 = this.yds1c.get(yds);
            if (yds0 == null || yds1 == null) {
                yds0 = (QDataSet)yds.property("BIN_MIN");
                yds1 = (QDataSet)yds.property("BIN_MAX");
                if (yds0 == null) {
                    Object bins;
                    QDataSet binPlus = (QDataSet)yds.property("BIN_PLUS");
                    QDataSet binMinus = (QDataSet)yds.property("BIN_MINUS");
                    if (SemanticOps.isBins(yds)) {
                        yds0 = Ops.slice1(yds, 0);
                        yds1 = Ops.slice1(yds, 1);
                    } else if (binPlus != null && binMinus != null) {
                        yds0 = Ops.subtract(yds, binMinus);
                        yds1 = Ops.add(yds, binPlus);
                    } else if (yds.rank() == 2) {
                        logger.info("inferring bounds rank 2 ytags, this can be slow.");
                        bins = DataSetUtil.inferBinsRank2(yds);
                        yds0 = bins[0];
                        yds1 = bins[1];
                    } else if (yds.rank() == 1) {
                        bins = DataSetUtil.inferBins(yds.rank() == 2 ? yds.slice(0) : yds);
                        yds0 = Ops.slice1((QDataSet)bins, 0);
                        yds1 = Ops.slice1((QDataSet)bins, 1);
                    } else {
                        throw new UnsupportedOperationException("bad rank on ytags: " + yds.rank());
                    }
                }
                this.yds0c.put(yds, yds0);
                this.yds1c.put(yds, yds1);
            }
            boolean rank2y = yds0.rank() == 2;
            Units xunits = SemanticOps.getUnits(xds);
            Units yunits = SemanticOps.getUnits(yds);
            if (tds.length() > 0) {
                UnitsConverter xc = xunits.getConverter(ddX.getUnits());
                QDataSet bounds = SemanticOps.bounds(xds);
                double start = xc.convert(bounds.value(1, 0));
                double end = xc.convert(bounds.value(1, 1));
                DatumRange dr = DatumRangeUtil.union(ddX.binStop(ddX.numberOfBins() - 1), ddX.binStart(0));
                if (start <= dr.max().doubleValue(ddX.getUnits())) {
                    rs = true;
                }
                if (end >= dr.min().doubleValue(ddX.getUnits())) {
                    re = true;
                }
            }
            logger.log(Level.FINEST, "Allocating rebinData and rebinWeights: {0} x {1}", new Object[]{nx, ny});
            int n = nYData = rank2y ? yds0.length(0) : yds0.length();
            if (SemanticOps.isBundle(tds1) && tds1.length(0) == 3 && !rank2y && yds0.length() == tds1.length() && xds0.length() == tds1.length()) {
                tds1 = DataSetOps.unbundle(tds1, tds1.length(0) - 1);
                weights = DataSetOps.unbundle(weights, weights.length(0) - 1);
                for (int i = 0; i < xds0.length(); ++i) {
                    int py1;
                    int py0;
                    int px1;
                    int px0;
                    double x0 = xds0.value(i);
                    double x1 = xds1.value(i);
                    if (ddX.start > ddX.end) {
                        px0 = ddX.whichBin(x1, xunits);
                        px1 = ddX.whichBin(x0, xunits);
                    } else {
                        px0 = ddX.whichBin(x0, xunits);
                        px1 = ddX.whichBin(x1, xunits);
                    }
                    double wx = 1.0 / (double)(px1 - px0 + 1);
                    int sx0 = Math.max(0, px0);
                    int sx1 = Math.min(nx - 1, px1);
                    double z = tds1.value(i);
                    double y0 = yds0.value(i);
                    y1 = yds1.value(i);
                    if (ddY.start > ddY.end) {
                        py0 = ddY.whichBin(y1, yunits);
                        py1 = ddY.whichBin(y0, yunits);
                    } else {
                        py0 = ddY.whichBin(y0, yunits);
                        py1 = ddY.whichBin(y1, yunits);
                    }
                    double wy = 1.0 / (double)(py1 - py0 + 1);
                    double w = wx * wy * weights.value(i);
                    int sy0 = Math.max(0, py0);
                    int sy1 = Math.min(ny - 1, py1);
                    for (int k = sx0; k <= sx1; ++k) {
                        for (int l = sy0; l <= sy1; ++l) {
                            if (!(w > N.value(k, l))) continue;
                            S.putValue(k, l, z * w);
                            N.putValue(k, l, w);
                        }
                    }
                }
                continue;
            }
            QDataSet yds0_1 = null;
            QDataSet yds1_1 = null;
            if (!rank2y) {
                yds0_1 = yds0;
                yds1_1 = yds1;
            }
            int[] py0s = new int[nYData];
            int[] py1s = new int[nYData];
            double[] wys = new double[nYData];
            for (int i = 0; i < xds0.length(); ++i) {
                int j;
                int px1;
                int px0;
                double x0 = xds0.value(i);
                double x1 = xds1.value(i);
                if (ddX.start > ddX.end) {
                    px0 = ddX.whichBin(x1, xunits);
                    px1 = ddX.whichBin(x0, xunits);
                } else {
                    px0 = ddX.whichBin(x0, xunits);
                    px1 = ddX.whichBin(x1, xunits);
                }
                double wx = 1.0 / (double)(px1 - px0 + 1);
                int sx0 = Math.max(0, px0);
                int sx1 = Math.min(nx - 1, px1);
                if (rank2y) {
                    yds0_1 = yds0.slice(i);
                    yds1_1 = yds1.slice(i);
                }
                assert (yds0_1 != null);
                assert (yds1_1 != null);
                for (j = 0; j < nYData; ++j) {
                    double wy;
                    int py1;
                    int py0;
                    if (i != 0 && !rank2y) continue;
                    double y0 = yds0_1.value(j);
                    y1 = yds1_1.value(j);
                    if (ddY.start > ddY.end) {
                        py0 = ddY.whichBin(y1, yunits);
                        py1 = ddY.whichBin(y0, yunits);
                    } else {
                        py0 = ddY.whichBin(y0, yunits);
                        py1 = ddY.whichBin(y1, yunits);
                    }
                    py0s[j] = py0;
                    py1s[j] = py1;
                    wys[j] = wy = 1.0 / (double)(py1 - py0 + 1);
                }
                for (j = 0; j < nYData; ++j) {
                    double z = tds1.value(i, j);
                    double w = wx * wys[j] * weights.value(i, j);
                    int sy0 = Math.max(0, py0s[j]);
                    int sy1 = Math.min(ny - 1, py1s[j]);
                    for (int k = sx0; k <= sx1; ++k) {
                        for (int l = sy0; l <= sy1; ++l) {
                            if (!(w > N.value(k, l))) continue;
                            S.putValue(k, l, z * w * 1.1);
                            N.putValue(k, l, w * 1.1);
                        }
                    }
                }
            }
        }
        if (!rs) {
            throw new NoDataInIntervalException("data starts after range");
        }
        if (!re) {
            throw new NoDataInIntervalException("data ends before range");
        }
        MutablePropertyDataSet mds = (MutablePropertyDataSet)Ops.divide(S, N);
        RebinDescriptor.putDepDataSet(ds, mds, ddX, ddY);
        logger.exiting("org.das2.dataset.LanlNNRebinner", "rebin");
        return mds;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

