/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.text.ParseException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.dataset.AbstractDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.system.DasLogger;

public class DataSetAdapter {
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    public static final String PROPERTY_SOURCE = "adapterSource";

    protected static Map<String, Object> adaptSubstitutions(Map<String, Object> das2props) {
        Pattern ptrn = Pattern.compile("(%\\{)(.+?)(\\})");
        for (Map.Entry<String, Object> e : das2props.entrySet()) {
            Object o = e.getValue();
            if (!(o instanceof String)) continue;
            String s = (String)o;
            Matcher m = ptrn.matcher(s);
            while (m.find()) {
                if (m.group(2).contains("USER_PROPERTIES")) continue;
                s = String.format("%sUSER_PROPERTIES.%s%s", s.substring(0, m.end(1)), s.substring(m.start(2), m.end(2)), s.substring(m.start(3), s.length()));
                m = ptrn.matcher(s);
            }
            e.setValue(s);
        }
        return das2props;
    }

    public static AbstractDataSet create(DataSet ds) {
        if (ds == null) {
            throw new NullPointerException("dataset is null");
        }
        if (ds instanceof VectorDataSet) {
            if (ds.getPlaneIds().length <= 1) {
                Vector v = new Vector((VectorDataSet)ds);
                String sname = (String)ds.getProperty("name");
                if (sname == null) {
                    sname = "y";
                }
                v.putProperty("NAME", sname);
                return v;
            }
            VectorDataSet vds = (VectorDataSet)ds;
            Vector v = new Vector(vds);
            String sname = (String)ds.getProperty("name");
            if (sname == null) {
                sname = "y";
            }
            v.putProperty("NAME", sname);
            AbstractDataSet bds = (AbstractDataSet)Ops.bundle(null, v);
            String[] planes = ds.getPlaneIds();
            Units unitsY = null;
            boolean bCommonYUnits = false;
            for (int i = 1; i < planes.length; ++i) {
                AbstractDataSet.ViewDataSet view = (AbstractDataSet.ViewDataSet)vds.getPlanarView(planes[i]);
                if (unitsY == null) {
                    unitsY = view.getYUnits();
                } else {
                    bCommonYUnits = unitsY == view.getYUnits();
                }
                v = new Vector((VectorDataSet)vds.getPlanarView(planes[i]), planes[i]);
                v.putProperty("NAME", planes[i]);
                Ops.bundle(bds, v);
            }
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(vds.getProperties());
            bds.putProperty("USER_PROPERTIES", dasProps);
            bds.putProperty("DEPEND_0", new XTagsDataSet(vds));
            bds.putProperty("TITLE", dasProps.get("title"));
            if (bCommonYUnits) {
                bds.putProperty("UNITS", unitsY);
                bds.putProperty("LABEL", unitsY.toString());
            }
            bds.putProperty("SCALE_TYPE", vds.getProperty("yScaleType"));
            DatumRange yRng = (DatumRange)vds.getProperty("yRange");
            if (yRng != null) {
                bds.putProperty("TYPICAL_MIN", yRng.min().value());
                bds.putProperty("TYPICAL_MAX", yRng.max().value());
            }
            return DDataSet.copy(bds);
        }
        if (ds instanceof TableDataSet) {
            TableDataSet tds = (TableDataSet)ds;
            if (tds.tableCount() <= 1) {
                return DataSetAdapter.createSimpleTableDS(tds);
            }
            if (tds instanceof DefaultTableDataSet && tds.tableCount() > tds.getXLength() / 2) {
                return ((DefaultTableDataSet)tds).toQDataSet();
            }
            return new MultipleTable(tds);
        }
        throw new IllegalArgumentException("unsupported dataset type: " + ds.getClass().getName());
    }

    public static DataSet createLegacyDataSet(QDataSet ds) {
        if (ds.rank() == 1) {
            return VectorDataSetAdapter.create(ds);
        }
        if (SemanticOps.isBundle(ds)) {
            return VectorDataSetAdapter.createFromBundle(ds);
        }
        if (ds.rank() == 2) {
            return TableDataSetAdapter.create(ds);
        }
        if (ds.rank() == 3) {
            return TableDataSetAdapter.create(ds);
        }
        throw new IllegalArgumentException("unsupported rank: " + ds.rank());
    }

    private static AbstractDataSet createSimpleTableDS(TableDataSet tds) {
        String sTopDs = null;
        String sTopSrc = null;
        String[] lPlanes = tds.getPlaneIds();
        if (lPlanes.length == 1) {
            sTopDs = lPlanes[0];
        } else {
            for (String sPlane : lPlanes) {
                DataSet ds = tds.getPlanarView(sPlane);
                sTopSrc = (String)ds.getProperty("source");
                if (sTopSrc == null) {
                    sTopDs = sPlane;
                    break;
                }
                String sOp = (String)ds.getProperty("operation");
                if (sOp == null || !sOp.equals("BIN_AVG")) continue;
                sTopDs = sPlane;
                break;
            }
        }
        if (sTopDs == null) {
            throw new IllegalArgumentException("Couldn't locate the top-level <yscan> in the set of <yscans>.  HINT: If this is simple bundle then you've hit a missing feature in Autoplot. If this is a peak and averages dataset, use the 'source' and 'operation' properties to clairify the <yscan> relationships. ");
        }
        SimpleTable qds = new SimpleTable((TableDataSet)tds.getPlanarView(sTopDs));
        for (String sPlane : lPlanes) {
            String sOp;
            TableDataSet dsPlane;
            String sPlaneSrc;
            if (sPlane.equals(sTopDs) || ((sPlaneSrc = (String)(dsPlane = (TableDataSet)tds.getPlanarView(sPlane)).getProperty("source")) != null || sTopSrc != null) && !sTopSrc.equals(sPlaneSrc) || (sOp = (String)dsPlane.getProperty("operation")) == null) continue;
            SimpleTable qdsAncillary = new SimpleTable(dsPlane);
            if (sOp.equals("BIN_MAX")) {
                qds.putProperty("BIN_MAX", qdsAncillary);
            }
            if (sOp.equals("BIN_MIN")) {
                qds.putProperty("BIN_MIN", qdsAncillary);
            }
            if (sOp.equals("DELTA_PLUS")) {
                qds.putProperty(sOp, qdsAncillary);
            }
            if (!sOp.equals("DELTA_MINUS")) continue;
            qds.putProperty(sOp, qdsAncillary);
        }
        return qds;
    }

    static class MultiTableXTagsDataSet
    extends AbstractDataSet {
        DataSet source;
        int offset;
        int length;

        MultiTableXTagsDataSet(DataSet source, int offset, int length) {
            Datum xTagWidth;
            this.source = source;
            this.offset = offset;
            this.length = length;
            this.properties.put("UNITS", source.getXUnits());
            this.properties.put("LABEL", source.getProperty("xLabel"));
            Object o = source.getProperty("xMonotonic");
            if (o != null) {
                this.properties.put("MONOTONIC", o);
            }
            if ((xTagWidth = (Datum)source.getProperty("xTagWidth")) != null) {
                this.properties.put("CADENCE", DataSetUtil.asDataSet(xTagWidth));
            }
        }

        @Override
        public int rank() {
            return 1;
        }

        @Override
        public double value(int i) {
            return this.source.getXTagDouble(i + this.offset, this.source.getXUnits());
        }

        @Override
        public int length() {
            return this.length;
        }
    }

    static class MultipleTable
    extends AbstractDataSet {
        TableDataSet source;

        MultipleTable(TableDataSet source) {
            this.source = source;
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(source.getProperties());
            this.properties.put("USER_PROPERTIES", dasProps);
            this.properties.put("JOIN_0", DDataSet.create(new int[0]));
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
            this.properties.put("TITLE", dasProps.get("title"));
            DatumRange zRng = (DatumRange)dasProps.get("zRange");
            if (zRng != null) {
                this.properties.put("TYPICAL_MIN", zRng.min().value());
                this.properties.put("TYPICAL_MAX", zRng.max().value());
            }
            this.properties.put("RENDER_TYPE", dasProps.get("renderer"));
            this.properties.put("FILL_VALUE", dasProps.get("zFill"));
            this.properties.put("VALID_MIN", dasProps.get("zValidMin"));
            this.properties.put("VALID_MAX", dasProps.get("zValidMax"));
            this.properties.put("SCALE_TYPE", dasProps.get("zScaleType"));
            this.properties.put("LABEL", dasProps.get("zLabel"));
        }

        @Override
        public int rank() {
            return 3;
        }

        @Override
        public int length() {
            return this.source.tableCount();
        }

        @Override
        public int length(int i) {
            return this.source.tableEnd(i) - this.source.tableStart(i);
        }

        @Override
        public int length(int i, int j) {
            return this.source.getYLength(i);
        }

        @Override
        public double value(int i, int j, int k) {
            int ts = this.source.tableStart(i);
            return this.source.getDouble(ts + j, k, this.source.getZUnits());
        }

        @Override
        public Object property(String name, int i) {
            if (name.equals("DEPEND_0")) {
                return new MultiTableXTagsDataSet(this.source, this.source.tableStart(i), this.source.tableEnd(i) - this.source.tableStart(i));
            }
            if (name.equals("DEPEND_1")) {
                return new YTagsDataSet(this.source, i);
            }
            return super.property(name, i);
        }
    }

    static class SimpleTable
    extends AbstractDataSet {
        TableDataSet source;

        SimpleTable(TableDataSet source) {
            if (source.tableCount() > 1) {
                throw new IllegalArgumentException("only simple tables are supported");
            }
            this.source = source;
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(source.getProperties());
            this.properties.put("USER_PROPERTIES", dasProps);
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put("LABEL", dasProps.get("zLabel"));
            this.properties.put("TITLE", dasProps.get("title"));
            XTagsDataSet xtags = new XTagsDataSet(source);
            this.properties.put("DEPEND_0", xtags);
            YTagsDataSet ytags = new YTagsDataSet(source, 0);
            this.properties.put("DEPEND_1", ytags);
            this.properties.put("QUBE", Boolean.TRUE);
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
            DatumRange zRng = (DatumRange)dasProps.get("zRange");
            if (zRng != null) {
                this.properties.put("TYPICAL_MIN", zRng.min().value());
                this.properties.put("TYPICAL_MAX", zRng.max().value());
            }
            this.properties.put("RENDER_TYPE", dasProps.get("renderer"));
            this.properties.put("FILL_VALUE", dasProps.get("zFill"));
            this.properties.put("VALID_MIN", dasProps.get("zValidMin"));
            this.properties.put("VALID_MAX", dasProps.get("zValidMax"));
            this.properties.put("SCALE_TYPE", dasProps.get("zScaleType"));
            this.properties.put("LABEL", dasProps.get("zLabel"));
        }

        @Override
        public int rank() {
            return 2;
        }

        @Override
        public int length(int i) {
            return this.source.getYLength(0);
        }

        @Override
        public double value(int i, int j) {
            return this.source.getDouble(i, j, this.source.getZUnits());
        }

        @Override
        public int length() {
            return this.source.getXLength();
        }
    }

    static class Vector
    extends AbstractDataSet {
        VectorDataSet source;

        Vector(VectorDataSet source) {
            this(source, null);
        }

        private static Object hack(Map<String, Object> m, String k, String id) {
            if (id == null) {
                return m.get(k);
            }
            return m.get(id + "." + k);
        }

        Vector(VectorDataSet source, String sPlaneID) {
            Datum d;
            double val;
            this.source = source;
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(source.getProperties());
            this.properties.put("USER_PROPERTIES", dasProps);
            this.properties.put("TITLE", Vector.hack(dasProps, "title", sPlaneID));
            this.properties.put("UNITS", source.getYUnits());
            this.properties.put("LABEL", Vector.hack(dasProps, "yLabel", sPlaneID));
            this.properties.put("FORMAT", Vector.hack(dasProps, "yFormat", sPlaneID));
            XTagsDataSet xds = new XTagsDataSet(source);
            xds.putProperty("CACHE_TAG", Vector.hack(dasProps, "cacheTag", sPlaneID));
            this.properties.put("DEPEND_0", xds);
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
            String syValid = (String)dasProps.get("valid_range");
            if (syValid != null) {
                try {
                    DatumRange yValid = DatumRangeUtil.parseDatumRange(syValid, source.getYUnits());
                    val = yValid.min().doubleValue(source.getYUnits());
                    this.properties.put("VALID_MIN", val);
                    val = yValid.max().doubleValue(source.getYUnits());
                    this.properties.put("VALID_MAX", val);
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if ((d = (Datum)Vector.hack(dasProps, "yValidMin", sPlaneID)) != null) {
                val = d.doubleValue(source.getYUnits());
                this.properties.put("VALID_MIN", val);
            }
            if ((d = (Datum)Vector.hack(dasProps, "yValidMax", sPlaneID)) != null) {
                val = d.doubleValue(source.getYUnits());
                this.properties.put("VALID_MAX", val);
            }
            this.properties.put("FILL_VALUE", Vector.hack(dasProps, "yFill", sPlaneID));
            this.properties.put("SCALE_TYPE", Vector.hack(dasProps, "yScaleType", sPlaneID));
            this.properties.put("MONOTONIC", Vector.hack(dasProps, "yMonotonic", sPlaneID));
            this.properties.put("DESCRIPTION", Vector.hack(dasProps, "ySummary", sPlaneID));
            DatumRange yRng = (DatumRange)Vector.hack(dasProps, "yRange", sPlaneID);
            if (yRng != null) {
                this.properties.put("TYPICAL_MIN", yRng.min().value());
                this.properties.put("TYPICAL_MAX", yRng.max().value());
            }
            if ((d = (Datum)Vector.hack(dasProps, "yTagWidth", sPlaneID)) != null) {
                this.properties.put("CADENCE", DRank0DataSet.create(d));
            }
        }

        @Override
        public int rank() {
            return 1;
        }

        @Override
        public double value(int i) {
            return this.source.getDouble(i, this.source.getYUnits());
        }

        @Override
        public int length() {
            return this.source.getXLength();
        }
    }

    static class XTagsDataSet
    extends AbstractDataSet {
        DataSet source;

        XTagsDataSet(DataSet source) {
            Object o;
            this.source = source;
            this.properties.put("UNITS", source.getXUnits());
            this.properties.put("LABEL", source.getProperty("xLabel"));
            Datum d = (Datum)source.getProperty("xTagWidth");
            if (d != null) {
                this.properties.put("CADENCE", DRank0DataSet.create(d));
            }
            if ((o = source.getProperty("xMonotonic")) != null) {
                this.properties.put("MONOTONIC", o);
            }
        }

        @Override
        public int rank() {
            return 1;
        }

        @Override
        public double value(int i) {
            return this.source.getXTagDouble(i, this.source.getXUnits());
        }

        @Override
        public int length() {
            return this.source.getXLength();
        }
    }

    static class YTagsDataSet
    extends AbstractDataSet {
        TableDataSet source;
        int table;

        YTagsDataSet(TableDataSet source, int table) {
            DatumRange yRng;
            this.source = source;
            this.table = table;
            this.properties.put("UNITS", source.getYUnits());
            this.properties.put("LABEL", source.getProperty("yLabel"));
            this.properties.put("SCALE_TYPE", source.getProperty("yScaleType"));
            Datum d = (Datum)source.getProperty("yTagWidth");
            if (d != null) {
                this.properties.put("CADENCE", DRank0DataSet.create(d));
            }
            if ((yRng = (DatumRange)source.getProperty("yRange")) != null) {
                this.properties.put("TYPICAL_MIN", yRng.min().value());
                this.properties.put("TYPICAL_MAX", yRng.max().value());
            }
        }

        @Override
        public int rank() {
            return 1;
        }

        @Override
        public double value(int i) {
            return this.source.getYTagDouble(this.table, i, this.source.getYUnits());
        }

        @Override
        public int length() {
            return this.source.tableCount() > 0 ? this.source.getYLength(this.table) : 99;
        }
    }
}

