/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.DasException;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;

public class ConstantDataSetDescriptor
extends DataSetDescriptor {
    DataSet ds;

    public ConstantDataSetDescriptor(DataSet ds) {
        if (ds == null) {
            throw new NullPointerException("DataSet parameter cannot be null");
        }
        this.ds = ds;
    }

    @Override
    public DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        return this.ds;
    }

    @Override
    public DataSet getDataSet(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        return this.ds;
    }

    @Override
    public Units getXUnits() {
        return this.ds.getXUnits();
    }

    @Override
    public void requestDataSet(Datum start, Datum end, Datum resolution, ProgressMonitor monitor, Object lockObject) {
        DataSetUpdateEvent dsue = null;
        try {
            DataSet ds = this.getDataSet(start, end, resolution, monitor);
            dsue = new DataSetUpdateEvent((Object)this, DataSetAdapter.create(ds));
            this.fireDataSetUpdateEvent(dsue);
        }
        catch (DasException e) {
            dsue = new DataSetUpdateEvent((Object)this, e);
            this.fireDataSetUpdateEvent(dsue);
        }
    }
}

