/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.das2.DasApplication;
import org.das2.beans.BeansUtil;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.IndexedPropertyTreeNode;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;
import org.das2.system.DasLogger;

public class PropertyTreeNode
implements PropertyTreeNodeInterface {
    protected static final Object[] NULL_ARGS = new Object[0];
    protected List children;
    protected PropertyTreeNode parent;
    protected PropertyDescriptor propertyDescriptor;
    protected DefaultTreeModel treeModel;
    protected Object value;
    protected boolean dirty;
    protected boolean childDirty;

    PropertyTreeNode(Object value) {
        this.value = value;
    }

    @Override
    public void setTreeModel(DefaultTreeModel treeModel) {
        if (this.treeModel != null) {
            throw new IllegalArgumentException("Improper use, see documentation");
        }
        this.treeModel = treeModel;
    }

    PropertyTreeNode(PropertyTreeNode parent, PropertyDescriptor propertyDescriptor) throws InvocationTargetException {
        this.parent = parent;
        this.propertyDescriptor = propertyDescriptor;
        this.treeModel = parent.treeModel;
        if (this.treeModel == null) {
            throw new IllegalArgumentException("null treeModel in parent");
        }
        try {
            if (propertyDescriptor.getReadMethod() == null) {
                throw new RuntimeException("read method not defined for " + propertyDescriptor.getName());
            }
            this.value = propertyDescriptor.getReadMethod().invoke(parent.value, NULL_ARGS);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public Enumeration children() {
        this.maybeLoadChildren();
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        Class<?> type;
        if (this.propertyDescriptor == null) {
            return true;
        }
        if (this.propertyDescriptor.getPropertyEditorClass() != null) {
            return false;
        }
        if (this.propertyDescriptor instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)this.propertyDescriptor;
            type = ipd.getIndexedPropertyType();
        } else {
            type = this.propertyDescriptor.getPropertyType();
        }
        return !PropertyEditor.editableTypes.contains(type) && BeansUtil.findEditor(type) == null;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.maybeLoadChildren();
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.maybeLoadChildren();
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.maybeLoadChildren();
        return this.children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        if (this.value == null) {
            return true;
        }
        this.maybeLoadChildren();
        return this.children.isEmpty();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    protected void maybeLoadChildren() {
        if (this.children == null) {
            ArrayList<PropertyTreeNode> children = new ArrayList<PropertyTreeNode>();
            if (this.getAllowsChildren()) {
                try {
                    PropertyDescriptor[] properties = BeansUtil.getPropertyDescriptors(this.value.getClass());
                    String[] propertyNameList = BeansUtil.getPropertyNames(properties);
                    HashMap<String, PropertyDescriptor> nameMap = new HashMap<String, PropertyDescriptor>();
                    for (int i = 0; i < properties.length; ++i) {
                        nameMap.put(properties[i].getName(), properties[i]);
                    }
                    for (int j = 0; j < propertyNameList.length; ++j) {
                        PropertyDescriptor pd = (PropertyDescriptor)nameMap.get(propertyNameList[j]);
                        if (pd == null) {
                            throw new IllegalArgumentException("property not found: " + propertyNameList[j] + " of object[" + this.value + "]");
                        }
                        if (pd.getReadMethod() == null) continue;
                        if (pd instanceof IndexedPropertyDescriptor) {
                            children.add(new IndexedPropertyTreeNode(this, (IndexedPropertyDescriptor)pd));
                            continue;
                        }
                        children.add(new PropertyTreeNode(this, pd));
                    }
                }
                catch (InvocationTargetException ite) {
                    DasApplication.getDefaultApplication().getExceptionHandler().handle(ite.getCause());
                }
            }
            this.children = children;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getDisplayValue() {
        if (this.value instanceof Displayable) {
            return this.value;
        }
        boolean allowsChildren = this.getAllowsChildren();
        if (allowsChildren) {
            return this.value;
        }
        return this.value;
    }

    public String getDisplayName() {
        if (this.propertyDescriptor == null) {
            return "root";
        }
        return this.propertyDescriptor.getName();
    }

    @Override
    public void setValue(Object obj) {
        if (obj == this.value) {
            return;
        }
        if (obj != null && obj.equals(this.value)) {
            return;
        }
        this.value = obj;
        this.setDirty();
    }

    protected String absPropertyName() {
        if (this.propertyDescriptor == null) {
            return "";
        }
        String s = this.parent.absPropertyName();
        return (s.equals("") ? "" : s + ".") + this.propertyDescriptor.getName();
    }

    protected Object[] getTreePath() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        list.add(this);
        for (TreeNode node = this.getParent(); node != null; node = node.getParent()) {
            list.add(0, node);
        }
        return list.toArray(new Object[list.size()]);
    }

    @Override
    public void flush() {
        try {
            if (this.dirty) {
                DasLogger.getLogger(DasLogger.DASML_LOG).fine("flushing property " + this.absPropertyName() + "=" + this.value);
                Method writeMethod = this.propertyDescriptor.getWriteMethod();
                writeMethod.invoke(this.parent.value, this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                for (PropertyTreeNode child : this.children) {
                    child.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException e) {
            DasApplication.getDefaultApplication().getExceptionHandler().handle(e);
        }
    }

    private void setDirty() {
        this.dirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.childDirty;
    }

    private void setChildDirty() {
        this.childDirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + column);
    }

    @Override
    public void setValueAt(Object value, int column) {
        switch (column) {
            case 0: {
                throw new IllegalArgumentException("Cell is not editable");
            }
            case 1: {
                this.setValue(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such column: " + column);
            }
        }
    }

    @Override
    public boolean isCellEditable(int column) {
        boolean isWritable = this.propertyDescriptor.getWriteMethod() != null;
        return isWritable && column == 1 && !this.getAllowsChildren();
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Property Name";
            }
            case 1: {
                return "Value";
            }
        }
        throw new IllegalArgumentException("No such column: " + columnIndex);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void refresh() {
        if (this.getAllowsChildren()) {
            if (this.children != null) {
                for (PropertyTreeNode child : this.children) {
                    child.refresh();
                }
            }
        } else {
            Object newValue = this.read();
            if (newValue != this.value && newValue != null && !newValue.equals(this.value)) {
                this.value = newValue;
            }
        }
    }

    protected Object read() {
        if (this.propertyDescriptor == null) {
            return this.value;
        }
        Method readMethod = this.propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            String pName = this.propertyDescriptor.getName();
            String pId = this.value.getClass().getName() + "#" + pName;
            throw new IllegalStateException("Null read method for: " + pId);
        }
        try {
            return readMethod.invoke(this.parent.value, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            IllegalAccessError err = new IllegalAccessError(iae.getMessage());
            err.initCause(iae);
            throw err;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

