/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.components.propertyeditor.PropertyTreeNode;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;

public class PeerPropertyTreeNode
implements PropertyTreeNodeInterface {
    PeerPropertyTreeNode parent;
    PeerPropertyTreeNode[] children = null;
    PropertyTreeNode leader;
    PropertyTreeNode[] peers;
    private DefaultTreeModel treeModel;

    public PeerPropertyTreeNode(PeerPropertyTreeNode parent, PropertyTreeNode leader, PropertyTreeNode[] peers) {
        this.parent = parent;
        this.leader = leader;
        this.peers = Arrays.copyOf(peers, peers.length);
    }

    public Enumeration children() {
        return new Enumeration(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < PeerPropertyTreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return PeerPropertyTreeNode.this.getChildAt(this.index++);
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return this.leader.getAllowsChildren();
    }

    private synchronized PeerPropertyTreeNode[] maybeCreateChildren() {
        if (this.children == null) {
            this.children = new PeerPropertyTreeNode[this.leader.getChildCount()];
            for (int childIndex = 0; childIndex < this.children.length; ++childIndex) {
                PropertyTreeNode[] peerChildren = new PropertyTreeNode[this.peers.length];
                for (int i = 0; i < this.peers.length; ++i) {
                    peerChildren[i] = (PropertyTreeNode)this.peers[i].getChildAt(childIndex);
                }
                PeerPropertyTreeNode child = new PeerPropertyTreeNode(this, (PropertyTreeNode)this.leader.getChildAt(childIndex), peerChildren);
                child.treeModel = this.treeModel;
                this.children[childIndex] = child;
            }
        }
        return this.children;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        PeerPropertyTreeNode[] kids = this.maybeCreateChildren();
        return kids[childIndex];
    }

    @Override
    public int getChildCount() {
        return this.leader.getChildCount();
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return this.leader.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 2 + this.peers.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex > 1) {
            return String.valueOf(this.peers[columnIndex - 2].getDisplayValue());
        }
        return this.leader.getColumnName(columnIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        PeerPropertyTreeNode[] kids = this.maybeCreateChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (node != kids[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public Object getValueAt(int column) {
        if (column > 1) {
            return this.peers[column - 2].getValueAt(1);
        }
        switch (column) {
            case 0: {
                return this.leader.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + column);
    }

    @Override
    public boolean isCellEditable(int column) {
        return column > 0;
    }

    @Override
    public boolean isDirty() {
        return this.leader.isDirty();
    }

    @Override
    public boolean isLeaf() {
        return this.leader.isLeaf();
    }

    @Override
    public void refresh() {
        this.leader.refresh();
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].refresh();
        }
    }

    @Override
    public void setValueAt(Object value, int column) {
        if (column > 1) {
            this.peers[column - 2].setValueAt(value, 1);
        } else {
            switch (column) {
                case 0: {
                    throw new IllegalArgumentException("Cell is not editable");
                }
                case 1: {
                    if (value == PropertyEditor.MULTIPLE) break;
                    this.setValue(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such column: " + column);
                }
            }
        }
        this.treeModel.nodeChanged(this);
    }

    @Override
    public void setTreeModel(DefaultTreeModel treeModel) {
        this.treeModel = treeModel;
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].setTreeModel(treeModel);
        }
        this.leader.setTreeModel(treeModel);
    }

    @Override
    public Object getValue() {
        return this.leader.getValue();
    }

    @Override
    public Object getDisplayValue() {
        Object value = this.leader.getDisplayValue();
        boolean warn = false;
        for (int i = 0; i < this.peers.length; ++i) {
            Object peerValue = this.peers[i].getDisplayValue();
            if (peerValue != null) {
                if (this.peers[i].getDisplayValue().equals(value)) continue;
                warn = true;
                continue;
            }
            if (value == null) continue;
            warn = true;
        }
        return warn ? PropertyEditor.MULTIPLE : value;
    }

    @Override
    public void flush() {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].flush();
        }
        this.leader.flush();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.leader.getPropertyDescriptor();
    }

    public String toString() {
        return this.leader.getDisplayName() + "";
    }

    @Override
    public void setValue(Object value) {
        for (int i = 0; i < this.peers.length; ++i) {
            this.peers[i].setValue(value);
        }
        this.leader.setValue(value);
        this.treeModel.nodeChanged(this);
    }
}

