/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.das2.graph.ColorUtil;
import org.das2.util.DesktopColorChooserPanel;

public class NamedColorChooserPanel
extends AbstractColorChooserPanel {
    JList l;

    @Override
    public void updateChooser() {
        Color c = this.getColorFromModel();
        String s = ColorUtil.nameForColor(c);
        if (!s.startsWith("#")) {
            this.l.setSelectedValue(s, true);
        } else {
            this.l.clearSelection();
            this.l.repaint();
        }
    }

    @Override
    protected void buildChooser() {
        this.l = new JList();
        final Map<String, Color> colors = ColorUtil.getNamedColors();
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (String s : colors.keySet()) {
            m.addElement(s);
        }
        this.l.setModel(m);
        ListCellRenderer r = new ListCellRenderer(){
            JLabel label = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.label.setText(String.valueOf(value));
                Color cc = (Color)colors.get((String)value);
                this.label.setIcon(DesktopColorChooserPanel.colorIcon(cc, 24, 16));
                if (isSelected) {
                    this.label.setBackground(list.getSelectionBackground());
                    this.label.setForeground(list.getSelectionForeground());
                    this.label.setOpaque(true);
                } else {
                    this.label.setBackground(list.getBackground());
                    this.label.setForeground(list.getForeground());
                    this.label.setOpaque(false);
                }
                return this.label;
            }
        };
        this.l.setCellRenderer(r);
        this.l.setSelectionMode(0);
        this.l.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String colorName = String.valueOf(NamedColorChooserPanel.this.l.getSelectedValue());
                NamedColorChooserPanel.this.getColorSelectionModel().setSelectedColor((Color)colors.get(colorName));
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.l, 22, 30);
        this.add((Component)jsp, "Center");
    }

    @Override
    public String getDisplayName() {
        return "Named Colors";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }
}

