/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.components.SliceSettings;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.MouseModule;
import org.das2.event.PointSlopeDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Painter;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.system.DasLogger;

public class VerticalSpectrogramSlicer
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private final DasPlot parentPlot;
    private DasPlot myPlot;
    private final DasAxis sourceZAxis;
    private final DasAxis sourceXAxis;
    protected Datum xValue;
    protected Datum yValue;
    protected Datum ySlice;
    JPanel buttonPanel;
    List<Action> additionalActions = new ArrayList<Action>();
    private SymbolLineRenderer renderer;
    private Color markColor = new Color(230, 230, 230);

    protected VerticalSpectrogramSlicer(DasPlot parent, DasAxis sourceXAxis, DasAxis sourceZAxis) {
        this.sourceZAxis = sourceZAxis;
        this.sourceXAxis = sourceXAxis;
        this.parentPlot = parent;
    }

    private void initPlot(DasCanvas canvas) {
        DasAxis xAxis = this.sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = this.sourceZAxis.createAttachedAxis(3);
        this.myPlot = new DasPlot(xAxis, yAxis);
        this.renderer = new SymbolLineRenderer();
        this.renderer.setAntiAliased(true);
        this.myPlot.addRenderer(this.renderer);
        canvas.addTopDecorator(new Painter(){

            @Override
            public void paint(Graphics2D g) {
                int ix = (int)VerticalSpectrogramSlicer.this.myPlot.getXAxis().transform(VerticalSpectrogramSlicer.this.yValue);
                DasRow row = VerticalSpectrogramSlicer.this.myPlot.getRow();
                int iy0 = row.getDMinimum();
                int iy1 = row.getDMaximum();
                g.drawLine(ix + 3, iy0, ix, iy0 + 3);
                g.drawLine(ix - 3, iy0, ix, iy0 + 3);
                g.drawLine(ix + 3, iy1, ix, iy1 - 3);
                g.drawLine(ix - 3, iy1, ix, iy1 - 3);
                g.setColor(VerticalSpectrogramSlicer.this.markColor);
                g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
            }
        });
        this.myPlot.getDasMouseInputAdapter().addMouseModule(new MouseModule(this.myPlot, new PointSlopeDragRenderer(this.myPlot, this.myPlot.getXAxis(), this.myPlot.getYAxis()), "Slope"));
    }

    public void addAction(Action a) {
        this.additionalActions.add(a);
        if (this.buttonPanel != null) {
            JButton b = new JButton(a);
            this.buttonPanel.add((Component)b, 0);
        }
    }

    protected void setDataSet(QDataSet ds) {
        this.renderer.setDataSet(ds);
    }

    public QDataSet getDataSet() {
        return this.renderer.getDataSet();
    }

    public static VerticalSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        return new VerticalSpectrogramSlicer(plot, sourceYAxis, sourceZAxis);
    }

    public static VerticalSpectrogramSlicer createSlicer(DasPlot plot, DasAxis xAxis, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        return new VerticalSpectrogramSlicer(plot, xAxis, sourceZAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VerticalSpectrogramSlicer.this.showPopupImpl();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    public void dispose() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
        }
    }

    public void clear(QDataSet tds) {
        if (this.renderer != null) {
            if (tds == null) {
                this.renderer.setDataSet(null);
            } else {
                try {
                    if (this.isPopupVisible()) {
                        this.showSlice(tds, this.xValue, this.yValue);
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    this.renderer.setDataSet(null);
                }
            }
        }
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        if (this.myPlot == null) {
            this.initPlot(canvas);
        }
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 3.0, -5.0, 0, 0);
        DasColumn column = new DasColumn(canvas, null, 0.0, 1.0, 7.0, -3.0, 0, 0);
        canvas.add(this.myPlot, row, column);
        JPanel content = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(this.buttonPanel, 0);
        this.buttonPanel.setLayout(buttonLayout);
        if (this.additionalActions != null && this.additionalActions.size() > 0) {
            for (Action a : this.additionalActions) {
                this.buttonPanel.add(new JButton(a));
            }
        }
        this.buttonPanel.add(Box.createHorizontalGlue());
        JButton printButton = new JButton(new AbstractAction("Print..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        this.buttonPanel.add(printButton);
        JButton settingsButton = new JButton(new AbstractAction("Settings..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrogramRenderer rend = null;
                for (Renderer r : VerticalSpectrogramSlicer.this.parentPlot.getRenderers()) {
                    if (!(r instanceof SpectrogramRenderer)) continue;
                    rend = (SpectrogramRenderer)r;
                    break;
                }
                if (rend == null) {
                    JOptionPane.showMessageDialog(null, "Unable to find associated Spectrogram");
                    return;
                }
                SliceSettings settings = new SliceSettings();
                settings.setSliceRebinnedData(rend.isSliceRebinnedData());
                new PropertyEditor(settings).showModalDialog(canvas);
                rend.setSliceRebinnedData(settings.isSliceRebinnedData());
                QDataSet ds = rend.getConsumedDataSet();
                VerticalSpectrogramSlicer.this.showSlice(ds, VerticalSpectrogramSlicer.this.xValue, VerticalSpectrogramSlicer.this.yValue);
            }
        });
        this.buttonPanel.add(settingsButton);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        this.buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)this.buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = new JDialog(parentWindow);
        this.popupWindow.setTitle("Vertical Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point(0, this.parentPlot.getY());
        parentLocation.translate(this.parentPlot.getX() / 20, -1 * this.myPlot.getRow().getDMinimum());
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        int xx = parentLocation.x + this.parentPlot.getCanvas().getWidth();
        int yy = parentLocation.y;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int totalwidth = gd.getDisplayMode().getWidth();
        int totalheight = gd.getDisplayMode().getHeight();
        if (xx > totalwidth - 100) {
            xx = totalwidth - 100;
        }
        if (yy > totalheight - 100) {
            yy = totalheight - 100;
        }
        this.popupWindow.setLocation(xx, yy);
    }

    protected boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible() && this.myPlot.getCanvas() != null;
    }

    @Override
    public void dataPointSelected(DataPointSelectionEvent e) {
        this.yValue = e.getY();
        this.xValue = e.getX();
        QDataSet ds = e.getDataSet();
        if (ds == null || !SemanticOps.isTableDataSet(ds)) {
            return;
        }
        QDataSet tds = ds;
        this.showSlice(tds, this.xValue, this.yValue);
    }

    private boolean showSlice(QDataSet tds, Datum xValue, Datum yValue) {
        QDataSet sliceDataSet;
        int ix;
        QDataSet tds1 = null;
        ArrayList<QDataSet> tdss = new ArrayList<QDataSet>();
        if (tds.rank() == 3) {
            for (int i = 0; i < tds.length(); ++i) {
                QDataSet bounds = DataSetOps.dependBounds(tds.slice(i));
                DatumRange xrange = DataSetUtil.asDatumRange(bounds.slice(0), true);
                if (!xrange.contains(xValue)) continue;
                tdss.add(tds.slice(i));
            }
        } else {
            QDataSet bounds = DataSetOps.dependBounds(tds);
            if (DataSetOps.boundsContains(bounds, xValue, yValue)) {
                tds1 = tds;
            }
        }
        Datum xx = null;
        DatumRange xdr = null;
        if (tds1 == null) {
            QDataSet jds = null;
            assert (tdss.size() > 0);
            Iterator iterator = tdss.iterator();
            while (iterator.hasNext()) {
                Datum xx1;
                QDataSet tds2;
                tds1 = tds2 = (QDataSet)iterator.next();
                QDataSet xds = SemanticOps.xtagsDataSet(tds1);
                ix = DataSetUtil.closestIndex(xds, xValue);
                QDataSet s1 = tds1.slice(ix);
                if (xx != null && !(xx1 = DataSetUtil.asDatum(xds.slice(ix))).equals(xx)) {
                    xdr = DatumRangeUtil.union(xx, xx1);
                }
                xx = DataSetUtil.asDatum(xds.slice(ix));
                jds = Ops.concatenate(jds, s1);
            }
            sliceDataSet = jds;
        } else {
            QDataSet xds = SemanticOps.xtagsDataSet(tds1);
            ix = DataSetUtil.closestIndex(xds, xValue);
            if ((xds = xds.slice(ix)).rank() == 0) {
                xx = DataSetUtil.asDatum(xds);
            } else {
                xx = DataSetUtil.asDatum(xds.slice(0));
                xx = xx.add(DataSetUtil.asDatum(Ops.divide((Object)Ops.subtract(xds.slice(1), xds.slice(0)), 2)));
            }
            sliceDataSet = tds1.slice(ix);
        }
        if (sliceDataSet == null) {
            return false;
        }
        DasLogger.getLogger(DasLogger.GUI_LOG).finest("setDataSet sliceDataSet");
        if (!this.isPopupVisible()) {
            this.showPopup();
        }
        this.renderer.setDataSet(sliceDataSet);
        DatumFormatter formatter = xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : xValue.getFormatter();
        String title = this.parentPlot.getTitle().trim();
        if (title.length() > 0) {
            title = title + "!c";
        }
        if (xdr != null) {
            this.myPlot.setTitle(title + "x: " + xdr + " y: " + yValue);
        } else {
            this.myPlot.setTitle(title + "x: " + formatter.format(xx) + " y: " + yValue);
        }
        if (!this.myPlot.getXAxis().getLabel().equals(this.sourceXAxis.getLabel())) {
            this.myPlot.getXAxis().setLabel(this.sourceXAxis.getLabel());
        }
        if (!this.myPlot.getYAxis().getLabel().equals(this.sourceZAxis.getLabel())) {
            this.myPlot.getYAxis().setLabel(this.sourceZAxis.getLabel());
        }
        return true;
    }

    public Color getMarkColor() {
        return this.markColor;
    }

    public void setMarkColor(Color markColor) {
        this.markColor = markColor;
    }
}

