/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.DasException;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class VerticalSpectrogramAverager
implements DataRangeSelectionListener {
    private JDialog popupWindow;
    private DasPlot parentPlot;
    private DasPlot myPlot;
    private DasAxis sourceZAxis;
    private DasAxis sourceXAxis;
    protected Datum value;
    private SeriesRenderer renderer;
    private Color markColor = new Color(230, 230, 230);

    protected VerticalSpectrogramAverager(DasPlot parent, DasAxis sourceXAxis, DasAxis sourceZAxis) {
        this.sourceZAxis = sourceZAxis;
        this.sourceXAxis = sourceXAxis;
        this.parentPlot = parent;
    }

    private void initPlot() {
        DasAxis xAxis = this.sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = this.sourceZAxis.createAttachedAxis(3);
        this.myPlot = new DasPlot(xAxis, yAxis);
        this.renderer = new SymbolLineRenderer();
        this.renderer.setAntiAliased(true);
        this.myPlot.addRenderer(this.renderer);
        this.myPlot.addRenderer(new Renderer(){

            @Override
            public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
                if (VerticalSpectrogramAverager.this.value != null) {
                    int ix = (int)VerticalSpectrogramAverager.this.myPlot.getXAxis().transform(VerticalSpectrogramAverager.this.value);
                    DasRow row = VerticalSpectrogramAverager.this.myPlot.getRow();
                    int iy0 = row.getDMinimum();
                    int iy1 = row.getDMaximum();
                    g.drawLine(ix + 3, iy0, ix, iy0 + 3);
                    g.drawLine(ix - 3, iy0, ix, iy0 + 3);
                    g.drawLine(ix + 3, iy1, ix, iy1 - 3);
                    g.drawLine(ix - 3, iy1, ix, iy1 - 3);
                    g.setColor(VerticalSpectrogramAverager.this.markColor);
                    g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
                }
            }
        });
    }

    protected void setDataSet(QDataSet ds) {
        this.renderer.setDataSet(ds);
    }

    public static VerticalSpectrogramAverager createAverager(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        return new VerticalSpectrogramAverager(plot, sourceYAxis, sourceZAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VerticalSpectrogramAverager.this.showPopupImpl();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    public void dispose() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
        }
    }

    public void clear() {
        if (this.renderer != null) {
            this.renderer.setDataSet(null);
        }
    }

    private void createPopup() {
        if (this.myPlot == null) {
            this.initPlot();
        }
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 3.0, -5.0, 0, 0);
        DasColumn column = new DasColumn(canvas, null, 0.0, 1.0, 7.0, -3.0, 0, 0);
        canvas.add(this.myPlot, row, column);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton printButton = new JButton(new AbstractAction("Print..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        buttonPanel.add(printButton);
        JButton close = new JButton("Hide Window");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalSpectrogramAverager.this.popupWindow.setVisible(false);
            }
        });
        buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = new JDialog(parentWindow);
        this.popupWindow.setTitle("Vertical Spectrogram Averager");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point(0, this.parentPlot.getY());
        parentLocation.translate(this.parentPlot.getX() / 20, -1 * this.myPlot.getRow().getDMinimum());
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        int xx = parentLocation.x + this.parentPlot.getCanvas().getWidth();
        int yy = parentLocation.y;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int totalwidth = gd.getDisplayMode().getWidth();
        int totalheight = gd.getDisplayMode().getHeight();
        if (xx > totalwidth - 100) {
            xx = totalwidth - 100;
        }
        if (yy > totalheight - 100) {
            yy = totalheight - 100;
        }
        this.popupWindow.setLocation(xx, yy);
    }

    protected boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible() && this.myPlot.getCanvas() != null;
    }

    @Override
    public void dataRangeSelected(DataRangeSelectionEvent e) {
        QDataSet ds = e.getDataSet();
        if (ds == null || !SemanticOps.isTableDataSet(ds)) {
            return;
        }
        QDataSet xtys = ds;
        Datum xValue1 = e.getMinimum();
        Datum xValue2 = e.getMaximum();
        if (xValue2.equals(xValue1)) {
            return;
        }
        if (!this.isPopupVisible()) {
            this.showPopup();
        }
        RebinDescriptor ddX = new RebinDescriptor(xValue1, xValue2, 1, false);
        ddX.setOutOfBoundsAction(-3);
        AverageTableRebinner rebinner = new AverageTableRebinner();
        try {
            if (xtys.rank() == 3) {
                QDataSet jds = null;
                for (int i = 0; i < xtys.length(); ++i) {
                    QDataSet rebinned = rebinner.rebin(xtys.slice(i), ddX, null);
                    QDataSet ds1 = rebinned.slice(0);
                    jds = Ops.concatenate(jds, ds1);
                }
                this.renderer.setDataSet(jds);
            } else {
                QDataSet rebinned = rebinner.rebin(xtys, ddX, null);
                QDataSet ds1 = rebinned.slice(0);
                this.renderer.setDataSet(ds1);
            }
        }
        catch (DasException rebinned) {
            // empty catch block
        }
        this.value = e.getReference();
        String title = this.parentPlot.getTitle().trim();
        if (title.length() > 0) {
            title = "Averaged " + title + "!c";
        }
        this.myPlot.setTitle(title + new DatumRange(xValue1, xValue2).toString());
        if (!this.myPlot.getXAxis().getLabel().equals(this.sourceXAxis.getLabel())) {
            this.myPlot.getXAxis().setLabel(this.sourceXAxis.getLabel());
        }
        if (!this.myPlot.getYAxis().getLabel().equals(this.sourceZAxis.getLabel())) {
            this.myPlot.getYAxis().setLabel(this.sourceZAxis.getLabel());
        }
    }
}

